<%@page language="java" import="java.io.*,java.sql.*,java.util.*" %>
<%
/**
 *     Caption: Zaval Database Front-end
 *     $Revision: 1.51 $
 *     $Date: 2002/03/13 14:30:17 $
 *
 *     @author:     Alexander Ivanyukovich
 *     @version:    1.2
 *
 * The Zaval Database Front-end provides end users with a light database 
 * query tool for databases that have JDBC-compliant drivers using Web 
 * interface. This tool is dedicated for software developers and 
 * database administrators.
 * 
 * For more info on this product read Zaval Database Front-End User's Guide
 * (It comes within this package).
 * The latest product version is always available from the product's homepage:
 * http://www.zaval.org/products/db-front-end/
 * and from the SourceForge:
 * http://sourceforge.net/projects/zaval0000/
 *
 * Contacts:
 *   Support : support@zaval.org
 *   Change Requests : change-request@zaval.org
 *   Feedback : feedback@zaval.org
 *   Other : info@zaval.org
 * 
 * Copyright (C) 2001-2002  Zaval Creative Engineering Group (http://www.zaval.org)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * (version 2) as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/**
 * File name 'index.jsp' I chosen for this tool is not always appropriate,
 * so you can change it. After file renaming change the variable value.
 */
String file = new String("index.jsp");

/**
 * In most databases you can execute several queries as one.
 * But there are databases that do not allow this functionality.
 * To make life easier we just parse input query and take it to pieces.
 * Each subquery is executed separately.
 * queryDelimiter constant is a delimiter symbol between subqueries.
 */
char queryDelimiter = ';';

/**
 * Usually, transaction is roll backed on any failure during queries execution.
 * If you want to change this behavior just set it to false.
 */
boolean rollbackOnFailure = true;

/**
 * To set browser encoding (via <meta>) we use pageEncoding array.
 */
String [] pageEncodings = new String[]{"ISO-8859-1", "Windows-1251"};

/**
 * While experimenting with various jdbc drivers we faced with a problem of national characters suport.
 * The most flexible way is to allow user choose the appropriate encodings - both database internal and actual.
 * The first encoding is a default one.
 */
String [] javaEncodings = new String[]{"ISO-8859-1", "US-ASCII", "UTF-8", "UTF-16", "Cp1251"};

/**
 * Transaction status (if supported).
 */
String [] transactionStatus = new String[]{"commit", "accumulation", "rollback"};

String query = new String("");
int totalParams = 12; //number of fields to expect.
HashMap hash = new HashMap(totalParams, (float)1.0);
byte [] tempArr = null;

if(session.getValue("connection") != null){
    int length = request.getContentLength();
    int nameStart = "Content-Disposition: form-data; name=\"".length();
    int i = 0, j = 0, k = 0, tmp = 0;
    InputStream is = new BufferedInputStream(request.getInputStream(), length);
    byte [] arr = new byte[length];
    while(i < length){
        tmp = is.read(arr, i, length);
        i += tmp; //i store current position(total bytes read)
        length -= tmp;
    }
    String tempStr = new String(arr);
    j = tempStr.indexOf('\n') - 1;
    String separator = tempStr.substring(0, j);
    i = tempStr.indexOf(separator, j);//search end position
    while(i != -1 && k < totalParams){
        tmp = tempStr.indexOf('\n', j+2); //skiping '\n\n' after Content-Disposition string
        if(tempStr.charAt(tempStr.indexOf("\"", j+nameStart+2)+1) == ';'){ //is it a file ?
            tmp = tempStr.indexOf('\n', tmp+1) + 2; //skiping Content-Type string + '\n\n'
            tempArr = new byte[i-tmp-3];
            System.arraycopy(arr, tmp+1, tempArr, 0, i-tmp-3); //skiping trailing '\n\n'
        }else{
            hash.put(tempStr.substring(j+nameStart+2, tempStr.indexOf("\"", j+nameStart+2)), tempStr.substring(tmp+1, i-2).trim()); //property's name/value
        }
        j = i + separator.length();
        i = tempStr.indexOf(separator, i+1);
        k++;
    }
}

/**
 * Variables initialization.
 * dbEnc - is an internal database encoding.
 * outEnc - is an internal java encoding we used to represent String object.
 * pageEnc - is a browser encoding (we set it via <meta> tag).
 * showResults - indicates query results status.
 * saveInput - indicates query string status after request.
 * parseQuery - by default query devided into subqueries and they executes one-by-one.
 * If they are not specified set them to default values.
*/
    if(hash.get("dbEnc") == null)
        hash.put("dbEnc", javaEncodings[0]);

    if(hash.get("outEnc") == null)
        hash.put("outEnc", javaEncodings[0]);

    if(hash.get("pageEnc") == null)
        hash.put("pageEnc", pageEncodings[0]);

    if(hash.get("source") == null)
        hash.put("source", "0");

    if(hash.get("transactionStatus") == null)
        hash.put("transactionStatus", transactionStatus[0]);

%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
    <title>Zaval Database Front-end</title>
    <meta name="description" content="Zaval Database Front-end (http://www.zaval.org)" />
    <meta http-equiv="Content-Type" content="text/html; charset=<%= (String)hash.get("pageEnc") %>" />
    <style>
        .login { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 8pt; color: #666666; width:320px; }
        .header { font-family:Verdana, Arial, Helvetica, sans-serif; font-size: 10pt; color: #666666; font-weight: bold; }
        .tableHeader { background-color: #c0c0c0; color: #666666;}
        .tableHeaderLight { background-color: #cccccc; color: #666666;}
        .main { font-family:Verdana, Arial, Helvetica, sans-serif; font-size: 8pt; color: #666666;}
        .copy { font-family:Verdana, Arial, Helvetica, sans-serif; font-size: 8pt; color: #999999;}
        .copy:Hover { color: #666666; text-decoration : underline; }
        td { font-family:Verdana, Arial, Helvetica, sans-serif; font-size: 8pt; color: #666666;}
        A { text-decoration: none; }
        A:Hover { color : Red; text-decoration : underline; }
        BODY { OVERFLOW: auto; font-family:Verdana, Arial, Helvetica, sans-serif; font-size: 8pt; color: #666666; }
    </style>
    <script language="JavaScript">
        function completeFields(val, id){
            document.forms[0].elements[id].value = val;
        }
    </script>
</head>
<body bgcolor="#FFFFFF">
    <center>
        <h2>Zaval Database Front-end</h2>
    </center>
<%
// we store connection in the session, so we cut connection expences down.
if(session.getValue("connection") == null){
    //lets check whether user passed to script url for the connection otherwise show login page.
    if(request.getParameter("url") == null || request.getParameter("url").toString().trim().length() == 0 || request.getParameter("url").toString().trim().equalsIgnoreCase("jdbc:odbc:")){
%>
    <center>
        <table border="0" cellpadding="0" cellspacing="0">
            <form action="<%= file %>" method="post">
            <tr>
                <td align="right">Driver :</td>
                <td align="right">&nbsp;&nbsp;</td>
                <td align="left" colspan="2"><input class="login" type="Text" name="driver" value="sun.jdbc.odbc.JdbcOdbcDriver" size="50"></td>
            </tr>
            <tr>
                <td align="right">URL :</td>
                <td align="right">&nbsp;&nbsp;</td>
                <td align="left" colspan="2"><input class="login" type="Text" name="url" value="jdbc:odbc:" size="50"></td>
            </tr>
            <tr>
                <td align="right">login :</td>
                <td align="right">&nbsp;</td>
                <td align="left" colspan="2"><input class="login" type="Text" name="login" value="" size="50"></td>
            </tr>
            <tr>
                <td align="right">password :</td>
                <td align="right">&nbsp;</td>
                <td align="left" colspan="2"><input class="login" type="Password" name="password" value="" size="50"></td>
            </tr>
            <tr>
                <td align="right" colspan="2">&nbsp;</td>
                <td align="left"><input class="main" type="Submit" value="Login"></td>
                <td align="right"><a href="http://www.zaval.org/products/db-front-end/user_guide/" title="Zaval DB Front-end User's Guide at Zaval.org"><nobr>User's Guide</nobr></a>&nbsp;&nbsp;&nbsp;<a href="http://www.zaval.org/products/db-front-end/" title="Zaval DB Front-end's homepage">Homepage</a></td>
            </tr>
            </form>
        </table>
        <br />
        <table border="1" cellpadding="2" cellspacing="0" width="100%">
            <tr>
                <td bgcolor="#c0c0c0" align="center">Database</td>
                <td bgcolor="#c0c0c0" align="center">Driver</td>
                <td bgcolor="#c0c0c0" align="center">URL</td>
                <td bgcolor="#c0c0c0" align="center">Notes</td>
            </tr>
            <tr>
                <td>Generic</td>
                <td><a href="javascript:completeFields('sun.jdbc.odbc.JdbcOdbcDriver', 0);">sun.jdbc.odbc.JdbcOdbcDriver</a></td>
                <td><a href="javascript:completeFields('jdbc:odbc:database', 1);">jdbc:odbc:database</a></td>
                <td>Can be found at <nobr><a href="http://java.sun.com">Sun website</a></nobr></td>
            </tr>
            <tr>
                <td>Generic Extended</td>
                <td><a href="javascript:completeFields('sun.jdbc.odbc.JdbcOdbcDriver', 0);">sun.jdbc.odbc.JdbcOdbcDriver</a></td>
                <td><a href="javascript:completeFields('jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=path_to_mdb_file', 1);">jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=path_to_mdb_file</a></td>
                <td>Can be found at <nobr><a href="http://java.sun.com">Sun website</a></nobr></td>
            </tr>
            <tr>
                <td>MySQL</td>
                <td><a href="javascript:completeFields('com.caucho.jdbc.mysql.Driver', 0);">com.caucho.jdbc.mysql.Driver</a></td>
                <td><a href="javascript:completeFields('jdbc:mysql-caucho://host:port/database', 1);">jdbc:mysql-caucho://host:port/database</a></td>
                <td>Can be found at <nobr><a href="http://www.caucho.com/projects/index.xtp">Caucho Technology</a></nobr><br />Default port : 3306</td>
            </tr>
            <tr>
                <td>PostgreSQL</td>
                <td><a href="javascript:completeFields('org.postgresql.Driver', 0);">org.postgresql.Driver</a></td>
                <td><a href="javascript:completeFields('jdbc:postgresql:database', 1);">jdbc:postgresql:database</a><br />
                    <a href="javascript:completeFields('jdbc:postgresql://host/database', 1);">jdbc:postgresql://host/database</a><br />
                    <a href="javascript:completeFields('jdbc:postgresql://host:port/database', 1);">jdbc:postgresql://host:port/database</a></td>
                <td>Can be found at <nobr><a href="http://jdbc.postgresql.org/download.html">PostgreSQL website</a></nobr></td>
            </tr>
            <tr>
                <td>DB2</td>
                <td><a href="javascript:completeFields('COM.ibm.db2.jdbc.app.DB2Driver', 0);">COM.ibm.db2.jdbc.app.DB2Driver</a></td>
                <td><a href="javascript:completeFields('jdbc:db2:database', 1);">jdbc:db2:database</a></td>
                <td>Can be found at <nobr><a href="http://www.ibm.com">IBM website</a></nobr></td>
            </tr>
            <tr>
                <td>DB2</td>
                <td><a href="javascript:completeFields('COM.ibm.db2.jdbc.net.DB2Driver', 0);">COM.ibm.db2.jdbc.net.DB2Driver</a></td>
                <td><a href="javascript:completeFields('jdbc:db2:host:database', 1);">jdbc:db2:host:database</a></td>
                <td>Can be found at <nobr><a href="http://www.ibm.com">IBM website</a></nobr><br />Default port : 50000</td>
            </tr>
            <tr>
                <td>Oracle</td>
                <td><a href="javascript:completeFields('oracle.jdbc.driver.OracleDriver', 0);">oracle.jdbc.driver.OracleDriver</a></td>
                <td><a href="javascript:completeFields('jdbc:oracle:oci8:@TNSNames_Entry', 1);">jdbc:oracle:oci8:@TNSNames_Entry</a><br />
                    <a href="javascript:completeFields('jdbc:oracle:thin:@host:port:SID', 1);">jdbc:oracle:thin:@host:port:SID</a></td>
                <td>Can be found at <nobr><a href="http://www.oracle.com">Oracle website</a></nobr><br />Default port : 1521</td>
            </tr>
            <tr>
                <td>InterBase</td>
                <td><a href="javascript:completeFields('interbase.interclient.Driver', 0);">interbase.interclient.Driver</a></td>
                <td><a href="javascript:completeFields('jdbc:interbase://host/path_to_gdb_file', 1);">jdbc:interbase://host/path_to_gdb_file</a></td>
                <td>Can be found at <nobr><a href="http://firebird.sourceforge.net/">Firebird website</a></nobr></td>
            </tr>
        </table>
    </center>
<%
    }else{
        try{
            // trying to load driver.
            Class.forName(request.getParameter("driver").trim());
            try{
                //driver loaded successfully - trying to get connection.
                String url = request.getParameter("url").trim();
                String login = request.getParameter("login").trim();
                String password = request.getParameter("password").trim();
                Connection Conn = DriverManager.getConnection(url, login, password);
                //checking for transactions support
                if(Conn.getMetaData().supportsTransactions()){
                    session.putValue("transactionsSupport", "true");
                    session.putValue("queriesInTransaction", new Integer(0));
                    Conn.setAutoCommit(false);
                    if(Conn.getMetaData().supportsTransactionIsolationLevel(Connection.TRANSACTION_SERIALIZABLE)){
                      Conn.setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
                    }else{
                      if(Conn.getMetaData().supportsTransactionIsolationLevel(Connection.TRANSACTION_REPEATABLE_READ)){
                        Conn.setTransactionIsolation(Connection.TRANSACTION_REPEATABLE_READ);
                      }else{
                        if(Conn.getMetaData().supportsTransactionIsolationLevel(Connection.TRANSACTION_READ_UNCOMMITTED)){
                          Conn.setTransactionIsolation(Connection.TRANSACTION_READ_UNCOMMITTED);
                        }else{
                          if(Conn.getMetaData().supportsTransactionIsolationLevel(Connection.TRANSACTION_READ_COMMITTED))
                            Conn.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);
                        }
                      }
                    }
                }else{
                    session.putValue("transactionsSupport", "false");
                }
                //connection ok. lets save it in session.
                session.putValue("connection", Conn);
                session.putValue("justConnected", "true");

                hash.put("showResults", "checked");
                hash.put("saveInput", "checked");
                hash.put("parseQuery", "checked");
                hash.put("commitOnExit", "checked");
                hash.put("query", "");
            }catch(SQLException e){
                    //connection failed. Lets explain user why it is failed(these messages depends on driver implementation).
                out.println("SQLException: " + e.getMessage() + "<br />");
                out.println("SQLState:     " + e.getSQLState() + "<br />");
                out.println("VendorError:  " + e.getErrorCode() + "<br />");
%>
    <center>
        <table border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td class="main">Back to the <a href="<%= file %>">main</a> page</td>
            </tr>
        </table>
    </center>
<%
            }
        }catch(Exception e){
            //driver loading failed.
            out.println("Unable to load driver.<br />");
%>
    <center>
        <table border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td class="main">Back to the <a href="<%= file %>">main</a> page</td>
            </tr>
        </table>
    </center>
<%
        }
    }
}
//lets check connection is established.
if(session.getValue("connection") != null){
    Connection Conn = (Connection) session.getValue("connection");
    int indexS = 0, indexE = 0;
    if(tempArr != null)
        hash.put("fileQuery", (new String(tempArr, (String)hash.get("dbEnc"))).trim());
    //should we show database info ?
    if(hash.get("dbmsInfo") != null){
        //yes. let's show it.
        String str = null;
%>
    <center>
        <table border="1" cellpadding="5" cellspacing="0">
            <tr>
                <td class="tableHeader" width="25%">Database product name :</td>
                <td width="75%"><%= Conn.getMetaData().getDatabaseProductName() %>&nbsp;</td>
            </tr>
            <tr>
                <td class="tableHeader">Database product version :</td>
                <td><%= Conn.getMetaData().getDatabaseProductVersion() %>&nbsp;</td>
            </tr>
            <tr>
                <td class="tableHeader">Database is read-only :</td>
                <td><%= Conn.getMetaData().isReadOnly() %>&nbsp;</td>
            </tr>
<%
        int maxConn = Conn.getMetaData().getMaxConnections();
%>
            <tr>
                <td class="tableHeader">Maximum active connections allowed :</td>
                <td><% if(maxConn > 0){out.println(maxConn);}else{out.println("unlimited or the limit is not known");} %></td>
            </tr>
            <tr>
                <td class="tableHeader">Database transaction isolation level :</td>
                <td><%= Conn.getMetaData().getDefaultTransactionIsolation() %>&nbsp;</td>
            </tr>
            <tr>
                <td class="tableHeader">Multiple ResultSet from a single execution :</td>
                <td><%= Conn.getMetaData().supportsMultipleResultSets() %>&nbsp;</td>
            </tr>
            <tr>
                <td class="tableHeader">Escape simbols :</td>
                <td><%= Conn.getMetaData().getSearchStringEscape() %>&nbsp;</td>
            </tr>
            <tr>
                <td class="tableHeader">Transaction support :</td>
                <td><%= Conn.getMetaData().supportsTransactions() %>&nbsp;</td>
            </tr>
            <tr>
                <td class="tableHeader">Supported transaction isolation levels :</td>
                <td><%
        if(Conn.getMetaData().supportsTransactionIsolationLevel(Connection.TRANSACTION_SERIALIZABLE)){%>TRANSACTION_SERIALIZABLE<%}
        if(Conn.getMetaData().supportsTransactionIsolationLevel(Connection.TRANSACTION_REPEATABLE_READ)){%>, TRANSACTION_REPEATABLE_READ<%}
        if(Conn.getMetaData().supportsTransactionIsolationLevel(Connection.TRANSACTION_READ_UNCOMMITTED)){%>, TRANSACTION_READ_UNCOMMITTED<%}
        if(Conn.getMetaData().supportsTransactionIsolationLevel(Connection.TRANSACTION_READ_COMMITTED)){%>, TRANSACTION_READ_COMMITTED<%}
        if(Conn.getMetaData().supportsTransactionIsolationLevel(Connection.TRANSACTION_NONE)){%>, TRANSACTION_NONE<%}
                 %>&nbsp;</td>
            </tr>
            <tr>
                <td class="tableHeader">"GROUP BY" support :</td>
                <td><%= Conn.getMetaData().supportsGroupBy() %>&nbsp;</td>
            </tr>
            <tr>
                <td class="tableHeader">Escape symbols in LIKE support :</td>
                <td><%= Conn.getMetaData().supportsLikeEscapeClause() %>&nbsp;</td>
            </tr>
            <tr>
                <td class="tableHeader">"UNION" support :</td>
                <td><%= Conn.getMetaData().supportsUnion() %>&nbsp;</td>
            </tr>
<%
        str = Conn.getMetaData().getStringFunctions();
        indexE = str.indexOf(',', indexS);
        while(indexE != -1){
            str = str.substring(0, indexE) + ", " + str.substring(indexE+1, str.length());
            indexS = indexE+2;
            indexE = str.indexOf(',', indexS);
        }
%>
            <tr>
                <td class="tableHeader">String functions supported :</td>
                <td><%= str %>&nbsp;</td>
            </tr>
<%
        str = Conn.getMetaData().getTimeDateFunctions();
        indexS = 0;
        indexE = 0;
        indexE = str.indexOf(',', indexS);
        while(indexE != -1){
            str = str.substring(0, indexE) + ", " + str.substring(indexE+1, str.length());
            indexS = indexE+2;
            indexE = str.indexOf(',', indexS);
        }
%>
            <tr>
                <td class="tableHeader">Date &amp; time functions supported :</td>
                <td><%= str %>&nbsp;</td>
            </tr>
<%
        str = Conn.getMetaData().getSystemFunctions();
        indexS = 0;
        indexE = 0;
        indexE = str.indexOf(',', indexS);
        while(indexE != -1){
            str = str.substring(0, indexE) + ", " + str.substring(indexE+1, str.length());
            indexS = indexE+2;
            indexE = str.indexOf(',', indexS);
        }
%>
            <tr>
                <td class="tableHeader">System functions supported :</td>
                <td><%= str %>&nbsp;</td>
            </tr>
<%
        str = Conn.getMetaData().getSQLKeywords();
        indexS = 0;
        indexE = 0;
        indexE = str.indexOf(',', indexS);
        while(indexE != -1){
            str = str.substring(0, indexE) + ", " + str.substring(indexE+1, str.length());
            indexS = indexE+2;
            indexE = str.indexOf(',', indexS);
        }
%>
            <tr>
                <td class="tableHeader">Database's SQL keywords that are NOT also SQL92 keywords :</td>
                <td><%= str %>&nbsp;</td>
            </tr>
        </table>
    </center><br />
<%
    }
    //let's check if we have any query to execute.
    if("false".equalsIgnoreCase((String)session.getValue("justConnected")) && (("0".equalsIgnoreCase((String)hash.get("source")) && hash.get("query") != null && ((String)hash.get("query")).length() > 0) || ("1".equalsIgnoreCase((String)hash.get("source")) && hash.get("fileQuery") != null && ((String)hash.get("fileQuery")).length() > 0))){
        //yes.
        try{
            Statement st = Conn.createStatement();
            if("0".equalsIgnoreCase((String)hash.get("source")))
                query = (String)hash.get("query");
            else
                query = (String)hash.get("fileQuery");
            boolean resultSetIsAvailable;
            boolean moreResultsAvailable;
            int i = 0;
            int res = 0;
            String result = new String("");
            Vector batchQuery = new Vector();
            //let's check user whant query to be parsed to subqueries and executed one-by-one.
            if((String)hash.get("parseQuery") != null){
                int lastMatch = 0;
                if(query.charAt(query.length()-1) != queryDelimiter)
                    query = query.concat(";");
                boolean inside = false;
                for(int j = 0; j < query.length(); j++){
                    if(query.charAt(j) == '\''){
                        if(query.charAt(j-1) != '\\')
                            inside = !inside;
                    }else{
                        if(query.charAt(j) == ';' && !inside){
                            String subquery;
                            if(lastMatch != 0)
                                subquery = query.substring(lastMatch+1, j).trim();
                            else
                                subquery = query.substring(lastMatch, j).trim();
                            batchQuery.add(subquery);
                            lastMatch = j;
                        }
                    }
                }
            }else{
                batchQuery.add(query);
            }
            for(int j = 0; j < batchQuery.size(); j++){
                resultSetIsAvailable = st.execute((String)batchQuery.get(j));
                //should we show query results ? ...
                if(hash.get("showResults") != null){
                    //yes. lets show them.
                    ResultSet rs = null;
                    for(moreResultsAvailable = true; moreResultsAvailable;){
                        if(resultSetIsAvailable && (rs = st.getResultSet()) != null){
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int numCols = rsmd.getColumnCount();
%>
Executed query : <b><%= new String(((String)batchQuery.get(j)).getBytes((String)hash.get("dbEnc")), (String)hash.get("outEnc")) %></b><br /><br />
    <center>
        <table border="1" cellpadding="5" cellspacing="0">
            <tr>
<%
                            for(i = 1; i <= numCols; i++){
%>
                <td class="tableHeader" align="center"><%= rsmd.getColumnLabel(i) %></td>
<%
                            }
%>
            </tr>
<%
                            if(hash.get("colsInfo") != null){
%>
            <tr>
<%
                                for (i = 1; i <= numCols; i++){
%>
                <td class="tableHeaderLight" align="center"><%= rsmd.getColumnTypeName(i) %>(<%= rsmd.getColumnDisplaySize(i) %>)/<% if(rsmd.isNullable(i) == rsmd.columnNullable){ out.println("null"); }else{ out.println("not null"); } %></td>
<%
                                }
%>
            </tr>
<%
                            }
                            while(rs.next()){
%>
            <tr>
<%
                                for(i = 1; i <= numCols; i++){
                                    result = rs.getString(i);
                                    if(result != null)
                                        result = new String(result.getBytes((String)hash.get("dbEnc")), (String)hash.get("outEnc"));
                                    else
                                        result = "";
%>
                <td class="main" align="center"><% 
                                    if(result.trim().length() > 0){
                                        indexS = 0;
                                        indexE = 0;
                                        indexE = result.indexOf('&', indexS);
                                        while(indexE != -1){
                                            result = result.substring(0, indexE) + "&amp;" + result.substring(indexE+1, result.length());
                                            indexS = indexE+2;
                                            indexE = result.indexOf('&', indexS);
                                        }
                                        indexS = 0;
                                        indexE = 0;
                                        indexE = result.indexOf('<', indexS);
                                        while(indexE != -1){
                                            result = result.substring(0, indexE) + "&lt;" + result.substring(indexE+1, result.length());
                                            indexS = indexE+2;
                                            indexE = result.indexOf('<', indexS);
                                        }
                                        indexS = 0;
                                        indexE = 0;
                                        indexE = result.indexOf('>', indexS);
                                        while(indexE != -1){
                                            result = result.substring(0, indexE) + "&gt;" + result.substring(indexE+1, result.length());
                                            indexS = indexE+2;
                                            indexE = result.indexOf('>', indexS);
                                        }
                                        out.println(result);
                                    }else{ %>&nbsp;<% } %></td>
<%
                                }
%>
            </tr>
<%
                            }
%>
        </table>
    </center>
    <hr />
<%
                        }else{
                            if((res = st.getUpdateCount()) != -1){
%>
    <table border="0" cellpadding="0" cellspacing="0">
        <tr>
            <td class="main"><%= res %> row(s) affected.</td>
        </tr>
    </table>
<%
                            }else{
                                moreResultsAvailable = false;
                            }
                        }
                        if(moreResultsAvailable){
                            resultSetIsAvailable = st.getMoreResults();
                                if(!resultSetIsAvailable)
                                    moreResultsAvailable = false;
                        }
                    }
                }
            }
            if(((String)session.getValue("transactionsSupport")).equalsIgnoreCase("true")){
              if(((String)hash.get("transactionStatus")).equalsIgnoreCase("commit")){
                Conn.commit();
                session.putValue("queriesInTransaction", new Integer(0));
              }else{
                if(((String)hash.get("transactionStatus")).equalsIgnoreCase("rollback")){
                  Conn.rollback();
                  session.putValue("queriesInTransaction", new Integer(0));
                }else{
                  session.putValue("queriesInTransaction", new Integer(((Integer)session.getValue("queriesInTransaction")).intValue()+1));
                }
              }
            }
            st.close();
        }catch(SQLException e){
            //query execution error caught. Lets explain the user what happend(These messages depends on driver implementation).
            out.println("SQLException: " + e.getMessage() + "<br />");
            out.println("SQLState:     " + e.getSQLState() + "<br />");
            out.println("VendorError:  " + e.getErrorCode() + "<br />");
            //All queries in this batch are rollbacked.
            if(rollbackOnFailure && session.getValue("transactionsSupport")!= null && ((String)session.getValue("transactionsSupport")).equalsIgnoreCase("true")){
              Conn.rollback();
            }
        }
    }else{
        if(session.getValue("transactionsSupport") != null && session.getValue("queriesInTransaction") != null && ((String)session.getValue("transactionsSupport")).equalsIgnoreCase("true") && ((Integer)session.getValue("queriesInTransaction")).intValue() > 0){
            if(((String)hash.get("transactionStatus")).equalsIgnoreCase("commit")){
                Conn.commit();
                session.putValue("queriesInTransaction", new Integer(0));
            }else{
                if(((String)hash.get("transactionStatus")).equalsIgnoreCase("rollback")){
                    Conn.rollback();
                    session.putValue("queriesInTransaction", new Integer(0));
                }
            }
        }
    }
    //should we disconnect from the database ?
    if(hash.get("disc") != null){
      if( session.getValue("transactionsSupport") != null && ((String)session.getValue("transactionsSupport")).equalsIgnoreCase("true") && ((String)hash.get("transactionStatus")).equalsIgnoreCase("accumulation")){
        if(hash.get("commitOnExit") != null)
          Conn.commit();
        else
          Conn.rollback();
      }
      //dropping connection.
      Conn.close();
      //dropping session variables.
      session.invalidate();
%>
    <center>
        <table border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td class="main">You are disconnected</td>
            </tr>
            <tr>
                <td class="main">Back to the <a href="<%= file %>">main</a> page</td>
            </tr>
        </table>
    </center>
<%
    }else{
%>
    <center>
        <table border="0" cellpadding="0" cellspacing="0">
            <form action="<%= file %>" method="post" enctype="multipart/form-data">
            <tr>
                <td class="main" align="right" colspan="2"><nobr>disconnect :&nbsp;</nobr></td>
                <td class="main" align="left"><input tabindex="5" type="Checkbox" name="disc" value="true"></td>
            </tr>
            <tr>
                <td class="main" align="right">File</td>
                <td class="main">&nbsp;<input type="Radio" tabindex="3" name="source" value="1" <% if("1".equalsIgnoreCase((String)hash.get("source"))){ %> checked<%}%>>&nbsp;</td>
                <td class="main" align="left"><input tabindex="4" type="File" name="fileQuery" class="main"></td>
            </tr>
            <tr>
                <td class="main" align="right">Query</td>
                <td class="main">&nbsp;<input type="Radio" tabindex="3" name="source" value="0" <% if("0".equalsIgnoreCase((String)hash.get("source"))){ %> checked<%}%>>&nbsp;</td>
                <td class="main" align="left" valign="top">
                    <table border="0" cellpadding="0" cellspacing="0">
                        <tr>
                            <td valign="top">
                              <textarea tabindex="1" cols="50" rows="10" name="query" wrap="soft"><% if(hash.get("saveInput") != null) { out.println(new String(((String)hash.get("query")).getBytes((String)hash.get("dbEnc")), (String)hash.get("outEnc"))); } %></textarea><br>
                              <input tabindex="2" type="Submit" value="Submit" class="main">
                            </td>
                            <td class="main">&nbsp;&nbsp;</td>
                            <td valign="top" class="main">
                                <table border="0" cellpadding="0" cellspacing="0">
                                    <tr>
                                        <td class="main" align="right">pageEncoding :</td>
                                        <td class="main">&nbsp;&nbsp;</td>
                                        <td class="main" align="left">
                                            <select name="pageEnc" tabindex="6">
<%
        for(int i = 0; i < pageEncodings.length; i++){
%>
                                                <option value="<%= pageEncodings[i] %>"<% if (((String)hash.get("pageEnc")).equalsIgnoreCase(pageEncodings[i])){ out.println(" selected"); } %>><%= pageEncodings[i] %></option>
<%
        }
%>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="main" align="right">dbEncoding :</td>
                                        <td class="main">&nbsp;&nbsp;</td>
                                        <td class="main" align="left">
                                            <select name="dbEnc" tabindex="7">
<%
        for(int i = 0; i < javaEncodings.length; i++){
%>
                                                <option value="<%= javaEncodings[i] %>"<% if (((String)hash.get("dbEnc")).equalsIgnoreCase(javaEncodings[i])){ out.println(" selected"); } %>><%= javaEncodings[i] %></option>
<%
        }
%>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="main" align="right">outEncoding :</td>
                                        <td class="main">&nbsp;&nbsp;</td>
                                        <td class="main" align="left">
                                            <select name="outEnc" tabindex="8">
<%
        for(int i = 0; i < javaEncodings.length; i++){
%>
                                                <option value="<%= javaEncodings[i] %>"<% if (((String)hash.get("outEnc")).equalsIgnoreCase(javaEncodings[i])){ out.println(" selected"); } %>><%= javaEncodings[i] %></option>
<%
        }
%>
                                            </select>
                                        </td>
                                    </tr>
                                    <% if(((String)session.getValue("transactionsSupport")).equalsIgnoreCase("true")){
                                      int queriesInTransaction = ((Integer)session.getValue("queriesInTransaction")).intValue();
                                    %>
                                    <tr>
                                        <td class="main" align="right">Transaction status :</td>
                                        <td class="main">&nbsp;&nbsp;</td>
                                        <td class="main" align="left">
                                          <table border="0" cellpadding="0" cellspacing="0">
                                            <tr>
                                              <td align="left" class="main">
                                            <select name="transactionStatus" tabindex="8">
<%
        for(int i = 0; i < transactionStatus.length; i++){
%>
                                                <option value="<%= transactionStatus[i] %>"<% if (((String)hash.get("transactionStatus")).equalsIgnoreCase(transactionStatus[i])){ out.println(" selected"); } %>><%= transactionStatus[i] %></option>
<%
        }
%>
                                            </select>
                                              </td>
                                              <td class="main">&nbsp;</td>
                                              <td align="left" class="main" valign="middle">
                                              (<%= queriesInTransaction %> <% if(queriesInTransaction == 1){%>query<%}else{%>queries<%}%>)
                                              </td>
                                            </tr>
                                          </table>
                                        </td>
                                    </tr>
                                    <% } %>
                                    <tr>
                                        <td class="main" align="right">Save input :</td>
                                        <td class="main">&nbsp;&nbsp;</td>
                                        <td class="main" align="left"><input tabindex="9" type="Checkbox" name="saveInput" value="checked" <%= (String)hash.get("saveInput") %>></td>
                                    </tr>
                                    <tr>
                                        <td class="main" align="right">Show results :</td>
                                        <td class="main">&nbsp;&nbsp;</td>
                                        <td class="main" align="left"><input tabindex="10" type="Checkbox" name="showResults" value="checked" <%= (String)hash.get("showResults") %>></td>
                                    </tr>
                                    <tr>
                                        <td class="main" align="right">Parse query :</td>
                                        <td class="main">&nbsp;&nbsp;</td>
                                        <td class="main" align="left"><input tabindex="11" type="Checkbox" name="parseQuery" value="checked" <%= (String)hash.get("parseQuery") %>></td>
                                    </tr>
                                    <% if(((String)session.getValue("transactionsSupport")).equalsIgnoreCase("true")){ %>
                                    <tr>
                                        <td class="main" align="right">Commit on disconnect :</td>
                                        <td class="main">&nbsp;&nbsp;</td>
                                        <td class="main" align="left"><input tabindex="11" type="Checkbox" name="commitOnExit" value="checked" <%= (String)hash.get("commitOnExit") %>></td>
                                    </tr>
                                    <% } %>
                                    <tr>
                                        <td class="main" align="right">Show columns info :</td>
                                        <td class="main">&nbsp;&nbsp;</td>
                                        <td class="main" align="left"><input tabindex="12" type="Checkbox" name="colsInfo" value="checked" <%= (String)hash.get("colsInfo") %>></td>
                                    </tr>
                                    <tr>
                                        <td class="main" align="right">Show DBMS info :</td>
                                        <td class="main">&nbsp;&nbsp;</td>
                                        <td class="main" align="left"><input tabindex="13" type="Checkbox" name="dbmsInfo" value="checked" <%= (String)hash.get("dbmsInfo") %>></td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            </form>
        </table>
    </center>
<%
        session.putValue("justConnected", "false");
    }
}
%>
    <br />
    <center><a href="http://www.zaval.org" class="copy" title="http://www.zaval.org">Zaval Creative Engineering Group, 2001-2002</a></center>
</body>
</html>
