/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Insets;
import org.zaval.awt.AlignConstants;

public class Align
implements AlignConstants {
    private int align = 0;
    private String alignStr = "center";
    private Insets code = new Insets(0, 0, 0, 0);

    public void setAlign(int n) {
        if (this.align == n) {
            return;
        }
        this.code = Align.align2insets(n);
        this.alignStr = Align.align2str(n);
        this.align = n;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlignInsets(Insets insets) {
        if (insets == this.code) {
            return;
        }
        this.align = Align.insets2align(insets);
    }

    public Insets getAlignInsets() {
        return this.code;
    }

    public String getAlignString() {
        return this.alignStr;
    }

    public static Insets align2insets(int n) {
        Insets insets = new Insets(-1, -1, -1, -1);
        insets.top = (n & 4) > 0 ? 1 : 0;
        insets.left = (n & 1) > 0 ? 1 : 0;
        insets.bottom = (n & 8) > 0 ? 1 : 0;
        int n2 = insets.right = (n & 2) > 0 ? 1 : 0;
        if (!Align.check(insets)) {
            return null;
        }
        return insets;
    }

    public static String align2str(int n) {
        String string = null;
        switch (n) {
            case 4: {
                string = "top";
                break;
            }
            case 8: {
                string = "bottom";
                break;
            }
            case 1: {
                string = "left";
                break;
            }
            case 2: {
                string = "right";
                break;
            }
            case 5: {
                string = "topLeft";
                break;
            }
            case 6: {
                string = "topRight";
                break;
            }
            case 10: {
                string = "bottomRight";
                break;
            }
            case 9: {
                string = "bottomLeft";
                break;
            }
            case 0: {
                string = "center";
            }
        }
        return string;
    }

    public static int insets2align(Insets insets) {
        if (insets == null || !Align.check(insets)) {
            return -1;
        }
        int n = 0;
        n |= insets.top > 0 ? 4 : 0;
        n |= insets.left > 0 ? 1 : 0;
        n |= insets.bottom > 0 ? 8 : 0;
        return n |= insets.right > 0 ? 2 : 0;
    }

    protected static boolean check(Insets insets) {
        if (insets.top > 0 && insets.bottom > 0 || insets.left > 0 && insets.right > 0) {
            return false;
        }
        return insets.top >= 0 && insets.bottom >= 0 && insets.left >= 0 && insets.right >= 0;
    }
}

