/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import org.zaval.awt.Align;

public class AlignArea
extends Align {
    public static final int INSIDE = 1;
    public static final int OUTSIDE = 2;
    private int mode = 1;
    private int sx = 0;
    private int sy = 0;
    private Dimension size = new Dimension(0, 0);
    private Insets insets = new Insets(0, 0, 0, 0);
    private boolean isValid = false;
    private Rectangle rect;

    public void setAlign(int n) {
        if (this.getAlign() == n) {
            return;
        }
        super.setAlign(n);
        this.invalidate();
    }

    public void setSize(Dimension dimension) {
        if (dimension != null && this.size != null && dimension.width == this.size.width && dimension.height == this.size.height) {
            return;
        }
        this.invalidate();
        this.size = dimension == null ? null : new Dimension(dimension.width, dimension.height);
    }

    public Dimension getSize() {
        if (this.size == null) {
            return null;
        }
        return new Dimension(this.size.width, this.size.height);
    }

    public void setSizeAlignObj(Dimension dimension) {
        if (this.sx == dimension.width && this.sy == dimension.height) {
            return;
        }
        this.invalidate();
        this.sx = dimension.width;
        this.sy = dimension.height;
    }

    public Dimension getSizeAlignObj() {
        return new Dimension(this.sx, this.sy);
    }

    public void setInsets(Insets insets) {
        if (insets != null && insets.top == this.insets.top && insets.left == this.insets.left && insets.right == this.insets.right && insets.bottom == this.insets.bottom) {
            return;
        }
        this.invalidate();
        this.insets = insets == null ? null : new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setMode(int n) {
        if (this.mode == n) {
            return;
        }
        this.invalidate();
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public Rectangle getAlignRectangle() {
        if (this.isValid()) {
            if (this.rect == null) {
                return null;
            }
            return new Rectangle(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
        this.recalc();
        Dimension dimension = this.getSize();
        dimension.width -= this.insets.left + this.insets.right;
        dimension.height -= this.insets.top + this.insets.bottom;
        int n = this.getWidth(this.sx, this.size);
        int n2 = this.getHeight(this.sy, this.size);
        int n3 = this.size.width - n;
        int n4 = this.size.height - n2;
        int n5 = this.getAlign();
        Rectangle rectangle = new Rectangle(n3 / 2, n4 / 2, n, n2);
        if ((n5 & 1) > 0) {
            rectangle.x = this.insets.left;
        } else if ((n5 & 2) > 0) {
            rectangle.x = n3 - this.insets.right;
        }
        if ((n5 & 4) > 0) {
            rectangle.y = this.insets.top;
        } else if ((n5 & 8) > 0) {
            rectangle.y = n4 - this.insets.bottom;
        }
        this.rect = rectangle;
        this.validate();
        return rectangle;
    }

    public boolean isBelongArea(int n, int n2) {
        return AlignArea.isBelongArea(this, n, n2);
    }

    protected int getWidth(int n, Dimension dimension) {
        return n;
    }

    protected int getHeight(int n, Dimension dimension) {
        return n;
    }

    protected void validate() {
        this.isValid = true;
    }

    protected void recalc() {
    }

    public void invalidate() {
        this.isValid = false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public static boolean isBelongArea(AlignArea alignArea, int n, int n2) {
        Rectangle rectangle = alignArea.getAlignRectangle();
        if (rectangle == null) {
            return false;
        }
        switch (alignArea.getMode()) {
            case 1: {
                return rectangle.inside(n, n2);
            }
            case 2: {
                return !rectangle.inside(n, n2);
            }
        }
        return false;
    }
}

