/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Insets;
import java.awt.Rectangle;
import org.zaval.awt.AlignArea;

public class AlignHelper {
    public static Insets align2insets(int n) {
        Insets insets = new Insets(-1, -1, -1, -1);
        insets.top = (n & 4) > 0 ? 1 : 0;
        insets.left = (n & 1) > 0 ? 1 : 0;
        insets.bottom = (n & 8) > 0 ? 1 : 0;
        int n2 = insets.right = (n & 2) > 0 ? 1 : 0;
        if (!AlignHelper.check(insets)) {
            return null;
        }
        return insets;
    }

    public static int insets2align(Insets insets) {
        if (insets == null || !AlignHelper.check(insets)) {
            return -1;
        }
        int n = 0;
        n |= insets.top > 0 ? 4 : 0;
        n |= insets.left > 0 ? 1 : 0;
        n |= insets.bottom > 0 ? 8 : 0;
        return n |= insets.right > 0 ? 2 : 0;
    }

    public static String align2str(int n) {
        String string = null;
        switch (n) {
            case 4: {
                string = "top";
                break;
            }
            case 8: {
                string = "bottom";
                break;
            }
            case 1: {
                string = "left";
                break;
            }
            case 2: {
                string = "right";
                break;
            }
            case 5: {
                string = "topLeft";
                break;
            }
            case 6: {
                string = "topRight";
                break;
            }
            case 10: {
                string = "bottomRight";
                break;
            }
            case 9: {
                string = "bottomLeft";
                break;
            }
            case 0: {
                string = "center";
            }
        }
        return string;
    }

    protected static boolean check(Insets insets) {
        if (insets.top > 0 && insets.bottom > 0 || insets.left > 0 && insets.right > 0) {
            return false;
        }
        return insets.top >= 0 && insets.bottom >= 0 && insets.left >= 0 && insets.right >= 0;
    }

    public static boolean isBelongArea(AlignArea alignArea, int n, int n2) {
        Rectangle rectangle = alignArea.getAlignRectangle();
        if (rectangle == null) {
            return false;
        }
        switch (alignArea.getMode()) {
            case 1: {
                return rectangle.inside(n, n2);
            }
            case 2: {
                return !rectangle.inside(n, n2);
            }
        }
        return false;
    }

    public static Insets getPointAlignInsets(AlignArea alignArea, int n, int n2) {
        if (!AlignHelper.isBelongArea(alignArea, n, n2)) {
            return null;
        }
        if (alignArea.getMode() == 1) {
            return alignArea.getAlignInsets();
        }
        Rectangle rectangle = alignArea.getAlignRectangle();
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        Insets insets = new Insets(0, 0, 0, 0);
        if (n > n3) {
            ++insets.right;
        } else if (n < rectangle.x) {
            ++insets.left;
        }
        if (n2 > n4) {
            ++insets.bottom;
        } else if (n2 < rectangle.y) {
            ++insets.top;
        }
        return insets;
    }
}

