/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import org.zaval.awt.TextAlignArea;

public abstract class BaseCheckbox
extends Canvas {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private Dimension sqSize = new Dimension(12, 12);
    private int textInset = 3;
    boolean state = false;
    boolean hasFocus = false;
    boolean isCalc = false;
    boolean mouse_down;
    private int align = 1;
    int posY = 0;
    int posX = 0;
    Rectangle textArea = new Rectangle();
    Rectangle eventBox = new Rectangle();
    private TextAlignArea alignArea = new TextAlignArea();

    public String getLabel() {
        return this.alignArea.getText();
    }

    public void disable() {
        super.disable();
        this.repaint();
    }

    public void enable() {
        super.enable();
        this.repaint();
    }

    public void setLabel(String string) {
        this.alignArea.setText(string);
        if (this.alignArea.isValid()) {
            return;
        }
        this.invalidate();
        this.repaint();
    }

    public void setAlign(int n) {
        if (n == this.align) {
            return;
        }
        this.align = n;
        if (this.alignArea.isValid()) {
            return;
        }
        this.invalidate();
        this.repaint();
    }

    public int getAlign() {
        return this.align;
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean bl) {
        this.state = bl;
        this.repaint();
    }

    public boolean gotFocus(Event event, Object object) {
        this.hasFocus = true;
        this.repaint();
        return super.gotFocus(event, object);
    }

    public boolean lostFocus(Event event, Object object) {
        this.hasFocus = false;
        this.repaint();
        return super.lostFocus(event, object);
    }

    private void calc() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        Dimension dimension = this.size();
        this.posY = dimension.height / 2 - this.sqSize.height / 2;
        this.posX = 0;
        if (this.align == 2) {
            this.posX = dimension.width - this.sqSize.width - 1;
        }
        this.eventBox.x = 0;
        this.eventBox.y = 0;
        this.eventBox.width = dimension.width;
        this.eventBox.height = dimension.height;
        this.alignArea.setSize(dimension);
        if (this.align == 1) {
            this.alignArea.setInsets(new Insets(0, this.textInset + this.sqSize.width + 1, 0, 0));
        } else {
            this.alignArea.setInsets(new Insets(0, 1, 0, 0));
        }
        this.alignArea.setFontMetrics(fontMetrics);
        this.textArea = this.alignArea.getAlignRectangle();
        if (this.textArea.x + this.textArea.width >= dimension.width) {
            this.textArea.width = dimension.width - this.textArea.x - 1;
        }
        if (this.textArea.y + this.textArea.height >= dimension.height) {
            this.textArea.height = dimension.height - this.textArea.y - 1;
        }
        if (this.align == 2 && this.textArea.x + this.textArea.width > this.posX) {
            this.textArea.width = this.posX - this.textArea.x - 1;
        }
        this.isCalc = true;
    }

    public void invalidate() {
        this.isCalc = false;
        super.invalidate();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.isCalc) {
            this.calc();
        }
        String string = this.getLabel();
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.gray);
        }
        int n = this.posY + this.sqSize.height;
        if (string != null && string.length() > 0) {
            if (!this.isEnabled()) {
                this.alignArea.draw(graphics, 0, 1, Color.white);
            }
            this.alignArea.draw(graphics, this.getForeground());
        }
        if (this.hasFocus) {
            graphics.setColor(Color.black);
            if (string != null && string.length() > 0) {
                this.drawRect(graphics, this.textArea.x - 1, this.textArea.y, this.textArea.width, this.textArea.height);
            }
        }
        this.paint(graphics, this.posX, this.posY, this.sqSize.width, this.sqSize.height);
    }

    protected boolean insideBox(int n, int n2) {
        return this.eventBox.inside(n, n2);
    }

    public synchronized boolean mouseDown(Event event, int n, int n2) {
        if (this.isEnabled() && this.insideBox(n, n2)) {
            this.mouse_down = true;
            this.requestFocus();
            if (this.condition()) {
                this.stateChanged();
            }
        }
        return super.mouseDown(event, n, n2);
    }

    public synchronized boolean mouseUp(Event event, int n, int n2) {
        if (this.isEnabled() && this.condition() && this.insideBox(n, n2)) {
            this.mouse_down = false;
            this.state = !this.state;
            this.repaint();
            Event event2 = new Event(this, 1001, "1");
            this.getParent().postEvent(event2);
            return true;
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean keyDown(Event event, int n) {
        if (!this.hasFocus || n != 32 || !this.condition()) {
            return super.keyDown(event, n);
        }
        this.setState(!this.getState());
        Event event2 = new Event(this, 1001, "1");
        this.getParent().postEvent(event2);
        return true;
    }

    public synchronized boolean mouseDrag(Event event, int n, int n2) {
        if (this.isEnabled() && this.insideBox(n, n2)) {
            this.mouse_down = false;
            this.repaint();
        }
        return super.mouseDrag(event, n, n2);
    }

    public Dimension preferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return super.preferredSize();
        }
        int n = this.textInset + this.sqSize.width + fontMetrics.stringWidth(this.alignArea.getText()) + 1;
        int n2 = Math.max(fontMetrics.getHeight(), this.sqSize.height);
        return new Dimension(n, n2);
    }

    public void stateChanged() {
    }

    protected boolean condition() {
        return true;
    }

    public TextAlignArea getAlignArea() {
        return this.alignArea;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return true;
    }

    public abstract void paint(Graphics var1, int var2, int var3, int var4, int var5);

    public void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawVLine(graphics, n2, n2 + n4, n);
        this.drawVLine(graphics, n2, n2 + n4, n + n3);
        this.drawHLine(graphics, n, n + n3, n2);
        this.drawHLine(graphics, n, n + n3, n2 + n4);
    }

    public void drawHLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n4 / 2 + n4 % 2;
        for (int i = 0; i < n5; ++i) {
            graphics.drawLine(n, n3, n, n3);
            n += 2;
        }
        graphics.drawLine(n2, n3, n2, n3);
    }

    public void drawVLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n4 / 2 + n4 % 2;
        for (int i = 0; i < n5; ++i) {
            graphics.drawLine(n3, n, n3, n);
            n += 2;
        }
        graphics.drawLine(n3, n2, n3, n2);
    }
}

