/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;

public class BorderedPanel
extends Panel {
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public static final int SUNKEN = 2;
    public static final int ETCHED = 3;
    public static final int RAISED2 = 4;
    protected int type = 1;
    protected int hideMode = 0;
    protected Insets insets = new Insets(2, 2, 2, 2);
    protected static Color[] colors = new Color[]{Color.white, Color.gray};
    int prevMode = -1;

    public BorderedPanel() {
        this(3);
    }

    public BorderedPanel(int n) {
        this.type = n;
    }

    public void setType(int n) {
        if (this.type == n) {
            return;
        }
        this.type = n;
        this.repaint();
    }

    public void setHideMode(int n) {
        if (this.hideMode == n) {
            return;
        }
        this.hideMode = n;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void paint(Graphics graphics) {
        if (this.type == 0) {
            Rectangle rectangle = this.bounds();
            graphics.setColor(this.getParent().getBackground());
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            return;
        }
        super.paint(graphics);
        Dimension dimension = this.size();
        int n = 0;
        int n2 = 0;
        int n3 = dimension.width - 1;
        int n4 = dimension.height - 1;
        this.leftLine(graphics, n, n2, n3, n4);
        this.rightLine(graphics, n, n2, n3, n4);
        this.topLine(graphics, n, n2, n3, n4);
        this.bottomLine(graphics, n, n2, n3, n4);
    }

    public void leftLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(colors[1]);
        switch (this.type) {
            case 3: {
                graphics.setColor(colors[1]);
                graphics.drawLine(n, n2, n, n4 - 1);
                graphics.setColor(colors[0]);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 2);
                break;
            }
            case 4: {
                graphics.setColor(colors[0]);
                graphics.drawLine(n, n2, n, n4 + 2);
                break;
            }
            case 1: {
                graphics.setColor(colors[0]);
                graphics.drawLine(n, n2, n, n4 - 1);
                break;
            }
            case 2: {
                graphics.setColor(colors[1]);
                graphics.drawLine(n, n2, n, n4 - 1);
                graphics.setColor(Color.black);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 2);
            }
        }
    }

    public void rightLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(colors[1]);
        switch (this.type) {
            case 3: {
                graphics.setColor(colors[1]);
                graphics.drawLine(n3 - 1, n2 + 1, n3 - 1, n4);
                graphics.setColor(colors[0]);
                graphics.drawLine(n3, n2, n3, n4);
                break;
            }
            case 1: {
                graphics.setColor(colors[1]);
                graphics.drawLine(n3, n2, n3, n4);
                graphics.setColor(colors[1]);
                graphics.drawLine(n3 - 1, n2 + 1, n3 - 1, n4 - 1);
                break;
            }
            case 2: {
                graphics.setColor(colors[0]);
                graphics.drawLine(n3, n2, n3, n4 - 1);
                break;
            }
            case 4: {
                graphics.setColor(colors[1]);
                graphics.drawLine(n3, n2, n3, n4);
            }
        }
    }

    public void topLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(colors[1]);
        switch (this.type) {
            case 3: {
                graphics.setColor(colors[1]);
                graphics.drawLine(n, n2, n3 - 1, n2);
                graphics.setColor(colors[0]);
                graphics.drawLine(n + 1, n2 + 1, n3 - 2, n2 + 1);
                break;
            }
            case 4: {
                graphics.setColor(colors[0]);
                graphics.drawLine(n, n2, n3 + 2, n2);
                break;
            }
            case 1: {
                graphics.setColor(colors[0]);
                graphics.drawLine(n, n2, n3 - 1, n2);
                break;
            }
            case 2: {
                graphics.setColor(Color.black);
                graphics.drawLine(n + 1, n2 + 1, n3 - 2, n2 + 1);
                graphics.setColor(colors[1]);
                graphics.drawLine(n, n2, n3 - 1, n2);
            }
        }
    }

    public void bottomLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(colors[1]);
        switch (this.type) {
            case 3: {
                graphics.setColor(colors[1]);
                graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
                graphics.setColor(colors[0]);
                graphics.drawLine(n, n4, n3, n4);
                break;
            }
            case 1: {
                graphics.setColor(colors[1]);
                graphics.drawLine(n, n4, n3 - 1, n4);
                graphics.setColor(colors[1]);
                graphics.drawLine(n + 1, n4 - 1, n3 - 2, n4 - 1);
                break;
            }
            case 2: {
                graphics.setColor(colors[0]);
                graphics.drawLine(n, n4, n3, n4);
                graphics.drawLine(n + 1, n4 - 1, n3 - 1, n4 - 1);
                break;
            }
            case 4: {
                graphics.setColor(colors[1]);
                graphics.drawLine(n + 1, n4, n3, n4);
            }
        }
    }

    public void hide() {
        if (this.hideMode == 0) {
            super.hide();
        } else {
            if (this.type == 0) {
                return;
            }
            this.prevMode = this.type;
            this.setType(0);
        }
    }

    public boolean isVisible() {
        if (this.hideMode == 0) {
            return super.isVisible();
        }
        return this.type != 0;
    }

    public void show() {
        if (this.hideMode == 0) {
            super.show();
        } else {
            if (!super.isVisible()) {
                super.show();
            }
            if (this.prevMode < 0) {
                return;
            }
            this.setType(this.prevMode);
            this.prevMode = -1;
            try {
                super.hide();
                super.show();
                ((Component)this).invalidate();
                ((Component)this).validate();
                this.repaint();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return true;
    }
}

