/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Hashtable;
import org.zaval.awt.ContextMenuBar;

public class ContextMenu
extends Menu {
    Rectangle size = null;
    int htext = 0;
    int stap = 0;
    int vdist = 0;
    int hdist = 0;
    int msize = 0;
    int act_option = 0;
    int prev_option = 0;
    int index = -1;
    boolean act = false;
    Color col_mark = new Color(128);
    Hashtable types = new Hashtable();

    public ContextMenu(String string) {
        super(string);
        this.setFont(new Font("Dialog", 0, 12));
    }

    public ContextMenu(String string, int n, int n2) {
        this(string);
        this.size.x = n;
        this.size.y = n2;
    }

    public boolean isActive() {
        return this.act;
    }

    public void setActive(boolean bl) {
        this.act = bl;
    }

    public void addCheckit(MenuItem menuItem, boolean bl) {
        this.add(menuItem);
        if (bl) {
            this.types.put(menuItem.getLabel(), "1");
        } else {
            this.types.put(menuItem.getLabel(), "0");
        }
    }

    public void addCheckit(String string, boolean bl) {
        this.addCheckit(new MenuItem(string), bl);
    }

    public void add(String string) {
        this.add(new MenuItem(string));
    }

    public void addSeparator() {
        super.addSeparator();
    }

    public void remove(int n) {
        this.size.height -= this.stap;
        super.remove(n);
    }

    public void remove(MenuComponent menuComponent) {
        super.remove(menuComponent);
    }

    public MenuItem add(MenuItem menuItem) {
        MenuItem menuItem2 = super.add(menuItem);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(menuItem.getLabel()) + 2 * this.hdist;
        if (this.size.width < n) {
            this.size.width = n;
        }
        this.size.height += this.stap;
        return menuItem2;
    }

    public void recalc() {
        this.recalc(this.getFont());
    }

    public Dimension getSize() {
        return new Dimension(this.size.width, this.size.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.size.x, this.size.y, this.size.width, this.size.height);
    }

    public Dimension preferredSize() {
        return new Dimension(this.size.width + 2 * this.hdist, this.size.height + 2 * this.vdist);
    }

    public void recalc(Font font) {
        int n;
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.hdist = fontMetrics.stringWidth("IIIII");
        this.htext = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
        this.vdist = this.htext / 4;
        this.stap = this.vdist + this.htext;
        this.msize = this.htext + this.htext / 4;
        if (this.size == null) {
            this.size = new Rectangle(0, 0, 0, 2 * this.vdist);
        } else {
            this.size.height = this.vdist + 5;
        }
        int n2 = this.countItems();
        MenuItem[] menuItemArray = new MenuItem[n2];
        for (n = 0; n < n2; ++n) {
            menuItemArray[n] = this.getItem(n);
            this.remove(n);
        }
        for (n = 0; n < n2; ++n) {
            this.add(menuItemArray[n]);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.recalc();
    }

    private void drawSeparator(Graphics graphics, int n) {
        int n2 = this.size.x + 2;
        int n3 = this.size.x + this.size.width - 3;
        graphics.setColor(Color.gray);
        graphics.drawLine(n2, (n -= this.vdist) - 1, n3, n - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(n2, n, n3, n);
    }

    public Rectangle getRedrawArea() {
        int n = this.size.y + this.vdist + this.vdist;
        if (this.prev_option > this.act_option) {
            return new Rectangle(this.size.x, n + this.act_option * this.stap, this.size.width, 2 * this.msize);
        }
        return new Rectangle(this.size.x, n + this.prev_option * this.stap, this.size.width, 2 * this.msize);
    }

    private void correctPos() {
        if (this.getParent() == null) {
            return;
        }
        Dimension dimension = ((ContextMenuBar)this.getParent()).getParentSize();
        if (this.size.x < this.hdist) {
            this.size.x = this.hdist;
        }
        if (this.size.y < this.vdist) {
            this.size.y = this.vdist;
        }
        int n = this.size.x + this.size.width + this.hdist;
        int n2 = this.size.y + this.size.height + this.vdist;
        if (n > dimension.width) {
            this.size.x -= n - dimension.width;
        }
        if (n2 > dimension.height) {
            this.size.y -= n2 - dimension.height;
        }
        if (this.size.x < 0) {
            this.size.x = 0;
        }
        if (this.size.y < 0) {
            this.size.y = 0;
        }
    }

    public boolean paint(Graphics graphics) {
        if (!this.isEnabled()) {
            return false;
        }
        this.correctPos();
        graphics.setFont(this.getFont());
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.size.x, this.size.y, this.size.width, this.size.height);
        graphics.setColor(Color.darkGray);
        graphics.drawRect(this.size.x, this.size.y, this.size.width - 1, this.size.height - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(this.size.x, this.size.y, this.size.x + this.size.width, this.size.y);
        graphics.drawLine(this.size.x, this.size.y, this.size.x, this.size.y + this.size.height - 1);
        graphics.setColor(this.col_mark);
        graphics.fillRect(this.size.x + 3, this.size.y + this.vdist + this.act_option * this.stap, this.size.width - 6, this.msize);
        int n = this.size.x + this.hdist;
        int n2 = this.size.y + this.stap;
        int n3 = this.countItems();
        for (int i = 0; i < n3; ++i) {
            this.drawOption(graphics, i);
        }
        return true;
    }

    private void drawCheckit(Graphics graphics, int n, String string, int n2, int n3) {
        String string2 = (String)this.types.get(string);
        if (string2 != null) {
            ContextMenuBar contextMenuBar = (ContextMenuBar)this.getParent();
            if (string2.equals("1")) {
                for (int i = 0; i < 2; ++i) {
                    graphics.drawLine(n2 + this.hdist / 3 + i, n3 + this.stap - this.htext + this.vdist, n2 + this.hdist / 2 + i, n3 + this.stap);
                    graphics.drawLine(n2 + this.hdist / 2 + i, n3 + this.stap, n2 + this.hdist - 3 + i, n3 + this.stap - this.htext + this.vdist);
                }
            }
        }
    }

    private void drawOption(Graphics graphics, int n) {
        if (n >= this.countItems()) {
            return;
        }
        MenuItem menuItem = this.getItem(n);
        String string = menuItem.getLabel();
        int n2 = this.size.y + this.stap;
        int n3 = this.size.x + this.hdist;
        int n4 = n * this.stap;
        if (menuItem.isEnabled()) {
            if (string.equals("-")) {
                this.drawSeparator(graphics, n2 + n4);
                return;
            }
            if (n != this.act_option) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.white);
            }
            this.drawCheckit(graphics, n, string, this.size.x, this.size.y + n4);
            graphics.drawString(string, n3, n2 + n4);
        } else {
            graphics.setColor(Color.darkGray);
            graphics.drawString(string, n3, n2 + n4);
            graphics.setColor(Color.white);
            graphics.drawString(string, n3 + 1, n2 + 1 + n4);
            if (n != this.act_option) {
                graphics.setColor(Color.darkGray);
            }
            this.drawCheckit(graphics, n, string, this.size.x, this.size.y + n4);
        }
    }

    public boolean paintPart(Graphics graphics) {
        if (!this.isEnabled()) {
            return false;
        }
        this.correctPos();
        graphics.setFont(this.getFont());
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.size.x + 1, this.size.y + this.vdist + this.prev_option * this.stap, this.size.width - 2, this.msize);
        this.drawOption(graphics, this.prev_option);
        graphics.setColor(this.col_mark);
        graphics.fillRect(this.size.x + 3, this.size.y + this.vdist + this.act_option * this.stap, this.size.width - 6, this.msize);
        this.drawOption(graphics, this.act_option);
        return true;
    }

    public boolean paint(Graphics graphics, int n, int n2) {
        this.setPos(n, n2);
        return this.paint(graphics);
    }

    public void setPos(int n, int n2) {
        this.size.x = n;
        this.size.y = n2;
    }

    public void pressKey(Event event) {
        int n = this.countItems();
        boolean bl = true;
        if (n == 0) {
            return;
        }
        switch (event.key) {
            case 1004: {
                bl = this.decOption();
                break;
            }
            case 1005: {
                bl = this.incOption();
            }
        }
        if (bl) {
            this.sendEvent(65520);
        }
    }

    public boolean isCheckit(int n) {
        MenuItem menuItem = this.getItem(n);
        if (menuItem == null) {
            return false;
        }
        return this.types.get(menuItem.getLabel()) != null;
    }

    public void invCheckit(int n) {
        if (!this.isCheckit(n)) {
            return;
        }
        String string = (String)this.types.get(this.getItem(n).getLabel());
        if (string.equals("1")) {
            this.types.put(this.getItem(n).getLabel(), "0");
        } else {
            this.types.put(this.getItem(n).getLabel(), "1");
        }
    }

    public void pressEnter() {
        MenuItem menuItem = this.getItem(this.act_option);
        if (menuItem.isEnabled()) {
            this.invCheckit(this.act_option);
            this.sendEvent(65522);
        }
    }

    public void pressExit() {
        this.sendEvent(65521);
    }

    private boolean incOption() {
        int n = this.countItems();
        if (n <= 0) {
            return false;
        }
        this.prev_option = this.act_option;
        for (int i = 0; i < n; ++i) {
            if (this.act_option < n - 1) {
                ++this.act_option;
                if (this.getItem(this.act_option).getLabel().equals("-")) continue;
                return true;
            }
            this.act_option = 0;
            if (this.getItem(this.act_option).getLabel().equals("-")) continue;
            return true;
        }
        return false;
    }

    private boolean decOption() {
        int n = this.countItems();
        if (n <= 0) {
            return false;
        }
        this.prev_option = this.act_option;
        for (int i = 0; i < n; ++i) {
            if (this.act_option > 0) {
                --this.act_option;
                if (this.getItem(this.act_option).getLabel().equals("-")) continue;
                return true;
            }
            this.act_option = n - 1;
            if (this.getItem(this.act_option).getLabel().equals("-")) continue;
            return true;
        }
        return false;
    }

    public void pressMouse(Event event) {
        int n = this.countItems();
        boolean bl = true;
        if (n == 0 || !this.inside(event.x, event.y)) {
            if (event.clickCount >= 1) {
                this.pressExit();
            }
            return;
        }
        int n2 = (event.y - this.size.y) / this.stap;
        if (n2 != this.act_option && n2 < n && !this.getItem(n2).getLabel().equals("-")) {
            this.prev_option = this.act_option;
            this.act_option = n2;
        } else {
            bl = false;
        }
        if (bl) {
            this.sendEvent(65520);
        }
        if (event.id == 502) {
            this.pressEnter();
        }
    }

    public boolean inside(int n, int n2) {
        return n <= this.size.x + this.size.width && n >= this.size.x && n2 <= this.size.y + this.size.height && n2 >= this.size.y;
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 505: {
                this.pressExit();
                break;
            }
            case 401: {
                if (event.key == 10) {
                    this.pressEnter();
                    break;
                }
                this.pressExit();
                break;
            }
            case 403: {
                this.pressKey(event);
                break;
            }
            case 503: 
            case 506: {
                this.pressMouse(event);
                break;
            }
            case 501: {
                this.pressMouse(event);
                break;
            }
            case 502: {
                this.pressMouse(event);
            }
        }
        return true;
    }

    private void sendEvent(int n) {
        if (this.getParent() == null) {
            return;
        }
        Event event = null;
        switch (n) {
            case 65520: {
                event = new Event(null, 65520, null);
                break;
            }
            case 65523: {
                event = new Event(null, 65523, null);
                break;
            }
            case 65521: {
                event = new Event(null, 65521, null);
                break;
            }
            case 65522: {
                MenuItem menuItem = this.getItem(this.act_option);
                event = new Event(menuItem, 65522, menuItem.getLabel());
            }
        }
        if (event != null) {
            ((ContextMenuBar)this.getParent()).sendEvent(event);
        }
    }
}

