/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.Rectangle;
import org.zaval.awt.ContextMenu;
import org.zaval.awt.event.Event;
import org.zaval.awt.event.Listener;
import org.zaval.awt.event.ListenerSupport;

public class ContextMenuBar
extends MenuBar {
    public static final int EV_MENU_REDRAW = 65520;
    public static final int EV_MENU_EXIT = 65521;
    public static final int EV_MENU_ENTER = 65522;
    public static final int EV_MENU_REDRAWALL = 65523;
    public Container parent = null;
    ContextMenu act_menu = null;
    boolean first = true;
    ListenerSupport support = new ListenerSupport();

    public ContextMenuBar(Container container) {
        this.parent = container;
    }

    public ContextMenuBar() {
    }

    public void addListener(Listener listener) {
        this.support.addListener(listener);
    }

    public void removeListener(Listener listener) {
        this.support.removeListener(listener);
    }

    public void setParent(Container container) {
        this.parent = container;
    }

    public Dimension getParentSize() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.size();
    }

    public void add(ContextMenu contextMenu) {
        contextMenu.index = this.countMenus();
        super.add(contextMenu);
    }

    public void remove(int n) {
        super.remove(n);
    }

    public void remove(MenuComponent menuComponent) {
        super.remove(menuComponent);
    }

    public boolean init(int n, int n2, int n3) {
        this.act_menu = this.get(n);
        if (this.act_menu == null || !this.act_menu.isEnabled()) {
            this.act_menu = null;
            return false;
        }
        this.act_menu.setPos(n2, n3);
        this.first = true;
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.act_menu == null) {
            return;
        }
        if (this.first) {
            this.first = false;
            this.act_menu.paint(graphics);
        } else {
            this.act_menu.paintPart(graphics);
        }
    }

    public boolean isRedraw() {
        return this.first;
    }

    public boolean isActive() {
        return this.parent != null && this.act_menu != null;
    }

    public ContextMenu get(int n) {
        return (ContextMenu)super.getMenu(n);
    }

    public void disable(int n) {
        this.get(n).disable();
    }

    public void enable(int n) {
        this.get(n).enable();
    }

    public void repaint() {
        if (this.parent == null) {
            return;
        }
        Graphics graphics = this.parent.getGraphics();
        this.paint(graphics);
        graphics.dispose();
    }

    public void repaintAll() {
        this.first = true;
        if (this.act_menu != null && this.parent != null) {
            Rectangle rectangle = this.act_menu.getBounds();
            this.parent.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.repaint();
    }

    public void sendEvent(java.awt.Event event) {
        if (this.parent == null || this.act_menu == null) {
            return;
        }
        switch (event.id) {
            case 65520: {
                this.repaint();
                break;
            }
            case 65523: {
                this.repaintAll();
                break;
            }
            case 65521: {
                this.repaintAll();
                this.act_menu = null;
                break;
            }
            case 65522: {
                this.repaintAll();
                this.act_menu = null;
                event.id = 1001;
                if (this.support.size() > 0) {
                    Event event2 = new Event(this, 65522);
                    event2.put("event", event);
                    this.support.perform(event2);
                    break;
                }
                this.parent.postEvent(event);
            }
        }
    }

    public boolean handleEvent(java.awt.Event event) {
        if (this.act_menu == null || !this.act_menu.isEnabled()) {
            return false;
        }
        return this.act_menu.handleEvent(event);
    }
}

