/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import org.zaval.awt.event.ValidateEvent;
import org.zaval.awt.event.ValidateListener;
import org.zaval.awt.event.ValidateListenerSupport;

public abstract class DecorativeComponent {
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private Color bColor = Color.white;
    private Color fColor = Color.black;
    private Font font;
    private int align = 1;
    private Dimension size = new Dimension(0, 0);
    private boolean isValid = false;
    private Component parent;
    private Insets insets = new Insets(0, 2, 4, 4);
    private ValidateListenerSupport listener = new ValidateListenerSupport();

    public DecorativeComponent() {
        this(null);
    }

    public DecorativeComponent(Component component) {
        this.setParent(component);
        this.invalidate();
    }

    public void addValidateListener(ValidateListener validateListener) {
        this.listener.addListener(validateListener);
    }

    public void removeValidateListener(ValidateListener validateListener) {
        this.listener.removeListener(validateListener);
    }

    protected void validatePerform() {
        this.listener.perform(new ValidateEvent(this, 2));
    }

    protected void invalidatePerform() {
        this.listener.perform(new ValidateEvent(this, 1));
    }

    public void setFromComponent(Component component) {
        if (component == null) {
            return;
        }
        if (component.getFont() != null) {
            this.setFont(component.getFont());
        }
        if (component.getBackground() != null) {
            this.setBackgroundColor(component.getBackground());
        }
        if (component.getForeground() != null) {
            this.setForegroundColor(component.getForeground());
        }
    }

    public Component getParent() {
        return this.parent;
    }

    public void setParent(Component component) {
        this.parent = component;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.invalidate();
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int n) {
        if (n == this.align) {
            return;
        }
        this.align = n;
    }

    public Color getBackgroundColor() {
        return this.bColor;
    }

    public void setBackgroundColor(Color color) {
        this.bColor = color;
    }

    public Color getForegroundColor() {
        return this.fColor;
    }

    public void setForegroundColor(Color color) {
        this.fColor = color;
    }

    public void setSize(Dimension dimension) {
        if (dimension == this.size) {
            return;
        }
        this.size.width = dimension.width;
        this.size.height = dimension.height;
        this.invalidate();
    }

    public Dimension getSize() {
        return this.size;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    protected void invalidate() {
        if (this.isValid) {
            this.isValid = false;
            this.invalidatePerform();
        }
    }

    protected void validate() {
        if (!this.isValid) {
            this.isValid = true;
            this.validatePerform();
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void doValidate() {
        this.validate();
    }

    public void doPaint(int n, int n2, int n3, int n4, Graphics graphics) {
        this.validate();
        if (!this.isValid()) {
            return;
        }
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        this.draw(n, n2, n3, n4, graphics);
    }

    public void doPaint(int n, int n2, Graphics graphics) {
        this.validate();
        if (!this.isValid()) {
            return;
        }
        Dimension dimension = this.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        this.draw(n, n2, dimension.width, dimension.height, graphics);
    }

    protected abstract void draw(int var1, int var2, int var3, int var4, Graphics var5);
}

