/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import org.zaval.awt.EmulatedTextField;
import org.zaval.awt.ScrollObject;

public class EmulatedTextArea
extends EmulatedTextField
implements ScrollObject {
    boolean wordWrap = false;
    int[] lineStart = new int[20];
    Vector lineText = new Vector();
    int maxTextWidth = 0;
    int rowsNumber = 0;
    int prefWidth = 0;
    int upRowNum = 0;
    int baseTextIndent = 0;
    int viewWidth = 0;
    int viewHeight = 0;
    Image internImg = null;
    int textWidth = 0;
    int textHeight = 0;
    int lastVisLine = 0;
    boolean addLineFeed = true;
    boolean noFontMetric = false;
    public static final int LINE_INCR = 20;

    public EmulatedTextArea() {
        this.lineText.addElement("");
    }

    public EmulatedTextArea(boolean bl, boolean bl2, int n, int n2) {
        this();
        this.wordWrap = bl;
        this.rowsNumber = n;
        this.prefWidth = n2;
        this.addLineFeed = bl2;
    }

    public void setLineFeed(boolean bl) {
        this.addLineFeed = bl;
    }

    public void setWordWrap(boolean bl) {
        this.wordWrap = bl;
    }

    public void setPrefWidth(int n) {
        this.prefWidth = n;
    }

    public void setRowsNumber(int n) {
        this.rowsNumber = n;
    }

    public void setText(String string) {
        super.setText(string);
        this.recalcLines(0);
    }

    public void focusGained(FocusEvent focusEvent) {
        int n = this.cursorPos;
        super.focusGained(focusEvent);
        this.selPos = 0;
        this.selWidth = 0;
        this.cursorPos = n;
    }

    protected boolean controlKey(int n, boolean bl) {
        switch (n) {
            case 40: {
                this.seek(this.vertPosShift(this.cursorPos, 1) - this.cursorPos, bl);
                break;
            }
            case 38: {
                this.seek(this.vertPosShift(this.cursorPos, -1) - this.cursorPos, bl);
                break;
            }
            case 36: {
                this.seek(this.lineStart[this.lineFromPos(this.cursorPos)] - this.cursorPos, bl);
                break;
            }
            case 35: {
                int n2 = this.lineFromPos(this.cursorPos);
                int n3 = this.buffer.toString().length();
                if (n2 < this.lineText.size() - 1) {
                    n3 = this.adjustPos(this.lineStart[n2 + 1] - 1, false);
                }
                this.seek(n3 - this.cursorPos, bl);
                break;
            }
            case 10: {
                return false;
            }
            case 33: {
                this.upRowNum -= this.lastVisLine;
                if (this.upRowNum < 0) {
                    this.upRowNum = 0;
                }
                this.seek(this.vertPosShift(this.cursorPos, -this.lastVisLine) - this.cursorPos, bl);
                break;
            }
            case 34: {
                this.upRowNum += this.lastVisLine;
                if (this.upRowNum + this.lastVisLine >= this.lineText.size()) {
                    this.upRowNum = this.lineText.size() - this.lastVisLine - 1;
                }
                this.seek(this.vertPosShift(this.cursorPos, this.lastVisLine) - this.cursorPos, bl);
                break;
            }
            default: {
                return super.controlKey(n, bl);
            }
        }
        if (!bl) {
            this.clear();
        }
        return true;
    }

    protected boolean write(char c) {
        super.write(c);
        if (this.addLineFeed && c == '\n') {
            super.write('\r');
        }
        this.recalcLines(this.cursorPos);
        return true;
    }

    protected String filterSymbols(String string) {
        return string;
    }

    protected void repaintPart() {
        this.repaint();
    }

    protected void remove(int n, int n2) {
        if (n + n2 > this.buffer.length()) {
            n2 = this.buffer.length() - n;
        }
        if (n > this.buffer.length() || n2 <= 0) {
            return;
        }
        if (n > 0 && this.buffer.charAt(n) == '\n' && this.buffer.charAt(n - 1) == '\r') {
            --n;
            ++n2;
        }
        if (n + n2 < this.buffer.length() && this.buffer.charAt(n + n2 - 1) == '\r' && this.buffer.charAt(n + n2) == '\n') {
            ++n2;
        }
        super.remove(n, n2);
        this.recalcLines(n);
    }

    public void insert(int n, String string) {
        super.insert(n, string);
        this.recalcLines(n);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        if (dimension.width != this.viewWidth || dimension.height != this.viewHeight || this.internImg == null) {
            if (dimension.width * dimension.height <= 0) {
                return;
            }
            this.internImg = this.createImage(dimension.width, dimension.height);
            this.viewWidth = dimension.width;
            this.viewHeight = dimension.height;
        }
        Graphics graphics2 = this.internImg.getGraphics();
        this.recalc();
        graphics2.clearRect(0, 0, dimension.width, dimension.height);
        this.drawBorder(graphics2);
        graphics2.clipRect(this.insets.left, this.insets.top, dimension.width - this.insets.left - this.insets.right + 1, dimension.height - this.insets.top - this.insets.bottom);
        this.drawCursor(graphics2);
        this.drawText(graphics2);
        this.drawBlock(graphics2);
        graphics.drawImage(this.internImg, 0, 0, this);
        graphics2.dispose();
    }

    protected void drawBlock(Graphics graphics) {
        if (!this.isSelected()) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = this.lineFromPos(this.selPos);
        int n2 = this.lineFromPos(this.selPos + this.selWidth);
        for (int i = n; i <= n2; ++i) {
            String string = (String)this.lineText.elementAt(i);
            int n3 = 0;
            int n4 = 0;
            if (i == n) {
                n4 = this.selPos - this.lineStart[i];
                n3 = fontMetrics.stringWidth(string.substring(0, n4));
            }
            int n5 = fontMetrics.stringWidth(string);
            int n6 = string.length();
            if (i == n2) {
                n6 = this.selPos + this.selWidth - this.lineStart[i];
                n5 = fontMetrics.stringWidth(string.substring(0, n6));
            }
            graphics.setColor(Color.blue);
            graphics.fillRect(this.textLocation.x + this.shift.x + n3, this.insets.top + (i - this.upRowNum) * fontMetrics.getHeight(), n5 - n3, this.textSize.height);
            graphics.setColor(Color.white);
            graphics.drawString(string.substring(n4, n6), this.insets.left + n3 + this.shift.x, this.insets.top + this.baseTextIndent + (i - this.upRowNum) * fontMetrics.getHeight());
        }
    }

    protected void drawText(Graphics graphics) {
        Dimension dimension = this.size();
        graphics.setColor(this.getForeground());
        for (int i = this.upRowNum; i < this.lineText.size(); ++i) {
            graphics.drawString((String)this.lineText.elementAt(i), this.insets.left + this.shift.x, this.insets.top + this.baseTextIndent + (i - this.upRowNum) * this.textSize.height);
        }
    }

    public Dimension preferredSize() {
        Object object;
        Object object2;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        Font font = this.getFont();
        if (font == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics == null && (fontMetrics = ((Toolkit)(object2 = Toolkit.getDefaultToolkit())).getFontMetrics(font)) == null) {
            return new Dimension(0, 0);
        }
        object2 = this.getText();
        for (int i = 0; i < ((String)object2).length(); ++i) {
            if (((String)object2).charAt(i) != '\n') continue;
            ++n3;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)object2, "\n");
        n2 = fontMetrics.getHeight() * (n3 + 1);
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            n = Math.max(n, fontMetrics.stringWidth((String)object));
        }
        object = this.insets();
        Dimension dimension = new Dimension(((Insets)object).left + ((Insets)object).right + n, ((Insets)object).top + ((Insets)object).bottom + n2);
        return dimension;
    }

    public Point getSOLocation() {
        return new Point(-this.shift.x, this.upRowNum * this.textSize.height);
    }

    public void setSOLocation(int n, int n2) {
        this.shift.x = -n;
        if (this.textSize.height > 0) {
            this.upRowNum = n2 / this.textSize.height;
        }
        this.repaint();
    }

    public Dimension getSOSize() {
        return new Dimension(this.maxTextWidth + this.insets.left + this.insets.right, this.lineText.size() * this.textSize.height + this.insets.top + this.insets.bottom);
    }

    public Component getScrollComponent() {
        return this;
    }

    protected void setLineStart(int n, int n2) {
        if (n >= this.lineStart.length) {
            int[] nArray = new int[(n / 20 + 1) * 20];
            System.arraycopy(this.lineStart, 0, nArray, 0, this.lineStart.length);
            this.lineStart = nArray;
        }
        this.lineStart[n] = n2;
    }

    protected int indexOfBlank(String string, int n) {
        int n2;
        int n3 = string.indexOf(32, n);
        if (n3 < 0) {
            n3 = string.length() - 1;
        }
        if ((n2 = string.indexOf(9, n)) < 0) {
            n2 = string.length() - 1;
        }
        return Math.min(n3, n2);
    }

    protected void recalcLines(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.lineFromPos(n);
        int n6 = this.lineText.size();
        int n7 = this.maxTextWidth;
        Dimension dimension = this.size();
        Insets insets = this.insets();
        this.textWidth = dimension.width - insets.left - insets.right;
        this.textHeight = dimension.height - insets.top - insets.bottom;
        if (this.textWidth <= 0 || this.textHeight <= 0) {
            return;
        }
        this.noFontMetric = true;
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics == null) {
            return;
        }
        this.noFontMetric = false;
        if (n5 > this.lineText.size()) {
            return;
        }
        String string = this.buffer.toString();
        int n8 = n5;
        for (n4 = this.lineText.size() - 1; n4 >= n8; --n4) {
            this.lineText.removeElementAt(n4);
        }
        this.setLineStart(0, 0);
        n4 = this.lineStart[n8];
        do {
            int n9;
            n3 = string.indexOf(10, n4);
            n2 = n3 + 1;
            if (n3 < 0) {
                n3 = string.length();
            }
            if (n3 > 0 && string.charAt(n3 - 1) == '\r') {
                --n3;
            }
            String string2 = string.substring(n4, n3);
            if (this.wordWrap && fontMetrics.stringWidth(string2) > this.textWidth && (n9 = this.indexOfBlank(string, n4)) < n3) {
                n3 = n9 + 1;
                String string3 = string2 = string.substring(n4, n3);
                while (fontMetrics.stringWidth(string3) < this.textWidth) {
                    string2 = string3;
                    n3 = n9 + 1;
                    n9 = this.indexOfBlank(string, n3);
                    string3 = string.substring(n4, n9 + 1);
                }
                n2 = n3;
            }
            this.lineText.addElement(string2);
            this.setLineStart(n8, n4);
            n4 = n2;
            ++n8;
        } while (n3 < string.length());
        this.maxTextWidth = 0;
        for (n2 = 0; n2 < this.lineText.size(); ++n2) {
            int n10 = fontMetrics.stringWidth((String)this.lineText.elementAt(n2));
            if (this.maxTextWidth >= n10) continue;
            this.maxTextWidth = n10;
        }
    }

    protected void setPos(int n) {
        super.setPos(this.adjustPos(n, true));
    }

    public void select(int n, int n2) {
        int n3 = this.adjustPos(n, true);
        int n4 = this.adjustPos(n + n2, true) - n3;
        super.select(n3, n4);
    }

    protected boolean seek(int n, boolean bl) {
        return super.seek(this.adjustPos(this.cursorPos + n, n > 0) - this.cursorPos, bl);
    }

    protected int adjustPos(int n, boolean bl) {
        int n2 = this.lineFromPos(n);
        int n3 = ((String)this.lineText.elementAt(n2)).length();
        if (n2 < this.lineText.size() - 1 && n - this.lineStart[n2] > n3) {
            if (bl) {
                return this.lineStart[n2 + 1];
            }
            return this.lineStart[n2] + n3;
        }
        return n;
    }

    protected boolean recalc() {
        int n = this.shift.x;
        if (this.noFontMetric) {
            this.recalcLines(0);
        }
        boolean bl = super.recalc();
        this.shift.x = n;
        int n2 = this.lineFromPos(this.cursorPos);
        String string = (String)this.lineText.elementAt(n2);
        string = string.substring(0, this.cursorPos - this.lineStart[n2]);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.shift.y = 0;
        this.baseTextIndent = fontMetrics.getHeight() - fontMetrics.getDescent();
        int n3 = this.lineFromPos(this.cursorPos);
        if (n3 < this.upRowNum) {
            this.upRowNum = n3;
        }
        this.lastVisLine = this.textHeight / fontMetrics.getHeight() - 1;
        if (this.lastVisLine < 0) {
            this.lastVisLine = 0;
        }
        if (n3 > this.lastVisLine + this.upRowNum) {
            this.upRowNum = n3 - this.lastVisLine;
        }
        this.cursorLocation.x = this.insets.left + fontMetrics.stringWidth(string);
        this.cursorLocation.y = this.insets.top + (n2 - this.upRowNum) * this.textSize.height;
        if (this.cursorLocation.x + this.shift.x < this.insets.left) {
            this.shift.x = this.insets.left - this.cursorLocation.x;
        } else {
            int n4 = this.size().width - this.insets.right;
            if (this.cursorLocation.x + this.shift.x > n4) {
                this.shift.x = n4 - this.cursorLocation.x;
            }
        }
        return bl;
    }

    protected int getLinePos(int n, FontMetrics fontMetrics, int n2) {
        int n3;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.lineText.size()) {
            n = this.lineText.size() - 1;
        }
        String string = (String)this.lineText.elementAt(n);
        for (n3 = 0; n3 < string.length(); ++n3) {
            if (fontMetrics.stringWidth(string.substring(0, n3)) <= n2) continue;
            return this.lineStart[n] + n3 - 1;
        }
        n3 = this.lineStart[n] + string.length();
        if (n2 > 0 && n < this.lineText.size() - 1 && this.buffer.charAt(this.lineStart[n + 1] - 1) != '\n') {
            --n3;
        }
        return n3;
    }

    protected int calcTextPos(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return this.getLinePos((n2 - this.insets.top) / fontMetrics.getHeight() + this.upRowNum, fontMetrics, n - this.insets.left - this.shift.x);
    }

    protected int vertPosShift(int n, int n2) {
        int n3 = this.lineFromPos(n);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n4 = fontMetrics.stringWidth(((String)this.lineText.elementAt(n3)).substring(0, n - this.lineStart[n3]));
        return this.getLinePos(n3 + n2, fontMetrics, n4);
    }

    protected int lineFromPos(int n) {
        for (int i = this.lineText.size() - 1; i >= 0; --i) {
            if (this.lineStart[i] > n) continue;
            return i;
        }
        return 0;
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.recalcLines(0);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Dimension dimension = this.size();
        super.reshape(n, n2, n3, n4);
        if (dimension.width != n3) {
            this.recalcLines(0);
        }
    }
}

