/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class EmulatedTextField
extends Canvas
implements KeyListener,
MouseListener,
FocusListener,
ActionListener {
    protected static EmulatedTextField cursorOwner = null;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    protected StringBuffer buffer = new StringBuffer("");
    Insets insets = new Insets(2, 5, 2, 5);
    Point textLocation = new Point(0, 0);
    Point cursorLocation = new Point(0, 0);
    Dimension textSize = new Dimension(0, 0);
    Dimension cursorSize = new Dimension(0, 0);
    Point shift = new Point(0, 0);
    Color cursorColor = Color.black;
    int cursorPos = 0;
    int align = 1;
    boolean is3D = true;
    protected int selPos = 0;
    protected int selWidth = 0;
    protected int startSel = 0;
    private PopupMenu menu;
    private int minSize = 0;
    private long clickTime = 0L;
    private static String clipboard;

    public EmulatedTextField() {
        this((String)null);
    }

    public EmulatedTextField(int n) {
        this((String)null);
        this.minSize = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cut")) {
            this.blCopy();
            this.removeBlock();
        } else if (actionEvent.getActionCommand().equals("Copy")) {
            this.blCopy();
        } else if (actionEvent.getActionCommand().equals("Paste")) {
            this.blPaste();
        }
    }

    public EmulatedTextField(String string) {
        if (string != null) {
            this.setText(string);
        }
        this.enableInputMethods(true);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.menu = new PopupMenu();
        this.add(this.menu);
        MenuItem menuItem = new MenuItem("Cut");
        this.menu.add(menuItem);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("Cut");
        menuItem = new MenuItem("Copy");
        this.menu.add(menuItem);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("Copy");
        menuItem = new MenuItem("Paste");
        this.menu.add(menuItem);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("Paste");
        this.menu.addActionListener(this);
    }

    public void setText(String string) {
        this.buffer = new StringBuffer(string);
        this.setPos(0);
    }

    public String getText() {
        return this.buffer.toString();
    }

    public void setAlign(int n) {
        this.align = n;
    }

    public void getAlign(int n) {
        this.align = n;
        this.repaint();
    }

    public void setCursorColor(Color color) {
        this.cursorColor = color;
        if (this.hasFocus()) {
            this.repaint();
        }
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    public boolean hasFocus() {
        return this == cursorOwner;
    }

    public void setInsets(Insets insets) {
        this.insets.top = insets.top;
        this.insets.left = insets.left;
        this.insets.right = insets.right;
        this.insets.bottom = insets.bottom;
        this.repaint();
    }

    public void set3D(boolean bl) {
        if (bl == this.is3D) {
            return;
        }
        this.is3D = bl;
        this.repaint();
    }

    public boolean is3D() {
        return this.is3D;
    }

    public void keyTyped(KeyEvent keyEvent) {
        boolean bl;
        int n = keyEvent.getKeyCode();
        boolean bl2 = (keyEvent.getModifiers() & 2) != 0;
        boolean bl3 = bl = (keyEvent.getModifiers() & 1) != 0;
        if (this.controlKey(n, bl)) {
            return;
        }
        if (keyEvent.isActionKey()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c == '\uffff') {
            return;
        }
        if (c == '\u007f' || c == '\u001b') {
            return;
        }
        if (keyEvent.isControlDown()) {
            return;
        }
        if (c != '\b' && c != '\t') {
            this.removeBlock();
            if (this.write(c)) {
                this.seek(1, false);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        int n = keyEvent.getKeyCode();
        boolean bl2 = (keyEvent.getModifiers() & 2) != 0;
        boolean bl3 = bl = (keyEvent.getModifiers() & 1) != 0;
        if (this.blockKey(n, bl2, bl)) {
            return;
        }
        if (this.controlKey(n, bl)) {
            return;
        }
        if (n == 123) {
            this.menu.show(this, 0, 0);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    protected boolean blockKey(int n, boolean bl, boolean bl2) {
        boolean bl3 = bl2;
        if (bl && (n == 155 || n == 67)) {
            this.blCopy();
        } else if (bl2 && n == 155 || bl && n == 86) {
            this.blPaste();
        } else if (bl2 && n == 127 || bl && n == 88) {
            this.blDelete();
        } else if (bl && n == 39) {
            this.seek(this.nextSpace() - this.cursorPos, bl3);
        } else if (bl && n == 37) {
            this.seek(this.prevSpace() - this.cursorPos, bl3);
        } else if (!bl) {
            return false;
        }
        return true;
    }

    protected int prevSpace() {
        int n = this.cursorPos;
        if (n >= this.buffer.length()) {
            n = this.buffer.length() - 1;
        }
        while (n > 0 && Character.isSpaceChar(this.buffer.charAt(n))) {
            --n;
        }
        while (n > 0 && !Character.isSpaceChar(this.buffer.charAt(n))) {
            --n;
        }
        return n;
    }

    protected int nextSpace() {
        int n = this.cursorPos;
        int n2 = this.buffer.length();
        if (n >= n2) {
            return this.cursorPos;
        }
        while (n < n2 && Character.isSpaceChar(this.buffer.charAt(n))) {
            ++n;
        }
        while (n < n2 && !Character.isSpaceChar(this.buffer.charAt(n))) {
            ++n;
        }
        return n;
    }

    protected boolean controlKey(int n, boolean bl) {
        boolean bl2 = true;
        switch (n) {
            case 39: 
            case 40: {
                this.seek(1, bl);
                break;
            }
            case 37: 
            case 38: {
                this.seek(-1, bl);
                break;
            }
            case 35: {
                this.seek2end(bl);
                break;
            }
            case 36: {
                this.seek2beg(bl);
                break;
            }
            case 127: {
                if (!this.isSelected()) {
                    this.remove(this.cursorPos, 1);
                    break;
                }
                this.removeBlock();
                break;
            }
            case 8: {
                if (!this.isSelected()) {
                    if (this.cursorPos <= 0) break;
                    this.seek(-1, bl);
                    this.remove(this.cursorPos, 1);
                    break;
                }
                this.removeBlock();
                break;
            }
            case 10: 
            case 33: 
            case 34: {
                break;
            }
            case 155: {
                return false;
            }
            case 9: {
                return true;
            }
            default: {
                return false;
            }
        }
        if (!bl) {
            this.clear();
        }
        return bl2;
    }

    public void blPaste() {
        String string = EmulatedTextField.readFromClipboard();
        if (string != null) {
            string = this.filterSymbols(string);
            this.removeBlock();
            this.insert(this.cursorPos, string);
            this.setPos(this.cursorPos + string.length());
        }
    }

    protected String filterSymbols(String string) {
        return string;
    }

    public String getSelectedText() {
        return this.buffer.toString().substring(this.selPos, this.selPos + this.selWidth);
    }

    public void blCopy() {
        if (!this.isSelected()) {
            return;
        }
        EmulatedTextField.writeToClipboard(this.buffer.toString().substring(this.selPos, this.selPos + this.selWidth));
    }

    public void blDelete() {
        if (!this.isSelected()) {
            return;
        }
        EmulatedTextField.writeToClipboard(this.buffer.toString().substring(this.selPos, this.selPos + this.selWidth));
        this.removeBlock();
    }

    protected boolean inputKey(int n) {
        this.removeBlock();
        char c = (char)n;
        if (this.write(n)) {
            this.seek(1, false);
        }
        return true;
    }

    protected void removeBlock() {
        if (this.isSelected()) {
            this.remove(this.selPos, this.selWidth);
            this.setPos(this.selPos);
            this.clear();
        }
    }

    public void paint(Graphics graphics) {
        this.recalc();
        this.drawBorder(graphics);
        this.drawCursor(graphics);
        this.drawText(graphics);
        this.drawBlock(graphics);
    }

    public Insets insets() {
        return this.insets;
    }

    protected void drawBlock(Graphics graphics) {
        int n = this.buffer.length();
        if (!this.isSelected()) {
            return;
        }
        String string = this.buffer.toString();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.stringWidth(string.substring(0, this.selPos));
        int n3 = fontMetrics.stringWidth(string.substring(0, this.selPos + this.selWidth));
        graphics.setColor(Color.blue);
        graphics.fillRect(this.textLocation.x + this.shift.x + n2, this.cursorLocation.y + this.shift.y, n3 - n2, this.textSize.height);
        graphics.setColor(Color.white);
        graphics.drawString(string.substring(this.selPos, this.selPos + this.selWidth), this.textLocation.x + this.shift.x + n2, this.textLocation.y + this.shift.y);
    }

    protected void drawText(Graphics graphics) {
        Dimension dimension = this.size();
        graphics.clipRect(this.insets.left, this.insets.top, dimension.width - this.insets.left - this.insets.right, dimension.height - this.insets.top - this.insets.bottom);
        graphics.setColor(this.getForeground());
        graphics.drawString(this.buffer.toString(), this.textLocation.x + this.shift.x, this.textLocation.y + this.shift.y);
    }

    protected void drawCursor(Graphics graphics) {
        if (cursorOwner != this) {
            return;
        }
        graphics.setColor(this.cursorColor);
        graphics.fillRect(this.cursorLocation.x + this.shift.x, this.cursorLocation.y + this.shift.y, this.cursorSize.width, this.cursorSize.height);
    }

    public Rectangle getCursorShape() {
        return new Rectangle(this.cursorLocation.x + this.shift.x, this.cursorLocation.y + this.shift.y, this.cursorSize.width, this.cursorSize.height);
    }

    protected void drawBorder(Graphics graphics) {
        Dimension dimension = this.size();
        if (this.is3D) {
            graphics.setColor(Color.gray);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, dimension.width - 3, 1);
            graphics.drawLine(1, 1, 1, dimension.height - 3);
            graphics.setColor(Color.white);
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
        } else {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    protected boolean seek(int n, boolean bl) {
        int n2 = this.buffer.length();
        int n3 = this.getValidPos(n);
        if (n3 > n2 || n3 < 0) {
            return false;
        }
        if (!this.isSelected() && bl) {
            this.startSel = this.cursorPos;
        }
        this.setPos(n3);
        if (bl) {
            if (this.cursorPos < this.startSel) {
                this.select(this.cursorPos, this.startSel - this.cursorPos);
            } else {
                this.select(this.startSel, this.cursorPos - this.startSel);
            }
        }
        return true;
    }

    protected int getValidPos(int n) {
        return this.cursorPos + n;
    }

    protected boolean seek2end(boolean bl) {
        this.seek(this.buffer.length() - this.cursorPos, bl);
        return true;
    }

    protected boolean seek2beg(boolean bl) {
        this.seek(-this.cursorPos, bl);
        return true;
    }

    protected boolean write(int n) {
        this.buffer.insert(this.cursorPos, (char)n);
        return true;
    }

    protected boolean write(char c) {
        this.buffer.insert(this.cursorPos, c);
        return true;
    }

    protected void remove(int n, int n2) {
        if (n > this.buffer.length() || n < 0) {
            return;
        }
        if (n + n2 > this.buffer.length()) {
            n2 = this.buffer.length() - n;
        }
        String string = this.buffer.toString();
        string = string.substring(0, n) + string.substring(n + n2);
        this.buffer = new StringBuffer(string);
        this.repaintPart();
    }

    protected int getShift(int n, Dimension dimension, Insets insets) {
        if (n < insets.left) {
            return insets.left - n;
        }
        int n2 = dimension.width - insets.right;
        if (n > n2) {
            return n2 - n;
        }
        return 0;
    }

    public void insert(int n, String string) {
        if (n > this.buffer.length() || n < 0) {
            return;
        }
        String string2 = this.buffer.toString();
        string2 = string2.substring(0, n) + string + string2.substring(n);
        this.buffer = new StringBuffer(string2);
        this.repaintPart();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void selectAll() {
        this.select(0, this.buffer.length());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        long l;
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (cursorOwner != this) {
            this.requestFocus();
        }
        if ((n = this.calcTextPos(n2, n3)) >= 0 && n != this.cursorPos) {
            this.setPos(n);
        }
        if (mouseEvent.isPopupTrigger() || mouseEvent.isShiftDown()) {
            this.menu.show(this, n2, n3);
            return;
        }
        if (this.isSelected() && !mouseEvent.isShiftDown()) {
            this.clear();
        }
        if ((l = System.currentTimeMillis()) - this.clickTime < 300L) {
            this.select(0, this.buffer.length());
        }
        this.clickTime = l;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected int calcTextPos(int n, int n2) {
        if (this.buffer.length() == 0) {
            return 0;
        }
        if (n > this.shift.x + this.textSize.width + this.textLocation.x) {
            return this.buffer.length();
        }
        if (this.shift.x + this.textLocation.x > n) {
            return 0;
        }
        int n3 = n - this.shift.x;
        int n4 = n3 * 100 / this.textSize.width;
        int n5 = this.buffer.length();
        int n6 = n5 * n4 / 100;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String string = this.buffer.toString();
        int n7 = n6;
        int n8 = n6 + 1;
        int n9 = n7;
        while (n7 >= 0 || n8 < n5) {
            if (n9 >= 0 && n9 < n5) {
                char c = this.buffer.charAt(n9);
                String string2 = string.substring(0, n9);
                int n10 = fontMetrics.stringWidth(string2) + this.shift.x + this.textLocation.x;
                int n11 = fontMetrics.charWidth(c);
                if (n >= n10 && n < n10 + n11) {
                    if (n > n10 + n11 / 2) {
                        return n9 + 1;
                    }
                    return n9;
                }
            }
            if (n9 == n8) {
                ++n8;
                n9 = --n7;
                continue;
            }
            n9 = n8;
        }
        return -1;
    }

    protected void setPos(int n) {
        this.cursorPos = n;
        this.repaintPart();
    }

    protected Dimension calcSize() {
        Object object;
        Font font = this.getFont();
        if (font == null) {
            return new Dimension(0, 25);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics == null && (fontMetrics = ((Toolkit)(object = Toolkit.getDefaultToolkit())).getFontMetrics(font)) == null) {
            return new Dimension(0, 25);
        }
        object = this.insets();
        String string = this.buffer.toString();
        return new Dimension(((Insets)object).left + ((Insets)object).right + Math.max(this.minSize * fontMetrics.stringWidth("W"), fontMetrics.stringWidth(string)), ((Insets)object).top + ((Insets)object).bottom + Math.max(fontMetrics.getHeight(), 17));
    }

    protected boolean recalc() {
        Dimension dimension = this.size();
        if (dimension.width == 0 || dimension.height == 0) {
            return false;
        }
        Insets insets = this.insets();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return false;
        }
        String string = this.buffer.toString();
        String string2 = string.substring(0, this.cursorPos);
        int n = fontMetrics.stringWidth(string2);
        int n2 = dimension.height - insets.top - insets.bottom;
        this.textSize.height = fontMetrics.getHeight();
        this.textSize.width = fontMetrics.stringWidth(string);
        this.textLocation.y = insets.top + (n2 + this.textSize.height) / 2 - fontMetrics.getDescent();
        this.cursorLocation.x = n + insets.left;
        this.cursorLocation.y = this.textLocation.y - this.textSize.height + fontMetrics.getDescent();
        if (this.cursorLocation.y < insets.top) {
            this.cursorLocation.y = insets.top;
        }
        this.cursorSize.width = 1;
        this.cursorSize.height = this.textSize.height;
        if (this.cursorLocation.y + this.cursorSize.height >= dimension.height - insets.bottom) {
            this.cursorSize.height = dimension.height - this.cursorLocation.y - insets.bottom;
        }
        switch (this.align) {
            case 1: {
                this.textLocation.x = insets.left;
                this.cursorLocation.x = n + insets.left;
                break;
            }
            case 2: {
                this.textLocation.x = dimension.width - insets.right - this.textSize.width;
                this.cursorLocation.x = n + this.textLocation.x;
            }
        }
        if (this.cursorLocation.x + this.shift.x < insets.left) {
            this.shift.x = insets.left - this.cursorLocation.x;
        } else {
            int n3 = dimension.width - insets.right;
            if (this.cursorLocation.x + this.shift.x > n3) {
                this.shift.x = n3 - this.cursorLocation.x;
            }
        }
        return true;
    }

    public void resize(int n, int n2) {
        this.shift.x = 0;
        super.resize(n, n2);
    }

    protected void otdaiFocusTvojuMat() {
        cursorOwner = null;
        this.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (cursorOwner != null) {
            cursorOwner.otdaiFocusTvojuMat();
        }
        cursorOwner = this;
        if (this.buffer != null) {
            this.setPos(this.buffer.length());
            this.select(0, this.buffer.length());
        }
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (cursorOwner == this) {
            cursorOwner = null;
            this.clear();
            this.repaint();
        }
    }

    protected void repaintPart() {
        Insets insets = this.insets();
        Dimension dimension = this.size();
        this.repaint(insets.left, insets.top, dimension.width - insets.right - insets.left + 1, dimension.height - insets.bottom - insets.top + 1);
    }

    public Dimension preferredSize() {
        return this.calcSize();
    }

    public void select(int n, int n2) {
        if (this.selPos == n && n2 == this.selWidth) {
            return;
        }
        this.selPos = n;
        this.selWidth = n2;
        this.repaintPart();
    }

    public boolean isSelected() {
        int n = this.buffer.length();
        return this.selPos >= 0 && this.selPos < n && this.selPos + this.selWidth <= n && this.selWidth != 0;
    }

    protected void clear() {
        this.selWidth = 0;
        this.repaintPart();
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        int n3 = this.calcTextPos(n, n2);
        if (n3 >= 0) {
            if (n3 < this.cursorPos) {
                this.select(n3, this.cursorPos - n3);
            } else {
                this.select(this.cursorPos, n3 - this.cursorPos);
            }
        }
        return super.mouseDrag(event, n, n2);
    }

    protected static synchronized void writeToClipboard(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    protected static synchronized String readFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents("e");
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }
}

