/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;

public class ExGridLayout
implements LayoutManager {
    private static int hackIE401 = -1;
    protected Hashtable comptable;
    protected GridBagConstraints defaultConstraints;
    protected int startx = 0;
    protected int starty = 0;
    protected int cols = 0;
    protected int rows = 0;
    protected int[] widths = new int[MAX_X + 1];
    protected int[] heights = new int[MAX_Y + 1];
    public static int MAX_X = 2560;
    public static int MAX_Y = 2560;
    public static int MIN_W = 1;
    public static int MIN_H = 1;
    protected GridBagConstraints[] bags = null;
    protected Dimension[] sizes = null;
    protected double max_wx = 10.0;
    protected double max_wy = 10.0;

    public void setMaxExpanded(double d, double d2) {
        this.max_wx = d;
        this.max_wy = d2;
    }

    public void setLimits(int n, int n2) {
        MAX_X = Math.max(n, MAX_X);
        MAX_Y = Math.max(n2, MAX_Y);
        this.widths = new int[MAX_X + 1];
        this.heights = new int[MAX_Y + 1];
    }

    public ExGridLayout() {
        this.comptable = new Hashtable();
        this.defaultConstraints = new GridBagConstraints();
        this.initFix();
    }

    public ExGridLayout(int n, int n2) {
        this.comptable = new Hashtable();
        this.defaultConstraints = new GridBagConstraints();
        this.initFix();
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.bags = null;
        this.sizes = null;
        this.comptable.put(component, gridBagConstraints.clone());
    }

    public GridBagConstraints getConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        return gridBagConstraints;
    }

    public void updateComponent(Container container, Component component, Component component2) {
        GridBagConstraints gridBagConstraints = this.getConstraints(component);
        if (this.comptable.containsKey(component)) {
            this.comptable.remove(component);
            this.comptable.put(component2, gridBagConstraints);
            container.remove(component);
            container.add(component2);
            if (this.bags == null) {
                return;
            }
            this.arrange(container, component2);
        }
    }

    public Point location(int n, int n2) {
        int n3;
        Point point = new Point(0, 0);
        int n4 = this.startx;
        int n5 = this.starty;
        for (n3 = 0; n3 < this.cols && (n4 += this.widths[n3]) <= n; ++n3) {
        }
        point.x = n3;
        n4 = this.starty;
        for (n3 = 0; n3 < this.rows && (n4 += this.heights[n3]) <= n2; ++n3) {
        }
        point.y = n3;
        return point;
    }

    private void initFix() {
        if (hackIE401 == -1) {
            String string = "1.0.2.";
            String string2 = "Sun";
            try {
                string = System.getProperty("java.version");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                string2 = System.getProperty("java.vendor");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hackIE401 = !string.startsWith("1.0") && string2.startsWith("Microsoft") ? 1 : 0;
        }
    }

    private Dimension getSize(Container container, boolean bl) {
        int n;
        this.makeInfo(bl);
        Insets insets = container.insets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        for (n = 0; n < this.cols; ++n) {
            n2 += this.widths[n];
        }
        for (n = 0; n < this.rows; ++n) {
            n3 += this.heights[n];
        }
        return new Dimension(n2, n3);
    }

    private void makeInfo(boolean bl) {
        int n;
        int n2 = this.comptable.size();
        if (this.bags != null && this.bags.length == n2) {
            return;
        }
        this.bags = new GridBagConstraints[n2];
        this.sizes = new Dimension[n2];
        n2 = 0;
        Enumeration enumeration = this.comptable.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            GridBagConstraints gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
            this.sizes[n2] = bl ? component.preferredSize() : component.minimumSize();
            this.sizes[n2].width += gridBagConstraints.insets.right + gridBagConstraints.insets.left;
            this.sizes[n2].height += gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
            this.bags[n2++] = gridBagConstraints;
            n = gridBagConstraints.gridx + gridBagConstraints.gridwidth;
            this.cols = Math.max(this.cols, n);
            n = gridBagConstraints.gridy + gridBagConstraints.gridheight;
            this.rows = Math.max(this.rows, n);
        }
        for (n2 = 0; n2 < this.cols; ++n2) {
            this.widths[n2] = MIN_W;
        }
        for (n2 = 0; n2 < this.rows; ++n2) {
            this.heights[n2] = MIN_H;
        }
        for (n2 = 0; n2 < this.bags.length; ++n2) {
            int n3;
            for (n3 = 0; n3 < this.bags[n2].gridwidth; ++n3) {
                n = this.bags[n2].gridx + n3;
                this.widths[n] = Math.max(this.sizes[n2].width / this.bags[n2].gridwidth, this.widths[n]);
            }
            for (n3 = 0; n3 < this.bags[n2].gridheight; ++n3) {
                n = this.bags[n2].gridy + n3;
                this.heights[n] = Math.max(this.sizes[n2].height / this.bags[n2].gridheight, this.heights[n]);
            }
        }
    }

    private void arrange(Container container) {
        this.arrange(container, null);
    }

    private void arrange(Container container, Component component) {
        this.makeInfo(true);
        Component[] componentArray = container.getComponents();
        Rectangle rectangle = container.bounds();
        Insets insets = container.insets();
        Dimension dimension = this.getSize(container, true);
        if (rectangle.width < 5 || rectangle.height < 5) {
            return;
        }
        double d = (double)rectangle.width / (double)dimension.width;
        double d2 = (double)rectangle.height / (double)dimension.height;
        if (d > this.max_wx) {
            d = this.max_wx;
        }
        if (d2 > this.max_wy) {
            d2 = this.max_wy;
        }
        for (int i = 0; i < componentArray.length; ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            block23: {
                int n5;
                Dimension dimension2;
                block25: {
                    GridBagConstraints gridBagConstraints;
                    block24: {
                        block21: {
                            block22: {
                                int n6;
                                gridBagConstraints = (GridBagConstraints)this.comptable.get(componentArray[i]);
                                if (gridBagConstraints == null) {
                                    componentArray[i].hide();
                                    continue;
                                }
                                if (component != null && component != componentArray[i]) continue;
                                n4 = 0;
                                n3 = 0;
                                n2 = 0;
                                n = 0;
                                for (n6 = 0; n6 < gridBagConstraints.gridx; ++n6) {
                                    n3 += this.widths[n6];
                                }
                                while (n6 < gridBagConstraints.gridx + gridBagConstraints.gridwidth) {
                                    n += this.widths[n6];
                                    ++n6;
                                }
                                for (n6 = 0; n6 < gridBagConstraints.gridy; ++n6) {
                                    n4 += this.heights[n6];
                                }
                                while (n6 < gridBagConstraints.gridy + gridBagConstraints.gridheight) {
                                    n2 += this.heights[n6];
                                    ++n6;
                                }
                                n3 += gridBagConstraints.insets.left;
                                n4 += gridBagConstraints.insets.top;
                                if ((n -= gridBagConstraints.insets.right + gridBagConstraints.insets.left) <= 0 || (n2 -= gridBagConstraints.insets.bottom + gridBagConstraints.insets.top) <= 0) continue;
                                dimension2 = componentArray[i].preferredSize();
                                if (gridBagConstraints.fill == 2) {
                                    n2 = dimension2.height;
                                    dimension2.width = n;
                                } else if (gridBagConstraints.fill == 3) {
                                    n = dimension2.width;
                                    dimension2.height = n2;
                                } else if (gridBagConstraints.fill == 1) {
                                    dimension2.width = n;
                                    dimension2.height = n2;
                                }
                                if (n <= dimension2.width) break block21;
                                n5 = n - dimension2.width;
                                if (gridBagConstraints.anchor == 10) {
                                    n3 += n5 / 2;
                                    n = dimension2.width;
                                }
                                if (gridBagConstraints.anchor == 13) break block22;
                                if (gridBagConstraints.anchor == 12) break block22;
                                if (gridBagConstraints.anchor != 14) break block21;
                            }
                            n3 += n5;
                            n = dimension2.width;
                        }
                        if (n2 <= dimension2.height) break block23;
                        n5 = n2 - dimension2.height;
                        if (gridBagConstraints.anchor != 10) break block24;
                        n4 += n5 / 2;
                        n2 = dimension2.height;
                        break block23;
                    }
                    if (gridBagConstraints.anchor == 15) break block25;
                    if (gridBagConstraints.anchor == 16) break block25;
                    if (gridBagConstraints.anchor != 14) break block23;
                }
                n4 += n5;
                n2 = dimension2.height;
            }
            n2 = (int)(d2 * (double)n2 + 0.5);
            n = (int)(d * (double)n + 0.5);
            componentArray[i].resize(n, n2);
            componentArray[i].move((int)((double)n3 * d) + insets.left, (int)((double)n4 * d2) + insets.top);
            if (hackIE401 != 1 || componentArray[i].isVisible()) continue;
            componentArray[i].show();
            componentArray[i].hide();
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getSize(container, true);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getSize(container, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        boolean bl = container.isVisible();
        if (bl) {
            container.hide();
        }
        try {
            this.arrange(container);
        }
        finally {
            if (bl) {
                container.show();
                container.repaint();
            }
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

