/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;

public class FitLayout
implements LayoutManager {
    protected int gapX;
    protected int gapY;
    protected int gapW;
    protected int gapH;

    public FitLayout() {
        this(0, 0, 0, 0);
    }

    public FitLayout(int n, int n2, int n3, int n4) {
        this.gapX = n;
        this.gapY = n2;
        this.gapW = n3;
        this.gapH = n4;
    }

    public Point location(int n, int n2) {
        return new Point(0, 0);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Cloneable cloneable;
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            cloneable = componentArray[i].preferredSize();
            if (((Dimension)cloneable).width == 0 || ((Dimension)cloneable).height == 0) {
                cloneable = componentArray[i].size();
            }
            if (n < ((Dimension)cloneable).width) {
                n = ((Dimension)cloneable).width;
            }
            if (n2 >= ((Dimension)cloneable).height) continue;
            n2 = ((Dimension)cloneable).height;
        }
        cloneable = container.insets();
        return new Dimension(n + this.gapX + this.gapW, n2 + this.gapY + this.gapH);
    }

    public Dimension minimumLayoutSize(Container container) {
        Cloneable cloneable;
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            cloneable = componentArray[i].minimumSize();
            if (((Dimension)cloneable).width == 0 || ((Dimension)cloneable).height == 0) {
                cloneable = componentArray[i].size();
            }
            if (n < ((Dimension)cloneable).width) {
                n = ((Dimension)cloneable).width;
            }
            if (n2 >= ((Dimension)cloneable).height) continue;
            n2 = ((Dimension)cloneable).height;
        }
        cloneable = container.insets();
        return new Dimension(n + this.gapX + this.gapW, n2 + this.gapY + this.gapH);
    }

    public void layoutContainer(Container container) {
        int n = 0;
        int n2 = -1;
        Rectangle rectangle = container.bounds();
        Component[] componentArray = container.getComponents();
        int n3 = this.gapX;
        int n4 = this.gapY;
        int n5 = this.gapW;
        int n6 = this.gapH;
        Insets insets = container.insets();
        for (n = 0; n < componentArray.length; ++n) {
            if (this.gapX == -1) {
                Dimension dimension = componentArray[n].preferredSize();
                if (dimension.width > rectangle.width) {
                    dimension.width = rectangle.width;
                }
                if (dimension.height > rectangle.height) {
                    dimension.height = rectangle.height;
                }
                n3 = n5 = (rectangle.width - dimension.width) / 2;
                n4 = n6 = (rectangle.height - dimension.height) / 2;
            }
            componentArray[n].move(n3 + insets.left, n4);
            componentArray[n].resize(rectangle.width - n3 - n5, rectangle.height - n4 - n6);
            if (!componentArray[n].isVisible()) continue;
            if (n2 >= 0) {
                componentArray[n].hide();
                continue;
            }
            n2 = n;
        }
    }
}

