/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Event;
import java.awt.Graphics;
import java.awt.MenuItem;
import org.zaval.awt.ContextMenu;
import org.zaval.awt.ContextMenuBar;
import org.zaval.awt.SymTree;
import org.zaval.awt.peer.TreeNode;

public class GraphTree
extends SymTree {
    ContextMenuBar menubar = null;
    int isRightKey = 0;

    public GraphTree() {
    }

    public GraphTree(TreeNode treeNode) {
    }

    public GraphTree(ContextMenuBar contextMenuBar) {
        this();
        this.menubar = contextMenuBar;
    }

    public void setMenuBar(ContextMenuBar contextMenuBar) {
        this.menubar = contextMenuBar;
        this.menubar.setParent(this);
    }

    public ContextMenuBar getMenuBar() {
        return this.menubar;
    }

    public void setContextMenu(String string, int n) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null || this.menubar.get(n) == null) {
            return;
        }
        treeNode.setContextMenu(n);
    }

    public void setContextMenu(String string, ContextMenu contextMenu) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return;
        }
        for (int i = 0; i < this.menubar.countMenus(); ++i) {
            if (this.menubar.get(i) != contextMenu) continue;
            treeNode.setContextMenu(i);
            return;
        }
        this.addMenu(contextMenu);
        this.setContextMenu(string, this.menubar.countMenus() - 1);
    }

    public ContextMenu getContextMenu(String string) {
        TreeNode treeNode = this.getNode(string);
        if (this.menubar == null || treeNode == null || treeNode.getContextMenu() < 0) {
            return null;
        }
        return this.menubar.get(treeNode.getContextMenu());
    }

    public int addMenu(ContextMenu contextMenu) {
        if (contextMenu == null) {
            return -1;
        }
        this.menubar.add(contextMenu);
        return this.menubar.countMenus() - 1;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.menubar != null && this.menubar.isActive()) {
            this.menubar.paint(graphics);
        } else {
            super.paint(graphics);
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.modifiers != 4) {
            this.isRightKey = 0;
            return super.mouseDown(event, n, n2);
        }
        this.isRightKey = 1;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.isRightKey == 1) {
            this.isRightKey = 0;
            this.changeSelection(event, event.x, event.y, false, new boolean[1]);
            TreeNode treeNode = this.getSelectedNode();
            if (this.noChoice || treeNode == null || treeNode.getContextMenu() < 0) {
                treeNode = this.getRootNode();
            }
            if (treeNode != null && treeNode.getContextMenu() >= 0) {
                this.menubar.init(treeNode.getContextMenu(), n, n2);
                this.repaint();
            }
        }
        return super.mouseUp(event, n, n2);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof MenuItem) {
            this.repaint();
            return false;
        }
        return super.action(event, object);
    }

    public boolean handleEvent(Event event) {
        if (event.key == 9) {
            return false;
        }
        if (this.menubar != null && this.menubar.handleEvent(event)) {
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean postEvent(Event event) {
        if (event.target instanceof MenuItem) {
            event.arg = this.noChoice ? null : this.getSelectedNode().text;
        }
        return super.postEvent(event);
    }

    public void disableAll() {
        if (this.menubar == null) {
            return;
        }
        int n = this.menubar.countMenus();
        for (int i = 0; i < n; ++i) {
            this.menubar.getMenu(i).disable();
        }
    }

    public void enableAll() {
        if (this.menubar == null) {
            return;
        }
        int n = this.menubar.countMenus();
        for (int i = 0; i < n; ++i) {
            this.menubar.getMenu(i).enable();
        }
    }

    public void setContextMenu(TreeNode treeNode, int n) {
        if (treeNode == null || this.menubar.get(n) == null) {
            return;
        }
        treeNode.setContextMenu(n);
    }

    public ContextMenu getContextMenu(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        return this.menubar.get(treeNode.getContextMenu());
    }
}

