/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Panel;
import java.awt.Toolkit;
import java.util.Vector;
import org.zaval.awt.FitLayout;

public class IEChoice
extends Panel {
    private int wx = 0;
    private int wy = 0;
    private int x = 0;
    private int y = 0;
    private Choice ch;
    private boolean fakeAdded = false;
    private Vector ids;
    private Vector items;
    private String lastval = null;
    private static final int[] acceptE = new int[]{701, 1001};

    public Vector getI1() {
        return this.items;
    }

    public Vector getI2() {
        return this.ids;
    }

    public void setItems(Vector vector, Vector vector2) {
        int n;
        int n2 = vector2.size();
        this.ids = vector2;
        this.items = vector;
        Choice choice = new Choice();
        for (n = 0; n < n2; ++n) {
            choice.addItem((String)vector.elementAt(n));
        }
        while (n < 2) {
            choice.addItem(" ");
            ++n;
        }
        this.setChoice(choice);
    }

    public void select(String string) {
        if (string == null) {
            string = this.lastval;
        }
        if (string == null) {
            return;
        }
        this.lastval = string;
        this.select(this.ids.indexOf(this.lastval));
    }

    public String getValue() {
        if (this.lastval == null) {
            try {
                String string;
                int n = this.ch.getSelectedIndex();
                this.lastval = string = (String)this.ids.elementAt(n);
                return this.lastval;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.lastval;
    }

    public IEChoice(Choice choice) {
        this.ch = choice;
        this.setLayout(new FitLayout(0, 0, 0, 0));
        this.add(this.ch);
    }

    public void resize(int n, int n2) {
        Dimension dimension = this.ch.preferredSize();
        if (dimension.height == 0) {
            Font font = this.getFont();
            if (font == null) {
                font = this.getParent().getFont();
            }
            if (font != null) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                if (fontMetrics == null) {
                    fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
                }
                dimension.height = fontMetrics.getHeight() + 10;
            } else {
                dimension.height = n2;
            }
        }
        super.resize(n, dimension.height);
    }

    public Choice getChoice() {
        return this.ch;
    }

    private void setChoice(Choice choice) {
        String string = System.getProperty("os.name");
        boolean bl = string != null && (string.equalsIgnoreCase("Solaris") || string.equalsIgnoreCase("Linux"));
        Color color = this.ch.getBackground();
        Color color2 = this.ch.getForeground();
        Font font = this.ch.getFont();
        Container container = this.getParent();
        if (bl && container != null) {
            container.remove(this);
        }
        this.removeAll();
        this.add(choice);
        choice.setBackground(color);
        choice.setForeground(color2);
        choice.setFont(font);
        if (this.isEnabled()) {
            choice.enable();
        } else {
            choice.disable();
        }
        this.ch = choice;
        if (bl && container != null) {
            container.add(this);
            this.addNotify();
        }
        ((Component)this).invalidate();
        ((Component)this).validate();
        this.ch.requestFocus();
    }

    public void enable() {
        this.ch.enable();
        super.enable();
    }

    public void disable() {
        this.ch.disable();
        super.disable();
    }

    public boolean handleEvent(Event event) {
        if (event.target != this && event.target != this.ch) {
            return super.handleEvent(event);
        }
        if (this.isSelectionEvent(event)) {
            try {
                String string = (String)this.ids.elementAt(this.ch.getSelectedIndex());
                this.sendSelectionEvent(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean keyDown(Event event, int n) {
        int n2;
        char c = (char)n;
        if (Character.isLetter(c)) {
            c = Character.toLowerCase(c);
            n2 = this.ch.countItems();
            for (int i = 0; i < n2; ++i) {
                StringBuffer stringBuffer = new StringBuffer(this.ch.getItem(i));
                if (Character.toLowerCase(stringBuffer.charAt(0)) != c) continue;
                if (this.ch.getSelectedIndex() != i) {
                    this.ch.select(i);
                }
                return true;
            }
        }
        if (n == 27) {
            try {
                this.ch.select(this.ids.indexOf(this.lastval));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        if (n == 10 || n == 9) {
            try {
                String string = (String)this.ids.elementAt(this.ch.getSelectedIndex());
                if (string.equals(this.lastval)) {
                    return false;
                }
                this.sendSelectionEvent(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        if (n == 1004) {
            n2 = this.ch.getSelectedIndex() - 1;
            if (n2 < 0) {
                return true;
            }
            this.ch.select(n2);
            return true;
        }
        if (n == 1005) {
            n2 = this.ch.getSelectedIndex() + 1;
            if (n2 >= this.ch.countItems()) {
                return true;
            }
            this.ch.select(n2);
            return true;
        }
        return super.keyDown(event, n);
    }

    public void requestFocus() {
        this.ch.requestFocus();
    }

    public boolean lostFocus(Event event, Object object) {
        if (event.target == this.ch && this.ids != null && this.lastval != null) {
            try {
                String string = (String)this.ids.elementAt(this.ch.getSelectedIndex());
                if (this.lastval.equals(string)) {
                    return true;
                }
                this.sendSelectionEvent(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return event.target == this;
    }

    public boolean gotFocus(Event event, Object object) {
        return this.ids == null;
    }

    private boolean isSelectionEvent(Event event) {
        if (event.target == this.ch) {
            for (int i = 0; i < acceptE.length; ++i) {
                if (acceptE[i] != event.id) continue;
                return true;
            }
        }
        return false;
    }

    private void sendSelectionEvent(String string) {
        if (!string.equals(this.lastval)) {
            this.lastval = string;
            this.getParent().postEvent(new Event(this, 1001, string));
        }
    }

    private void fakeFix() {
        if (this.fakeAdded) {
            Choice choice = new Choice();
            Choice choice2 = this.ch;
            int n = choice2.countItems() - 1;
            for (int i = 0; i < n; ++i) {
                String string = choice2.getItem(i);
                if (i == n - 1 && string.trim().length() == 0) break;
                choice.addItem(string);
            }
            this.fakeAdded = false;
            this.setChoice(choice);
            this.select(this.lastval);
        }
    }

    public void addNotify() {
        try {
            super.addNotify();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void select(int n) {
        if (n < 0 && !IEChoice.checkIeHack()) {
            Choice choice = this.getChoice();
            int n2 = 0;
            int n3 = choice.countItems();
            for (n2 = 0; n2 < n3; ++n2) {
                if (choice.getItem(n2).trim().length() != 0) continue;
                choice.select(n2);
                return;
            }
            choice.addItem(" ");
            choice.select(" ");
            this.fakeAdded = true;
            return;
        }
        this.fakeFix();
        try {
            this.getChoice().select(n);
        }
        catch (Exception exception) {
            System.err.println("SEL Error: " + exception + " for " + this.getChoice());
            exception.printStackTrace();
        }
    }

    private static boolean checkIeHack() {
        String string = "1.0.2.";
        String string2 = "Sun";
        try {
            string = System.getProperty("java.version");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string2 = System.getProperty("java.vendor");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return !string.startsWith("1.0") && string2.startsWith("Microsoft");
    }
}

