/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public class IELabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int FIT = 3;
    private int wsize = 0;
    private int hsize = 0;
    private int ascent;
    private String name;
    private int align;

    public IELabel() {
        this.align = 0;
        this.name = "";
    }

    public IELabel(String string) {
        this.align = 0;
        this.name = string;
    }

    public IELabel(String string, int n) {
        this.align = n;
        this.name = string;
    }

    public int getAlignment() {
        return this.align;
    }

    public String getText() {
        return this.name;
    }

    public void setAlignment(int n) {
        this.align = n;
    }

    public void setText(String string) {
        this.name = string;
        this.measure();
    }

    public String toString() {
        return "IELabel[text=" + this.name + ",align=" + (this.align == 0 ? "LEFT" : (this.align == 1 ? "CENTER" : "RIGHT")) + "]";
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
    }

    public void paint(Graphics graphics) {
        try {
            this.measure();
            Dimension dimension = this.size();
            int n = this.ascent + (dimension.height - this.hsize) / 2;
            int n2 = 2 == this.align ? dimension.width - this.wsize : (1 == this.align ? (dimension.width - this.wsize) / 2 : 1);
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(this.getForeground());
            if (this.align != 3 || dimension.width <= this.wsize) {
                graphics.drawString(this.name, n2, n);
            } else {
                this.drawText(graphics, this.name, n2, n, dimension.width);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void drawText(Graphics graphics, String string, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        if (stringTokenizer.countTokens() == 0) {
            return;
        }
        String[] stringArray = new String[stringTokenizer.countTokens()];
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n6] = stringTokenizer.nextToken();
            n5 += fontMetrics.stringWidth(stringArray[n6]);
            ++n6;
        }
        int n7 = (n3 - n5) / stringArray.length;
        int n8 = n4 = (n3 - n5) % stringArray.length;
        int n9 = 0;
        for (n6 = 0; n6 < stringArray.length; ++n6) {
            graphics.drawString(stringArray[n6], n, n2);
            n9 = n8 / stringArray.length;
            if (n9 > 0) {
                n8 %= stringArray.length;
            }
            n8 += n4;
            n += fontMetrics.stringWidth(stringArray[n6]) + n7 + n9;
        }
    }

    public Dimension preferredSize() {
        this.measure();
        return new Dimension(this.wsize, this.hsize);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    private void measure() {
        Toolkit toolkit;
        if (this.name == null) {
            return;
        }
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics == null && (fontMetrics = (toolkit = Toolkit.getDefaultToolkit()).getFontMetrics(font)) == null) {
            return;
        }
        this.hsize = fontMetrics.getHeight();
        this.ascent = fontMetrics.getAscent();
        this.wsize = fontMetrics.stringWidth(this.name);
    }
}

