/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.zaval.awt.ImageResolver;
import org.zaval.awt.InvalidTreeNodeException;
import org.zaval.awt.peer.TreeNode;

public class LevelTree {
    public static final int CHILD = 0;
    public static final int NEXT = 1;
    public static final int LAST = 2;
    public Vector e = new Vector();
    public Vector v = new Vector();
    private TreeNode rootNode;
    private ImageResolver imgres;
    private int count = 0;
    private int viewCount = 0;
    private String[] treeStructure;
    String delim = ".";
    private String selectedNode;
    private Hashtable nameCache = new Hashtable();

    public LevelTree() {
    }

    public LevelTree(TreeNode treeNode) {
        this();
        this.rootNode = treeNode;
        this.setResolver(this.rootNode, this.imgres);
        this.count = 1;
    }

    public String getNamesDelim() {
        return this.delim;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    public void insert(TreeNode treeNode, TreeNode treeNode2, int n) {
        if (treeNode == null || treeNode2 == null) {
            return;
        }
        if (!this.exists(treeNode2)) {
            return;
        }
        switch (n) {
            case 0: {
                this.addChild(treeNode, treeNode2);
                break;
            }
            case 1: {
                this.addSibling(treeNode, treeNode2);
                break;
            }
            case 2: {
                this.addSibling(treeNode, treeNode2);
                break;
            }
            default: {
                return;
            }
        }
        this.setResolver(this.rootNode, this.imgres);
        this.nameCache.put(treeNode.text, treeNode);
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public int getCount() {
        return this.count;
    }

    boolean viewable(TreeNode treeNode) {
        for (int i = 0; i < this.viewCount; ++i) {
            if (treeNode != this.v.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    boolean viewable(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < this.viewCount; ++i) {
            TreeNode treeNode = (TreeNode)this.v.elementAt(i);
            if (treeNode.text == null || !string.equals(treeNode.text)) continue;
            return true;
        }
        return false;
    }

    public boolean exists(TreeNode treeNode) {
        if (this.nameCache.get(treeNode.text) != null) {
            return true;
        }
        for (int i = 0; i < this.count; ++i) {
            if (treeNode != this.e.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    public boolean exists(String string) {
        if (string == null) {
            return false;
        }
        if (this.nameCache.get(string) != null) {
            return true;
        }
        for (int i = 0; i < this.count; ++i) {
            TreeNode treeNode = (TreeNode)this.e.elementAt(i);
            if (treeNode.text == null || !string.equals(treeNode.text)) continue;
            return true;
        }
        return false;
    }

    public TreeNode getNode(String string) {
        if (string == null) {
            return null;
        }
        if (this.nameCache.get(string) != null) {
            return (TreeNode)this.nameCache.get(string);
        }
        for (int i = 0; i < this.count; ++i) {
            TreeNode treeNode = (TreeNode)this.e.elementAt(i);
            if (treeNode.text == null || !string.equals(treeNode.text)) continue;
            return treeNode;
        }
        return null;
    }

    public boolean insertChild(String string, String string2) {
        return this.insertChild(string, string2, null, null);
    }

    public boolean insertChild(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null) {
            return false;
        }
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return false;
        }
        this.insert(new TreeNode(string2, string3, string4), treeNode, 0);
        return true;
    }

    public boolean insertNext(String string, String string2) {
        return this.insertNext(string, string2, null, null);
    }

    public boolean insertNext(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null) {
            return false;
        }
        TreeNode treeNode = this.getNode(string);
        TreeNode treeNode2 = this.getRootNode();
        if (treeNode == null || treeNode2 == null || treeNode.text.equals(treeNode2.text)) {
            return false;
        }
        this.insert(new TreeNode(string2, string3, string4), treeNode, 1);
        return true;
    }

    public boolean insertRoot(String string) {
        return this.insertRoot(string, null, null);
    }

    public boolean insertRoot(String string, String string2, String string3) {
        if (string == null) {
            return false;
        }
        if (this.getRootNode() == null) {
            this.append(new TreeNode("root"));
        }
        return this.insertChild(this.rootNode.text, string, string2, string3);
    }

    public boolean setImages(String string, String string2, String string3) {
        return this.setImageOpen(string, string2) && this.setImageClose(string, string3);
    }

    public boolean setImageOpen(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return false;
        }
        treeNode.setExpandedImage(string2);
        return true;
    }

    public boolean setImageClose(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return false;
        }
        treeNode.setCollapsedImage(string2);
        return true;
    }

    public boolean changeText(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        TreeNode treeNode = this.getNode(string);
        treeNode.setText(string2);
        return true;
    }

    public void setNamesDelim(String string) {
        this.delim = string;
    }

    public void append(TreeNode treeNode) {
        if (this.rootNode == null) {
            this.rootNode = treeNode;
            this.rootNode.setDepth(0);
            this.rootNode.setStringProperty("PATH", "");
            this.e.addElement(this.rootNode);
            this.count = 1;
        } else {
            this.addSibling(treeNode, this.rootNode);
        }
        this.setResolver(treeNode, this.imgres);
    }

    void addChild(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode2.child == null) {
            treeNode2.child = treeNode;
            treeNode.parent = treeNode2;
            treeNode.setDepth(treeNode2.getDepth() + 1);
            String string = treeNode2.getStringProperty("PATH");
            if (string.length() > 0) {
                string = string + this.delim;
            }
            treeNode.setStringProperty("PATH", string + treeNode.text);
            this.e.addElement(treeNode);
            ++this.count;
        } else {
            this.addSibling(treeNode, treeNode2.child);
        }
        ++treeNode2.numberOfChildren;
        this.setResolver(treeNode, this.imgres);
    }

    protected void addBefore(TreeNode treeNode, TreeNode treeNode2, TreeNode treeNode3) {
        if (treeNode == null || treeNode2 == null || treeNode3 == null) {
            return;
        }
        TreeNode treeNode4 = treeNode;
        if (treeNode.child == treeNode3 || treeNode.child == null) {
            treeNode2.sibling = treeNode.child;
            treeNode.child = treeNode2;
        } else {
            treeNode = treeNode.child;
            while (treeNode.sibling != null && treeNode.sibling != treeNode3) {
                treeNode = treeNode.sibling;
            }
            if (treeNode.sibling != null) {
                treeNode2.sibling = treeNode.sibling;
            }
            treeNode.sibling = treeNode2;
        }
        this.setResolver(treeNode2, this.imgres);
        ++treeNode4.numberOfChildren;
        treeNode2.parent = treeNode4;
        treeNode2.setDepth(treeNode4.getDepth() + 1);
        String string = treeNode.getStringProperty("PATH");
        if (string.length() > 0) {
            string = string + this.delim;
        }
        treeNode2.setStringProperty("PATH", string + treeNode2.text);
        this.e.insertElementAt(treeNode2, this.e.indexOf(treeNode3));
        ++this.count;
    }

    void addSibling(TreeNode treeNode, TreeNode treeNode2) {
        TreeNode treeNode3 = treeNode2;
        String string = treeNode2.getStringProperty("PATH");
        int n = string.lastIndexOf(this.delim);
        if (n >= 0) {
            treeNode.setStringProperty("PATH", string.substring(0, n) + this.delim + treeNode.text);
        } else {
            treeNode.setStringProperty("PATH", treeNode.text);
        }
        while (treeNode3.sibling != null) {
            treeNode3 = treeNode3.sibling;
        }
        treeNode3.sibling = treeNode;
        treeNode.parent = treeNode3.parent;
        treeNode.setDepth(treeNode3.getDepth());
        this.e.addElement(treeNode);
        ++this.count;
        this.setResolver(treeNode, this.imgres);
    }

    public TreeNode remove(String string) {
        this.recount();
        for (int i = 0; i < this.count; ++i) {
            TreeNode treeNode = (TreeNode)this.e.elementAt(i);
            if (treeNode.text == null || !string.equals(treeNode.text)) continue;
            this.remove(treeNode);
            return treeNode;
        }
        return null;
    }

    public void remove(TreeNode treeNode) {
        if (!this.exists(treeNode)) {
            return;
        }
        this.nameCache.remove(treeNode.text);
        if (treeNode.parent != null) {
            if (treeNode.parent.child == treeNode) {
                if (treeNode.sibling != null) {
                    treeNode.parent.child = treeNode.sibling;
                } else {
                    treeNode.parent.child = null;
                    treeNode.parent.collapse();
                }
            } else {
                TreeNode treeNode2 = treeNode.parent.child;
                while (treeNode2.sibling != treeNode) {
                    treeNode2 = treeNode2.sibling;
                }
                treeNode2.sibling = treeNode.sibling != null ? treeNode.sibling : null;
            }
        } else if (treeNode == this.rootNode) {
            this.rootNode = treeNode.sibling == null ? null : treeNode.sibling;
        } else {
            TreeNode treeNode3 = this.rootNode;
            while (treeNode3.sibling != treeNode) {
                treeNode3 = treeNode3.sibling;
            }
            treeNode3.sibling = treeNode.sibling != null ? treeNode.sibling : null;
        }
        this.recount();
    }

    private void recount() {
        this.count = 0;
        this.e = new Vector();
        this.nameCache = new Hashtable();
        if (this.rootNode != null) {
            this.rootNode.depth = 0;
            this.traverse(this.rootNode);
        }
    }

    private void traverse(TreeNode treeNode) {
        ++this.count;
        this.e.addElement(treeNode);
        this.nameCache.put(treeNode.text, treeNode);
        if (treeNode.child != null) {
            treeNode.child.depth = treeNode.depth + 1;
            this.traverse(treeNode.child);
        }
        if (treeNode.sibling != null) {
            treeNode.sibling.depth = treeNode.depth;
            this.traverse(treeNode.sibling);
        }
    }

    public void resetVector() {
        this.v = new Vector(this.count);
        if (this.count < 1) {
            this.viewCount = 0;
            return;
        }
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode.child);
        this.viewCount = this.v.size();
    }

    private void vectorize(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        this.nameCache.put(treeNode.text, treeNode);
        if (!treeNode.hidden) {
            this.v.addElement(treeNode);
            if (treeNode.isExpanded() && treeNode.child != null) {
                treeNode.child.depth = treeNode.depth + 1;
                this.vectorize(treeNode.child);
            }
        }
        if (treeNode.sibling != null) {
            treeNode.sibling.depth = treeNode.depth;
            this.vectorize(treeNode.sibling);
        }
    }

    public void setTreeStructure(String[] stringArray) {
        this.rootNode = null;
        this.treeStructure = stringArray;
        try {
            this.parseTreeStructure();
        }
        catch (InvalidTreeNodeException invalidTreeNodeException) {
            System.out.println(invalidTreeNodeException);
        }
    }

    public String[] getTreeStructure() {
        return this.treeStructure;
    }

    private void parseTreeStructure() throws InvalidTreeNodeException {
        String[] stringArray = null;
        String string = null;
        stringArray = this.treeStructure;
        TreeNode treeNode = new TreeNode("root");
        treeNode.setDepth(0);
        this.append(treeNode);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            string = stringArray[i];
            int n2 = this.findLastPreSpace(string) + 1;
            if (n2 == -1) {
                throw new InvalidTreeNodeException();
            }
            TreeNode treeNode2 = this.rootNode;
            for (n = 1; n < n2; ++n) {
                int n3 = treeNode2.numberOfChildren;
                TreeNode treeNode3 = null;
                if (n3 > 0) {
                    treeNode3 = treeNode2.child;
                    while (treeNode3.sibling != null) {
                        treeNode3 = treeNode3.sibling;
                    }
                }
                if (treeNode3 == null) break;
                treeNode2 = treeNode3;
            }
            if ((n = n2 - treeNode2.getDepth()) > 1) {
                throw new InvalidTreeNodeException();
            }
            treeNode = new TreeNode(string.trim());
            treeNode.setDepth(n2);
            if (n == 1) {
                this.insert(treeNode, treeNode2, 0);
                continue;
            }
            this.insert(treeNode, treeNode2, 1);
        }
    }

    private int findLastPreSpace(String string) {
        int n = string.length();
        if (string.charAt(0) != ' ' && string.charAt(0) != '\t') {
            return 0;
        }
        for (int i = 1; i < n; ++i) {
            if (string.charAt(i) == ' ' || string.charAt(i) == '\t') continue;
            return i;
        }
        return -1;
    }

    public void setResolver(ImageResolver imageResolver) {
        this.imgres = imageResolver;
        TreeNode treeNode = this.getRootNode();
        this.setResolver(treeNode, imageResolver);
    }

    private void setResolver(TreeNode treeNode, ImageResolver imageResolver) {
        if (treeNode != null) {
            treeNode.setResolver(imageResolver);
        }
        for (int i = 0; i < this.e.size(); ++i) {
            TreeNode treeNode2 = (TreeNode)this.e.elementAt(i);
            treeNode2.setResolver(imageResolver);
        }
    }

    public void show(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode != null) {
            treeNode.setHide(false);
        }
    }

    public void hide(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode != null) {
            treeNode.setHide(true);
        }
    }

    public void setCaption(String string, String string2) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return;
        }
        treeNode.setCaption(string2);
    }

    public void openNode(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return;
        }
        if (treeNode.isExpandable() && !treeNode.isExpanded()) {
            treeNode.toggle();
        }
    }

    public void closeNode(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return;
        }
        if (treeNode.isExpandable() && treeNode.isExpanded()) {
            treeNode.toggle();
        }
    }

    public void toggleNode(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return;
        }
        if (treeNode.isExpandable()) {
            treeNode.toggle();
        }
    }

    public boolean isHidden(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return false;
        }
        return treeNode.getHide();
    }

    public void expandAll() {
        this.recount();
        if (this.e == null) {
            return;
        }
        for (int i = 0; i < this.e.size(); ++i) {
            TreeNode treeNode = (TreeNode)this.e.elementAt(i);
            treeNode.expand();
        }
    }

    public void collapseAll() {
        this.recount();
        if (this.e == null) {
            return;
        }
        for (int i = 0; i < this.e.size(); ++i) {
            TreeNode treeNode = (TreeNode)this.e.elementAt(i);
            treeNode.collapse();
        }
    }

    public TreeNode findNode(String string, String string2) {
        this.recount();
        TreeNode treeNode = this.getRootNode();
        if (treeNode == null) {
            return null;
        }
        TreeNode treeNode2 = treeNode.child;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (!stringTokenizer.hasMoreElements()) {
            return null;
        }
        String string3 = (String)stringTokenizer.nextElement();
        while (treeNode2 != null) {
            if (treeNode2.caption != null && treeNode2.caption.equalsIgnoreCase(string3)) {
                if (!stringTokenizer.hasMoreElements()) {
                    return treeNode2;
                }
                string3 = (String)stringTokenizer.nextElement();
                treeNode2 = treeNode2.child;
                continue;
            }
            treeNode2 = treeNode2.sibling;
        }
        return null;
    }

    public void view(TreeNode treeNode, String string) {
        this.recount();
        if (treeNode == null) {
            return;
        }
        System.out.println(string + treeNode.caption);
        this.view(treeNode.child, string + " ");
        this.view(treeNode.sibling, string);
    }

    public TreeNode getNode2(String string) {
        this.recount();
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.delim);
        TreeNode treeNode = null;
        if (stringTokenizer.hasMoreElements()) {
            treeNode = this.getNode(stringTokenizer.nextToken());
        } else {
            return null;
        }
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            TreeNode treeNode2 = this.getChild(treeNode, string2);
            if (treeNode2 == null) {
                return null;
            }
            treeNode = treeNode2;
        }
        return treeNode;
    }

    protected int getNumChild(TreeNode treeNode) {
        this.recount();
        if (treeNode == null) {
            return -1;
        }
        TreeNode treeNode2 = treeNode.child;
        int n = 0;
        while (treeNode2 != null) {
            ++n;
            treeNode2 = treeNode2.sibling;
        }
        return n;
    }

    protected TreeNode getChild(TreeNode treeNode, String string) {
        this.recount();
        if (treeNode == null || treeNode.child == null || string == null) {
            return null;
        }
        int n = this.getNumChild(treeNode);
        TreeNode treeNode2 = treeNode.child;
        for (int i = 0; i < n; ++i) {
            if (string.equalsIgnoreCase(treeNode2.getText())) {
                return treeNode2;
            }
            treeNode2 = treeNode2.sibling;
        }
        return null;
    }

    public TreeNode[] enumChild(String string) {
        this.recount();
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.delim);
        TreeNode treeNode = null;
        if (stringTokenizer.hasMoreElements()) {
            treeNode = this.getNode(stringTokenizer.nextToken());
        }
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            TreeNode treeNode2 = this.getChild(treeNode, string2);
            if (treeNode2 == null) {
                return null;
            }
            treeNode = treeNode2;
        }
        return this.enumChild(treeNode);
    }

    public TreeNode[] enumChild(TreeNode treeNode) {
        this.recount();
        if (treeNode == null || treeNode.child == null) {
            return null;
        }
        int n = this.getNumChild(treeNode);
        TreeNode[] treeNodeArray = new TreeNode[n];
        TreeNode treeNode2 = treeNode.child;
        for (int i = 0; i < n; ++i) {
            treeNodeArray[i] = treeNode2;
            treeNode2 = treeNode2.sibling;
        }
        return treeNodeArray;
    }

    public void insertNode(String string, String string2, String string3) {
        TreeNode treeNode = string == null ? this.rootNode : this.getNode(string);
        TreeNode treeNode2 = new TreeNode(string2);
        TreeNode treeNode3 = this.getNode(string3);
        this.addBefore(treeNode, treeNode2, treeNode3);
    }
}

