/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String[] lines;
    protected int lcount = 0;
    protected int width = 0;
    protected int height;
    protected int ascent;
    protected int[] widths;
    protected int align = 0;
    public int LMAX = 50;
    protected boolean isVc = false;
    protected boolean withHeader = false;
    protected Font flf = new Font("Dialog", 1, 10);
    private boolean fullrepaint = false;

    public void setText(String string) {
        this.newLabel(string);
        this.width = 0;
        this.measure();
        this.repaint();
    }

    public void setTitleFont(Font font) {
        this.flf = font;
        this.width = 0;
        this.measure();
        this.repaint();
    }

    public boolean isHeaderPainting() {
        return this.withHeader;
    }

    public void headerPaint(boolean bl) {
        this.withHeader = bl;
    }

    public Font getTitleFont() {
        return this.flf;
    }

    public MultiLabel(String string, int n, int n2) {
        this.align = n;
        this.LMAX = n2;
        this.newLabel(string);
    }

    public MultiLabel(String string, int n) {
        this(string, n, 40);
    }

    public MultiLabel(String string) {
        this(string, 0, 40);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.width = 0;
        this.measure();
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension preferredSize() {
        return new Dimension(this.width, this.height * this.lcount);
    }

    public Dimension minimumSize() {
        return new Dimension(this.width, this.height * this.lcount);
    }

    public void measure() {
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics == null) {
            return;
        }
        this.height = fontMetrics.getHeight();
        this.ascent = fontMetrics.getAscent();
        for (int i = 0; i < this.lcount; ++i) {
            this.widths[i] = fontMetrics.stringWidth(this.lines[i]);
            if (this.width >= this.widths[i]) continue;
            this.width = this.widths[i];
        }
    }

    private void newLabel(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "^", true);
        this.lcount = stringTokenizer.countTokens() + 1;
        this.lines = new String[this.lcount * 5];
        this.widths = new int[this.lcount * 5];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.lcount - 1; ++i) {
            String string2 = stringTokenizer.nextToken();
            n2 = string2.equals("^") ? ++n2 : 0;
            if (n2 > 1 || n2 == 0) {
                if (n2 > 0) {
                    this.lines[n++] = " ";
                } else {
                    while (string2.length() > this.LMAX) {
                        int n3 = this.LMAX;
                        n3 = string2.lastIndexOf(" ", this.LMAX);
                        if (n3 < 0) {
                            n3 = this.LMAX;
                        }
                        this.lines[n++] = string2.substring(0, n3);
                        string2 = string2.substring(n3, string2.length());
                    }
                    this.lines[n++] = string2;
                }
            }
            if (n == this.lcount * 5 - 1) break;
        }
        this.lcount = n;
    }

    public void vertCenter(boolean bl) {
        this.isVc = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        MultiLabel multiLabel = this;
        synchronized (multiLabel) {
            this.fullrepaint = true;
        }
        super.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int n, int n2, int n3, int n4) {
        MultiLabel multiLabel = this;
        synchronized (multiLabel) {
            this.fullrepaint = true;
        }
        super.repaint(n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        int n;
        MultiLabel multiLabel = this;
        synchronized (multiLabel) {
            this.fullrepaint = false;
        }
        if (graphics == null) {
            return;
        }
        if (this.width == 0) {
            this.measure();
        }
        Dimension dimension = this.size();
        graphics.clearRect(0, 0, dimension.width, dimension.height);
        int n2 = this.ascent + 1;
        if (this.withHeader) {
            int n3 = (dimension.width - this.widths[0]) / 2;
            Font font = graphics.getFont();
            graphics.setFont(this.flf);
            graphics.drawString(this.lines[0], n3, n2);
            graphics.setFont(font);
            n2 += this.height;
            n = 1;
        } else {
            n = 0;
        }
        if (this.isVc) {
            n2 += (dimension.height - this.height * this.lcount) / 2;
        }
        while (n < this.lcount) {
            int n4 = this.align == 0 ? 1 : (this.align == 2 ? dimension.width - 1 - this.widths[n] : (dimension.width - this.widths[n]) / 2);
            graphics.drawString(this.lines[n], n4, n2);
            n2 += this.height;
            ++n;
        }
    }
}

