/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import org.zaval.awt.ImageResolver;
import org.zaval.awt.NotebookPage;

public class Notebook
extends Panel
implements LayoutManager {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int ROUNDED = 0;
    public static final int SQUARE = 1;
    private final int IMAGE_SIZE = 16;
    private int TF_LEFT = 0;
    private int TF_RIGHT = 0;
    private int TF_TOP = 23;
    private int TF_BOTTOM = 0;
    private int TF_BTN_HEIGHT = 20;
    protected int curIndex = -1;
    private Font fReg;
    private Font fSel;
    private Color caption = Color.black;
    private int iTabsPosition = 0;
    private int iTabsStyle = 1;
    private int firstVisibleTab = 0;
    private Button dbLeft;
    private Button dbRight;
    private Polygon nullPoly;
    private int lastWidth = -1;
    private Vector pages = new Vector();
    private Panel oobj = null;
    private CardLayout card = null;
    private ImageResolver imgres;
    private boolean mark = false;
    boolean isHandle = true;

    public Notebook() {
        this(0, 0);
    }

    public Notebook(boolean bl) {
        this(bl ? 0 : 1, bl ? 0 : 1);
    }

    public void setImageResolver(ImageResolver imageResolver) {
        this.imgres = imageResolver;
    }

    public void setFont(Font font, Font font2, Color color) {
        this.fReg = font;
        if (font2 == null) {
            font2 = new Font(font.getName(), font.getStyle() | 1, font.getSize());
        }
        this.fSel = font2;
        this.caption = color;
    }

    public Notebook(int n, int n2) {
        this.setTabsInfo(n, n2);
        this.fReg = new Font("Helvetica", 0, 12);
        this.fSel = new Font("Helvetica", 1, 12);
        this.setLayout(this);
        this.dbLeft = new Button("<<");
        this.dbRight = new Button(">>");
        this.add(this.dbLeft);
        this.add(this.dbRight);
        this.oobj = new Panel();
        this.card = new CardLayout();
        this.oobj.setLayout(this.card);
        this.add(this.oobj);
        this.nullPoly = new Polygon();
        this.nullPoly.addPoint(0, 0);
        this.nullPoly.addPoint(1, 1);
        this.nullPoly.addPoint(0, 0);
        this.iTabsStyle = 0;
    }

    public void setTabsInfo(int n, int n2) {
        this.iTabsPosition = n;
        this.iTabsStyle = this.iTabsPosition == 0 ? 0 : n2;
        this.TF_BTN_HEIGHT = this.iTabsStyle == 0 ? 20 : 17;
    }

    public int getTabIndex() {
        return this.curIndex;
    }

    public void addPanel(String string, Component component) {
        int n = this.pages.size();
        NotebookPage notebookPage = new NotebookPage();
        notebookPage.setImageResolver(this.imgres);
        notebookPage.comp = component;
        notebookPage.label = string;
        notebookPage.hidden = false;
        notebookPage.poly = null;
        notebookPage.color = Color.gray;
        notebookPage.name = Integer.toString(n);
        if (this.curIndex < 0) {
            this.curIndex = n;
        }
        this.pages.addElement(notebookPage);
        this.oobj.add(notebookPage.name, notebookPage.comp);
        this.repaint();
    }

    public void removePanel(int n) {
        NotebookPage notebookPage = (NotebookPage)this.pages.elementAt(n);
        this.pages.removeElementAt(n);
        this.oobj.remove(notebookPage.comp);
        this.showPanel(this.curIndex);
    }

    public boolean isHidden(int n) {
        NotebookPage notebookPage = (NotebookPage)this.pages.elementAt(n);
        return notebookPage.hidden;
    }

    public Component getPanel(int n) {
        NotebookPage notebookPage = (NotebookPage)this.pages.elementAt(n);
        return notebookPage.comp;
    }

    public void showPanel(int n) {
        NotebookPage notebookPage = (NotebookPage)this.pages.elementAt(n);
        this.card.show(this.oobj, notebookPage.name);
        this.curIndex = n;
        this.repaint();
    }

    public void setColor(int n, Color color) {
        NotebookPage notebookPage = (NotebookPage)this.pages.elementAt(n);
        notebookPage.color = color;
        this.repaint();
    }

    public void layoutContainer(Container container) {
        Rectangle rectangle = container.bounds();
        int n = rectangle.width - this.TF_LEFT + this.TF_RIGHT;
        if (n < 0) {
            return;
        }
        int n2 = rectangle.height - this.TF_TOP + this.TF_BOTTOM;
        if (n2 < 0) {
            return;
        }
        int n3 = this.TF_LEFT;
        int n4 = 0;
        n4 = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        this.oobj.move(n3 + 1, n4 + 1);
        this.oobj.resize(n - 3, n2 - 3);
        if (this.iTabsPosition == 0) {
            this.dbLeft.move(rectangle.width - 33 + this.TF_RIGHT, this.TF_TOP - 16);
            this.dbRight.move(rectangle.width - 16 + this.TF_RIGHT, this.TF_TOP - 16);
            this.dbLeft.resize(16, 15);
            this.dbRight.resize(16, 15);
        } else {
            this.dbLeft.move(rectangle.width - 33 + this.TF_RIGHT, rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT);
            this.dbRight.move(rectangle.width - 16 + this.TF_RIGHT, rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT);
            this.dbLeft.resize(16, 15);
            this.dbRight.resize(16, 15);
        }
        this.repaint();
    }

    public Point location(int n, int n2) {
        return new Point(0, 0);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getSize(container, true);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getSize(container, false);
    }

    private Dimension getSize(Container container, boolean bl) {
        int n = this.TF_LEFT - this.TF_RIGHT;
        int n2 = this.TF_TOP - this.TF_BOTTOM;
        int n3 = this.TF_LEFT;
        int n4 = 0;
        n4 = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        Dimension dimension = bl ? this.oobj.preferredSize() : this.oobj.minimumSize();
        return new Dimension(dimension.width + n, dimension.height + n2);
    }

    public void setVisible(int n, boolean bl) {
        NotebookPage notebookPage = (NotebookPage)this.pages.elementAt(n);
        notebookPage.hidden = !bl;
        this.layout();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Rectangle rectangle = this.bounds();
        int n3 = rectangle.width - this.TF_LEFT + this.TF_RIGHT;
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = rectangle.height - this.TF_TOP + this.TF_BOTTOM) < 0) {
            n2 = 0;
        }
        if (rectangle.width > this.lastWidth) {
            this.firstVisibleTab = 0;
        }
        this.lastWidth = rectangle.width;
        int n4 = this.TF_LEFT;
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        int n5 = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        graphics.setColor(Color.white);
        graphics.drawLine(n4, n5, n4 + n3 - 1, n5);
        graphics.drawLine(n4, n5, n4, n5 + n2 - 1);
        graphics.setColor(Color.gray);
        graphics.drawLine(n4 + 2, n5 + n2 - 2, n4 + n3 - 2, n5 + n2 - 2);
        graphics.drawLine(n4 + n3 - 2, n5 + 2, n4 + n3 - 2, n5 + n2 - 2);
        graphics.setColor(Color.black);
        graphics.drawLine(n4 + 1, n5 + n2 - 1, n4 + n3 - 1, n5 + n2 - 1);
        graphics.drawLine(n4 + n3 - 1, n5 + 1, n4 + n3 - 1, n5 + n2 - 1);
        int n6 = this.TF_LEFT + 8;
        int n7 = 0;
        int n8 = this.TF_LEFT;
        int n9 = this.pages.size();
        Font font = graphics.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(this.fReg);
        FontMetrics fontMetrics2 = this.getFontMetrics(this.fSel);
        int n10 = 0;
        NotebookPage[] notebookPageArray = new NotebookPage[n9];
        for (n = 0; n < n9; ++n) {
            notebookPageArray[n] = (NotebookPage)this.pages.elementAt(n);
            notebookPageArray[n].poly = this.nullPoly;
        }
        if (this.firstVisibleTab > 0) {
            n8 += 2;
        }
        int n11 = 1;
        for (n = this.firstVisibleTab; n < n9; ++n) {
            int n12;
            int n13;
            int n14;
            int n15 = fontMetrics.getHeight() - fontMetrics2.getDescent();
            if (n == this.curIndex) {
                n15 = fontMetrics2.getHeight() - fontMetrics2.getDescent();
            }
            Polygon polygon = new Polygon();
            if (notebookPageArray[n].hidden) {
                n14 = this.TF_TOP - this.TF_BTN_HEIGHT;
                n13 = this.TF_TOP - 1;
                n12 = n8 - 1;
                n6 = n12 + 1;
                n7 = n12;
                n8 = n6;
                polygon.addPoint(n12, n14);
                polygon.addPoint(n12, n13);
                polygon.addPoint(n6, n13);
                polygon.addPoint(n6, n14);
                notebookPageArray[n].poly = polygon;
                continue;
            }
            try {
                String string = notebookPageArray[n].label;
                n10 = n == this.curIndex ? fontMetrics2.stringWidth(string) : fontMetrics.stringWidth(string);
                if (notebookPageArray[n].img != null) {
                    n10 += 16;
                }
                if (this.iTabsPosition == 0) {
                    n14 = this.TF_TOP - this.TF_BTN_HEIGHT;
                    n13 = this.TF_TOP - 1;
                } else {
                    n14 = rectangle.height + this.TF_BOTTOM + 1;
                    n13 = rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT;
                }
                if (this.iTabsStyle == 0) {
                    n12 = n8 + 2;
                    n6 = n12 + n10 + 13;
                } else {
                    n12 = n6 - 7;
                    n6 = n12 + n10 + 28;
                }
                if (n6 + 36 - this.TF_RIGHT > rectangle.width) break;
                if (this.iTabsPosition == 0) {
                    if (n == this.curIndex) {
                        n14 -= 3;
                        n12 -= 2;
                    }
                    graphics.setColor(Color.white);
                    graphics.drawLine(n12 + 2, n14, n6, n14);
                    graphics.drawLine(n12, n14 + 2, n12, n13);
                    n7 = n12;
                    graphics.drawLine(n12 + 1, n14 + 1, n12 + 1, n14 + 1);
                    graphics.setColor(Color.gray);
                    graphics.drawLine(n6, n14, n6, n13);
                    graphics.setColor(Color.black);
                    graphics.drawLine(n6 + 1, n14 + 2, n6 + 1, n13);
                    n8 = n6;
                } else if (this.iTabsStyle == 1) {
                    graphics.setColor(Color.gray);
                    graphics.drawLine(n12 + 9, n14, n6 - 9, n14);
                    graphics.setColor(Color.black);
                    if (n == 0 || n == this.curIndex) {
                        graphics.drawLine(n12, n13, n12 + 9, n14);
                        polygon.addPoint(n12, n13);
                    } else {
                        graphics.drawLine(n12 + 4, n14 - 9, n12 + 9, n14);
                        polygon.addPoint(n12 + 9, n13);
                        polygon.addPoint(n12 + 4, n14 - 9);
                    }
                    polygon.addPoint(n12 + 9, n14);
                    polygon.addPoint(n6 - 9, n14);
                    if (n + n11 == this.curIndex) {
                        graphics.drawLine(n6 - 5, n14 - 9, n6 - 9, n14);
                        polygon.addPoint(n6 - 5, n14);
                        polygon.addPoint(n6 - 9, n13);
                    } else {
                        graphics.drawLine(n6, n13, n6 - 9, n14);
                        polygon.addPoint(n6, n13);
                    }
                    if (n == 1 || n == this.curIndex) {
                        polygon.addPoint(n12, n13);
                    } else {
                        polygon.addPoint(n12 + 9, n13);
                    }
                } else {
                    if (n == this.curIndex) {
                        n14 += 3;
                        n12 -= 2;
                    }
                    graphics.setColor(Color.white);
                    if (this.curIndex == n + n11) {
                        graphics.drawLine(n12 + 2, n14, n6 - 2, n14);
                    } else {
                        graphics.drawLine(n12 + 2, n14, n6, n14);
                    }
                    if (this.curIndex != n - n11) {
                        graphics.drawLine(n12, n14 - 2, n12, n13);
                        n7 = n12;
                    } else {
                        n7 = n12 + 1;
                    }
                    graphics.drawLine(n12 + 1, n14 - 1, n12 + 1, n14 - 1);
                    if (this.curIndex != n + n11) {
                        graphics.setColor(Color.gray);
                        graphics.drawLine(n6, n14, n6, n13);
                        graphics.setColor(Color.black);
                        graphics.drawLine(n6 + 1, n14 - 2, n6 + 1, n13);
                        n8 = n6;
                    } else {
                        n8 = n6 - 1;
                    }
                }
                if (n == this.curIndex) {
                    n13 = this.iTabsPosition == 0 ? ++n13 : --n13;
                    graphics.setColor(this.getBackground());
                    graphics.drawLine(n12 + 1, n13, n6, n13);
                    if (this.iTabsPosition == 1) {
                        graphics.drawLine(n12 + 1, n13 - 1, n6, n13 - 1);
                    }
                    graphics.setFont(this.fSel);
                } else {
                    graphics.setFont(this.fReg);
                }
                if (this.iTabsStyle == 0) {
                    polygon.addPoint(n7 - 1, n13 + 1);
                    polygon.addPoint(n8 + 1, n13 + 1);
                    polygon.addPoint(n8 + 1, n14 - 1);
                    polygon.addPoint(n7 + 2, n14 - 1);
                    polygon.addPoint(n7 - 1, n14 + 2);
                    polygon.addPoint(n7 - 1, n13 + 1);
                }
                notebookPageArray[n].poly = polygon;
                graphics.setColor(notebookPageArray[n].color);
                Polygon polygon2 = this.justPolygon(polygon, this.iTabsPosition == 0);
                graphics.fillPolygon(polygon2);
                graphics.setColor(this.caption);
                int n16 = notebookPageArray[n].img == null ? 0 : 16;
                int n17 = n12 + 8 + n16;
                int n18 = n14 + 15;
                if (this.iTabsStyle != 0) {
                    if (this.iTabsStyle == 0) {
                        n18 = n14 - 6;
                    } else {
                        n17 = n12 + 14 + n16;
                        n18 = n14 - 4;
                    }
                }
                int n19 = n18 - n15 / 2;
                if (notebookPageArray[n].img != null) {
                    int n20 = notebookPageArray[n].img.getHeight(this);
                    int n21 = notebookPageArray[n].img.getWidth(this);
                    n19 = n19 - n20 / 2 + 1;
                    graphics.drawImage(notebookPageArray[n].img, n17 - 16 - 2, n19, n21, n20, this);
                }
                graphics.drawString(string, n17, n18);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            n11 = 1;
        }
        if (this.firstVisibleTab > 0 || n < n9) {
            this.dbLeft.show();
            this.dbRight.show();
            if (this.firstVisibleTab > 0) {
                this.dbLeft.enable();
            } else {
                this.dbLeft.disable();
            }
            if (n < n9) {
                this.dbRight.enable();
            } else {
                this.dbRight.disable();
            }
        } else {
            this.dbLeft.hide();
            this.dbRight.hide();
        }
        graphics.setFont(font);
        graphics.setColor(color);
        if (this.mark && this.curIndex >= 0) {
            this.drawMark(graphics, notebookPageArray[this.curIndex].poly);
        }
        notebookPageArray = null;
    }

    private void drawMark(Graphics graphics, Polygon polygon) {
        graphics.setColor(Color.black);
        Rectangle rectangle = polygon.getBoundingBox();
        rectangle.x += 3;
        rectangle.y += 3;
        rectangle.height -= 5;
        rectangle.width -= 6;
        Notebook.drawRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private Polygon justPolygon(Polygon polygon, boolean bl) {
        Polygon polygon2 = new Polygon();
        Rectangle rectangle = polygon.getBoundingBox();
        for (int i = 0; i < polygon.npoints; ++i) {
            int n = polygon.xpoints[i];
            if (polygon.xpoints[i] >= rectangle.x + rectangle.width - 1) {
                n = polygon.xpoints[i] - 1;
            }
            if (polygon.xpoints[i] == rectangle.x) {
                n = polygon.xpoints[i] + 2;
            }
            int n2 = polygon.ypoints[i];
            if (!bl && polygon.ypoints[i] >= rectangle.y + rectangle.height - 1) {
                n2 = polygon.ypoints[i] - 1;
            }
            if (bl && polygon.ypoints[i] == rectangle.y) {
                n2 = polygon.ypoints[i] + 2;
            }
            polygon2.addPoint(n, n2);
        }
        return polygon2;
    }

    public boolean keyDown(Event event, int n) {
        block2 : switch (n) {
            case 1006: {
                int n2 = this.curIndex;
                if (n2 > 0 && this.mark) {
                    --n2;
                } else {
                    return false;
                }
                while (n2 >= 0) {
                    try {
                        NotebookPage notebookPage = (NotebookPage)this.pages.elementAt(n2);
                        if (!this.isHidden(n2)) {
                            this.sendActionEvent(n2, 0);
                            this.requestFocus();
                            break block2;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    --n2;
                }
                break;
            }
            case 1007: {
                int n3 = this.pages.size();
                int n4 = this.curIndex;
                if (n4 < n3 - 1 && this.mark) {
                    ++n4;
                } else {
                    return false;
                }
                while (n4 < n3) {
                    try {
                        NotebookPage notebookPage = (NotebookPage)this.pages.elementAt(n4);
                        if (!this.isHidden(n4)) {
                            this.sendActionEvent(n4, 0);
                            this.requestFocus();
                            break block2;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    ++n4;
                }
                break;
            }
        }
        return super.keyDown(event, n);
    }

    public void setHandleEvent(boolean bl) {
        this.isHandle = bl;
    }

    public boolean handleEvent(Event event) {
        block1 : switch (event.id) {
            case 501: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                return true;
            }
            case 502: {
                if (!this.isHandle) {
                    return true;
                }
                int n = this.pages.size();
                NotebookPage notebookPage = null;
                for (int i = 0; i < n; ++i) {
                    try {
                        notebookPage = (NotebookPage)this.pages.elementAt(i);
                        if (notebookPage.poly == this.nullPoly || !notebookPage.poly.inside(event.x, event.y) || this.isHidden(i)) continue;
                        if (i == this.curIndex) {
                            this.requestFocus();
                            return true;
                        }
                        this.sendActionEvent(i, 1);
                        break block1;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                break;
            }
            case 1001: {
                if (event.target == this.dbLeft) {
                    if (--this.firstVisibleTab < 0) {
                        this.firstVisibleTab = 0;
                    } else {
                        this.repaint();
                    }
                    return true;
                }
                if (event.target != this.dbRight) break;
                int n = this.pages.size();
                if (++this.firstVisibleTab == n) {
                    --this.firstVisibleTab;
                } else {
                    this.repaint();
                }
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public boolean lostFocus(Event event, Object object) {
        if (!(event.target instanceof Notebook)) {
            return super.lostFocus(event, object);
        }
        this.mark = false;
        this.repaint();
        return super.lostFocus(event, object);
    }

    public void setImage(int n, String string) {
        NotebookPage notebookPage = (NotebookPage)this.pages.elementAt(n);
        notebookPage.setImage(string);
        this.repaint();
    }

    private void sendActionEvent(int n, int n2) {
        Event event = new Event(this, System.currentTimeMillis(), 1001, n, 0, 0, n2, Integer.toString(n));
        this.mark = false;
        this.getParent().postEvent(event);
        this.repaint();
    }

    public void requestFocus() {
        super.requestFocus();
        this.mark = true;
        this.repaint();
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return true;
    }

    public int countPages() {
        return this.pages.size();
    }

    public static void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        Notebook.drawVLine(graphics, n2, n2 + n4, n);
        Notebook.drawVLine(graphics, n2, n2 + n4, n + n3);
        Notebook.drawHLine(graphics, n, n + n3, n2);
        Notebook.drawHLine(graphics, n, n + n3, n2 + n4);
    }

    public static void drawHLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n4 / 2 + n4 % 2;
        for (int i = 0; i < n5; ++i) {
            graphics.drawLine(n, n3, n, n3);
            n += 2;
        }
        graphics.drawLine(n2, n3, n2, n3);
    }

    public static void drawVLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n4 / 2 + n4 % 2;
        for (int i = 0; i < n5; ++i) {
            graphics.drawLine(n3, n, n3, n);
            n += 2;
        }
        graphics.drawLine(n3, n2, n3, n2);
    }
}

