/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;

public class ResizeLayout
implements LayoutManager {
    private int fix = -1;

    public Point location(int n, int n2) {
        return new Point(n < this.fix ? 0 : 2, 0);
    }

    public void setSeparator(int n, Container container) {
        this.fix = n;
        this.layoutAll(container);
    }

    private void layoutAll(Container container) {
        LayoutManager layoutManager = container.getLayout();
        if (layoutManager != null) {
            layoutManager.layoutContainer(container);
        }
        Component[] componentArray = container.getComponents();
        container.repaint();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Container)) continue;
            this.layoutAll((Container)componentArray[i]);
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Container container2 = null;
        Container container3 = null;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Panel)) continue;
            if (container2 == null) {
                container2 = (Panel)componentArray[i];
                continue;
            }
            if (container3 != null) break;
            container3 = (Panel)componentArray[i];
        }
        Dimension dimension = container2.preferredSize();
        if (this.fix != -1) {
            dimension.width = this.fix;
        }
        Dimension dimension2 = container3.preferredSize();
        return new Dimension(dimension.width + dimension2.width + 5, Math.max(dimension.height, dimension2.height));
    }

    public Dimension minimumLayoutSize(Container container) {
        Container container2 = null;
        Container container3 = null;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Panel)) continue;
            if (container2 == null) {
                container2 = (Panel)componentArray[i];
                continue;
            }
            if (container3 != null) break;
            container3 = (Panel)componentArray[i];
        }
        Dimension dimension = container2.minimumSize();
        if (this.fix != -1) {
            dimension.width = this.fix;
        }
        Dimension dimension2 = container3.minimumSize();
        return new Dimension(dimension.width + dimension2.width + 5, Math.max(dimension.height, dimension2.height));
    }

    public void layoutContainer(Container container) {
        Container container2 = null;
        Panel panel = null;
        Component component = null;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Panel) {
                if (container2 == null) {
                    container2 = (Panel)componentArray[i];
                    continue;
                }
                if (panel != null) break;
                panel = (Panel)componentArray[i];
                continue;
            }
            if (component != null) continue;
            component = componentArray[i];
        }
        Rectangle rectangle = container.bounds();
        int n = this.fix == -1 ? container2.preferredSize().width : this.fix;
        int n2 = rectangle.width - n - 15;
        container2.reshape(5, 5, n, rectangle.height - 10);
        panel.reshape(10 + n, 5, n2, rectangle.height - 10);
        component.reshape(5 + n, 5, 5, rectangle.height - 10);
    }
}

