/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import org.zaval.awt.ResizeLayout;

public class Resizer
extends Canvas {
    private int startx = 0;
    private int oldrg = 0;
    private boolean drag = false;
    private boolean state = false;
    private boolean _enable = this.isEnabled();

    public void enable() {
        this.enable(true);
    }

    public void disable() {
        this.enable(false);
    }

    public void enable(boolean bl) {
        if (this._enable == bl) {
            return;
        }
        this._enable = bl;
        super.enable(this._enable);
        if (!this._enable) {
            this.drag = false;
            this.oldrg = 0;
            this.startx = 0;
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this._enable) {
            Rectangle rectangle = this.bounds();
            int n = 0;
            int n2 = 0;
            int n3 = rectangle.width - 2 * n - 1;
            int n4 = rectangle.height - 2 * n2 - 1;
            graphics.setColor(Color.lightGray);
            graphics.fillRect(n, n2, n + n3, n2 + n4);
            graphics.setColor(Color.white);
            graphics.drawLine(n, n2, n + n3, n2);
            graphics.drawLine(n, n2, n, n2 + n4);
            graphics.setColor(Color.black);
            graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
            graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
        }
    }

    private void paintLine(Component component, int n) {
        int n2 = 0;
        while (n2 < this.bounds().width) {
            Resizer.drawVLineOnComponent(component, this.bounds().y, this.bounds().height + this.bounds().y, n, Color.darkGray);
            ++n2;
            ++n;
        }
    }

    private static void drawVLineOnComponent(Component component, int n, int n2, int n3, Color color) {
        Object object;
        if (component == null) {
            return;
        }
        Rectangle rectangle = component.bounds();
        if (rectangle.height <= n2) {
            n2 = rectangle.height - 1;
        }
        Component component2 = Resizer.getNextBottomChild(component, n + 1, n3);
        while (component2 != null && n < n2) {
            int n4;
            object = component2.bounds();
            int n5 = n - ((Rectangle)object).y;
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = n2 - ((Rectangle)object).y) >= ((Rectangle)object).height) {
                n4 = ((Rectangle)object).height - 1;
            }
            int n6 = n3 - ((Rectangle)object).x;
            if (n4 <= n5) break;
            if (((Rectangle)object).y > n) {
                Graphics graphics = component.getGraphics();
                Color color2 = graphics.getColor();
                graphics.setColor(color);
                graphics.setXORMode(component.getBackground());
                graphics.drawLine(n3, n, n3, ((Rectangle)object).y);
                graphics.setColor(color2);
                graphics.setPaintMode();
                graphics.dispose();
            }
            Resizer.drawVLineOnComponent(component2, n5, n4, n6, color);
            n = ((Rectangle)object).y + ((Rectangle)object).height;
            component2 = Resizer.getNextBottomChild(component, n, n3);
        }
        if (n < n2) {
            object = component.getGraphics();
            Color color3 = ((Graphics)object).getColor();
            ((Graphics)object).setColor(color);
            ((Graphics)object).setXORMode(component.getBackground());
            ((Graphics)object).drawLine(n3, n, n3, n2);
            ((Graphics)object).setColor(color3);
            ((Graphics)object).setPaintMode();
            ((Graphics)object).dispose();
        }
    }

    private static Component getNextBottomChild(Component component, int n, int n2) {
        if (!(component instanceof Container)) {
            return null;
        }
        Component component2 = Resizer.getComponentAtFix((Container)component, n2, n);
        if (component2 != null && component2 != component) {
            return component2;
        }
        Component[] componentArray = ((Container)component).getComponents();
        Component component3 = null;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < componentArray.length; ++i) {
            Rectangle rectangle = componentArray[i].bounds();
            if (n2 < rectangle.x || n2 > rectangle.x + rectangle.width || rectangle.y >= n3 || rectangle.y <= n) continue;
            n3 = rectangle.y;
            component3 = componentArray[i];
        }
        return component3;
    }

    private static Component getComponentAtFix(Container container, int n, int n2) {
        Component[] componentArray = container.getComponents();
        Vector<Component> vector = new Vector<Component>();
        for (int i = 0; i < componentArray.length; ++i) {
            Rectangle rectangle;
            if (!componentArray[i].isVisible() || !(rectangle = componentArray[i].bounds()).inside(n, n2)) continue;
            vector.addElement(componentArray[i]);
        }
        if (vector.size() > 0) {
            return (Component)vector.elementAt(0);
        }
        return null;
    }

    private void setCursor0(int n) {
        Component component;
        for (component = this; component != null && !(component instanceof Frame); component = component.getParent()) {
        }
        if (component instanceof Frame) {
            ((Frame)component).setCursor(n);
        }
    }

    private void resizeme(int n) {
        Rectangle rectangle = this.bounds();
        ResizeLayout resizeLayout = (ResizeLayout)this.getParent().getLayout();
        Rectangle rectangle2 = this.getParent().bounds();
        int n2 = rectangle.x + n - this.startx - rectangle.width;
        int n3 = 0;
        int n4 = rectangle2.width - 2 * rectangle.width + rectangle2.x;
        if (n2 > n4) {
            n2 = n4;
        }
        if (n2 < n3) {
            n2 = n3;
        }
        resizeLayout.setSeparator(n2, this.getParent());
        this.startx = 0;
        this.oldrg = 0;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        if (this._enable) {
            this.setCursor0(11);
            return true;
        }
        return super.mouseEnter(event, n, n2);
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this._enable) {
            if (this.drag) {
                this.paintLine(this.getParent(), this.oldrg + this.bounds().x - this.startx);
                this.drag = false;
            }
            this.setCursor0(0);
            return true;
        }
        return super.mouseExit(event, n, n2);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this._enable && this.inside(n, n2) && event.modifiers == 0) {
            if (this.drag) {
                return super.mouseDown(event, n, n2);
            }
            this.startx = n;
            this.oldrg = n;
            this.drag = true;
            this.state = true;
            this.paintLine(this.getParent(), this.oldrg + this.bounds().x - this.startx);
            this.setCursor0(11);
            return true;
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this._enable) {
            if (this.state) {
                this.paintLine(this.getParent(), this.oldrg + this.bounds().x - this.startx);
                this.resizeme(n);
                this.drag = false;
                this.state = false;
            }
            return true;
        }
        return super.mouseUp(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this._enable) {
            if (this.state) {
                if (this.oldrg == n) {
                    return super.mouseDrag(event, n, n2);
                }
                if (this.drag) {
                    this.paintLine(this.getParent(), this.oldrg + this.bounds().x - this.startx);
                } else {
                    this.drag = true;
                }
                this.paintLine(this.getParent(), n + this.bounds().x - this.startx);
                this.oldrg = n;
            }
            return true;
        }
        return super.mouseDrag(event, n, n2);
    }

    public static void debug(String string) {
        System.out.println(string);
    }
}

