/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import org.zaval.awt.TextAlignArea;

public class ResultField
extends Canvas {
    TextAlignArea alignArea = new TextAlignArea();
    boolean is3D = false;

    public ResultField(String string) {
        this.setText(string);
    }

    public ResultField() {
        this.alignArea.setInsets(new Insets(0, 2, 0, 0));
    }

    public void set3D(boolean bl) {
        if (bl == this.is3D) {
            return;
        }
        this.is3D = bl;
        this.repaint();
    }

    public TextAlignArea getAlignArea() {
        return this.alignArea;
    }

    public String getText() {
        return this.alignArea.getText();
    }

    public void setText(String string) {
        this.alignArea.setText(string);
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.alignArea.invalidate();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.alignArea.setSize(new Dimension(n3, n4));
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.alignArea.setSize(new Dimension(n, n2));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.alignArea.getFontMetrics() == null) {
            this.alignArea.setFontMetrics(this.getFontMetrics(this.getFont()));
        }
        if (this.is3D) {
            Dimension dimension = this.size();
            graphics.setColor(Color.white);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            graphics.setColor(Color.gray);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.clipRect(2, 2, dimension.width - 3, dimension.height - 3);
        }
        this.alignArea.draw(graphics, this.getForeground());
    }

    public Dimension preferredSize() {
        if (!this.isValid()) {
            this.validate();
        }
        Rectangle rectangle = this.alignArea.getAlignRectangle();
        return new Dimension(rectangle.width, rectangle.height);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.requestFocus();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return true;
    }
}

