/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import org.zaval.awt.ScrollArea;
import org.zaval.awt.ScrollObject;
import org.zaval.awt.util.Metrics;

public class ScrollController
extends Metrics {
    public static final int SCROLL_SIZE = 16;
    private int hValue = 0;
    private int vValue = 0;
    private ScrollArea area;
    private ScrollObject sobj;
    private Dimension pages = new Dimension(0, 0);
    private Dimension lines = new Dimension(1, 1);

    public ScrollController() {
    }

    public ScrollController(ScrollArea scrollArea, ScrollObject scrollObject) {
        this.setScrollArea(scrollArea);
        this.setScrollObject(scrollObject);
    }

    protected int normilize(Scrollbar scrollbar, int n, int n2) {
        int n3 = n + n2;
        if (n3 < 0) {
            n2 -= n3;
        } else if (n3 >= scrollbar.getMaximum()) {
            n2 -= n3 - scrollbar.getMaximum();
        }
        return n2;
    }

    protected int next(Scrollbar scrollbar, int n, int n2, int n3) {
        if (scrollbar == null || !scrollbar.isVisible()) {
            return 0;
        }
        int n4 = 0;
        int n5 = scrollbar.getOrientation();
        switch (n2) {
            case 604: {
                if (n5 == 0) {
                    n4 = this.getHPageSize(n2);
                    break;
                }
                n4 = this.getVPageSize(n2);
                break;
            }
            case 601: {
                if (n5 == 0) {
                    n4 = -this.getHLineSize(n2);
                    break;
                }
                n4 = -this.getVLineSize(n2);
                break;
            }
            case 605: {
                n4 = scrollbar.getValue() - n;
                break;
            }
            case 602: {
                if (n5 == 0) {
                    n4 = this.getHLineSize(n2);
                    break;
                }
                n4 = this.getVLineSize(n2);
                break;
            }
            case 603: {
                n4 = n5 == 0 ? -this.getHPageSize(n2) : -this.getVPageSize(n2);
            }
        }
        n4 *= n3;
        n4 = this.normilize(scrollbar, n, n4);
        return n4;
    }

    public boolean handle(Event event, int n) {
        boolean bl;
        Scrollbar scrollbar = this.area.getHBar();
        Scrollbar scrollbar2 = this.area.getVBar();
        if (event.target != scrollbar && event.target != scrollbar2) {
            return false;
        }
        boolean bl2 = bl = event.id == 603 || event.id == 604 || event.id == 605 || event.id == 601 || event.id == 602;
        if (!bl) {
            return false;
        }
        return this.handle((Scrollbar)event.target, event.id, n);
    }

    protected boolean handle(Scrollbar scrollbar, int n, int n2) {
        if (scrollbar == null || !scrollbar.isVisible()) {
            return false;
        }
        Scrollbar scrollbar2 = this.area.getHBar();
        Scrollbar scrollbar3 = this.area.getVBar();
        int n3 = 0;
        int n4 = 0;
        if (scrollbar == scrollbar2) {
            n3 = this.next(scrollbar2, this.hValue, n, n2);
            this.hValue += n3;
            if (n3 != 0) {
                scrollbar2.setValue(this.hValue);
            }
        } else if (scrollbar == scrollbar3) {
            n4 = this.next(scrollbar3, this.vValue, n, n2);
            this.vValue += n4;
            if (n4 != 0) {
                scrollbar3.setValue(this.vValue);
            }
        }
        if (n3 != 0 || n4 != 0) {
            ScrollObject scrollObject = this.getScrollObject();
            Point point = scrollObject.getSOLocation();
            scrollObject.setSOLocation(point.x - n3, point.y - n4);
        }
        return true;
    }

    public void clear() {
        this.hValue = 0;
        this.vValue = 0;
    }

    public int getMaxHorScroll() {
        boolean bl;
        boolean bl2;
        Scrollbar scrollbar = this.area.getHBar();
        Scrollbar scrollbar2 = this.area.getVBar();
        if (scrollbar == null) {
            return -1;
        }
        Dimension dimension = this.sobj.getSOSize();
        Dimension dimension2 = this.area.getSASize();
        int n = dimension2.width;
        int n2 = dimension2.height;
        boolean bl3 = false;
        boolean bl4 = bl2 = dimension.width > n;
        if (scrollbar2 != null && (dimension.height > n2 || bl2 && dimension.height > n2 - 16)) {
            bl3 = true;
            n -= 16;
        }
        boolean bl5 = bl = bl3 && dimension.width > n;
        if (bl2 || bl) {
            this.hValue = 0;
            int n3 = dimension.width - n;
            return n3 + 1;
        }
        return -1;
    }

    public int getMaxVerScroll() {
        boolean bl;
        boolean bl2;
        Scrollbar scrollbar = this.area.getHBar();
        Scrollbar scrollbar2 = this.area.getVBar();
        if (scrollbar2 == null) {
            return -1;
        }
        Dimension dimension = this.sobj.getSOSize();
        Dimension dimension2 = this.area.getSASize();
        int n = dimension2.width;
        int n2 = dimension2.height;
        boolean bl3 = false;
        boolean bl4 = bl2 = dimension.height > n2;
        if (scrollbar != null && (dimension.width > n || bl2 && dimension.width > n - 16)) {
            n2 -= 16;
            bl3 = true;
        }
        boolean bl5 = bl = bl3 && dimension.height > n2;
        if (bl2 || bl) {
            this.vValue = 0;
            int n3 = dimension.height - n2;
            return n3 + 1;
        }
        return -1;
    }

    public ScrollArea getScrollArea() {
        return this.area;
    }

    public ScrollObject getScrollObject() {
        return this.sobj;
    }

    public void setScrollArea(ScrollArea scrollArea) {
        this.area = scrollArea;
        this.invalidate();
    }

    public void setScrollObject(ScrollObject scrollObject) {
        this.sobj = scrollObject;
        this.invalidate();
    }

    public void recalc() {
        this.clear();
        Scrollbar scrollbar = this.area.getHBar();
        Scrollbar scrollbar2 = this.area.getVBar();
        Dimension dimension = this.area.getSASize();
        this.pages.width = dimension.width;
        this.pages.height = dimension.height;
        if (scrollbar != null && scrollbar.isVisible()) {
            this.pages.width -= 16;
            this.lines.width = this.pages.width / 4;
        }
        if (scrollbar2 != null && scrollbar2.isVisible()) {
            this.pages.height -= 16;
            this.lines.height = this.pages.height / 4;
        }
    }

    public void setV(int n, int n2) {
        this.clear();
        this.handle(this.area.getVBar(), n, n2);
    }

    public void setH(int n, int n2) {
        this.clear();
        this.handle(this.area.getHBar(), n, n2);
    }

    public int getVPageSize(int n) {
        return this.pages.height;
    }

    public int getHPageSize(int n) {
        return this.pages.width;
    }

    public int getHLineSize(int n) {
        return this.lines.width;
    }

    public int getVLineSize(int n) {
        return this.lines.height;
    }

    public static Dimension calcPreferredSize(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isVisible()) continue;
            Rectangle rectangle = componentArray[i].bounds();
            int n3 = rectangle.x + rectangle.width;
            int n4 = rectangle.y + rectangle.height;
            if (n < n3) {
                n = n3;
            }
            if (n2 >= n4) continue;
            n2 = n4;
        }
        return new Dimension(n + 5, n2 + 5);
    }
}

