/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class ScrollLayout
implements LayoutManager {
    protected Component hs;
    protected Component vs;
    protected Component stubb;
    protected Component center;

    public void addLayoutComponent(String string, Component component) {
        if (string != null) {
            if (string.equals("East")) {
                this.vs = component;
            } else if (string.equals("South")) {
                this.hs = component;
            } else if (string.equals("Center")) {
                this.center = component;
            } else if (string.equals("Stubb")) {
                this.stubb = component;
                this.stubb.resize(0, 0);
                this.stubb.setBackground(Color.lightGray);
                return;
            }
        }
    }

    protected Insets getInsets(Container container) {
        return container.insets();
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.vs) {
            this.vs = null;
        }
        if (component == this.hs) {
            this.hs = null;
        }
        if (this.center == component) {
            this.center = null;
        }
        if (this.stubb == component) {
            this.stubb = null;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Cloneable cloneable;
        boolean bl;
        Dimension dimension = new Dimension(0, 0);
        boolean bl2 = this.hs != null && this.hs.isVisible();
        boolean bl3 = bl = this.vs != null && this.vs.isVisible();
        if (bl) {
            cloneable = this.vs.preferredSize();
            dimension.width += cloneable.width;
            dimension.height = Math.max(cloneable.height, dimension.height);
        }
        if (this.center != null && this.center.isVisible()) {
            cloneable = this.center.preferredSize();
            dimension.width += cloneable.width;
            dimension.height = Math.max(cloneable.height, dimension.height);
        }
        if (bl2) {
            cloneable = this.hs.preferredSize();
            dimension.width = Math.max(cloneable.width, dimension.width);
            dimension.height += cloneable.height;
        }
        cloneable = this.getInsets(container);
        dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
        dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        boolean bl;
        Insets insets = this.getInsets(container);
        Rectangle rectangle = container.bounds();
        int n = insets.top;
        int n2 = rectangle.height - insets.bottom;
        int n3 = insets.left;
        int n4 = rectangle.width - insets.right;
        int n5 = 16;
        boolean bl2 = this.hs != null && this.hs.isVisible();
        boolean bl3 = bl = this.vs != null && this.vs.isVisible();
        if (bl2) {
            n2 -= n5;
        }
        if (bl) {
            n4 -= n5;
        }
        if (bl2) {
            this.hs.reshape(n3, n2, n4, n5);
        }
        if (bl) {
            this.vs.reshape(n4, n, n5, n2);
        }
        if (this.center != null && this.center.isVisible()) {
            this.layoutCenter(container, n3, n, n4 - n3, n2 - n);
        }
        if (bl2 && bl) {
            if (this.stubb != null) {
                this.stubb.reshape(n4, n2, n5, n5);
            }
        } else if (this.stubb != null) {
            this.stubb.resize(0, 0);
        }
    }

    public Dimension getAreaSize(Component component) {
        Rectangle rectangle;
        Rectangle rectangle2 = component.bounds();
        Dimension dimension = new Dimension(rectangle2.width, rectangle2.height);
        if (this.hs.isVisible()) {
            rectangle = this.hs.bounds();
            if (rectangle2.y + rectangle2.height < rectangle.y) {
                dimension.height += rectangle.height;
            }
        }
        if (this.vs.isVisible()) {
            rectangle = this.vs.bounds();
            if (rectangle2.x + rectangle2.width < rectangle.x) {
                dimension.width += rectangle.width;
            }
        }
        return dimension;
    }

    protected void layoutCenter(Container container, int n, int n2, int n3, int n4) {
        this.center.reshape(n, n2, n3, n4);
    }
}

