/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Scrollbar;
import org.zaval.awt.ScrollArea;
import org.zaval.awt.ScrollController;
import org.zaval.awt.ScrollLayout;
import org.zaval.awt.ScrollObject;
import org.zaval.awt.StubbComponent;

public class ScrollPanel
extends Panel
implements ScrollArea,
LayoutManager {
    private Scrollbar hBar = new Scrollbar(0);
    private Scrollbar vBar = new Scrollbar(1);
    private Panel mainPanel = new Panel();
    private ScrollLayout layout = new ScrollLayout();
    private ScrollController metrics;

    public ScrollPanel(ScrollObject scrollObject) {
        this.init(new ScrollController(this, scrollObject));
    }

    public ScrollPanel(ScrollController scrollController) {
        this.init(scrollController);
    }

    protected void init(ScrollController scrollController) {
        this.metrics = scrollController;
        if (this.metrics == null) {
            this.metrics = new ScrollController(this, null);
        }
        if (this.metrics.getScrollArea() == null) {
            this.metrics.setScrollArea(this);
        }
        this.setLayout(this.layout);
        this.add("Center", this.mainPanel);
        this.add("East", this.vBar);
        this.add("South", this.hBar);
        this.add("Stubb", new StubbComponent());
        ScrollObject scrollObject = this.metrics.getScrollObject();
        this.init(this.mainPanel, scrollObject.getScrollComponent());
    }

    protected void init(Container container, Component component) {
        container.setLayout(this);
        container.add(component);
    }

    public boolean handleEvent(Event event) {
        if (this.metrics.handle(event, 1)) {
            return true;
        }
        return super.handleEvent(event);
    }

    public void invalidate() {
        super.invalidate();
        if (this.metrics != null) {
            this.metrics.invalidate();
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.metrics != null) {
            this.metrics.invalidate();
        }
        this.invalidate();
        this.recalc();
    }

    public void layout() {
        this.recalc();
        super.layout();
    }

    public void recalc() {
        if (!this.metrics.isValid()) {
            this.metrics.validate();
        }
        ScrollObject scrollObject = this.metrics.getScrollObject();
        int n = this.metrics.getMaxVerScroll();
        int n2 = this.metrics.getMaxHorScroll();
        if (n < 0) {
            this.vBar.hide();
        } else {
            this.vBar.setValues(0, 0, 0, n);
            scrollObject.setSOLocation(0, 0);
            this.vBar.show();
        }
        if (n2 < 0) {
            this.hBar.hide();
        } else {
            this.hBar.setValues(0, 0, 0, n2);
            scrollObject.setSOLocation(0, 0);
            this.hBar.show();
        }
        scrollObject.setSOLocation(0, 0);
    }

    public Scrollbar getVBar() {
        return this.vBar;
    }

    public Scrollbar getHBar() {
        return this.hBar;
    }

    public Dimension getSASize() {
        return this.size();
    }

    protected ScrollController getMetrics() {
        return this.metrics;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Component[] componentArray = container.getComponents();
        if (componentArray.length > 0) {
            return componentArray[0].preferredSize();
        }
        return new Dimension(0, 0);
    }

    public void layoutContainer(Container container) {
        Component[] componentArray = container.getComponents();
        ScrollArea scrollArea = this.metrics.getScrollArea();
        Dimension dimension = container.size();
        for (int i = 0; i < componentArray.length; ++i) {
            Dimension dimension2 = componentArray[i].preferredSize();
            if (!scrollArea.getVBar().isVisible()) {
                dimension2.height = dimension.height;
            }
            if (!scrollArea.getHBar().isVisible()) {
                dimension2.width = dimension.width;
            }
            componentArray[i].resize(dimension2.width, dimension2.height);
        }
    }
}

