/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;

public class SimpleScrollPanel
extends Panel
implements LayoutManager {
    private boolean isHor = true;
    private boolean isVer = true;
    private Scrollbar hor;
    private Scrollbar ver;
    private Component comp;
    private Panel panel;
    private Dimension auf = null;
    public static final int IS_NEED_SCROLL = 646478;
    private static final int[] table = new int[]{605, 602, 601, 604, 603};

    public Component getScrollableObject() {
        return this.comp;
    }

    public SimpleScrollPanel(Component component) {
        this.comp = component;
        this.hor = new Scrollbar(0);
        this.ver = new Scrollbar(1);
        this.setLayout(this);
        this.panel = new Panel();
        this.panel.setLayout(null);
        this.panel.add(this.comp);
        this.ver.hide();
        this.hor.hide();
        this.add(this.panel);
        this.add(this.hor);
        this.add(this.ver);
        this.setBackground(this.getBackground());
        this.hor.setBackground(this.getBackground());
        this.ver.setBackground(this.getBackground());
        this.panel.setBackground(this.getBackground());
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.hor.setBackground(color);
        this.ver.setBackground(color);
        this.panel.setBackground(color);
    }

    private boolean drop(Event event) {
        if (!(event.target instanceof Scrollbar)) {
            return true;
        }
        for (int i = 0; i < table.length; ++i) {
            if (event.id != table[i]) continue;
            return false;
        }
        return true;
    }

    public boolean handleEvent(Event event) {
        if (this.drop(event)) {
            return super.handleEvent(event);
        }
        if (event.target == this.ver) {
            this.comp.move(this.comp.bounds().x, -this.ver.getValue());
            this.checkValid();
            return true;
        }
        if (event.target == this.hor) {
            this.comp.move(-this.hor.getValue(), this.comp.bounds().y);
            this.checkValid();
            return true;
        }
        return super.handleEvent(event);
    }

    private void checkValid() {
        if (!this.hor.isEnabled()) {
            this.hor.hide();
            this.hor.enable();
            ((Component)this).invalidate();
            this.validate();
        }
        if (!this.ver.isEnabled()) {
            this.ver.hide();
            this.ver.enable();
            ((Component)this).invalidate();
            this.validate();
        }
        this.comp.repaint();
    }

    public Point location(int n, int n2) {
        return new Point(0, 0);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.comp.preferredSize();
        if (dimension.width == 0 || dimension.height == 0) {
            dimension = this.comp.size();
        }
        dimension.width += this.ver.preferredSize().width;
        dimension.height += this.hor.preferredSize().height;
        if (this.auf == null) {
            return dimension;
        }
        return this.auf;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = this.comp.minimumSize();
        if (dimension.width == 0 || dimension.height == 0) {
            dimension = this.comp.size();
        }
        dimension.width += this.ver.preferredSize().width;
        dimension.height += this.hor.preferredSize().height;
        if (this.auf == null) {
            return dimension;
        }
        return this.oops(this.auf, dimension);
    }

    private Dimension oops(Dimension dimension, Dimension dimension2) {
        int n = Math.min(dimension.width, dimension2.width);
        int n2 = Math.min(dimension.height, dimension2.height);
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        Dimension dimension = this.comp.preferredSize();
        if (dimension.width == 0 || dimension.height == 0) {
            dimension = this.comp.size();
        }
        this.comp.resize(dimension.width, dimension.height);
        Rectangle rectangle = this.comp.bounds();
        if (rectangle.x < 0 || rectangle.y < 0) {
            this.comp.move(0, 0);
        }
        this.checkForSVH();
    }

    private Component get0(Container container) {
        return container.getComponent(0);
    }

    public void setMaxSize(Dimension dimension) {
        this.auf = dimension;
    }

    private void checkForSVH() {
        int n;
        Dimension dimension = this.comp.preferredSize();
        if (dimension.width == 0 || dimension.height == 0) {
            dimension = this.comp.size();
        }
        Rectangle rectangle = this.bounds();
        int n2 = this.hor.preferredSize().height;
        int n3 = this.ver.preferredSize().width;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        boolean bl = false;
        boolean bl2 = false;
        bl = dimension.width > n4 || dimension.height > n5 && dimension.width > n4 - n3;
        boolean bl3 = bl2 = dimension.height > n5 || dimension.width > n4 && dimension.height > n5 - n2;
        if (!bl) {
            if (this.hor.isVisible()) {
                this.hor.hide();
            }
            this.comp.move(0, 0);
        } else {
            this.hor.move(0, rectangle.height - n2);
            this.hor.resize(rectangle.width - (bl2 ? n3 : 0), n2);
            this.hor.show();
            n = dimension.width - n4 + (dimension.height > (n5 -= n2) ? n3 : 0);
            this.hor.setValues(0, n4 - (bl2 ? n3 : 0), 0, dimension.width);
            this.hor.setPageIncrement(n4 / 2);
        }
        if (!bl2) {
            if (this.ver.isVisible()) {
                this.ver.hide();
            }
            this.comp.move(0, 0);
        } else {
            this.ver.move(rectangle.width - n3, 0);
            this.ver.resize(n3, rectangle.height - (bl ? n2 : 0));
            this.ver.show();
            n4 -= n3;
            n = dimension.height - n5;
            this.ver.setValues(0, n5, 0, dimension.height);
            this.ver.setPageIncrement(n5 / 2);
        }
        this.panel.move(0, 0);
        this.panel.resize(n4, n5);
        if (dimension.width < n4) {
            dimension.width = n4;
            this.comp.resize(dimension.width, dimension.height);
        }
    }

    public Scrollbar getVScrollbar() {
        return this.ver;
    }

    public Scrollbar getHScrollbar() {
        return this.hor;
    }

    public void scroll(int n, int n2) {
        this.comp.move(-n, -n2);
        this.hor.setValue(n);
        this.ver.setValue(n2);
    }
}

