/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import org.zaval.awt.image.BoxButtonFilter;
import org.zaval.awt.image.ButtonImageFilter;

public class SpeedButton
extends Canvas {
    private static final int FREE = 1;
    private static final int UP = 2;
    private static final int DOWN = 3;
    private Image normImg;
    private Image upImg;
    private Image disImg;
    private Image downImg;
    private int w;
    private int h;
    private int state = 1;

    public void setImageSize(Dimension dimension) {
        this.w = dimension.width;
        this.h = dimension.height;
    }

    public SpeedButton(Image image, int n, int n2, ButtonImageFilter buttonImageFilter) {
        this.w = image.getWidth(this);
        this.h = image.getHeight(this);
        if (n < 0) {
            n = -n;
            if ((n = this.w * n / 100) < 2) {
                n = 2;
            }
        }
        this.init(image, this.getFilter(image, buttonImageFilter, n2, n, false), this.getFilter(image, buttonImageFilter, -n2, n, true), this.getFilter(image, buttonImageFilter, -Math.abs(n2), 0, false));
    }

    public SpeedButton(Image image, Image image2, Image image3, Image image4) {
        if (image == null) {
            this.h = 0;
            this.w = 0;
        } else {
            this.w = image.getWidth(this);
            this.h = image.getHeight(this);
        }
        this.init(image, image2, image3, image4);
    }

    public SpeedButton(Image image) {
        this(image, -5, 30, new BoxButtonFilter());
    }

    private void init(Image image, Image image2, Image image3, Image image4) {
        this.normImg = image;
        this.upImg = image2;
        this.disImg = image4;
        this.downImg = image3;
    }

    public Image getFilter(Image image, ButtonImageFilter buttonImageFilter, int n, int n2, boolean bl) {
        buttonImageFilter = (ButtonImageFilter)buttonImageFilter.clone();
        buttonImageFilter.setup(n, n2, this.w, this.h, bl);
        ImageProducer imageProducer = image.getSource();
        FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, buttonImageFilter);
        return this.createImage(filteredImageSource);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
        this.repaint();
    }

    public Dimension preferredSize() {
        if (this.w < 0) {
            this.w = 0;
        }
        if (this.h < 0) {
            this.h = 0;
        }
        return new Dimension(this.w, this.h);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.disImg != null && !this.isEnabled()) {
            graphics.drawImage(this.disImg, 0, 0, n, n2, this);
        } else if (this.state == 1 && this.normImg != null) {
            graphics.drawImage(this.normImg, 0, 0, n, n2, this);
        } else if (this.state == 3 && this.downImg != null) {
            graphics.drawImage(this.downImg, 0, 0, n, n2, this);
        } else if (this.state == 2 && this.upImg != null) {
            graphics.drawImage(this.upImg, 0, 0, n, n2, this);
        }
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (!this.isEnabled() || this.state == 1) {
            return true;
        }
        this.setState(2);
        this.getParent().postEvent(new Event(this, 1001, null));
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.isEnabled()) {
            return true;
        }
        this.setState(3);
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.setState(2);
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.setState(1);
        return true;
    }
}

