/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.io.Serializable;
import org.zaval.awt.StatusBarElement;

public class StatusBar
extends Panel
implements LayoutManager {
    public static final int FULL = 1;
    private Insets insets = new Insets(2, 1, 0, -1);
    private int hgap = 2;
    private int fill = 0;

    public StatusBar() {
        this.setLayout(this);
    }

    public int getFill() {
        return this.fill;
    }

    public void setFill(int n) {
        if (this.fill == n) {
            return;
        }
        this.fill = n;
        this.invalidate();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.size();
        Component[] componentArray = container.getComponents();
        int n = this.getActualHeight(container);
        int[] nArray = this.getActualWidths(container);
        int n2 = this.insets.left;
        int n3 = this.insets.top;
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].move(n2, n3);
            componentArray[i].resize(nArray[i], n);
            n2 += nArray[i] + this.hgap;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        int[] nArray = this.getActualWidths(container);
        int n = this.getActualHeight(container) + this.insets.top + this.insets.bottom;
        int n2 = this.insets.left + this.insets.right + this.hgap * (nArray.length - 1);
        for (int i = 0; i < nArray.length; ++i) {
            n2 += nArray[i];
        }
        return new Dimension(n2, n);
    }

    public void removeLayoutComponent(Component component) {
    }

    protected int getActualHeight(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            Dimension dimension = componentArray[i].preferredSize();
            if (n >= dimension.height) continue;
            n = dimension.height;
        }
        return n;
    }

    protected int[] getActualWidths(Container container) {
        Serializable serializable;
        Dimension dimension = container.size();
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[componentArray.length];
        int n3 = this.insets.left + this.hgap * (componentArray.length - 1);
        dimension.width -= this.insets.left + this.insets.right + this.hgap * (componentArray.length - 1);
        dimension.height -= this.insets.top + this.insets.bottom;
        for (n2 = 0; n2 < componentArray.length; ++n2) {
            StatusBarElement statusBarElement;
            serializable = componentArray[n2].preferredSize();
            if (!(componentArray[n2] instanceof StatusBarElement)) {
                nArray[n2] = ((Dimension)serializable).width;
                n += ((Dimension)serializable).width;
                continue;
            }
            if (!(componentArray[n2] instanceof StatusBarElement) || (statusBarElement = (StatusBarElement)componentArray[n2]).getPercent() != 0) continue;
            n += ((Dimension)serializable).width;
            nArray[n2] = ((Dimension)serializable).width;
        }
        dimension.width -= n;
        for (n2 = 0; n2 < componentArray.length; ++n2) {
            int n4;
            n3 += nArray[n2];
            if (!(componentArray[n2] instanceof StatusBarElement) || (n4 = ((StatusBarElement)(serializable = (StatusBarElement)componentArray[n2])).getPercent()) == 0) continue;
            nArray[n2] = dimension.width * n4 / 100;
        }
        if (this.getFill() == 1) {
            nArray[componentArray.length - 1] = dimension.width - (n3 -= nArray[componentArray.length - 1]) - this.insets.right;
        }
        return nArray;
    }
}

