/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;

public class StatusBarElement
extends Panel {
    private int percent = -1;
    private int type = 1;
    private Insets ins = new Insets(1, 3, 1, 3);
    private Dimension pref = null;

    public StatusBarElement(Component component, int n, Dimension dimension) {
        this.setLayout(new BorderLayout(1, 0));
        if (component != null) {
            this.add("Center", component);
        }
        this.percent = n;
        this.pref = dimension;
    }

    public StatusBarElement(Component component, int n) {
        this(component, n, null);
    }

    public void setType(int n) {
        if (n == this.type) {
            return;
        }
        this.type = n;
        this.repaint();
    }

    public int getPercent() {
        return this.percent;
    }

    public Insets insets() {
        return this.ins;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.size();
        switch (this.type) {
            case 1: {
                graphics.setColor(Color.gray);
                graphics.drawLine(0, 0, dimension.width - 1, 0);
                graphics.drawLine(0, 0, 0, dimension.height - 1);
                graphics.setColor(Color.white);
                graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
                graphics.drawLine(dimension.width - 1, dimension.height - 1, 0, dimension.height - 1);
                break;
            }
            case 2: {
                graphics.setColor(Color.white);
                graphics.drawLine(0, 0, dimension.width - 1, 0);
                graphics.drawLine(0, 0, 0, dimension.height - 1);
                graphics.setColor(Color.gray);
                graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
                graphics.drawLine(dimension.width - 1, dimension.height - 1, 0, dimension.height - 1);
            }
        }
    }

    public Dimension preferredSize() {
        if (this.pref != null) {
            return new Dimension(this.pref.width, this.pref.height);
        }
        return super.preferredSize();
    }
}

