/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import org.zaval.awt.ImageResolver;
import org.zaval.awt.LevelTree;
import org.zaval.awt.ScrollArea;
import org.zaval.awt.ScrollController;
import org.zaval.awt.ScrollLayout;
import org.zaval.awt.ScrollObject;
import org.zaval.awt.StubbComponent;
import org.zaval.awt.peer.TreeNode;

public class SymTree
extends Panel
implements ScrollArea,
ScrollObject {
    public static final int SEL_CHANGED = 1006;
    private TreeNode selectedNode;
    private Scrollbar sbV;
    private Scrollbar sbH;
    private Color bgHighlightColor = Color.gray;
    private Color fgHighlightColor = Color.white;
    private int viewHeight = 300;
    private int viewWidth = 300;
    private final int cellSize = 16;
    private int clickSize = 8;
    private int textInset = 6;
    private int textBaseLine = 3;
    private FontMetrics fm;
    private ScrollController sm;
    protected Image im1;
    protected Graphics g1 = null;
    protected boolean noChoice = false;
    private int posx = 0;
    private int posy = 0;
    private Dimension scrollInsets = new Dimension(10, 0);
    private LevelTree ltree = null;
    private ScrollLayout sl = new ScrollLayout();
    private static final int DELETE = 127;
    private static final int INSERT = 1025;
    int mouse_down = 0;
    long time = 0L;
    public static int NONE_FRAME = 0;
    public static int LINE_FRAME = 1;
    private int styleFrame = 1;
    public static int RECT_MARK = 0;
    public static int FILLRECT_MARK = 1;
    private int styleMark = 1;

    public SymTree() {
        super.setLayout(this.sl);
        this.sbV = new Scrollbar(1);
        this.add("East", this.sbV);
        this.sbH = new Scrollbar(0);
        this.add("South", this.sbH);
        this.add("Stubb", new StubbComponent());
        this.sbV.hide();
        this.sbH.hide();
        this.sbV.setBackground(Color.lightGray);
        this.sbH.setBackground(Color.lightGray);
        this.sm = new ScrollController(this, this);
        this.ltree = new LevelTree();
    }

    public SymTree(TreeNode treeNode) {
        this();
        this.selectedNode = this.ltree.getRootNode();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.invalidate();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.invalidate();
    }

    public void insert(TreeNode treeNode, TreeNode treeNode2, int n) {
        this.ltree.insert(treeNode, treeNode2, n);
    }

    public TreeNode getRootNode() {
        return this.ltree.getRootNode();
    }

    public int getCount() {
        return this.ltree.getCount();
    }

    public boolean exists(TreeNode treeNode) {
        return this.ltree.exists(treeNode);
    }

    public boolean exists(String string) {
        return this.ltree.exists(string);
    }

    private void resetVector() {
        this.ltree.resetVector();
    }

    public TreeNode getNode(String string) {
        return this.ltree.getNode(string);
    }

    public boolean insertChild(String string, String string2) {
        boolean bl = this.insertChild(string, string2, null, null);
        this.validate2();
        return bl;
    }

    public boolean insertChild(String string, String string2, String string3, String string4) {
        boolean bl = this.ltree.insertChild(string, string2, string3, string4);
        this.validate2();
        return bl;
    }

    public boolean insertNext(String string, String string2) {
        boolean bl = this.insertNext(string, string2, null, null);
        this.validate2();
        return bl;
    }

    public boolean insertNext(String string, String string2, String string3, String string4) {
        boolean bl = this.ltree.insertNext(string, string2, string3, string4);
        this.validate2();
        return bl;
    }

    public boolean insertRoot(String string) {
        boolean bl = this.insertRoot(string, null, null);
        this.validate2();
        return bl;
    }

    public boolean insertRoot(String string, String string2, String string3) {
        boolean bl = this.ltree.insertRoot(string, string2, string3);
        this.validate2();
        return bl;
    }

    public boolean setImages(String string, String string2, String string3) {
        return this.setImageOpen(string, string2) && this.setImageClose(string, string3);
    }

    public boolean setImageOpen(String string, String string2) {
        return this.ltree.setImageOpen(string, string2);
    }

    public boolean setImageClose(String string, String string2) {
        return this.ltree.setImageClose(string, string2);
    }

    public boolean changeText(String string, String string2) {
        return this.ltree.changeText(string, string2);
    }

    public boolean selectNode(String string) {
        if (this.getNode(string) == null) {
            return false;
        }
        TreeNode treeNode = this.getNode(string);
        if (this.isHidden(string)) {
            return false;
        }
        return this.selectNode(treeNode);
    }

    public boolean selectNode(TreeNode treeNode) {
        this.selectedNode = treeNode;
        int n = this.getViewCount();
        int n2 = this.getIndex(this.selectedNode);
        if (n2 == -1) {
            n2 = this.ltree.e.indexOf(this.selectedNode);
        }
        if (n2 > n - 1) {
            n2 = n - 1;
        }
        this.checkSelection(n2);
        return true;
    }

    public boolean selectNodeAndOpen(String string) {
        if (!this.selectNode(string)) {
            return false;
        }
        TreeNode treeNode = this.selectedNode.parent;
        while (treeNode != null) {
            treeNode.expand();
            treeNode = treeNode.parent;
        }
        this.validate2();
        return true;
    }

    public void setNamesDelim(String string) {
        this.ltree.setNamesDelim(string);
    }

    public TreeNode findNode(String string, String string2) {
        return this.ltree.findNode(string, string2);
    }

    public void append(TreeNode treeNode) {
        this.ltree.append(treeNode);
        if (this.getRootNode() == null) {
            this.selectedNode = this.getRootNode();
        }
    }

    public void remove(String string) {
        this.remove(this.getNode(string));
    }

    public void removeSelected() {
        if (this.selectedNode != null) {
            this.remove(this.selectedNode);
        }
    }

    public void remove(TreeNode treeNode) {
        int n = this.getViewCount();
        if (treeNode == this.selectedNode) {
            int n2 = this.getIndex(this.selectedNode);
            if (n2 == -1) {
                n2 = this.ltree.e.indexOf(this.selectedNode);
            }
            if (n2 > n - 1) {
                n2 = n - 1;
            }
            if (n2 > 0) {
                this.changeSelection((TreeNode)this.ltree.v.elementAt(n2 - 1), n2 - 1);
            } else if (n > 0) {
                try {
                    this.changeSelection((TreeNode)this.ltree.v.elementAt(1), 1);
                }
                catch (Exception exception) {
                    this.changeSelection((TreeNode)this.ltree.v.elementAt(0), 0);
                }
            }
        }
        this.ltree.remove(treeNode);
    }

    protected boolean checkScrolls() {
        int n;
        int n2;
        if (!this.isVisible()) {
            return false;
        }
        int n3 = this.getViewCount();
        Dimension dimension = this.getSASize();
        boolean bl = false;
        int n4 = this.sm.getMaxHorScroll();
        int n5 = this.sm.getMaxVerScroll();
        int n6 = dimension.width - (n5 > 0 ? 16 : 0);
        int n7 = dimension.height - (n4 > 0 ? 16 : 0);
        if (n5 > 0) {
            n2 = n3 - n7 / 16 + (n7 % 16 > 0 ? 1 : 0);
            if ((n2 += this.scrollInsets.height) <= 1) {
                n2 = 2;
            }
            n = this.sbV.getValue();
            this.sbV.setValues(n, 0, 0, n2);
            if (!this.sbV.isVisible()) {
                bl = true;
            }
            this.sbV.show();
        } else if (this.sbV.isVisible()) {
            this.sbV.hide();
            this.sbV.setValue(0);
            this.posy = 0;
            bl = true;
        }
        if (this.sm.getMaxHorScroll() > 0) {
            n2 = this.getMaxWidth() - n6 + this.scrollInsets.width;
            n = this.sbH.getValue();
            if (n2 <= 1) {
                n2 = 2;
            }
            this.sbH.setValues(n, 0, 0, n2);
            if (!this.sbH.isVisible()) {
                bl = true;
            }
            this.sbH.show();
        } else if (this.sbH.isVisible()) {
            this.sbH.setValue(0);
            this.sbH.hide();
            this.posx = 0;
            bl = true;
        }
        return bl;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.validate2();
    }

    public boolean handleEvent(Event event) {
        if (this.scroll(event)) {
            return true;
        }
        if (event.key > 0 && this.selectedNode != null) {
            if (event.key == 45 && this.selectedNode.isExpanded()) {
                this.toggleEvent(this.selectedNode, 0);
                return true;
            }
            if (event.key == 43 && this.isExpandable(this.selectedNode) && !this.selectedNode.isExpanded()) {
                this.toggleEvent(this.selectedNode, 1);
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public String getCaption(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return null;
        }
        return treeNode.getCaption();
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.time == 0L) {
            this.time = System.currentTimeMillis();
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.time;
        this.time = l;
        if (event.clickCount == 0 && l2 < 300L) {
            event.clickCount = 2;
        }
        if (event.modifiers == 4) {
            return super.mouseUp(event, n, n2);
        }
        this.requestFocus();
        this.mouse_down = 1;
        boolean[] blArray = new boolean[1];
        boolean bl = this.changeSelection(event, n, n2, true, blArray);
        if (!blArray[0]) {
            this.time -= 400L;
        }
        if (blArray[0] && event.clickCount == 2) {
            Event event2 = new Event(event.target, 9999, event.arg);
            this.getParent().postEvent(event2);
        }
        return super.mouseUp(event, n, n2);
    }

    public boolean keyDown(Event event, int n) {
        this.requestFocus();
        if (this.selectedNode == null) {
            return super.keyDown(event, n);
        }
        int n2 = this.getIndex(this.selectedNode);
        int n3 = this.getViewCount();
        TreeNode treeNode = null;
        this.mouse_down = 0;
        switch (n) {
            case 10: {
                this.sendActionEvent(event);
                break;
            }
            case 1004: {
                if (n2 <= 0) break;
                this.changeSelection((TreeNode)this.ltree.v.elementAt(--n2), n2);
                this.sendActionEvent(event);
                break;
            }
            case 1005: {
                if (n2 >= n3 - 1) break;
                this.changeSelection((TreeNode)this.ltree.v.elementAt(++n2), n2);
                this.sendActionEvent(event);
                break;
            }
            case 1007: {
                if (!this.selectedNode.isExpanded()) {
                    this.toggleEvent(this.selectedNode, 1);
                    break;
                }
                if (this.selectedNode.child == null) break;
                treeNode = this.selectedNode.child;
                while (treeNode != null && treeNode.hidden) {
                    treeNode = treeNode.sibling;
                }
                if (treeNode == null) break;
                this.changeSelection(treeNode, n2);
                this.sendActionEvent(event);
                break;
            }
            case 1006: {
                if (this.selectedNode.isExpanded()) {
                    this.toggleEvent(this.selectedNode, 0);
                    break;
                }
                if (this.selectedNode.parent == null || this.selectedNode.parent == this.getRootNode() || this.selectedNode.parent.hidden) break;
                this.changeSelection(this.selectedNode.parent, n2);
                this.sendActionEvent(event);
                break;
            }
            case 1002: {
                this.scrollPages(-1);
                this.sendActionEvent(event);
                break;
            }
            case 1003: {
                this.scrollPages(1);
                this.sendActionEvent(event);
                break;
            }
            case 1000: {
                treeNode = (TreeNode)this.ltree.v.elementAt(0);
                this.changeSelection(treeNode, 0);
                this.sendActionEvent(event);
                break;
            }
            case 1001: {
                treeNode = (TreeNode)this.ltree.v.elementAt(this.ltree.v.size() - 1);
                this.changeSelection(treeNode, this.ltree.v.size() - 1);
                this.sendActionEvent(event);
                break;
            }
            case 1025: {
                Event event2 = new Event(event.target, 9999, event.arg);
                this.getParent().postEvent(event2);
                break;
            }
            case 127: {
                Event event3 = new Event(event.target, 9991, event.arg);
                this.getParent().postEvent(event3);
            }
        }
        return super.keyDown(event, n);
    }

    private void sendActionEvent(Event event) {
        int n = event.id;
        Object object = event.arg;
        event.id = 1001;
        event.arg = new String(this.selectedNode.getText());
        this.postEvent(event);
        event.id = n;
        event.arg = object;
        this.repaint();
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public String getSelectedText() {
        if (this.selectedNode == null) {
            return null;
        }
        return this.selectedNode.getText();
    }

    public TreeNode getNode(int n, int n2) {
        int n3 = (Math.abs(this.posy) + n2) / 16;
        for (int i = 0; i <= n3 && i < this.ltree.v.size(); ++i) {
            TreeNode treeNode = (TreeNode)this.ltree.v.elementAt(i);
            if (!treeNode.getHide()) continue;
            ++n3;
        }
        if (n3 >= this.ltree.v.size()) {
            return null;
        }
        return (TreeNode)this.ltree.v.elementAt(n3);
    }

    public boolean changeSelection(Event event, int n, int n2, boolean bl, boolean[] blArray) {
        Object object;
        TreeNode treeNode;
        this.requestFocus();
        Dimension dimension = this.size();
        blArray[0] = false;
        int n3 = dimension.height / 16;
        int n4 = (Math.abs(this.posy) + n2) / 16;
        this.noChoice = false;
        int n5 = n2 / 16;
        if (n5 > n3 - 1) {
            this.noChoice = true;
            return false;
        }
        for (int i = 0; i <= n4 && i < this.ltree.v.size(); ++i) {
            treeNode = (TreeNode)this.ltree.v.elementAt(i);
            if (!treeNode.getHide()) continue;
            ++n4;
        }
        if (n4 >= this.ltree.v.size()) {
            return false;
        }
        TreeNode treeNode2 = this.selectedNode;
        treeNode = (TreeNode)this.ltree.v.elementAt(n4);
        int n6 = treeNode.getDepth();
        if (this.isExpandable(treeNode) && ((Rectangle)(object = new Rectangle(this.posx + 16 * (n6 - 1) + 4, this.posy + this.getIndex(treeNode) * 16 + this.clickSize / 2, this.clickSize, this.clickSize))).inside(n, n2) && bl) {
            this.toggleEvent(treeNode, treeNode.isExpanded() ? 1 : 0);
            return false;
        }
        object = treeNode.caption == null ? treeNode.text : treeNode.caption;
        int n7 = this.posx + (n6 - 1) * 16 + 16 + this.textInset;
        int n8 = n7 + this.fm.stringWidth((String)object) + 4;
        FontMetrics fontMetrics = this.g1.getFontMetrics();
        if (treeNode.getImage() != null) {
            n8 += fontMetrics.getHeight();
        }
        if (treeNode.getIndicator() != null) {
            n8 += fontMetrics.getHeight();
        }
        if (n > n8 || n < n7) {
            this.noChoice = true;
            return false;
        }
        if (treeNode == treeNode2) {
            blArray[0] = true;
        }
        this.changeSelection(treeNode, n4);
        Rectangle rectangle = new Rectangle(this.posx + 16 * n6 + 4, this.posy + n4 * 16 + this.clickSize / 2, this.clickSize, this.clickSize);
        if (event.modifiers != 4 && bl && treeNode == treeNode2) {
            this.toggleEvent(treeNode, treeNode.isExpanded() ? 0 : 1);
            return false;
        }
        if (treeNode.getImage() != null) {
            rectangle.x -= fontMetrics.getHeight();
        }
        if (treeNode.getIndicator() != null) {
            rectangle.x -= fontMetrics.getHeight();
        }
        if (!rectangle.inside(n, n2)) {
            this.sendActionEvent(event);
        }
        return false;
    }

    private void validate2() {
        this.resetVector();
        if (this.checkScrolls()) {
            this.invalidate();
        }
        this.validate();
        this.repaint();
    }

    private int getIndex(TreeNode treeNode) {
        return this.ltree.v.indexOf(treeNode);
    }

    private void changeSelection(TreeNode treeNode, int n) {
        if (this.selectedNode == null) {
            if (treeNode != null) {
                this.selectedNode = treeNode;
            } else {
                return;
            }
        }
        TreeNode treeNode2 = this.selectedNode;
        this.selectedNode = treeNode;
        int n2 = n * 16;
        this.drawNodeText(treeNode2, n2, true);
        this.drawNodeText(treeNode, n2, true);
        this.checkSelection(n);
    }

    protected void checkSelection(int n) {
        if (!this.sbV.isVisible() || n < 0) {
            return;
        }
        int n2 = n * 16;
        if (this.posy != 0 && n2 < Math.abs(this.posy)) {
            int n3 = Math.abs(this.posy) / 16;
            int n4 = n3 - n;
            int n5 = n4 * 16;
            this.vscroll(-n4);
            return;
        }
        n2 += this.posy + 16;
        int n6 = this.viewHeight;
        if (this.sbH.isVisible()) {
            n6 -= 16;
        }
        if (n2 > n6) {
            int n7 = n2 - n6;
            int n8 = n7 / 16;
            if (n7 % 16 > 0) {
                ++n8;
            }
            this.vscroll(n8);
            return;
        }
    }

    public void paint(Graphics graphics) {
        this.redraw();
        if (this.im1 != null) {
            graphics.drawImage(this.im1, 0, 0, this);
        }
        graphics.setColor(Color.gray);
        Dimension dimension = this.size();
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    public void redraw() {
        this.resetVector();
        this.drawTree();
    }

    public void drawTree() {
        Font font;
        Dimension dimension = this.size();
        if (dimension.width != this.viewWidth || dimension.height != this.viewHeight || this.g1 == null) {
            if (dimension.width * dimension.height <= 0) {
                return;
            }
            this.im1 = this.createImage(dimension.width, dimension.height);
            if (this.g1 != null) {
                this.g1.dispose();
                this.g1 = null;
            }
            this.g1 = this.im1.getGraphics();
            this.viewWidth = dimension.width;
            this.viewHeight = dimension.height;
        }
        if ((font = this.getFont()) == null) {
            font = new Font("TimesRoman", 0, 14);
            this.g1.setFont(font);
            this.setFont(font);
        }
        if (font != null && this.g1.getFont() == null) {
            this.g1.setFont(font);
        }
        int n = this.viewWidth - (this.sbV.isVisible() ? 16 : 0);
        int n2 = this.viewHeight - (this.sbH.isVisible() ? 16 : 0);
        this.fm = this.g1.getFontMetrics();
        this.g1.setColor(this.getBackground());
        this.g1.fillRect(0, 0, this.viewWidth, this.viewHeight);
        int n3 = this.ltree.v.size();
        int n4 = 0;
        int n5 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            Image image;
            Image image2;
            int n6;
            TreeNode treeNode = null;
            try {
                treeNode = (TreeNode)this.ltree.v.elementAt(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (treeNode == null) {
                this.g1.dispose();
                this.g1 = null;
                break;
            }
            int n7 = this.posx + 16 * (treeNode.depth - 1);
            int n8 = this.posy + (i - n4) * 16;
            this.g1.setColor(this.getForeground());
            TreeNode treeNode2 = this.getSibling(treeNode);
            if (treeNode2 != null) {
                n6 = this.getIndex(treeNode2) - this.getIndex(treeNode);
                this.drawDotLine(n7 + 8, n8 + 8, n7 + 8, n8 + 8 + n6 * 16);
            }
            if (treeNode.isExpanded()) {
                n6 = n7 + 16 + 8;
                this.drawDotLine(n6, n8 + 16 - 2, n6, n8 + 16 + 8);
            }
            this.g1.setColor(this.getForeground());
            n6 = n7 + 8;
            this.drawDotLine(n6, n8 + 8, n6 + 8 + 10, n8 + 8);
            if (this.isExpandable(treeNode)) {
                int n9 = n7 + this.clickSize / 2;
                this.g1.setColor(this.getBackground());
                this.g1.fillRect(n9, n8 + this.clickSize / 2, this.clickSize, this.clickSize);
                this.g1.setColor(this.getForeground());
                this.g1.drawRect(n9, n8 + this.clickSize / 2, this.clickSize, this.clickSize);
                this.g1.drawLine(n9 + 2, n8 + 8, n9 + this.clickSize - 2, n8 + 8);
                if (!this.isExpanded(treeNode)) {
                    this.g1.drawLine(n9 + this.clickSize / 2, n8 + this.clickSize / 2 + 2, n9 + this.clickSize / 2, n8 + this.clickSize / 2 + this.clickSize - 2);
                }
            }
            Image image3 = image2 = this.isExpanded(treeNode) ? treeNode.getExpandedImage() : treeNode.getCollapsedImage();
            if (image2 != null) {
                this.g1.drawImage(image2, n7 + 16, n8, this);
            }
            if ((image = treeNode.getIndicator()) != null) {
                int n10 = (image2 == null ? 16 : 32) + 2;
                int n11 = (16 - image.getHeight(this)) / 2 + 1;
                this.g1.drawImage(image, n7 + n10, n8 + n11, this);
            }
            if (treeNode.text == null) continue;
            this.drawNodeText(treeNode, n8, treeNode == this.selectedNode);
        }
    }

    private TreeNode getSibling(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode.sibling;
        while (treeNode2 != null && treeNode2.hidden) {
            treeNode2 = treeNode2.sibling;
        }
        return treeNode2;
    }

    private int getMaxWidth() {
        int n = 0;
        for (int i = 0; i < this.ltree.v.size(); ++i) {
            TreeNode treeNode = (TreeNode)this.ltree.v.elementAt(i);
            if (treeNode.getHide()) continue;
            String string = treeNode.caption == null ? treeNode.text : treeNode.caption;
            int n2 = treeNode.depth;
            int n3 = (n2 - 1) * 16 + 16 + this.textInset - 1 + (this.fm == null ? 0 : this.fm.stringWidth(string));
            if (treeNode.getImage() != null && this.fm != null) {
                n3 += this.fm.getHeight();
            }
            if (treeNode.getIndicator() != null && this.fm != null) {
                n3 += this.fm.getHeight();
            }
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    private void drawNodeText(TreeNode treeNode, int n, boolean bl) {
        String string = treeNode.caption == null ? treeNode.text : treeNode.caption;
        Color color = null;
        Color color2 = null;
        int n2 = this.getTextPos(treeNode);
        if (treeNode == this.selectedNode) {
            color = this.fgHighlightColor;
            color2 = this.bgHighlightColor;
        } else {
            color = this.getForeground();
            color2 = this.getBackground();
        }
        int n3 = n2 - 1 + this.fm.stringWidth(string) - this.posx;
        if (bl) {
            this.g1.setColor(color2);
            if (this.styleMark != RECT_MARK) {
                this.g1.fillRect(n2 - 1, n + 1, this.fm.stringWidth(string) + 4, 15);
                this.g1.setColor(color);
            } else {
                this.g1.setColor(Color.black);
                this.g1.drawRect(n2 - 1, n + 1, this.fm.stringWidth(string) + 4, 14);
            }
        } else {
            this.g1.setColor(color);
        }
        this.g1.drawString(string, n2, n + 16 - this.textBaseLine);
    }

    private void drawDotLine(int n, int n2, int n3, int n4) {
        if (n2 == n4) {
            for (int i = n; i < n3; i += 2) {
                this.g1.drawLine(i, n2, i, n4);
            }
        } else {
            for (int i = n2; i < n4; i += 2) {
                this.g1.drawLine(n, i, n3, i);
            }
        }
    }

    public void setTreeStructure(String[] stringArray) {
        this.ltree.setTreeStructure(stringArray);
        this.selectedNode = null;
        this.invalidate();
    }

    public String[] getTreeStructure() {
        return this.ltree.getTreeStructure();
    }

    public Dimension preferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return new Dimension(175, Math.min(this.ltree.v.size() * fontMetrics.getHeight(), 500));
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void setResolver(ImageResolver imageResolver) {
        this.ltree.setResolver(imageResolver);
    }

    public void show(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode != null) {
            treeNode.setHide(false);
        }
    }

    public void hide(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return;
        }
        treeNode.setHide(true);
        if (treeNode == this.selectedNode && this.fm != null) {
            this.correctSelect(treeNode.parent);
            return;
        }
        if (!this.isExpandable(treeNode.parent)) {
            treeNode.parent.collapse();
            if (this.fm != null) {
                this.correctSelect(treeNode.parent);
            }
        }
        this.validate2();
    }

    private void correctSelect(TreeNode treeNode) {
        this.resetVector();
        if (this.selectedNode != null && this.ltree.v.indexOf(this.selectedNode) < 0) {
            this.changeSelection(treeNode, this.ltree.v.indexOf(treeNode));
            Event event = new Event(this, 0, null);
            this.sendActionEvent(event);
        }
    }

    public void setCaption(String string, String string2) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return;
        }
        treeNode.setCaption(string2);
        this.validate2();
    }

    private boolean isExpandable(TreeNode treeNode) {
        if (!treeNode.isExpandable()) {
            return false;
        }
        if (treeNode.child == null) {
            return false;
        }
        treeNode = treeNode.child;
        if (!treeNode.getHide()) {
            return true;
        }
        while (treeNode.sibling != null) {
            treeNode = treeNode.sibling;
            if (treeNode.getHide()) continue;
            return true;
        }
        return false;
    }

    public void openToNode(String string) {
        TreeNode treeNode = this.getNode(string);
        while (treeNode != null) {
            if (treeNode.isExpandable() && !treeNode.isExpanded()) {
                treeNode.toggle();
            }
            treeNode = treeNode.parent;
        }
        this.validate2();
    }

    public void openNode(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null || treeNode.isExpanded()) {
            return;
        }
        if (treeNode.isExpandable() && !treeNode.isExpanded()) {
            treeNode.toggle();
        }
        this.validate2();
    }

    public void closeNode(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return;
        }
        if (treeNode.isExpandable() && treeNode.isExpanded()) {
            treeNode.toggle();
            this.correctSelect(treeNode);
        }
        this.validate2();
    }

    public boolean isHidden(String string) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return false;
        }
        while (treeNode.parent != null) {
            if (treeNode.getHide()) {
                return true;
            }
            treeNode = treeNode.parent;
        }
        return false;
    }

    public void expandAll() {
        this.ltree.expandAll();
        this.validate2();
    }

    public void collapseAll() {
        this.ltree.collapseAll();
        this.validate2();
    }

    public TreeNode getNode2(String string) {
        return this.ltree.getNode2(string);
    }

    protected int getNumChild(TreeNode treeNode) {
        return this.ltree.getNumChild(treeNode);
    }

    protected TreeNode getChild(TreeNode treeNode, String string) {
        return this.ltree.getChild(treeNode, string);
    }

    public TreeNode[] enumChild(String string) {
        return this.ltree.enumChild(string);
    }

    public TreeNode[] enumChild(TreeNode treeNode) {
        return this.ltree.enumChild(treeNode);
    }

    public void styleFrame(int n) {
        this.styleFrame = n;
        this.repaint();
    }

    public void styleMark(int n) {
        this.styleMark = n;
        this.repaint();
    }

    public void insertNode(String string, String string2, String string3) {
        this.ltree.insertNode(string, string2, string3);
        this.repaint();
    }

    private boolean isExpanded(TreeNode treeNode) {
        if (!treeNode.isExpanded()) {
            return false;
        }
        TreeNode treeNode2 = treeNode.child;
        while (treeNode2 != null) {
            if (!treeNode2.getHide()) {
                return true;
            }
            treeNode2 = treeNode2.sibling;
        }
        return false;
    }

    public int getViewCount() {
        return this.ltree.getViewCount();
    }

    public Dimension getSASize() {
        return this.sl.getAreaSize(this);
    }

    public Scrollbar getVBar() {
        return this.sbV;
    }

    public Scrollbar getHBar() {
        return this.sbH;
    }

    public Point getSOLocation() {
        return null;
    }

    public void setSOLocation(int n, int n2) {
    }

    public Dimension getSOSize() {
        int n = this.getViewCount();
        Dimension dimension = new Dimension(this.getMaxWidth(), 0);
        dimension.height = n * 16;
        return dimension;
    }

    public Component getScrollComponent() {
        return null;
    }

    public Rectangle getVisibleArea(Container container) {
        Rectangle rectangle = new Rectangle();
        return rectangle;
    }

    public boolean gotFocus(Event event, Object object) {
        this.bgHighlightColor = Color.blue;
        this.repaint();
        return true;
    }

    public void setIndicator(String string, String string2) {
        TreeNode treeNode = this.getNode(string);
        if (treeNode == null) {
            return;
        }
        treeNode.setIndicator(string2);
    }

    public boolean lostFocus(Event event, Object object) {
        this.bgHighlightColor = Color.gray;
        this.repaint();
        return super.lostFocus(event, object);
    }

    private void toggleEvent(TreeNode treeNode, int n) {
        if (!this.isExpandable(treeNode)) {
            return;
        }
        this.getParent().postEvent(new Event(this, 0L, 8888, 0, 0, n, 0, treeNode.getText()));
        treeNode.toggle();
        this.correctSelect(treeNode);
        this.validate2();
    }

    protected boolean scrollPages(int n) {
        int n2;
        int n3;
        int n4 = this.getIndex(this.selectedNode);
        int n5 = this.viewHeight - (this.sbH.isVisible() ? 16 : 0);
        int n6 = n5 / 16;
        if (n < 0) {
            n6 = -n6;
        }
        if ((n3 = n6 + n4) >= (n2 = this.ltree.v.size())) {
            n3 = n2 - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.changeSelection((TreeNode)this.ltree.v.elementAt(n3), n3);
        this.repaint();
        return this.vscroll(n6);
    }

    protected boolean vscroll(int n) {
        this.sbV.setValue(this.sbV.getValue() + n);
        int n2 = n < 0 ? 602 : 601;
        Event event = new Event(this.sbV, n2, null);
        return this.scroll(event);
    }

    protected boolean scroll(Event event) {
        boolean bl = false;
        if (event.target == this.sbV && this.sbV.isVisible()) {
            this.posy = -this.sbV.getValue() * 16;
            bl = true;
        }
        if (event.target == this.sbH && this.sbH.isVisible()) {
            this.posx = -this.sbH.getValue();
            bl = true;
        }
        if (bl) {
            this.validate2();
        }
        return bl;
    }

    protected int getTextPos(TreeNode treeNode) {
        int n = treeNode.depth;
        int n2 = (n - 1) * 16 + 16 + this.textInset + this.posx;
        if (treeNode.getImage() != null) {
            n2 += this.fm.getHeight();
        }
        if (treeNode.getIndicator() != null) {
            n2 += 16;
        }
        return n2;
    }
}

