/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.zaval.awt.AlignArea;

public class TextAlignArea
extends AlignArea {
    public static final int STRING_GAP = 0;
    private String text;
    private String[] strs = new String[0];
    private String deliver = "/p";
    private FontMetrics fontMetrics = null;
    private boolean isMulti = false;

    public TextAlignArea() {
        this.setAlign(1);
    }

    protected int getWidth(int n, Dimension dimension) {
        if (this.fontMetrics == null || this.text == null) {
            return -1;
        }
        if (!this.isMulti) {
            return this.fontMetrics.stringWidth(this.text);
        }
        int n2 = -1;
        for (int i = 0; i < this.strs.length; ++i) {
            int n3 = this.fontMetrics.stringWidth(this.strs[i]);
            if (n2 >= n3) continue;
            n2 = n3;
        }
        return n2;
    }

    protected int getHeight(int n, Dimension dimension) {
        if (this.fontMetrics == null || this.text == null) {
            return -1;
        }
        if (!this.isMulti) {
            return this.fontMetrics.getHeight();
        }
        return this.fontMetrics.getHeight() * this.strs.length + (this.strs.length - 1) * 0;
    }

    protected void recalc() {
        Dimension dimension = this.getSize();
        this.strs = this.fontMetrics == null ? null : TextAlignArea.breakString(this.text, this.fontMetrics, dimension.width);
    }

    public void setMultiLine(boolean bl) {
        if (this.isMulti == bl) {
            return;
        }
        this.isMulti = bl;
        this.invalidate();
    }

    public void setFontMetrics(FontMetrics fontMetrics) {
        this.fontMetrics = fontMetrics;
        this.invalidate();
    }

    public void setText(String string) {
        if (string != null && this.text != null && string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.invalidate();
    }

    public String getText() {
        return this.text;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public void draw(Graphics graphics, Color color) {
        this.draw(graphics, 0, 0, color);
    }

    private void drawText(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken() + ":";
        String string3 = stringTokenizer.nextToken();
        FontMetrics fontMetrics = this.fontMetrics;
        n4 += fontMetrics.stringWidth(string2);
        graphics.drawString(string2, n, n2);
        graphics.drawString(string3, n + n3 - (n5 += fontMetrics.stringWidth(string3)), n2);
    }

    private void drawJText(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        FontMetrics fontMetrics = this.fontMetrics;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n4] = stringTokenizer.nextToken();
            n5 += fontMetrics.stringWidth(stringArray[n4]);
            ++n4;
        }
        double d = (n3 - n5) / (stringArray.length - 1);
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            graphics.drawString(stringArray[n4], n, n2);
            n = (int)((double)n + d);
        }
    }

    public void draw(Graphics graphics, int n, int n2, Color color) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Rectangle rectangle = this.getAlignRectangle();
        int n3 = this.fontMetrics.getHeight();
        int n4 = rectangle.y + this.fontMetrics.getHeight() + n2 - this.fontMetrics.getDescent();
        graphics.setColor(color);
        int n5 = rectangle.x + n;
        if (this.isMulti) {
            for (int i = 0; i < this.strs.length; ++i) {
                if ((this.getAlign() & 2) > 0) {
                    int n6 = this.fontMetrics.stringWidth(this.strs[i]);
                    n5 = n6 > dimension.width ? insets.left + n : rectangle.x + n + rectangle.width - n6;
                }
                if ((this.getAlign() & 0x10) > 0) {
                    this.drawText(graphics, this.strs[i], n5, n4, dimension.width);
                } else if (i + 1 != this.strs.length && (this.getAlign() & 0x20) > 0) {
                    this.drawJText(graphics, this.strs[i], n5, n4, dimension.width);
                } else {
                    graphics.drawString(this.strs[i], n5, n4);
                }
                n4 += n3 + 0;
            }
        } else {
            graphics.drawString(this.text, rectangle.x, n4);
        }
    }

    public static void next(String string, String[] stringArray) {
        int n = string.indexOf(32);
        if (n < 0) {
            stringArray[0] = string;
            stringArray[1] = null;
            return;
        }
        if (n == 0) {
            ++n;
        }
        stringArray[0] = string.substring(n);
        stringArray[1] = string.substring(0, n);
    }

    public static String[] breakString(String string, FontMetrics fontMetrics, int n) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
            Vector<String> vector2 = new Vector<String>();
            String[] stringArray = new String[2];
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                String string3 = "";
                int n2 = 0;
                int n3 = 0;
                do {
                    String string4 = null;
                    TextAlignArea.next(string2, stringArray);
                    string4 = stringArray[1] != null ? stringArray[1] : stringArray[0];
                    string2 = stringArray[0];
                    int n4 = fontMetrics.stringWidth(string4);
                    if (n2 + n4 > n) {
                        if (string3.length() > 0) {
                            vector2.addElement(string3);
                            string3 = string4;
                            n2 = n4;
                            continue;
                        }
                        vector2.addElement(string4);
                        string3 = "";
                        n2 = 0;
                        continue;
                    }
                    ++n3;
                    string3 = string3 + string4;
                    n2 += n4;
                } while (stringArray[1] != null);
                if (n3 <= 0) continue;
                vector2.addElement(string3);
            }
            String[] stringArray2 = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                stringArray2[i] = (String)vector2.elementAt(i);
            }
            return stringArray2;
        }
        return null;
    }
}

