/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt.dialog;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import org.zaval.awt.EmulatedTextField;
import org.zaval.awt.ExGridLayout;
import org.zaval.awt.IELabel;

public class EditDialog
extends Dialog
implements AWTEventListener {
    private EmulatedTextField edit;
    private Button ok;
    private Button cancel;
    private boolean isApply;
    private Component listener;
    private IELabel label;

    public EditDialog(Frame frame, String string, boolean bl, Component component) {
        super(frame, string, bl);
        this.setLayout(new GridBagLayout());
        this.ok = new Button("Ok");
        this.cancel = new Button("Cancel");
        this.label = new IELabel("Name");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 2, 0));
        panel.add(this.ok);
        panel.add(this.cancel);
        EditDialog.constrain(this, this.label, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        this.edit = new EmulatedTextField(20);
        EditDialog.constrain(this, this.edit, 1, 0, 4, 1, 2, 17, 1.0, 0.0, 5, 5, 5, 5);
        EditDialog.constrain(this, panel, 0, 10, 2, 1, 0, 13, 1.0, 0.0, 5, 5, 5, 5);
        this.listener = component;
        this.edit.requestFocus();
    }

    public void setText(String string) {
        if (string == null) {
            this.edit.setText("");
        } else {
            this.edit.setText(string);
        }
    }

    public String getText() {
        return this.edit.getText();
    }

    public void setButtonsCaption(String string, String string2) {
        this.ok.setLabel(string);
        this.cancel.setLabel(string2);
    }

    public void setLabelCaption(String string) {
        this.label.setText(string);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201 || event.target == this.cancel && event.id == 1001) {
            this.isApply = false;
            this.dispose();
        }
        if (event.target == this.ok && event.id == 1001) {
            this.isApply = true;
            this.listener.postEvent(new Event(this, 1001, this.edit.getText()));
            this.dispose();
        }
        return super.handleEvent(event);
    }

    public boolean isApply() {
        return this.isApply;
    }

    public void toCenter() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.move((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8, int n9, int n10) {
        LayoutManager layoutManager;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.anchor = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        if (n7 + n10 + n8 + n9 > 0) {
            gridBagConstraints.insets = new Insets(n7, n8, n10, n9);
        }
        if ((layoutManager = container.getLayout()) instanceof GridBagLayout) {
            GridBagLayout gridBagLayout = (GridBagLayout)layoutManager;
            gridBagLayout.setConstraints(component, gridBagConstraints);
        } else if (layoutManager instanceof ExGridLayout) {
            ExGridLayout exGridLayout = (ExGridLayout)layoutManager;
            exGridLayout.setConstraints(component, gridBagConstraints);
        }
        container.add(component);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4) {
        EditDialog.constrain(container, component, n, n2, n3, n4, 0, 18, 1.0, 1.0, 0, 0, 5, 3);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6) {
        EditDialog.constrain(container, component, n, n2, n3, n4, n5, n6, 1.0, 1.0, 0, 0, 5, 3);
    }

    public boolean keyDown(Event event, int n) {
        if (n == 9) {
            return this.moveFocus();
        }
        if (event.target == this.ok && n == 10 || event.target == this.edit && n == 10) {
            this.isApply = true;
            this.listener.postEvent(new Event(this, 1001, this.edit.getText()));
            this.dispose();
            return true;
        }
        if (event.target == this.cancel && n == 10) {
            this.isApply = false;
            this.dispose();
            return true;
        }
        return false;
    }

    public boolean doModal() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        this.pack();
        this.toCenter();
        this.edit.requestFocus();
        this.show();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        return this.isApply();
    }

    private boolean moveFocus() {
        Component component = this.getFocusOwner();
        return this.moveFocus(component);
    }

    private void optimize(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Component component = (Component)vector.elementAt(i);
            if (!(component instanceof Button)) continue;
            vector.removeElementAt(i);
            vector.addElement(component);
            --n;
            --i;
        }
    }

    private boolean moveFocus(Component component) {
        int n;
        boolean bl = false;
        Vector vector = new Vector();
        this.linearize(this, vector);
        this.optimize(vector);
        int n2 = vector.size();
        for (n = 0; n < n2 && component != vector.elementAt(n); ++n) {
        }
        if (n >= n2) {
            n = -1;
        }
        if (n == n2 - 1) {
            bl = true;
            n = -1;
        }
        ((Component)vector.elementAt(n + 1)).requestFocus();
        return bl;
    }

    private void linearize(Container container, Vector vector) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Label || component instanceof IELabel) continue;
            if (component instanceof Container) {
                this.linearize((Container)component, vector);
                continue;
            }
            vector.addElement(component);
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() != 400) {
            return;
        }
        if (!(aWTEvent instanceof KeyEvent)) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        if (keyEvent.getKeyChar() != '\t') {
            return;
        }
        this.moveFocus();
    }
}

