/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt.dialog;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Vector;
import org.zaval.awt.ResultField;
import org.zaval.awt.StaticImage;
import org.zaval.awt.TextAlignArea;

public class MessageBox2
extends Dialog
implements LayoutManager {
    private StaticImage icon = null;
    private Vector buttons = null;
    private ResultField text;
    private Color storedColor = null;
    private Vector listeners = new Vector();
    private Button pressedButton = null;
    private static final int INDENT = 10;
    private static final int ICON_TEXT_GAP = 5;
    private static final int w = 4;
    private static final int h = 3;
    private static final int maxlinecount = 15;

    public ResultField getTextContainer() {
        return this.text;
    }

    public MessageBox2(Frame frame) {
        super(frame, false);
        this.setLayout(this);
        this.setTitle("Message");
        this.text = new ResultField();
        TextAlignArea textAlignArea = this.text.getAlignArea();
        if (textAlignArea != null) {
            textAlignArea.setMultiLine(true);
            textAlignArea.setAlign(5);
            textAlignArea.setInsets(new Insets(10, 0, 10, 0));
        }
        this.add(this.text);
    }

    public void show() {
        this.pack();
        Dimension dimension = this.preferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.resize(dimension.width, dimension.height);
        this.move((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setResizable(false);
        super.show();
    }

    public void setBackground(Color color) {
        if (this.storedColor != null) {
            color = this.storedColor;
        }
        this.storedColor = color;
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.icon != null) {
            this.icon.setBackground(color);
        }
        for (int i = 0; this.buttons != null && i < this.buttons.size(); ++i) {
            ((Component)this.buttons.elementAt(i)).setBackground(color);
        }
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.icon != null) {
            this.icon.setForeground(color);
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            ((Component)this.buttons.elementAt(i)).setForeground(color);
        }
    }

    public void setButtons(Vector vector) {
        int n;
        if (this.buttons != null) {
            for (n = 0; n < this.buttons.size(); ++n) {
                this.remove((Component)this.buttons.elementAt(n));
            }
        }
        this.buttons = vector;
        for (n = 0; n < this.buttons.size(); ++n) {
            this.add((Component)this.buttons.elementAt(n));
        }
        this.invalidate();
        this.validate();
    }

    public Vector getButtons() {
        return this.buttons;
    }

    public void setButtons(String[] stringArray) {
        Vector<Button> vector = new Vector<Button>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Button button = new Button(stringArray[i]);
            vector.addElement(button);
        }
        this.setButtons(vector);
    }

    public void setButtons(String string) {
        Vector<Button> vector = new Vector<Button>();
        vector.addElement(new Button(string));
        this.setButtons(vector);
    }

    public void setIcon(Image image) {
        if (this.icon != null) {
            this.remove(this.icon);
        }
        if (image == null) {
            return;
        }
        this.icon = new StaticImage(image);
        this.add(this.icon);
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public String getText() {
        return this.text.getText();
    }

    public void addListener(Component component) {
        this.listeners.addElement(component);
    }

    public void removeListener(Component component) {
        this.listeners.removeElement(component);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            this.pressedButton = (Button)event.target;
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                component.postEvent(new Event(this, 1001, (Button)event.target));
            }
            this.hide();
            return true;
        }
        return super.action(event, object);
    }

    private void setDefFontMetrics() {
        if (this.text != null && this.text.getAlignArea().getFontMetrics() == null) {
            Font font = this.getFont();
            if (font == null) {
                return;
            }
            FontMetrics fontMetrics = this.getFontMetrics(font);
            if (fontMetrics == null) {
                return;
            }
            this.text.getAlignArea().setFontMetrics(fontMetrics);
        }
    }

    private Dimension getIconSize() {
        if (this.icon == null) {
            return new Dimension(0, 0);
        }
        return this.icon.preferredSize();
    }

    private Dimension getTextSize(int n) {
        if (this.text == null) {
            return new Dimension(0, 0);
        }
        this.setDefFontMetrics();
        int n2 = 0;
        int n3 = 0;
        TextAlignArea textAlignArea = this.text.getAlignArea();
        if (textAlignArea != null && textAlignArea.getFontMetrics() != null) {
            FontMetrics fontMetrics = textAlignArea.getFontMetrics();
            String[] stringArray = TextAlignArea.breakString(textAlignArea.getText(), fontMetrics, n);
            for (int i = 0; i < stringArray.length; ++i) {
                n2 = Math.max(fontMetrics.stringWidth(stringArray[i]), n2);
            }
            n3 = fontMetrics.getHeight() * Math.min(15, stringArray.length);
            Insets insets = textAlignArea.getInsets();
            n2 += insets.left + insets.right;
            n3 += insets.top + insets.bottom;
        }
        return new Dimension(n2, n3);
    }

    private Button getButton(int n) {
        return (Button)this.buttons.elementAt(n);
    }

    private Dimension getButtonsSize() {
        if (this.buttons == null || this.buttons.size() == 0) {
            return new Dimension(0, 0);
        }
        int n = 23;
        int n2 = 48;
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.getButton(i);
            Dimension dimension = this.getButton(i).preferredSize();
            n = Math.max(dimension.height, n);
            n2 = Math.max(dimension.width, n2);
        }
        return new Dimension(n2, n);
    }

    private Rectangle getPosition(Rectangle rectangle, Dimension dimension) {
        int n = Math.max(0, (rectangle.width - dimension.width) / 2);
        int n2 = Math.max(0, (rectangle.height - dimension.height) / 2);
        return new Rectangle(rectangle.x + n, rectangle.y + n2, rectangle.width - n * 2, rectangle.height - n2 * 2);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = this.insets();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getTextSize(dimension.width / 2);
        int n = dimension2.width;
        int n2 = dimension2.height;
        dimension2 = this.getIconSize();
        if (dimension2.width != 0) {
            dimension2.width += 5;
        }
        n += dimension2.width;
        n2 = Math.max(dimension2.height, n2);
        dimension2 = this.getButtonsSize();
        n = Math.max(n, (dimension2.width + 4) * this.buttons.size() + 4);
        n2 += dimension2.height + 6 + 10;
        if (n < dimension.width / 4) {
            n = dimension.width / 4;
        }
        Dimension dimension3 = new Dimension(n + insets.left + insets.right + 20, n2 + insets.top + insets.bottom + 20);
        return dimension3;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        Rectangle rectangle;
        Dimension dimension = container.size();
        Insets insets = this.insets();
        int n = insets.left + 10;
        int n2 = insets.top + 10;
        int n3 = dimension.width - (n + insets.right + 10);
        int n4 = dimension.height - (n2 + insets.bottom + 10);
        Dimension dimension2 = this.getIconSize();
        Dimension dimension3 = this.getTextSize(n3 - dimension2.width - 5);
        Dimension dimension4 = this.getButtonsSize();
        n4 -= dimension4.height + 6;
        n4 = Math.max(n4, Math.max(dimension2.height, dimension3.height));
        if (this.icon != null) {
            Dimension dimension5 = this.icon.preferredSize();
            rectangle = this.getPosition(new Rectangle(n, n2, dimension2.width, n4), dimension5);
            this.icon.move(rectangle.x, rectangle.y);
            this.icon.resize(rectangle.width, rectangle.height);
        }
        if (this.text != null) {
            int n5 = dimension2.width;
            if (dimension2.width > 0) {
                n5 += 5;
            }
            n5 = n3 - dimension3.width > 3 * n5 ? 0 : (n5 -= (n3 - dimension3.width - n5) / 2);
            rectangle = this.getPosition(new Rectangle(n + n5, n2, n3 - n5, n4), dimension3);
            this.text.move(rectangle.x, rectangle.y);
            this.text.resize(rectangle.width, rectangle.height);
        }
        int n6 = n4 + n2 + 3;
        int n7 = (n3 - (dimension4.width + 4) * this.buttons.size() - 4) / 2 + 4 + n;
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.getButton(i).move(n7, n6);
            this.getButton(i).resize(dimension4);
            n7 += dimension4.width + 4;
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
            return true;
        }
        return super.handleEvent(event);
    }

    public Button getPressedButton() {
        return this.pressedButton;
    }

    public void init() {
    }

    public boolean keyDown(Event event, int n) {
        if (event.target instanceof Button && n == 10) {
            Container container;
            Window window = null;
            for (container = this; container != null && !(container instanceof Window); container = container.getParent()) {
            }
            if (container == null) {
                return false;
            }
            window = (Window)container;
            container.action(event, null);
            return true;
        }
        return false;
    }
}

