/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt.image;

import java.io.IOException;
import org.zaval.awt.image.BMP_InputStream;

class BMP_Info_Header {
    public int HeaderSize;
    public int Width;
    public int Height;
    public short NumOfPlanes;
    public short BitsPerPixel;
    public int CompressionMethod;
    public int BitmapSize;
    public int HorizRes;
    public int VertRes;
    public int NumOfColors;
    public int SiginificantColors;
    public int readBytes = 0;

    public BMP_Info_Header(int n, int n2, int n3, int n4) {
        this.Width = n;
        this.Height = n2;
        this.BitsPerPixel = (short)n3;
        this.NumOfColors = n4;
    }

    public BMP_Info_Header(BMP_InputStream bMP_InputStream) throws IOException {
        this.HeaderSize = bMP_InputStream.readInt();
        this.Width = bMP_InputStream.readInt();
        this.Height = bMP_InputStream.readInt();
        this.NumOfPlanes = bMP_InputStream.readShort();
        if (this.NumOfPlanes != 1) {
            throw new IllegalArgumentException("NumOfPlanes not 1" + this.NumOfPlanes);
        }
        this.BitsPerPixel = bMP_InputStream.readShort();
        if (this.BitsPerPixel != 24 && this.BitsPerPixel != 16 && this.BitsPerPixel != 8 && this.BitsPerPixel != 4 && this.BitsPerPixel != 1) {
            throw new IllegalArgumentException("Illegal BitsPerPixel " + this.BitsPerPixel);
        }
        this.CompressionMethod = bMP_InputStream.readInt();
        if (this.CompressionMethod < 0 || this.CompressionMethod > 2) {
            throw new IllegalArgumentException("Illegal CompressionMethod " + this.CompressionMethod);
        }
        this.BitmapSize = bMP_InputStream.readInt();
        this.HorizRes = bMP_InputStream.readInt();
        this.VertRes = bMP_InputStream.readInt();
        this.NumOfColors = bMP_InputStream.readInt();
        this.SiginificantColors = bMP_InputStream.readInt();
        this.readBytes = 40;
    }
}

