/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt.image;

import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import org.zaval.awt.image.BMP_Header;
import org.zaval.awt.image.BMP_Info_Header;
import org.zaval.awt.image.BMP_InputStream;
import org.zaval.awt.image.BMP_Palette;

public class BmpFileDecoder {
    public static int BmpHints = 30;
    BMP_Header header;
    BMP_Info_Header info_header;
    BMP_Palette palette;
    public int[][] bmp_image;
    private BMP_InputStream is;

    public int[][] getMatrix() {
        return this.bmp_image;
    }

    public BmpFileDecoder(InputStream inputStream) throws IOException {
        this.init(inputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(InputStream inputStream) throws IOException {
        this.is = new BMP_InputStream(inputStream);
        this.header = new BMP_Header(this.is);
        this.info_header = new BMP_Info_Header(this.is);
        if (this.info_header.NumOfColors != 0) {
            this.palette = new BMP_Palette(this.info_header.NumOfColors, this.is, this.info_header.BitsPerPixel);
        } else {
            long l = this.header.readBytes + this.info_header.readBytes;
            this.info_header.NumOfColors = (int)((long)this.header.dataOffset - l) / 4;
            this.palette = new BMP_Palette(this.info_header.NumOfColors, this.is, this.info_header.BitsPerPixel);
        }
        this.bmp_image = new int[this.getHeight()][this.getWidth()];
        int n = this.getByteWidth();
        int n2 = n % 4;
        if (this.info_header.CompressionMethod != 0) {
            if (this.info_header.BitsPerPixel != 8 && this.info_header.BitsPerPixel != 4) throw new IllegalArgumentException("Can't uncompress " + this.info_header.BitsPerPixel + "bit files");
            this.readRLE(n, n2, this.is, 8 / this.info_header.CompressionMethod);
            return;
        } else {
            int[][] nArray = new int[this.getHeight()][n];
            this.readRegular(n, n2, nArray, this.is);
            int[] nArray2 = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
            if (this.info_header.BitsPerPixel == 8) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    for (int j = 0; j < n; ++j) {
                        this.bmp_image[i][j] = nArray[i][j];
                    }
                }
                return;
            } else if (this.info_header.BitsPerPixel == 4) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    for (int j = 0; j < n; ++j) {
                        this.bmp_image[i][j * 2] = this.MSN(nArray[i][j]);
                        this.bmp_image[i][j * 2 + 1] = this.LSN(nArray[i][j]);
                    }
                }
                return;
            } else if (this.info_header.BitsPerPixel == 1) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    for (int j = 0; j < n; ++j) {
                        for (int k = 0; k < 8; ++k) {
                            if (j * 8 + k >= this.getWidth()) continue;
                            this.bmp_image[i][j * 8 + k] = (nArray[i][j] & nArray2[k]) == nArray2[k] ? 1 : 0;
                        }
                    }
                }
                return;
            } else if (this.info_header.BitsPerPixel == 24) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    for (int j = 0; j < this.getWidth(); ++j) {
                        this.bmp_image[i][j] = -16777216 + (nArray[i][j * 3] << 16) + (nArray[i][j * 3 + 1] << 8) + nArray[i][j * 3 + 2];
                    }
                }
                return;
            } else {
                if (this.info_header.BitsPerPixel != 16) throw new IllegalArgumentException("Illegal BitsPerPixel " + this.info_header.BitsPerPixel);
                for (int i = 0; i < this.getHeight(); ++i) {
                    for (int j = 0; j < this.getWidth(); ++j) {
                        int n3 = nArray[i][j * 2] + (nArray[i][j * 2 + 1] << 8);
                        int n4 = ((n3 & 0x7C00) >> 10) * 255 / 31;
                        int n5 = ((n3 & 0x3E0) >> 5) * 255 / 31;
                        int n6 = (n3 & 0x1F) * 255 / 31;
                        this.bmp_image[i][j] = -16777216 + (n6 << 16) + (n5 << 8) + n4;
                    }
                }
            }
        }
    }

    protected void readRegular(int n, int n2, int[][] nArray, InputStream inputStream) throws IOException {
        for (int i = 0; i < this.getHeight(); ++i) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                nArray[i][n3] = inputStream.read();
            }
            if (n2 == 0) continue;
            for (n3 = 0; n3 < 4 - n2; ++n3) {
                inputStream.read();
            }
        }
    }

    public int getWidth() {
        return this.info_header.Width;
    }

    public int getHeight() {
        return this.info_header.Height;
    }

    public int getPixel(int n, int n2) {
        return this.bmp_image[this.getHeight() - n2 - 1][n];
    }

    public void setPixel(int n, int n2, int n3) {
        this.bmp_image[this.getHeight() - n2 - 1][n] = n3;
    }

    public ColorModel getColorModel() {
        return this.palette.getColorModel();
    }

    private int LSN(int n) {
        return n & 0xF;
    }

    private int MSN(int n) {
        return (n & 0xF0) >> 4;
    }

    private int getByteWidth() {
        int n = 0;
        if (this.info_header.BitsPerPixel == 8) {
            n = this.getWidth();
        } else if (this.info_header.BitsPerPixel == 4) {
            n = this.getWidth() / 2;
            if (n * 2 < this.getWidth()) {
                ++n;
            }
        } else if (this.info_header.BitsPerPixel == 1) {
            n = this.getWidth() / 8;
            if (n * 8 < this.getWidth()) {
                ++n;
            }
        } else if (this.info_header.BitsPerPixel == 24) {
            n = this.getWidth() * 3;
        } else if (this.info_header.BitsPerPixel == 16) {
            n = this.getWidth() * 2;
        } else {
            throw new IllegalArgumentException("Illegal BitsPerPixel " + this.info_header.BitsPerPixel);
        }
        return n;
    }

    protected void readRLE(int n, int n2, BMP_InputStream bMP_InputStream, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.header.FileSize; ++i) {
            int n6;
            int n7 = bMP_InputStream.read();
            int n8 = bMP_InputStream.read();
            i += 2;
            if (n7 == 0) {
                int n9;
                if (n8 == 0) {
                    n4 = 0;
                    ++n5;
                    continue;
                }
                if (n8 == 1) {
                    return;
                }
                if (n8 == 2) {
                    n6 = (char)bMP_InputStream.readShort();
                    i += 2;
                    n9 = (char)bMP_InputStream.readShort();
                    i += 2;
                    n4 += n6;
                    n5 += n9;
                    continue;
                }
                n6 = 0;
                n9 = bMP_InputStream.read();
                ++i;
                for (int j = 0; j < n8; ++j) {
                    if (n3 == 4) {
                        if (n6 == 0) {
                            this.bmp_image[n5][n4] = n9 >> 4 & 0xF;
                        } else {
                            this.bmp_image[n5][n4] = n9 & 0xF;
                            n9 = bMP_InputStream.read();
                            ++i;
                        }
                        n6 = n6 == 0 ? 1 : 0;
                    } else {
                        this.bmp_image[n5][n4] = n9;
                        n9 = bMP_InputStream.read();
                        ++i;
                    }
                    if (++n4 < this.getWidth()) continue;
                    n4 = 0;
                    ++n5;
                }
                if ((n8 & 1) != 1) continue;
                bMP_InputStream.read();
                ++i;
                continue;
            }
            for (n6 = 0; n6 < n7; ++n6) {
                this.bmp_image[n5][n4] = n3 == 4 ? ((n6 & 1) == 0 ? n8 >> 4 & 0xF : n8 & 0xF) : n8;
                if (++n4 < this.getWidth()) continue;
                n4 = 0;
                ++n5;
            }
        }
    }
}

