/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt.image;

import org.zaval.awt.image.ButtonImageFilter;

public class BoxButtonFilter
extends ButtonImageFilter {
    private int light;
    private int border;
    private int width;
    private int height;
    private boolean pressed;

    public void setup(int n, int n2, int n3, int n4, boolean bl) {
        this.light = n;
        this.border = n2;
        this.width = n3;
        this.height = n4;
        this.pressed = bl;
    }

    public Object clone() {
        BoxButtonFilter boxButtonFilter = new BoxButtonFilter();
        ((ButtonImageFilter)boxButtonFilter).setup(this.light, this.border, this.width, this.height, this.pressed);
        return boxButtonFilter;
    }

    public int filterRGB(int n, int n2, int n3) {
        boolean bl = this.light > 0;
        int n4 = 100;
        int n5 = Math.abs(this.light);
        int n6 = this.height - this.border;
        int n7 = this.width - this.border;
        if (n >= this.border && n2 >= this.border && n2 <= n6 && n <= n7) {
            if (this.pressed) {
                bl = false;
                n4 = n5 >> 1;
            } else {
                bl = true;
                n4 = n5 >> 1;
            }
        } else if (n < this.border && n2 < this.height - n) {
            bl = !this.pressed;
            n4 = n5;
        } else if (n2 < this.border && n < this.width - n2) {
            bl = !this.pressed;
            n4 = n5;
        } else if (n >= n7 || n2 >= n6) {
            bl = this.pressed;
            n4 = n5;
        }
        return this.filterRGB(n3, bl, n4);
    }

    public int filterRGB(int n, boolean bl, int n2) {
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n >> 0 & 0xFF;
        int n6 = 100 - n2;
        if (bl) {
            n3 = 255 - (255 - n3) * n6 / 100;
            n4 = 255 - (255 - n4) * n6 / 100;
            n5 = 255 - (255 - n5) * n6 / 100;
        } else {
            n3 = n3 * n6 / 100;
            n4 = n4 * n6 / 100;
            n5 = n5 * n6 / 100;
        }
        return n3 << 16 | n4 << 8 | n5 << 0 | 0xFF000000;
    }
}

