/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.awt.peer;

import java.awt.Image;
import java.util.Hashtable;
import org.zaval.awt.ImageResolver;

public class TreeNode {
    public ImageResolver imgres = null;
    public TreeNode sibling;
    public TreeNode child;
    public TreeNode parent;
    public String text;
    public String nameCollImage = null;
    public String nameExpImage = null;
    public Image collapsedImage = null;
    public Image expandedImage = null;
    public int depth = -1;
    public boolean isExpanded = false;
    public int numberOfChildren;
    public int contextMenu = -1;
    public Hashtable property = new Hashtable();
    public boolean hidden = false;
    public String caption;
    public Image indicator;

    public void setResolver(ImageResolver imageResolver) {
        this.imgres = imageResolver;
    }

    public TreeNode(String string) {
        this(string, null, null);
    }

    public TreeNode(String string, String string2, String string3) {
        this.text = string;
        this.sibling = null;
        this.child = null;
        this.nameCollImage = string2;
        this.nameExpImage = string3;
        if (string2 != null && this.imgres != null) {
            this.collapsedImage = this.imgres.getImage(string2);
        }
        if (string3 != null && this.imgres != null) {
            this.expandedImage = this.imgres.getImage(string2);
        }
        this.numberOfChildren = 0;
        this.caption = null;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isExpanded() {
        return !this.hidden && this.isExpanded;
    }

    public boolean isExpandable() {
        return !this.hidden && this.child != null;
    }

    public void expand() {
        if (this.isExpandable()) {
            this.isExpanded = true;
        }
    }

    public void collapse() {
        this.isExpanded = false;
    }

    public void toggle() {
        if (this.isExpanded) {
            this.collapse();
        } else if (this.isExpandable()) {
            this.expand();
        }
    }

    public Image getImage() {
        return this.isExpanded && this.expandedImage != null ? this.expandedImage : this.collapsedImage;
    }

    public Image getExpandedImage() {
        this.loadImages();
        return this.expandedImage != null ? this.expandedImage : this.collapsedImage;
    }

    public Image getCollapsedImage() {
        this.loadImages();
        return this.collapsedImage;
    }

    public String getNameImage() {
        if (this.getImage() != null) {
            return this.isExpanded && this.expandedImage != null ? this.nameExpImage : this.nameCollImage;
        }
        return null;
    }

    private void loadImages() {
        if (this.imgres == null) {
            return;
        }
        if (this.nameCollImage != null && this.collapsedImage == null) {
            this.collapsedImage = this.imgres.getImage(this.nameCollImage);
        }
        if (this.nameExpImage != null && this.expandedImage == null) {
            this.expandedImage = this.imgres.getImage(this.nameExpImage);
        }
    }

    public void setExpandedImage(String string) {
        this.nameCollImage = string;
        if (string != null && this.imgres != null) {
            this.collapsedImage = this.imgres.getImage(this.nameCollImage);
        }
    }

    public void setCollapsedImage(String string) {
        this.nameExpImage = string;
        if (string != null && this.imgres != null) {
            this.expandedImage = this.imgres.getImage(this.nameExpImage);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setContextMenu(int n) {
        this.contextMenu = n;
    }

    public int getContextMenu() {
        return this.contextMenu;
    }

    public Object getProperty(String string) {
        return this.property.get(string);
    }

    public String getStringProperty(String string) {
        return (String)this.getProperty(string);
    }

    public int getIntProperty(String string) {
        return Integer.parseInt((String)this.getProperty(string));
    }

    public void setProperty(String string, Object object) {
        this.property.put(string, object);
    }

    public void setStringProperty(String string, String string2) {
        this.setProperty(string, string2);
    }

    public void setIntProperty(String string, int n) {
        this.setProperty(string, "" + n);
    }

    public int getNumberOfChildren() {
        return this.numberOfChildren;
    }

    public void setHide(boolean bl) {
        this.hidden = bl;
    }

    public boolean getHide() {
        return this.hidden;
    }

    public String getCaption() {
        return this.caption == null ? this.text : this.caption;
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    public void setCollapsedImage(Image image) {
        this.collapsedImage = image;
    }

    public void setExpandedImage(Image image) {
        this.expandedImage = image;
    }

    public void setIndicator(String string) {
        this.indicator = string == null || this.imgres == null ? null : this.imgres.getImage(string);
    }

    public Image getIndicator() {
        return this.indicator;
    }
}

