/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

public class IniFile {
    private Vector keys = new Vector();
    private Vector vals = new Vector();
    private boolean dirty = false;
    private File file = null;

    public IniFile(String string) throws IOException {
        this.file = new File(string);
        if (this.file.canRead()) {
            this.loadFile();
        }
    }

    private void saveFile() throws IOException {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        PrintStream printStream = new PrintStream(new FileOutputStream(this.file));
        for (int i = 0; i < this.keys.size(); ++i) {
            printStream.print(this.keys.elementAt(i));
            printStream.print("=");
            printStream.println(this.vals.elementAt(i));
        }
        printStream.close();
    }

    public void removeKey(String string) throws IOException {
        int n = this.keys.indexOf(string);
        if (n < 0) {
            return;
        }
        this.keys.removeElementAt(n);
        this.vals.removeElementAt(n);
        this.dirty = true;
        this.saveFile();
    }

    private void loadFile() throws IOException {
        int n = 32;
        String string = null;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.file));
        while ((string = dataInputStream.readLine()) != null) {
            int n2;
            int n3 = string.length();
            if (n3 <= 0) continue;
            for (n2 = 0; n2 < n3 && ((n = (int)string.charAt(n2)) == 9 || n == 32); ++n2) {
            }
            if (n == 35 || n == 10 || n == 13) continue;
            int n4 = n2;
            while (n2 < n3 && (n = (int)string.charAt(n2)) != 9 && n != 32 && n != 10 && n != 13 && n != 61 && n != 35) {
                ++n2;
            }
            if (n2 != n4) {
                this.keys.addElement(string.substring(n4, n2));
            }
            while (n2 < n3 && (n = (int)string.charAt(n2)) != 61 && n != 10 && n != 13 && n != 35) {
                ++n2;
            }
            if (n == 10 || n == 13 || n == 35) {
                this.vals.addElement("");
                continue;
            }
            ++n2;
            while (n2 < n3 && ((n = (int)string.charAt(n2)) == 32 || n == 9)) {
                ++n2;
            }
            if (n == 10 || n == 13 || n == 35) {
                this.vals.addElement("");
                continue;
            }
            n4 = n2;
            while (n2 < n3 && (n = (int)string.charAt(n2)) != 10 && n != 13 && n != 35) {
                ++n2;
            }
            this.vals.addElement(n2 != n4 ? string.substring(n4, n2).trim() : "");
        }
        dataInputStream.close();
        dataInputStream = null;
    }

    public synchronized String getString(String string) throws IOException {
        int n = this.keys.indexOf(string);
        if (n < 0) {
            return "UNDEFINED";
        }
        return (String)this.vals.elementAt(n);
    }

    public int getInt(String string) throws IOException {
        return Integer.parseInt(this.getString(string));
    }

    public boolean getBoolean(String string) throws IOException {
        return this.getString(string).compareTo("True") == 0;
    }

    public synchronized void putString(String string, String string2) throws IOException {
        int n = this.keys.indexOf(string);
        if (n < 0) {
            this.keys.addElement(string);
            this.vals.addElement(string2);
        } else {
            this.vals.setElementAt(string2, n);
        }
        this.dirty = true;
        this.saveFile();
    }

    public void putInt(String string, int n) throws IOException {
        this.putString(string, Integer.toString(n));
    }

    public void putBoolean(String string, boolean bl) throws IOException {
        this.putString(string, bl ? "True" : "False");
    }

    public synchronized void close() throws IOException {
        this.saveFile();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[IniFile = " + this.file.toString() + "]={");
        for (int i = 0; i < this.keys.size(); ++i) {
            stringBuffer.append("\n\t" + this.keys.elementAt(i) + "=" + this.vals.elementAt(i));
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getValue(String string, String string2) {
        String string3;
        IniFile iniFile;
        block10: {
            iniFile = null;
            string2 = string2.trim();
            iniFile = new IniFile(string);
            string3 = iniFile.getString(string2);
            if (string3 != null && string3.length() != 0 && !string3.equals("UNDEFINED")) break block10;
            String string4 = null;
            Object var6_8 = null;
            try {
                iniFile.close();
            }
            catch (IOException iOException) {
                System.out.println("Loader start():" + iOException);
            }
            return string4;
        }
        String string5 = string3;
        Object var6_9 = null;
        try {
            iniFile.close();
        }
        catch (IOException iOException) {
            System.out.println("Loader start():" + iOException);
        }
        return string5;
        catch (IOException iOException) {
            String string6;
            try {
                System.out.println("Loader getValue():" + iOException);
                string6 = null;
                Object var6_10 = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                try {
                    iniFile.close();
                }
                catch (IOException iOException2) {
                    System.out.println("Loader start():" + iOException2);
                }
                throw throwable;
            }
            try {
                iniFile.close();
            }
            catch (IOException iOException3) {
                System.out.println("Loader start():" + iOException3);
            }
            return string6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int setValue(String string, String string2, String string3) {
        block9: {
            IniFile iniFile = null;
            string2 = string2.trim();
            string3 = string3.trim();
            iniFile = new IniFile(string);
            iniFile.putString(string2, string3);
            Object var7_4 = null;
            try {
                iniFile.close();
            }
            catch (IOException iOException) {
                System.out.println("Loader start():" + iOException);
            }
            break block9;
            {
                catch (IOException iOException) {
                    System.out.println("Loader setValue():" + iOException);
                    int n = -1;
                    Object var7_5 = null;
                    try {
                        iniFile.close();
                    }
                    catch (IOException iOException2) {
                        System.out.println("Loader start():" + iOException2);
                    }
                    return n;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    iniFile.close();
                }
                catch (IOException iOException) {
                    System.out.println("Loader start():" + iOException);
                }
                throw throwable;
            }
        }
        return 0;
    }
}

