/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.io;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class InputIniFile {
    private Hashtable hash;
    private DataInputStream in;
    private String name;
    private String postponed = null;

    public Hashtable getTable() {
        return this.hash;
    }

    public InputIniFile(String string) throws IOException {
        this.name = string;
        this.in = new DataInputStream(new FileInputStream(string));
        this.hash = new Hashtable();
        this.load();
    }

    public InputIniFile(InputStream inputStream) throws IOException {
        this.name = inputStream.toString();
        this.in = new DataInputStream(inputStream);
        this.hash = new Hashtable();
        this.load();
    }

    public synchronized String getString(String string) throws IOException {
        return (String)this.hash.get(string);
    }

    public int getInt(String string) throws IOException {
        try {
            return Integer.parseInt(this.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean getBoolean(String string) throws IOException {
        String string2 = this.getString(string);
        if ("True".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("On".equalsIgnoreCase(string2)) {
            return true;
        }
        return "1".equals(string2);
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
    }

    private String readLine(DataInputStream dataInputStream) throws IOException {
        int n;
        String string;
        String string2 = this.postponed == null ? dataInputStream.readLine() : this.postponed;
        this.postponed = null;
        if (string2 == null) {
            return string2;
        }
        string2 = string2.trim();
        while (string2.endsWith("\\") && (string = dataInputStream.readLine()) != null) {
            if (!string.startsWith(" ")) {
                this.postponed = string;
                break;
            }
            int n2 = string.indexOf(35);
            if (n2 > 0) {
                string = string.endsWith("\\") ? string.substring(0, n2) + " \\" : string.substring(0, n2);
            }
            string2 = string2.substring(0, string2.length() - 1) + string.trim();
        }
        if ((n = string2.indexOf(35)) == 0) {
            return "";
        }
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private void load() throws IOException {
        String string = null;
        while ((string = this.readLine(this.in)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=", true);
            if (stringTokenizer.countTokens() < 3) continue;
            String string2 = stringTokenizer.nextToken().trim();
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken("").trim();
            this.hash.put(string2, string3);
        }
    }
}

