/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.io;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class WinIniFile {
    public static final int MAX_LEN_LINE = 256;
    public static final int CREATE = 1;
    public static final int OPEN_EXISTS = 2;
    public static final String NO_VALUE = "NOVALUE";
    private Hashtable sections = null;
    private String name = null;
    private InputStream isdata = null;
    private char[] buf = new char[256];
    private String begSecSymb = "[";
    private String endSecSymb = "]";
    private int openFlag = 2;

    public WinIniFile(String string, int n) throws IOException {
        this.name = string;
        this.openFlag = n;
        switch (n) {
            case 1: {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                fileOutputStream.close();
                this.sections = new Hashtable();
                break;
            }
            case 2: {
                this.init(new FileInputStream(string));
            }
        }
    }

    public WinIniFile(String string) throws IOException {
        this.name = string;
        this.init(new FileInputStream(string));
    }

    public WinIniFile(InputStream inputStream) throws IOException {
        this.init(inputStream);
    }

    public void init(InputStream inputStream) throws IOException {
        String string = new String();
        Hashtable<String, String> hashtable = null;
        this.sections = new Hashtable();
        this.isdata = inputStream;
        DataInputStream dataInputStream = new DataInputStream(this.isdata);
        while ((string = this.readLine(inputStream)) != null) {
            StringTokenizer stringTokenizer;
            if (this.isEmpty(string) || string.indexOf(";") == 0) continue;
            if (string.equals("EOF")) break;
            int n = string.indexOf(this.begSecSymb);
            if (n == 0) {
                int n2 = string.indexOf(this.endSecSymb);
                if (n2 != string.length() - 1) continue;
                hashtable = new Hashtable<String, String>();
                this.sections.put(string.substring(n + 1, n2).toLowerCase(), hashtable);
                continue;
            }
            if (hashtable == null || !(stringTokenizer = new StringTokenizer(string, "=")).hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken().toLowerCase();
            String string3 = null;
            if (!stringTokenizer.hasMoreTokens()) {
                string3 = NO_VALUE;
            }
            string3 = stringTokenizer.nextToken();
            if (this.isEmpty(string2) || this.isEmpty(string3)) continue;
            hashtable.put(string2, string3);
        }
        dataInputStream.close();
        dataInputStream = null;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int n = -1;
        int n2 = 0;
        while ((n = inputStream.read()) > 0 && n != 10 && n2 < this.buf.length) {
            this.buf[n2++] = (char)n;
        }
        if (n2 == 0) {
            return null;
        }
        return new String(this.buf, 0, n2).trim();
    }

    private void writeLine(RandomAccessFile randomAccessFile, String string) throws IOException {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, string.length(), byArray, 0);
        randomAccessFile.write(byArray);
        randomAccessFile.write(13);
        randomAccessFile.write(10);
    }

    public String getValue(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.sections.get(string.toLowerCase());
        if (hashtable == null) {
            return null;
        }
        return (String)hashtable.get(string2.toLowerCase());
    }

    public String getValue(String string) {
        Hashtable hashtable = this.foundSection(string.toLowerCase());
        if (hashtable == null) {
            return null;
        }
        return (String)hashtable.get(string.toLowerCase());
    }

    public Hashtable getSection(String string) {
        return (Hashtable)this.sections.get(string.toLowerCase());
    }

    public Hashtable foundSection(String string) {
        Enumeration enumeration = this.sections.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            String string2 = (String)hashtable.get(string.toLowerCase());
            if (string2 == null) continue;
            return hashtable;
        }
        return null;
    }

    public int size(String string) {
        Hashtable hashtable = this.getSection(string);
        if (hashtable == null) {
            return -1;
        }
        return hashtable.size();
    }

    public int size() {
        Enumeration enumeration = this.sections.elements();
        int n = 0;
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return -1;
        }
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            n += hashtable.size();
        }
        return n;
    }

    public int sizeNumber(String string) {
        int n = 0;
        Hashtable hashtable = (Hashtable)this.sections.get(string.toLowerCase());
        if (hashtable == null) {
            return -1;
        }
        String string2 = "";
        n = 0;
        while (string2 != null) {
            string2 = (String)hashtable.get("" + n);
            ++n;
        }
        return n - 1;
    }

    public int putValue(String string, String string2, String string3) {
        Hashtable hashtable = this.getSection(string.toLowerCase());
        if (hashtable == null) {
            return -1;
        }
        hashtable.put(string2.toLowerCase(), string3);
        return 0;
    }

    public int putValue(String string, String string2) {
        Hashtable hashtable = this.foundSection(string.toLowerCase());
        if (hashtable == null) {
            return -1;
        }
        hashtable.put(string.toLowerCase(), string2);
        return 0;
    }

    public int delSection(String string) {
        if (this.sections == null) {
            return -1;
        }
        this.sections.remove(string.toLowerCase());
        return 0;
    }

    public int delValue(String string, String string2) {
        Hashtable hashtable = this.getSection(string.toLowerCase());
        if (hashtable == null) {
            return -1;
        }
        hashtable.remove(string2.toLowerCase());
        return 0;
    }

    public int putSection(String string) {
        if (this.sections == null || this.sections.get(string.toLowerCase()) != null) {
            return -1;
        }
        this.sections.put(string.toLowerCase(), new Hashtable());
        return 0;
    }

    public int flush(String string) throws IOException {
        Hashtable hashtable;
        if (this.sections == null) {
            return -1;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        Enumeration enumeration = this.sections.elements();
        Enumeration enumeration2 = this.sections.keys();
        while (enumeration.hasMoreElements() && (hashtable = (Hashtable)enumeration.nextElement()) != null) {
            Enumeration enumeration3 = hashtable.keys();
            Enumeration enumeration4 = hashtable.elements();
            this.writeLine(randomAccessFile, this.begSecSymb + (String)enumeration2.nextElement() + this.endSecSymb);
            while (enumeration3.hasMoreElements()) {
                String string2 = (String)enumeration3.nextElement();
                String string3 = (String)enumeration4.nextElement();
                if (string3.equals(NO_VALUE)) {
                    this.writeLine(randomAccessFile, string2);
                    continue;
                }
                this.writeLine(randomAccessFile, string2 + "=" + string3);
            }
        }
        randomAccessFile.close();
        return 0;
    }

    public int flush() throws IOException {
        if (this.name == null) {
            return -1;
        }
        return this.flush(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setSectionSymbols(String string, String string2) {
        this.begSecSymb = string;
        this.endSecSymb = string2;
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0 || string.trim().length() == 0;
    }
}

