/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.tools.i18n.translator;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.Vector;
import org.zaval.tools.i18n.translator.BundleItem;
import org.zaval.tools.i18n.translator.BundleSet;
import org.zaval.tools.i18n.translator.LangItem;
import org.zaval.tools.i18n.translator.TranslatorConstants;

class BundleManager
implements TranslatorConstants {
    private BundleSet set = new BundleSet();

    BundleManager() {
    }

    void appendResource(InputStream inputStream, String string) throws IOException {
        this.readResource(inputStream, string);
    }

    BundleManager(String string) throws IOException {
        this.readResources(string);
    }

    BundleSet getBundle() {
        return this.set;
    }

    String dirName(String string) {
        int n = (string = this.replace(string, "\\", "/")).lastIndexOf(47);
        return n >= 0 ? string.substring(0, n + 1) : "./";
    }

    String baseName(String string) {
        int n = (string = this.replace(string, "\\", "/")).lastIndexOf(47);
        string = n >= 0 ? string.substring(n + 1) : string;
        n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(0, n) : string;
    }

    private String extName(String string) {
        int n = (string = this.replace(string, "\\", "/")).lastIndexOf(46);
        return n >= 0 ? string.substring(n) : "";
    }

    private String purifyFileName(String string) {
        int n;
        int n2 = (string = this.baseName(string)).lastIndexOf(95);
        int n3 = n = n2 > 0 ? string.lastIndexOf(95, n2 - 1) : -1;
        if (n < 0 && n2 > 0) {
            n = n2;
        }
        return n >= 0 ? string.substring(0, n) : string;
    }

    private Vector getResFiles(String string, String string2, String string3) {
        File file = new File(string);
        String string4 = this.purifyFileName(string2);
        String[] stringArray = file.list();
        if (stringArray.length == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2;
            String string5;
            if (!stringArray[i].startsWith(string4) || !(string5 = this.purifyFileName(stringArray[i])).equals(string4) || !this.extName(stringArray[i]).equals(string3) || (file2 = new File(string + stringArray[i])).isDirectory()) continue;
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    String determineLanguage(String string) {
        int n;
        int n2 = (string = this.baseName(string)).lastIndexOf(95);
        int n3 = n = n2 > 0 ? string.lastIndexOf(95, n2 - 1) : -1;
        if (n < 0 && n2 > 0) {
            n = n2;
        }
        return n >= 0 ? string.substring(n + 1) : "en";
    }

    private void readResources(String string) throws IOException {
        String string2 = this.dirName(string);
        String string3 = this.extName(string);
        string = this.baseName(string);
        Vector vector = this.getResFiles(string2, string, string3);
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = (String)vector.elementAt(i);
            this.readResource(string2 + string4, this.determineLanguage(string4));
        }
    }

    private void readResource(String string, String string2) throws IOException {
        Vector vector = this.getLines(string);
        this.proceedLines(vector, string2, string);
    }

    private void readResource(InputStream inputStream, String string) throws IOException {
        Vector vector = this.getLines(inputStream);
        this.proceedLines(vector, string, null);
    }

    private void proceedLines(Vector vector, String string, String string2) {
        String string3 = null;
        string2 = string2 != null ? string2 : "tmp_" + string;
        this.set.addLanguage(string);
        this.set.getLanguage(string).setLangFile(string2);
        for (int i = 0; i < vector.size(); ++i) {
            BundleItem bundleItem;
            String string4 = (String)vector.elementAt(i);
            if ((string4 = string4.trim()).length() == 0) continue;
            if (string4.startsWith("#")) {
                string3 = string4.substring(1);
                continue;
            }
            int n = string4.indexOf(35);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "=", true);
            if (stringTokenizer.countTokens() < 2) continue;
            String string5 = stringTokenizer.nextToken().trim();
            stringTokenizer.nextToken();
            String string6 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken("");
            }
            if ((bundleItem = this.set.getItem(string5)) == null) {
                bundleItem = this.set.addKey(string5);
            }
            bundleItem.setTranslation(string, string6);
            bundleItem.setComment(string3);
            string3 = null;
        }
        this.set.resort();
    }

    void setComment(String string, String string2) {
        BundleItem bundleItem = this.set.getItem(string);
        if (bundleItem == null) {
            return;
        }
        bundleItem.setComment(string2);
    }

    private Vector getLines(String string) throws IOException {
        Vector<String> vector = new Vector<String>();
        if (string.endsWith(".properties")) {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            String string2 = null;
            while ((string2 = dataInputStream.readLine()) != null) {
                String string3;
                while ((string2 = string2.trim()).endsWith("\\") && (string3 = dataInputStream.readLine()) != null) {
                    string2 = string2.substring(0, string2.length() - 1) + string3;
                }
                vector.addElement(BundleManager.fromEscape(string2));
            }
            dataInputStream.close();
        } else {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            int n2 = 256;
            while (randomAccessFile.length() - randomAccessFile.getFilePointer() != 0L) {
                int n3 = randomAccessFile.readUnsignedByte() * n + randomAccessFile.readUnsignedByte() * n2;
                if (n3 == 65534) {
                    n = 256;
                    n2 = 1;
                }
                if (n3 == 13 || n3 == 65534 || n3 == 65279 || n3 == 65535) continue;
                if (n3 != 10) {
                    stringBuffer.append((char)n3);
                    continue;
                }
                vector.addElement(BundleManager.fromEscape(stringBuffer.toString()));
                stringBuffer.setLength(0);
            }
            randomAccessFile.close();
        }
        return vector;
    }

    private Vector getLines(InputStream inputStream) throws IOException {
        Vector<String> vector = new Vector<String>();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = null;
        while ((string = dataInputStream.readLine()) != null) {
            String string2;
            while ((string = string.trim()).endsWith("\\") && (string2 = dataInputStream.readLine()) != null) {
                string = string.substring(0, string.length() - 1) + string2;
            }
            vector.addElement(BundleManager.fromEscape(string));
        }
        dataInputStream.close();
        return vector;
    }

    private static String toEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = c = string.charAt(i);
            if (c == '\r') continue;
            if (c2 >= '\u0000' && c2 < '\u0080' && c != '\n' && c != '\\') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("\\u");
            String string2 = Integer.toHexString(c2);
            for (int j = 0; j < 4 - string2.length(); ++j) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String fromEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i + 1 >= string.length()) {
                stringBuffer.append(c);
                break;
            }
            if (c != '\\') {
                stringBuffer.append(c);
                continue;
            }
            switch (string.charAt(i + 1)) {
                case 'u': {
                    stringBuffer.append((char)Integer.parseInt(string.substring(i + 2, i + 6), 16));
                    i += 5;
                    continue block6;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    ++i;
                    continue block6;
                }
                case 't': {
                    stringBuffer.append('\t');
                    ++i;
                    continue block6;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    ++i;
                    continue block6;
                }
            }
        }
        return stringBuffer.toString();
    }

    String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = -1;
        int n2 = 0;
        while ((n = string.indexOf(string2, n + 1)) != -1) {
            if (n2 < n) {
                String string4 = string.substring(n2, n);
                stringBuffer.append(string4);
            }
            stringBuffer.append(string3);
            n2 = n + string2.length();
            n += string2.length() - 1;
        }
        if (n2 == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    void store(String string) throws IOException {
        int n = this.set.getLangCount();
        for (int i = 0; i < n; ++i) {
            LangItem langItem = this.set.getLanguage(i);
            this.store(langItem.getLangId(), string);
        }
    }

    void store(String string, String object) throws IOException {
        Object object2;
        LangItem langItem = this.set.getLanguage(string);
        if (object == null) {
            object = langItem.getLangFile();
        } else {
            object2 = object;
            object2 = this.dirName((String)object2) + this.purifyFileName((String)object2);
            if (this.set.getLanguage(0) != langItem) {
                object2 = (String)object2 + "_" + langItem.getLangId();
            }
            object = object2 = (String)object2 + ".properties";
            langItem.setLangFile((String)object);
        }
        if (object == null) {
            this.store(string, "autosaved.properties");
            return;
        }
        object2 = this.set.store(langItem.getLangId());
        if (((String)object).endsWith(".properties")) {
            PrintStream printStream = new PrintStream(new FileOutputStream((String)object));
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                printStream.print(BundleManager.toEscape((String)((Vector)object2).elementAt(i)) + System.getProperty("line.separator"));
            }
            printStream.close();
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream((String)object);
            fileOutputStream.write(255);
            fileOutputStream.write(254);
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                String string2 = (String)((Vector)object2).elementAt(i);
                string2 = this.replace(string2, "\n", BundleManager.toEscape("\n"));
                for (int j = 0; j < string2.length(); ++j) {
                    char c = string2.charAt(j);
                    fileOutputStream.write(c & 0xFF);
                    fileOutputStream.write(c >> 8);
                }
                fileOutputStream.write(13);
                fileOutputStream.write(0);
                fileOutputStream.write(10);
                fileOutputStream.write(0);
            }
            fileOutputStream.close();
        }
    }
}

