/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.tools.i18n.translator;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.zaval.tools.i18n.translator.BundleItem;
import org.zaval.tools.i18n.translator.LangItem;
import org.zaval.tools.i18n.translator.TranslatorConstants;

class BundleSet
implements TranslatorConstants {
    private Vector items = new Vector();
    private Vector lng = new Vector();
    private Hashtable nameCache = new Hashtable();

    BundleSet() {
    }

    void addLanguage(String string, String string2) {
        if (this.getLanguage(string) != null) {
            return;
        }
        LangItem langItem = new LangItem(string, string2);
        this.lng.addElement(langItem);
        this.correctFileName(langItem);
    }

    int getLangCount() {
        return this.lng.size();
    }

    LangItem getLanguage(int n) {
        return (LangItem)this.lng.elementAt(n);
    }

    LangItem getLanguage(String string) {
        int n = this.getLangIndex(string);
        return n < 0 ? null : this.getLanguage(n);
    }

    int getLangIndex(String string) {
        int n = this.getLangCount();
        for (int i = 0; i < n; ++i) {
            LangItem langItem = this.getLanguage(i);
            if (!langItem.getLangId().equals(string)) continue;
            return i;
        }
        return -1;
    }

    LangItem[] getLanguageByDescription(String string) {
        LangItem[] langItemArray;
        int n;
        int n2 = this.getLangCount();
        Vector<LangItem[]> vector = new Vector<LangItem[]>();
        for (n = 0; n < n2; ++n) {
            langItemArray = this.getLanguage(n);
            if (!langItemArray.getLangDescription().equals(string)) continue;
            vector.addElement(langItemArray);
        }
        if (vector.size() == 0) {
            return null;
        }
        n2 = vector.size();
        langItemArray = new LangItem[n2];
        for (n = 0; n < n2; ++n) {
            langItemArray[n] = (LangItem)vector.elementAt(n);
        }
        return langItemArray;
    }

    int getItemCount() {
        return this.items.size();
    }

    BundleItem getItem(int n) {
        return (BundleItem)this.items.elementAt(n);
    }

    BundleItem getItem(String string) {
        return (BundleItem)this.nameCache.get(string);
    }

    int getItemIndex(String string) {
        int n = this.getItemCount();
        for (int i = n - 1; i >= 0; --i) {
            BundleItem bundleItem = this.getItem(i);
            if (!bundleItem.getId().equals(string)) continue;
            return i;
        }
        return -1;
    }

    BundleItem addKey(String string) {
        int n = this.getItemCount();
        BundleItem bundleItem = this.getItem(string);
        if (bundleItem == null) {
            bundleItem = new BundleItem(string);
            this.items.addElement(bundleItem);
            this.nameCache.put(string, bundleItem);
        }
        return bundleItem;
    }

    void removeKey(String string) {
        int n = this.getItemIndex(string);
        if (n >= 0) {
            this.items.removeElementAt(n);
        }
        this.nameCache.remove(string);
    }

    Enumeration getKeysBeginningWith(String string) {
        Vector<BundleItem> vector = new Vector<BundleItem>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            BundleItem bundleItem = this.getItem(i);
            if (!bundleItem.getId().startsWith(string)) continue;
            vector.addElement(bundleItem);
        }
        return vector.elements();
    }

    void removeKeysBeginningWith(String string) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            BundleItem bundleItem = this.getItem(i);
            if (!bundleItem.getId().startsWith(string)) continue;
            this.removeKey(bundleItem.getId());
            --i;
        }
    }

    void updateValue(String string, String string2, String string3) {
        BundleItem bundleItem = this.getItem(string);
        if (bundleItem != null) {
            bundleItem.setTranslation(string2, string3);
        }
    }

    private Locale parseLanguage(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(95);
        String string2 = string;
        String string3 = "";
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        return new Locale(string2, string3);
    }

    void addLanguage(String string) {
        Locale locale = this.parseLanguage(string);
        if (locale != null) {
            String string2 = locale.getDisplayLanguage();
            String string3 = locale.getDisplayCountry();
            if (string3 != null && string3.length() > 0) {
                string2 = string2 + " (" + string3 + ")";
            }
            this.addLanguage(string, string2);
        }
    }

    private String makeLine(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string.length() + string2.length() + 2;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        stringBuffer.append('=');
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    Vector store(String string) {
        LangItem langItem = this.getLanguage(string);
        Vector<String> vector = new Vector<String>();
        vector.addElement("# Java Resource Bundle");
        vector.addElement("# Modified by Zaval JRC Editor (C) Zaval CE Group");
        vector.addElement("# http://www.zaval.org/products/jrc-editor/");
        vector.addElement("#");
        vector.addElement("");
        for (int i = 0; i < this.getItemCount(); ++i) {
            BundleItem bundleItem = this.getItem(i);
            if (bundleItem.getComment() != null) {
                vector.addElement("#" + bundleItem.getComment());
            }
            if (bundleItem.getTranslation(string) == null) continue;
            vector.addElement(this.makeLine(bundleItem.getId(), bundleItem.getTranslation(string)));
        }
        return vector;
    }

    private void correctFileName(LangItem langItem) {
        if (this.getLangCount() < 1) {
            return;
        }
        LangItem langItem2 = this.getLanguage(0);
        if (langItem2 == langItem) {
            return;
        }
        if (langItem.getLangFile() != null) {
            return;
        }
        if (langItem2.getLangFile() == null) {
            return;
        }
        String string = langItem2.getLangFile();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return;
        }
        string = string.substring(0, n) + "_" + langItem.getLangId() + string.substring(n);
        langItem.setLangFile(string);
    }

    public void resort() {
        Collections.sort(this.items, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((BundleItem)object).getId().compareTo(((BundleItem)object2).getId());
            }

            public boolean equals(Object object) {
                return this == object;
            }
        });
    }
}

