/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.tools.i18n.translator;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.Toolkit;
import org.zaval.awt.ExGridLayout;
import org.zaval.awt.IELabel;
import org.zaval.tools.i18n.translator.LangItem;

public class LangDialog
extends Dialog {
    private List edit;
    private Button ok;
    private Button cancel;
    private boolean isApply;
    private Component listener;
    private IELabel label;

    public LangDialog(Frame frame, String string, boolean bl, Component component) {
        super(frame, string, bl);
        this.setLayout(new GridBagLayout());
        this.label = new IELabel("List of languages");
        LangDialog.constrain(this, this.label, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        this.edit = new List(10, true);
        LangDialog.constrain(this, this.edit, 0, 1, 4, 1, 2, 17, 1.0, 0.0, 5, 5, 5, 5);
        this.ok = new Button("Ok");
        this.cancel = new Button("Cancel");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 2, 0));
        panel.add(this.ok);
        panel.add(this.cancel);
        LangDialog.constrain(this, panel, 0, 2, 2, 1, 0, 13, 1.0, 0.0, 5, 5, 5, 5);
        this.listener = component;
        this.pack();
    }

    public void setList(LangItem[] langItemArray) {
        this.edit.clear();
        if (langItemArray == null) {
            return;
        }
        for (int i = 0; i < langItemArray.length; ++i) {
            String string = langItemArray[i].getLangId() + ": " + langItemArray[i].getLangDescription();
            this.edit.add(string);
        }
        this.edit.select(0);
    }

    public String[] getList() {
        this.edit.select(0);
        return this.edit.getSelectedItems();
    }

    public void setButtonsCaption(String string, String string2) {
        this.ok.setLabel(string);
        this.cancel.setLabel(string2);
    }

    public void setLabelCaption(String string) {
        this.label.setText(string);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201 || event.target == this.cancel && event.id == 1001) {
            this.isApply = false;
            this.dispose();
        }
        if (event.target == this.ok && event.id == 1001) {
            this.isApply = true;
            this.listener.postEvent(new Event(this, 1001, null));
            this.dispose();
        }
        return super.handleEvent(event);
    }

    public boolean isApply() {
        return this.isApply;
    }

    public void toCenter() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.move((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8, int n9, int n10) {
        LayoutManager layoutManager;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.anchor = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        if (n7 + n10 + n8 + n9 > 0) {
            gridBagConstraints.insets = new Insets(n7, n8, n10, n9);
        }
        if ((layoutManager = container.getLayout()) instanceof GridBagLayout) {
            GridBagLayout gridBagLayout = (GridBagLayout)layoutManager;
            gridBagLayout.setConstraints(component, gridBagConstraints);
        } else if (layoutManager instanceof ExGridLayout) {
            ExGridLayout exGridLayout = (ExGridLayout)layoutManager;
            exGridLayout.setConstraints(component, gridBagConstraints);
        }
        container.add(component);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4) {
        LangDialog.constrain(container, component, n, n2, n3, n4, 0, 18, 1.0, 1.0, 0, 0, 5, 3);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6) {
        LangDialog.constrain(container, component, n, n2, n3, n4, n5, n6, 1.0, 1.0, 0, 0, 5, 3);
    }

    public boolean keyDown(Event event, int n) {
        if (event.target == this.ok && n == 10 || event.target == this.edit && n == 10) {
            this.isApply = true;
            this.listener.postEvent(new Event(this, 1001, null));
            this.dispose();
            return true;
        }
        if (event.target == this.cancel && n == 10) {
            this.isApply = false;
            this.dispose();
            return true;
        }
        return false;
    }

    public Dimension preferredSize() {
        Dimension dimension = super.preferredSize();
        dimension.width *= 2;
        return dimension;
    }

    public boolean doModal() {
        this.pack();
        this.toCenter();
        this.show();
        return true;
    }
}

