/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.tools.i18n.translator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.zaval.tools.i18n.translator.BundleItem;
import org.zaval.tools.i18n.translator.BundleManager;
import org.zaval.tools.i18n.translator.BundleSet;
import org.zaval.tools.i18n.translator.JavaParser;
import org.zaval.tools.i18n.translator.SrcGenerator;
import org.zaval.tools.i18n.translator.UtfParser;
import org.zaval.tools.i18n.translator.XmlReader;
import org.zaval.util.SafeResourceBundle;

public class Split {
    private BundleManager bundle = new BundleManager();
    private SafeResourceBundle rcTable = null;

    private Split(String string) {
        try {
            this.readResources(string, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String RC(String string) {
        return this.rcTable.getString(string);
    }

    private void join(BundleManager bundleManager, boolean bl) {
        if (bl) {
            BundleSet bundleSet = bundleManager.getBundle();
            int n = bundleSet.getItemCount();
            for (int i = 0; i < n; ++i) {
                BundleItem bundleItem = bundleSet.getItem(i);
                this.bundle.getBundle().addKey(bundleItem.getId());
                Enumeration enumeration = bundleItem.getLanguages();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.bundle.getBundle().addLanguage(string);
                    this.bundle.getBundle().updateValue(bundleItem.getId(), string, bundleItem.getTranslation(string));
                }
            }
        } else {
            this.bundle = bundleManager;
        }
    }

    public void readResources(String string, boolean bl) throws Exception {
        try {
            BundleManager bundleManager = new BundleManager(string);
            this.join(bundleManager, bl);
        }
        catch (Exception exception) {
            this.infoException(string, exception);
            throw exception;
        }
    }

    public void onSaveAs(String string) {
        String string2 = string;
        if (string2 != null) {
            try {
                this.bundle.store(string2);
            }
            catch (Exception exception) {
                this.infoException(string, exception);
            }
        }
    }

    private void infoException(String string, Exception exception) {
        System.err.println(string + ":" + exception.getMessage());
    }

    private void onGenCode(String string) {
        try {
            String string2 = string;
            if (string2 != null) {
                SrcGenerator srcGenerator = new SrcGenerator(this.bundle.replace(string2, "\\", "/"));
                srcGenerator.perform(this.bundle.getBundle());
            }
        }
        catch (Exception exception) {
            this.infoException(string, exception);
        }
    }

    private void onParseCode(String string) throws Exception {
        String string2 = string;
        if (string != null) {
            string2 = this.bundle.replace(string2, "\\", "/");
            JavaParser javaParser = new JavaParser(new FileInputStream(string2));
            Hashtable hashtable = javaParser.parse();
            this.bundle.getBundle().addLanguage("en");
            String string3 = this.bundle.getBundle().getLanguage(0).getLangId();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                this.bundle.getBundle().addKey(string4);
                this.bundle.getBundle().updateValue(string4, string3, (String)hashtable.get(string4));
            }
        }
    }

    private String stretchPath(String string) {
        if (string.length() < 60) {
            return string;
        }
        return string.substring(0, 4) + "..." + string.substring(string.length() - Math.min(string.length() - 7, 53));
    }

    private String[] getLangSet(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";,");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public void onSaveXml(String string, String[] stringArray) {
        String string2 = string;
        if (string2 != null) {
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string2));
                BundleSet bundleSet = this.bundle.getBundle();
                int n = bundleSet.getItemCount();
                dataOutputStream.writeChar(65279);
                dataOutputStream.writeChars("<xml>\n");
                for (int i = 0; i < n; ++i) {
                    BundleItem bundleItem = bundleSet.getItem(i);
                    Enumeration enumeration = bundleItem.getLanguages();
                    dataOutputStream.writeChars("\t<key name=\"" + bundleItem.getId() + "\">\n");
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        if (!this.inArray(stringArray, string3)) continue;
                        dataOutputStream.writeChars("\t\t<value lang=\"" + string3 + "\">" + bundleItem.getTranslation(string3) + "</value>\n");
                    }
                    dataOutputStream.writeChars("\t</key>\n");
                }
                dataOutputStream.writeChars("</xml>\n");
                dataOutputStream.close();
            }
            catch (Exception exception) {
                this.infoException(string, exception);
            }
        }
    }

    public void onSaveUtf(String string, String[] stringArray) {
        String string2 = string;
        if (string2 != null) {
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string2));
                BundleSet bundleSet = this.bundle.getBundle();
                int n = bundleSet.getItemCount();
                dataOutputStream.writeChar(65279);
                dataOutputStream.writeChars("#JRC Editor 2.0: do not modify this line\r\n\r\n");
                for (int i = 0; i < n; ++i) {
                    BundleItem bundleItem = bundleSet.getItem(i);
                    Enumeration enumeration = bundleItem.getLanguages();
                    dataOutputStream.writeChars("KEY=\"" + bundleItem.getId() + "\":\r\n");
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        if (!this.inArray(stringArray, string3)) continue;
                        dataOutputStream.writeChars("\t\"" + string3 + "\"=\"" + bundleItem.getTranslation(string3) + "\"\r\n");
                    }
                    dataOutputStream.writeChars("\r\n");
                }
                dataOutputStream.close();
            }
            catch (Exception exception) {
                this.infoException(string, exception);
            }
        }
    }

    private boolean inArray(String[] stringArray, String string) {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (stringArray[i] == null || !stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private String getBody(String string) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        StringBuffer stringBuffer = new StringBuffer(dataInputStream.available());
        try {
            dataInputStream.readChar();
            while (true) {
                char c = dataInputStream.readChar();
                stringBuffer.append(c);
            }
        }
        catch (EOFException eOFException) {
            return stringBuffer.toString();
        }
    }

    private void fillTable(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "!");
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            if (this.bundle.getBundle().getLanguage(string3) == null) {
                this.bundle.getBundle().addLanguage(string3);
            }
            this.bundle.getBundle().addKey(string2);
            this.bundle.getBundle().updateValue(string2, string3, (String)hashtable.get(string));
        }
    }

    public void onLoadXml(String string) throws Exception {
        String string2 = string;
        if (string2 != null) {
            this.bundle.getBundle().addLanguage("en");
            XmlReader xmlReader = new XmlReader(this.getBody(string2));
            Hashtable hashtable = xmlReader.getTable();
            this.fillTable(hashtable);
        }
    }

    public void onLoadUtf(String string) throws Exception {
        String string2 = string;
        if (string2 != null) {
            this.bundle.getBundle().addLanguage("en");
            UtfParser utfParser = new UtfParser(new StringReader(this.getBody(string2)));
            Hashtable hashtable = utfParser.parse();
            this.fillTable(hashtable);
        }
    }

    private void infoError(String string) {
        System.err.println(string);
    }

    private void tryToLoad(String string) throws IOException {
        try {
            this.onParseCode(string);
            return;
        }
        catch (Exception exception) {
            try {
                this.onLoadXml(string);
                return;
            }
            catch (Exception exception2) {
                try {
                    this.onLoadUtf(string);
                    return;
                }
                catch (Exception exception3) {
                    try {
                        this.readResources(string, true);
                        return;
                    }
                    catch (Exception exception4) {
                        throw new IOException(string + ": wrong file format or file unavailable");
                    }
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        block10: {
            try {
                String string = stringArray[0];
                String string2 = stringArray[1];
                String[] stringArray2 = new String[stringArray.length - 2];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = stringArray[i + 2];
                }
                Split split = new Split(string2);
                if (string.equals("join")) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        split.tryToLoad(stringArray2[i]);
                    }
                    split.onSaveAs(string2);
                    break block10;
                }
                if (string.equals("split")) {
                    String string3 = stringArray2[0];
                    stringArray2[0] = null;
                    if (string3.endsWith(".txt")) {
                        split.onSaveUtf(string3, stringArray2);
                        break block10;
                    }
                    if (string3.endsWith(".xml")) {
                        split.onSaveXml(string3, stringArray2);
                        break block10;
                    }
                    if (string3.endsWith(".java")) {
                        split.onGenCode(string3);
                        break block10;
                    }
                    throw new IOException(string3 + ": wrong file format or I/O error");
                }
                throw new Exception();
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Usage:\n\tjrc-split join srcFile ... addFile\n\tjrc-split split srcFile dstFile [lang ...]\nWhere:\n\taddFile\t- XML, Java, other bundle set or UCS16 text file\n\tsrcFile\t- a root file of properties bundle set\n\tdstFile\t- XML, Java, other bundle set or UCS16 text file\n\tlang\t- locale abbreviation (suffix of slave properties files)\n");
            }
        }
    }
}

