/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.tools.i18n.translator;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.zaval.tools.i18n.translator.BundleItem;
import org.zaval.tools.i18n.translator.BundleSet;

class SrcGenerator {
    private PrintStream out = null;
    private String filename = null;

    SrcGenerator(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.out = new PrintStream(fileOutputStream);
        this.filename = string;
    }

    void perform(BundleSet bundleSet) throws IOException {
        BundleItem bundleItem;
        int n;
        this.out.println("import java.util.*;\n\npublic class " + this.baseName(this.filename) + "\n{");
        int n2 = bundleSet.getItemCount();
        for (n = 0; n < n2; ++n) {
            bundleItem = bundleSet.getItem(n);
            this.out.println("\tprivate String " + this.makeVarName(bundleItem) + ";");
        }
        this.out.println();
        for (n = 0; n < n2; ++n) {
            bundleItem = bundleSet.getItem(n);
            this.out.println("\tpublic final String get" + this.makeFunName(bundleItem) + "()\t{ return " + this.makeVarName(bundleItem) + ";}");
        }
        this.out.println();
        for (n = 0; n < n2; ++n) {
            bundleItem = bundleSet.getItem(n);
            this.out.println("\tpublic final void set" + this.makeFunName(bundleItem) + "(String what)\t{ this." + this.makeVarName(bundleItem) + " = what;}");
        }
        this.out.println();
        this.out.println("\tpublic void loadFromResource(ResourceBundle rs)\n\t{");
        for (n = 0; n < n2; ++n) {
            bundleItem = bundleSet.getItem(n);
            this.out.println("\t\ttry{ set" + this.makeFunName(bundleItem) + "(rs.getString(\"" + bundleItem.getId() + "\")); } catch(Exception error){ reportNoRc(\"" + bundleItem.getId() + "\", error); }");
        }
        this.out.println("\t}\n");
        this.out.println("\tprivate void reportNoRc(String what, Exception details)\n\t{\n\t\tSystem.err.println(what + \": unknown resource\");\n\t\tdetails.printStackTrace();\n\t}\n");
        this.out.println("}");
        this.out.close();
    }

    private String makeVarName(BundleItem bundleItem) {
        String string = bundleItem.getTranslation("__var");
        if (string != null) {
            return string;
        }
        string = this.makeVarName(bundleItem.getId());
        bundleItem.setTranslation("__var", string);
        return string;
    }

    private String makeFunName(BundleItem bundleItem) {
        String string = bundleItem.getTranslation("__varF");
        if (string != null) {
            return string;
        }
        string = this.capitalize(this.makeVarName(bundleItem.getId()));
        bundleItem.setTranslation("__varF", string);
        return string;
    }

    private String makeVarName(String string) {
        String string2 = string.toLowerCase();
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return string2;
        }
        int n2 = string2.lastIndexOf(46, n - 1);
        if (n2 < 0) {
            n2 = -1;
        }
        string2 = string2.substring(n2 + 1, n) + this.capitalize(string2.substring(n + 1));
        return string2;
    }

    private String capitalize(String string) {
        if (string.length() < 2) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private String baseName(String string) {
        int n = string.lastIndexOf(47);
        string = n >= 0 ? string.substring(n + 1) : string;
        n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(0, n) : string;
    }
}

