/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.tools.i18n.translator;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.im.InputSubset;
import java.util.Locale;
import org.zaval.awt.EmulatedTextArea;

public class TextAreaWrap {
    private EmulatedTextArea tf1 = null;
    private TextArea tf2 = null;
    private int flavor;
    public static final int NATIVE = 1;
    public static final int PJAVA = 2;
    static Character.Subset[] usedInputs = new Character.Subset[]{Character.UnicodeBlock.ARABIC, Character.UnicodeBlock.ARMENIAN, Character.UnicodeBlock.BASIC_LATIN, Character.UnicodeBlock.BENGALI, Character.UnicodeBlock.BOPOMOFO, Character.UnicodeBlock.CJK_COMPATIBILITY, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, Character.UnicodeBlock.CURRENCY_SYMBOLS, Character.UnicodeBlock.CYRILLIC, Character.UnicodeBlock.DEVANAGARI, Character.UnicodeBlock.DINGBATS, Character.UnicodeBlock.ENCLOSED_ALPHANUMERICS, Character.UnicodeBlock.GENERAL_PUNCTUATION, Character.UnicodeBlock.GEORGIAN, Character.UnicodeBlock.GREEK, Character.UnicodeBlock.GREEK_EXTENDED, Character.UnicodeBlock.GUJARATI, Character.UnicodeBlock.GURMUKHI, Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO, Character.UnicodeBlock.HANGUL_JAMO, Character.UnicodeBlock.HANGUL_SYLLABLES, Character.UnicodeBlock.HEBREW, Character.UnicodeBlock.HIRAGANA, Character.UnicodeBlock.KANBUN, Character.UnicodeBlock.KANNADA, Character.UnicodeBlock.KATAKANA, Character.UnicodeBlock.LAO, Character.UnicodeBlock.LATIN_1_SUPPLEMENT, Character.UnicodeBlock.LATIN_EXTENDED_A, Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL, Character.UnicodeBlock.LATIN_EXTENDED_B, Character.UnicodeBlock.MALAYALAM, Character.UnicodeBlock.ORIYA, Character.UnicodeBlock.TAMIL, Character.UnicodeBlock.TELUGU, Character.UnicodeBlock.THAI, Character.UnicodeBlock.TIBETAN, InputSubset.FULLWIDTH_DIGITS, InputSubset.FULLWIDTH_LATIN, InputSubset.HALFWIDTH_KATAKANA, InputSubset.HANJA, InputSubset.KANJI, InputSubset.LATIN, InputSubset.LATIN_DIGITS, InputSubset.SIMPLIFIED_HANZI, InputSubset.TRADITIONAL_HANZI};

    public TextAreaWrap() {
        this.flavor = 2;
        String string = System.getProperty("inputControls");
        if (string != null && string.equals("native")) {
            this.flavor = 1;
        }
        this.initControls();
    }

    public TextAreaWrap(int n) {
        this.flavor = n;
        this.initControls();
    }

    private void initControls() {
        if (this.flavor == 1) {
            this.tf2 = new TextArea("", 3, 20, 3);
            this.tf2.enableInputMethods(true);
        } else {
            this.tf1 = new EmulatedTextArea(true, false, 3, 20);
        }
    }

    public String getText() {
        return this.flavor == 1 ? this.tf2.getText() : this.tf1.getText();
    }

    public void setText(String string) {
        if (this.flavor == 1) {
            this.tf2.setText(string);
        } else {
            this.tf1.setText(string);
        }
    }

    public void setVisible(boolean bl) {
        if (this.flavor == 1) {
            this.tf2.setVisible(bl);
        } else {
            this.tf1.setVisible(bl);
        }
    }

    public void requestFocus() {
        if (this.flavor == 1) {
            this.requestFocus();
        } else {
            this.tf1.requestFocus();
        }
    }

    public Component getControl() {
        return this.flavor == 1 ? this.tf2 : this.tf1;
    }

    public void setLocale(Locale locale) {
        if (this.flavor == 1) {
            this.tf2.setLocale(locale);
        }
        if (this.getControl().getInputContext() != null) {
            this.getControl().getInputContext().setCharacterSubsets(usedInputs);
        }
    }

    public void selectAll() {
        if (this.flavor == 1) {
            this.tf2.selectAll();
        } else {
            this.tf1.selectAll();
        }
    }

    public Rectangle getCursorShape() {
        if (this.flavor == 1) {
            return null;
        }
        return this.tf1.getCursorShape();
    }
}

