/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.tools.i18n.translator;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.zaval.awt.BorderedPanel;
import org.zaval.awt.ContextMenu;
import org.zaval.awt.ContextMenuBar;
import org.zaval.awt.EmulatedTextField;
import org.zaval.awt.GraphTree;
import org.zaval.awt.IELabel;
import org.zaval.awt.ResizeLayout;
import org.zaval.awt.Resizer;
import org.zaval.awt.ResultField;
import org.zaval.awt.SimpleScrollPanel;
import org.zaval.awt.SpeedButton;
import org.zaval.awt.StatusBar;
import org.zaval.awt.StatusBarElement;
import org.zaval.awt.StatusBarStubbElement;
import org.zaval.awt.TextAlignArea;
import org.zaval.awt.Toolbar;
import org.zaval.awt.ToolkitResolver;
import org.zaval.awt.dialog.EditDialog;
import org.zaval.awt.dialog.MessageBox2;
import org.zaval.awt.peer.TreeNode;
import org.zaval.io.IniFile;
import org.zaval.io.InputIniFile;
import org.zaval.tools.i18n.translator.BundleItem;
import org.zaval.tools.i18n.translator.BundleManager;
import org.zaval.tools.i18n.translator.BundleSet;
import org.zaval.tools.i18n.translator.JavaParser;
import org.zaval.tools.i18n.translator.LangDialog;
import org.zaval.tools.i18n.translator.LangItem;
import org.zaval.tools.i18n.translator.LangState;
import org.zaval.tools.i18n.translator.ReplaceDialog;
import org.zaval.tools.i18n.translator.SearchDialog;
import org.zaval.tools.i18n.translator.SrcGenerator;
import org.zaval.tools.i18n.translator.TextAreaWrap;
import org.zaval.tools.i18n.translator.TranslatorConstants;
import org.zaval.tools.i18n.translator.UtfParser;
import org.zaval.tools.i18n.translator.XmlReader;
import org.zaval.util.SafeResourceBundle;

public class Translator
extends Frame
implements TranslatorConstants,
AWTEventListener {
    private MessageBox2 closeDialog = null;
    private MessageBox2 delDialog = null;
    private MessageBox2 errDialog = null;
    private MessageBox2 repDialog = null;
    private EmulatedTextField keyName = null;
    private IELabel keyLabel = null;
    private Button keyInsertButton = null;
    private Button keyDeleteButton = null;
    private Button dropComment = null;
    private GridBagLayout textLayout = null;
    private IELabel commLab = null;
    private IELabel keynLab = null;
    private GraphTree tree = null;
    private Panel textPanel = null;
    private Vector langStates = new Vector();
    private String lastDirectory = ".";
    private boolean keepLastDir = true;
    private boolean omitSpaces = true;
    private boolean autoExpandTF = true;
    private boolean allowDot = true;
    private boolean allowUScore = true;
    private MenuItem newBundleMenu;
    private MenuItem openBundleMenu;
    private MenuItem openBundleMenuP;
    private MenuItem saveBundleMenu;
    private MenuItem saveAsBundleMenu;
    private MenuItem genMenu;
    private MenuItem parseMenu;
    private MenuItem saveXmlBundleMenu;
    private MenuItem saveUtfBundleMenu;
    private MenuItem loadXmlBundleMenu;
    private MenuItem loadUtfBundleMenu;
    private MenuItem saveXmlBundleMenuP;
    private MenuItem saveUtfBundleMenuP;
    private MenuItem loadXmlBundleMenuP;
    private MenuItem loadUtfBundleMenuP;
    private MenuItem loadJarMenu;
    private MenuItem closeMenu;
    private MenuItem exitMenu;
    private MenuItem newLangMenu;
    private Menu langMenu;
    private Menu fileMenu;
    private MenuItem delMenu;
    private MenuItem insMenu;
    private MenuItem renMenu;
    private MenuItem editCopyMenu;
    private MenuItem editCutMenu;
    private MenuItem editPasteMenu;
    private MenuItem editDeleteMenu;
    private MenuItem searchMenu;
    private MenuItem searchAgainMenu;
    private MenuItem replaceToMenu;
    private MenuItem aboutMenu;
    private MenuItem expandTreeMenu;
    private MenuItem collapseTreeMenu;
    private MenuItem expandNodeMenu;
    private MenuItem collapseNodeMenu;
    private CheckboxMenuItem hideTransMenu;
    private MenuItem statisticsMenu;
    private Menu optionsMenu;
    private CheckboxMenuItem showNullsMenu;
    private CheckboxMenuItem keepLastDirMenu;
    private CheckboxMenuItem omitSpacesMenu;
    private CheckboxMenuItem autoExpandTFMenu;
    private CheckboxMenuItem allowDotMenu;
    private CheckboxMenuItem allowUScoreMenu;
    private MenuItem ctNewMenu;
    private MenuItem ctNodeExpandMenu;
    private MenuItem ctNodeCollapseMenu;
    private MenuItem ctNodeDeleteMenu;
    private MenuItem ctNodeRenameMenu;
    private EmulatedTextField commField = null;
    private IELabel sbl1;
    private IELabel sbl2;
    private ToolkitResolver imgres = null;
    private boolean exitInitiated = true;
    private boolean isDirty = false;
    private String wasSelectedKey = null;
    private String SYS_DIR;
    private BundleManager bundle = new BundleManager();
    private Panel pane = new Panel();
    private Toolbar tool;
    private SimpleScrollPanel scrPanel;
    private String[] CLOSE_BUTTONS = new String[3];
    private String[] YESNO_BUTTONS = new String[2];
    private String[] DELETE_BUTTONS = new String[3];
    private String[] DELETE_BUTTONS2 = new String[2];
    private String[] DELETE_BUTTONS3 = new String[2];
    private String[] REPLACE_BUTTONS = new String[3];
    private MenuItem[] tbar2menu;
    private static final int MAX_PICK_LENGTH = 40;
    private Vector pickList = new Vector(8);
    private int nullsCount = 0;
    private int notCompletedCount = 0;
    private String searchCriteria = null;
    private String lastKeyFound = null;
    private boolean searchRegex = false;
    private boolean searchData = true;
    private boolean searchMask = false;
    private boolean searchCase = true;
    private boolean replacePrompt = true;
    private boolean replaceAll = false;
    private String replaceTo = null;
    private BundleItem curItemForReplace = null;
    private LangItem curLangForReplace = null;
    private Vector tabOrder = new Vector();
    private SafeResourceBundle rcTable = null;

    public Translator(String string, SafeResourceBundle safeResourceBundle) {
        this.init(string, safeResourceBundle);
        this.onNewBundle();
    }

    public Translator(String string, SafeResourceBundle safeResourceBundle, String string2) {
        this.init(string, safeResourceBundle);
        this.clear();
        this.readResources(string2, false);
    }

    private void init(String string, SafeResourceBundle safeResourceBundle) {
        this.SYS_DIR = string;
        this.rcTable = safeResourceBundle;
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        this.CLOSE_BUTTONS[0] = this.RC("dialog.button.yes");
        this.CLOSE_BUTTONS[1] = this.RC("dialog.button.no");
        this.CLOSE_BUTTONS[2] = this.RC("dialog.button.cancel");
        this.REPLACE_BUTTONS[0] = this.RC("dialog.button.yes");
        this.REPLACE_BUTTONS[1] = this.RC("dialog.button.no");
        this.REPLACE_BUTTONS[2] = this.RC("dialog.button.cancel");
        this.YESNO_BUTTONS[0] = this.RC("dialog.button.yes");
        this.YESNO_BUTTONS[1] = this.RC("dialog.button.no");
        this.DELETE_BUTTONS[0] = this.RC("dialog.button.delete.all");
        this.DELETE_BUTTONS[1] = this.RC("dialog.button.delete.this");
        this.DELETE_BUTTONS[2] = this.RC("dialog.button.cancel");
        this.DELETE_BUTTONS2[0] = this.DELETE_BUTTONS[0];
        this.DELETE_BUTTONS2[1] = this.DELETE_BUTTONS[2];
        this.DELETE_BUTTONS3[0] = this.DELETE_BUTTONS[1];
        this.DELETE_BUTTONS3[1] = this.DELETE_BUTTONS[2];
        this.imgres = new ToolkitResolver();
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", this.pane);
        this.tool = new Toolbar();
        this.tool.add(91, (Component)new IELabel(this.RC("menu.file") + ":"));
        this.tool.add(0, (Component)new SpeedButton(this.imgres.getImage(this.SYS_DIR + "new.gif", this)));
        this.tool.add(1, (Component)new SpeedButton(this.imgres.getImage(this.SYS_DIR + "load.gif", this)));
        this.tool.add(2, (Component)new SpeedButton(this.imgres.getImage(this.SYS_DIR + "save.gif", this)));
        this.tool.add(3, (Component)new SpeedButton(this.imgres.getImage(this.SYS_DIR + "saveas.gif", this)));
        this.tool.add(92, (Component)new IELabel("+"));
        this.tool.add(4, (Component)new SpeedButton(this.imgres.getImage(this.SYS_DIR + "deploy.gif", this)));
        this.tool.add(5, (Component)new SpeedButton(this.imgres.getImage(this.SYS_DIR + "import.gif", this)));
        this.tool.add(93, (Component)new IELabel(this.RC("menu.edit") + ":"));
        this.tool.add(6, (Component)new SpeedButton(this.imgres.getImage(this.SYS_DIR + "newlang.gif", this)));
        this.tool.add(7, (Component)new SpeedButton(this.imgres.getImage(this.SYS_DIR + "del.gif", this)));
        this.tool.add(94, (Component)new IELabel(this.RC("menu.help") + ": "));
        this.tool.add(8, (Component)new SpeedButton(this.imgres.getImage(this.SYS_DIR + "about.gif", this)));
        this.add("North", this.tool);
        this.setIconImage(this.imgres.getImage(this.SYS_DIR + "jrc-editor.gif"));
        StatusBar statusBar = new StatusBar();
        this.sbl1 = new IELabel();
        statusBar.add(new StatusBarElement(this.sbl1, 20));
        this.sbl2 = new IELabel();
        statusBar.add(new StatusBarElement(this.sbl2, 80));
        StatusBarStubbElement statusBarStubbElement = new StatusBarStubbElement(new Panel(), 0, new Dimension(22, 19));
        statusBarStubbElement.setLayout(new FlowLayout(0, 1, 2));
        statusBarStubbElement.setType(0);
        statusBar.add(statusBarStubbElement);
        this.add("South", statusBar);
        this.tree = new GraphTree();
        this.tree.setResolver(this.imgres);
        this.tree.setBackground(Color.white);
        ContextMenuBar contextMenuBar = new ContextMenuBar(this);
        ContextMenu contextMenu = new ContextMenu("");
        this.ctNewMenu = new MenuItem(this.RC("tools.translator.menu.insert"));
        contextMenu.add(this.ctNewMenu);
        contextMenuBar.add(contextMenu);
        ContextMenu contextMenu2 = new ContextMenu("");
        this.ctNewMenu = new MenuItem(this.RC("tools.translator.menu.insert"));
        contextMenu2.add(this.ctNewMenu);
        this.ctNodeExpandMenu = new MenuItem(this.RC("tools.translator.menu.expand"));
        contextMenu2.add(this.ctNodeExpandMenu);
        this.ctNodeCollapseMenu = new MenuItem(this.RC("tools.translator.menu.collapse"));
        contextMenu2.add(this.ctNodeCollapseMenu);
        this.ctNodeDeleteMenu = new MenuItem(this.RC("tools.translator.menu.delete"));
        contextMenu2.add(this.ctNodeDeleteMenu);
        this.ctNodeRenameMenu = new MenuItem(this.RC("tools.translator.menu.rename"));
        contextMenu2.add(this.ctNodeRenameMenu);
        contextMenuBar.add(contextMenu2);
        this.tree.setMenuBar(contextMenuBar);
        this.pane.setLayout(new BorderLayout());
        BorderedPanel borderedPanel = new BorderedPanel(4);
        GridBagLayout gridBagLayout = new GridBagLayout();
        Panel panel = new Panel(gridBagLayout);
        this.keyLabel = new IELabel(this.RC("tools.translator.label.key"));
        this.constrain(panel, this.keyLabel, 0, 0, 1, 1, 11, 0, 0.0, 0.0, 5, 5, 5, 5);
        this.keyName = new EmulatedTextField();
        this.keyName.setBackground(Color.white);
        this.constrain(panel, this.keyName, 1, 0, 1, 1, 11, 1, 1.0, 1.0, 5, 5, 5, 5);
        this.keyInsertButton = new Button(this.RC("tools.translator.label.insert"));
        this.constrain(panel, this.keyInsertButton, 2, 0, 1, 1, 11, 0, 0.0, 0.0, 5, 5, 5, 5);
        this.keyDeleteButton = new Button(this.RC("tools.translator.label.delete"));
        this.constrain(panel, this.keyDeleteButton, 3, 0, 1, 1, 11, 0, 0.0, 0.0, 5, 5, 5, 5);
        this.pane.add((Component)panel, "South");
        this.pane.add((Component)borderedPanel, "Center");
        ResizeLayout resizeLayout = new ResizeLayout();
        Resizer resizer = new Resizer();
        this.textPanel = new Panel();
        this.scrPanel = new SimpleScrollPanel(this.textPanel);
        this.setBackground(Color.lightGray);
        borderedPanel.setLayout(resizeLayout);
        borderedPanel.add(this.tree);
        borderedPanel.add(this.scrPanel);
        borderedPanel.add(resizer);
        this.textLayout = new GridBagLayout();
        this.textPanel.setLayout(this.textLayout);
        this.tabOrder.add(this.tree);
        this.tabOrder.add(this.keyName);
        this.tabOrder.add(this.keyInsertButton);
        this.tabOrder.add(this.keyDeleteButton);
        MenuBar menuBar = new MenuBar();
        this.fileMenu = new Menu(this.RC("menu.file"));
        this.newBundleMenu = new MenuItem(this.RC("tools.translator.menu.new.bundle"), new MenuShortcut(78));
        this.openBundleMenu = new MenuItem(this.RC("tools.translator.menu.open"), new MenuShortcut(79));
        this.saveBundleMenu = new MenuItem(this.RC("tools.translator.menu.save"), new MenuShortcut(83));
        this.saveBundleMenu.disable();
        this.saveAsBundleMenu = new MenuItem(this.RC("tools.translator.menu.saveas"));
        this.saveAsBundleMenu.disable();
        this.closeMenu = new MenuItem(this.RC("tools.translator.menu.close"));
        this.closeMenu.disable();
        this.exitMenu = new MenuItem(this.RC("menu.exit"));
        Menu menu = new Menu(this.RC("menu.edit"));
        this.editCopyMenu = new MenuItem(this.RC("tools.translator.menu.edit.copy"));
        this.editCutMenu = new MenuItem(this.RC("tools.translator.menu.edit.cut"));
        this.editPasteMenu = new MenuItem(this.RC("tools.translator.menu.edit.paste"));
        this.editDeleteMenu = new MenuItem(this.RC("tools.translator.menu.edit.delete"));
        this.searchMenu = new MenuItem(this.RC("menu.search"));
        this.searchAgainMenu = new MenuItem(this.RC("menu.searchagain"), new MenuShortcut(70));
        this.replaceToMenu = new MenuItem(this.RC("menu.replace"));
        this.newLangMenu = new MenuItem(this.RC("tools.translator.menu.new.lang"), new MenuShortcut(76));
        this.delMenu = new MenuItem(this.RC("tools.translator.menu.delete"), new MenuShortcut(68));
        this.insMenu = new MenuItem(this.RC("tools.translator.menu.insert"), new MenuShortcut(73));
        this.renMenu = new MenuItem(this.RC("tools.translator.menu.rename"), new MenuShortcut(82));
        Menu menu2 = new Menu(this.RC("menu.tree"));
        this.expandNodeMenu = new MenuItem(this.RC("tools.translator.menu.node.expand"));
        this.collapseNodeMenu = new MenuItem(this.RC("tools.translator.menu.node.collapse"));
        this.expandTreeMenu = new MenuItem(this.RC("tools.translator.menu.expand"));
        this.collapseTreeMenu = new MenuItem(this.RC("tools.translator.menu.collapse"));
        this.hideTransMenu = new CheckboxMenuItem(this.RC("tools.translator.menu.hide.completed"));
        Menu menu3 = new Menu(this.RC("menu.options"));
        this.statisticsMenu = new MenuItem(this.RC("tools.translator.menu.statistics"));
        this.showNullsMenu = new CheckboxMenuItem(this.RC("tools.translator.menu.nulls"), false);
        this.langMenu = new Menu(this.RC("tools.translator.menu.showres"));
        this.langMenu.disable();
        this.optionsMenu = new Menu(this.RC("tools.translator.menu.options"));
        this.keepLastDirMenu = new CheckboxMenuItem(this.RC("tools.translator.menu.options.keeplastdir"), true);
        this.omitSpacesMenu = new CheckboxMenuItem(this.RC("tools.translator.menu.options.omitspaces"), true);
        this.autoExpandTFMenu = new CheckboxMenuItem(this.RC("tools.translator.menu.options.autofit"), true);
        this.allowDotMenu = new CheckboxMenuItem(this.RC("tools.translator.menu.options.allowdot"), true);
        this.allowUScoreMenu = new CheckboxMenuItem(this.RC("tools.translator.menu.options.allowuscore"), true);
        this.omitSpacesMenu.disable();
        Menu menu4 = new Menu(this.RC("menu.help"));
        this.aboutMenu = new MenuItem(this.RC("menu.about"));
        Menu menu5 = new Menu(this.RC("tools.translator.menu.tools"));
        this.genMenu = new MenuItem(this.RC("tools.translator.menu.generate"));
        this.genMenu.disable();
        this.parseMenu = new MenuItem(this.RC("tools.translator.menu.parse"));
        this.saveXmlBundleMenu = new MenuItem(this.RC("tools.translator.menu.save.xml"));
        this.saveUtfBundleMenu = new MenuItem(this.RC("tools.translator.menu.save.utf"));
        this.loadXmlBundleMenu = new MenuItem(this.RC("tools.translator.menu.load.xml"));
        this.loadUtfBundleMenu = new MenuItem(this.RC("tools.translator.menu.load.utf"));
        this.saveXmlBundleMenuP = new MenuItem(this.RC("tools.translator.menu.save.xml.part"));
        this.saveUtfBundleMenuP = new MenuItem(this.RC("tools.translator.menu.save.utf.part"));
        this.loadXmlBundleMenuP = new MenuItem(this.RC("tools.translator.menu.load.xml.part"));
        this.loadUtfBundleMenuP = new MenuItem(this.RC("tools.translator.menu.load.utf.part"));
        this.openBundleMenuP = new MenuItem(this.RC("tools.translator.menu.load.part"));
        this.loadJarMenu = new MenuItem(this.RC("tools.translator.menu.load.jar"));
        this.fileMenu.add(this.newBundleMenu);
        this.fileMenu.add(this.openBundleMenu);
        this.fileMenu.add(this.saveBundleMenu);
        this.fileMenu.add(this.saveAsBundleMenu);
        this.fileMenu.add(this.closeMenu);
        this.fileMenu.addSeparator();
        menu.add(this.newLangMenu);
        menu.addSeparator();
        menu.add(this.editCopyMenu);
        menu.add(this.editCutMenu);
        menu.add(this.editPasteMenu);
        menu.add(this.editDeleteMenu);
        menu.addSeparator();
        menu.add(this.insMenu);
        menu.add(this.delMenu);
        menu.add(this.renMenu);
        menu.addSeparator();
        menu.add(this.searchMenu);
        menu.add(this.searchAgainMenu);
        menu.add(this.replaceToMenu);
        menu2.add(this.expandNodeMenu);
        menu2.add(this.collapseNodeMenu);
        menu2.addSeparator();
        menu2.add(this.expandTreeMenu);
        menu2.add(this.collapseTreeMenu);
        menu2.add(this.hideTransMenu);
        menu3.add(this.langMenu);
        menu3.add(this.showNullsMenu);
        menu3.add(this.statisticsMenu);
        menu3.addSeparator();
        menu3.add(this.optionsMenu);
        this.optionsMenu.add(this.keepLastDirMenu);
        this.optionsMenu.add(this.omitSpacesMenu);
        this.optionsMenu.add(this.autoExpandTFMenu);
        this.optionsMenu.add(this.allowDotMenu);
        this.optionsMenu.add(this.allowUScoreMenu);
        menu5.add(this.loadJarMenu);
        menu5.addSeparator();
        menu5.add(this.loadXmlBundleMenu);
        menu5.add(this.loadUtfBundleMenu);
        menu5.add(this.saveXmlBundleMenu);
        menu5.add(this.saveUtfBundleMenu);
        menu5.addSeparator();
        menu5.add(this.openBundleMenuP);
        menu5.add(this.loadXmlBundleMenuP);
        menu5.add(this.loadUtfBundleMenuP);
        menu5.add(this.saveXmlBundleMenuP);
        menu5.add(this.saveUtfBundleMenuP);
        menu5.addSeparator();
        menu5.add(this.genMenu);
        menu5.add(this.parseMenu);
        menu4.add(this.aboutMenu);
        menuBar.add(this.fileMenu);
        menuBar.add(menu);
        menuBar.add(menu3);
        menuBar.add(menu2);
        menuBar.add(menu5);
        menuBar.add(menu4);
        this.setMenuBar(menuBar);
        this.delDialog = new MessageBox2(this);
        this.delDialog.setIcon(this.imgres.getImage(this.SYS_DIR + "ogo.gif", this.delDialog));
        this.delDialog.setTitle(this.RC("dialog.title.warning"));
        this.delDialog.setButtons(this.DELETE_BUTTONS);
        this.delDialog.addListener(this);
        this.closeDialog = new MessageBox2(this);
        this.closeDialog.setText(this.RC("tools.translator.message.save"));
        this.closeDialog.setTitle(this.RC("dialog.title.warning"));
        this.closeDialog.setIcon(this.imgres.getImage(this.SYS_DIR + "ogo.gif", this.closeDialog));
        this.closeDialog.setButtons(this.CLOSE_BUTTONS);
        this.closeDialog.addListener(this);
        this.repDialog = new MessageBox2(this);
        this.repDialog.setText("");
        this.repDialog.setTitle(this.RC("dialog.title.warning"));
        this.repDialog.setIcon(this.imgres.getImage(this.SYS_DIR + "ogo.gif", this.repDialog));
        this.repDialog.setButtons(this.REPLACE_BUTTONS);
        this.repDialog.addListener(this);
        this.errDialog = new MessageBox2(this);
        this.errDialog.setText("");
        this.errDialog.setTitle(this.RC("dialog.title.warning"));
        this.errDialog.setIcon(this.imgres.getImage(this.SYS_DIR + "Stop.gif", this.errDialog));
        String[] stringArray = new String[]{this.RC("dialog.button.ok")};
        this.errDialog.setButtons(stringArray);
        MenuItem[] menuItemArray = new MenuItem[]{this.newBundleMenu, this.openBundleMenu, this.saveBundleMenu, this.saveAsBundleMenu, this.genMenu, this.parseMenu, this.newLangMenu, this.delMenu, this.aboutMenu};
        this.tbar2menu = menuItemArray;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.onClose();
            return true;
        }
        if (event.target == this.tree) {
            if (event.id == 9991) {
                this.onDeleteKey();
            }
            if (event.target == this.tree && this.wasSelectedKey != this.tree.getSelectedText()) {
                this.setTranslations();
                this.invokeAutoFit();
            }
        }
        return super.handleEvent(event);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() != 400) {
            return;
        }
        if (!(aWTEvent instanceof KeyEvent)) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        if (keyEvent.getKeyChar() != '\t') {
            return;
        }
        this.moveFocus();
    }

    public boolean keyDown(Event event, int n) {
        if (event.target == this.keyName && n == 10) {
            this.onInsertKey();
            return true;
        }
        if (event.target instanceof Button && n == 10) {
            this.action(event, null);
            return true;
        }
        return false;
    }

    public boolean action(Event event, Object object) {
        String string;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        int n;
        if (event.target instanceof Toolbar) {
            n = Integer.parseInt((String)object);
            if (n < 0 || n >= this.tbar2menu.length) {
                return false;
            }
            event.target = this.tbar2menu[n];
        }
        if (event.target == this.statisticsMenu) {
            this.onStatistics();
        }
        if (event.target == this.searchMenu) {
            this.onSearch();
        }
        if (event.target == this.searchAgainMenu) {
            this.onSearchAgain();
        }
        if (event.target == this.replaceToMenu) {
            this.onReplace();
        }
        if (event.target == this.expandNodeMenu || event.target == this.ctNodeExpandMenu) {
            this.expand(this.tree.getSelectedNode());
        }
        if (event.target == this.collapseNodeMenu || event.target == this.ctNodeCollapseMenu) {
            this.collapse(this.tree.getSelectedNode());
        }
        if (event.target == this.expandTreeMenu) {
            this.tree.expandAll();
            this.tree.repaint();
        }
        if (event.target == this.collapseTreeMenu) {
            this.tree.collapseAll();
            this.tree.repaint();
        }
        if (event.target == this.hideTransMenu) {
            this.hideTranslated(this.hideTransMenu.getState());
        }
        if (event.target == this.dropComment) {
            this.commField.setText("");
            this.setTranslations();
        }
        if (event.target == this.editCopyMenu) {
            Component component = this.getFocusOwner();
            if (component instanceof EmulatedTextField) {
                object4 = (EmulatedTextField)component;
                ((EmulatedTextField)object4).blCopy();
            } else if (component instanceof TextField) {
                object4 = (TextField)component;
                object3 = Toolkit.getDefaultToolkit().getSystemClipboard();
                object2 = new StringSelection(((TextComponent)object4).getSelectedText());
                ((Clipboard)object3).setContents((Transferable)object2, (ClipboardOwner)object2);
            }
        }
        if (event.target == this.editCutMenu) {
            Component component = this.getFocusOwner();
            if (component instanceof EmulatedTextField) {
                object4 = (EmulatedTextField)component;
                ((EmulatedTextField)object4).blCopy();
                ((EmulatedTextField)object4).blDelete();
            } else if (component instanceof TextField) {
                object4 = (TextField)component;
                object3 = Toolkit.getDefaultToolkit().getSystemClipboard();
                object2 = new StringSelection(((TextComponent)object4).getSelectedText());
                ((Clipboard)object3).setContents((Transferable)object2, (ClipboardOwner)object2);
                if (((TextComponent)object4).getSelectedText().length() > 0) {
                    ((TextField)object4).setText(((TextComponent)object4).getText().substring(0, ((TextComponent)object4).getSelectionStart()) + ((TextComponent)object4).getText().substring(((TextComponent)object4).getSelectionEnd()));
                }
            }
        }
        if (event.target == this.editPasteMenu) {
            Component component = this.getFocusOwner();
            if (component instanceof EmulatedTextField) {
                object4 = (EmulatedTextField)component;
                ((EmulatedTextField)object4).blPaste();
            } else if (component instanceof TextField) {
                object4 = (TextField)component;
                object3 = Toolkit.getDefaultToolkit().getSystemClipboard();
                object2 = ((Clipboard)object3).getContents("e");
                String string3 = "";
                if (object2.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        string3 = (String)object2.getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (((TextComponent)object4).getSelectedText().length() > 0) {
                    ((TextField)object4).setText(((TextComponent)object4).getText().substring(0, ((TextComponent)object4).getSelectionStart()) + string3 + ((TextComponent)object4).getText().substring(((TextComponent)object4).getSelectionEnd()));
                } else {
                    ((TextField)object4).setText(((TextComponent)object4).getText().substring(0, ((TextComponent)object4).getCaretPosition()) + string3 + ((TextComponent)object4).getText().substring(((TextComponent)object4).getCaretPosition()));
                }
            }
        }
        if (event.target == this.editDeleteMenu) {
            Component component = this.getFocusOwner();
            if (component instanceof EmulatedTextField) {
                object4 = (EmulatedTextField)component;
                ((EmulatedTextField)object4).blDelete();
            } else if (component instanceof TextField && ((TextComponent)(object4 = (TextField)component)).getSelectedText().length() > 0) {
                ((TextField)object4).setText(((TextComponent)object4).getText().substring(0, ((TextComponent)object4).getSelectionStart()) + ((TextComponent)object4).getText().substring(((TextComponent)object4).getSelectionEnd()));
            }
        }
        if (event.target == this.newLangMenu) {
            this.onNewResource();
        }
        if (event.target == this.insMenu || event.target == this.ctNewMenu) {
            this.onNewKey();
        }
        if (event.target == this.renMenu || event.target == this.ctNodeRenameMenu) {
            this.onRenameKey();
        }
        if (event.target == this.newBundleMenu) {
            this.onNewBundle();
        }
        if (event.target == this.closeMenu) {
            this.exitInitiated = false;
            this.onClose();
        }
        if (event.target == this.openBundleMenu) {
            this.onOpen(false);
        }
        if (event.target == this.saveBundleMenu) {
            this.onSave();
        }
        if (event.target == this.saveAsBundleMenu) {
            this.onSaveAs();
        }
        if (event.target == this.exitMenu) {
            this.onClose();
        }
        if (event.target == this.keyInsertButton) {
            this.onInsertKey();
        }
        if (event.target == this.keyDeleteButton || event.target == this.delMenu || event.target == this.ctNodeDeleteMenu) {
            this.onDeleteKey();
        }
        if (event.target == this.genMenu) {
            this.onGenCode();
        }
        if (event.target == this.parseMenu) {
            this.onParseCode();
        }
        if (event.target == this.aboutMenu) {
            this.onAbout();
        }
        if (event.target == this.optionsMenu) {
            this.onOptions();
        }
        if (event.target == this.loadXmlBundleMenu) {
            this.onLoadXml(false);
        }
        if (event.target == this.saveXmlBundleMenu) {
            this.onSaveXml(false);
        }
        if (event.target == this.loadUtfBundleMenu) {
            this.onLoadUtf(false);
        }
        if (event.target == this.saveUtfBundleMenu) {
            this.onSaveUtf(false);
        }
        if (event.target == this.openBundleMenuP) {
            this.onOpen(true);
        }
        if (event.target == this.loadXmlBundleMenuP) {
            this.onLoadXml(true);
        }
        if (event.target == this.saveXmlBundleMenuP) {
            this.onSaveXml(true);
        }
        if (event.target == this.loadUtfBundleMenuP) {
            this.onLoadUtf(true);
        }
        if (event.target == this.saveUtfBundleMenuP) {
            this.onSaveUtf(true);
        }
        if (event.target == this.loadJarMenu) {
            this.onLoadJar();
        }
        if (event.target instanceof CheckboxMenuItem && event.target == this.showNullsMenu) {
            this.setIndicators(this.tree.getRootNode());
            this.tree.repaint();
        }
        if (event.target instanceof CheckboxMenuItem) {
            for (n = 0; n < this.langStates.size(); ++n) {
                object4 = this.getLangState(n);
                if (event.target == ((LangState)object4).box) {
                    ((LangState)object4).hidden = !((LangState)object4).hidden;
                    ((LangState)object4).tf.setVisible(!((LangState)object4).hidden);
                    ((LangState)object4).label.setVisible(!((LangState)object4).hidden);
                    this.setIndicators(this.tree.getRootNode());
                    this.textPanel.invalidate();
                    this.validate();
                }
                ((LangState)object4).box.setState(!((LangState)object4).hidden);
            }
        }
        if (event.target == this.closeDialog && event.arg instanceof Button) {
            if (!((Button)event.arg).getLabel().equals(this.CLOSE_BUTTONS[2])) {
                if (((Button)event.arg).getLabel().equals(this.CLOSE_BUTTONS[0])) {
                    this.onSave();
                }
                if (this.exitInitiated) {
                    this.finish();
                } else {
                    this.clear();
                }
            }
            this.exitInitiated = true;
        }
        if (event.target == this.delDialog && event.arg instanceof Button && ((Button)event.arg).getLabel().equals(this.DELETE_BUTTONS[0]) && (string2 = this.tree.getSelectedText()) != null) {
            this.isDirty = true;
            object4 = this.tree.getNode(string2);
            if (object4 != null) {
                object4 = ((TreeNode)object4).parent;
            }
            this.bundle.getBundle().removeKeysBeginningWith(string2);
            this.tree.remove(string2);
            this.removeLeafs(string2);
            this.adjustIndicator((TreeNode)object4);
            this.tree.repaint();
            this.wasSelectedKey = null;
            this.setTranslations();
        }
        if (event.target == this.delDialog && event.arg instanceof Button && ((Button)event.arg).getLabel().equals(this.DELETE_BUTTONS[1]) && (string = this.tree.getSelectedText()) != null) {
            this.isDirty = true;
            object4 = this.tree.getNode(string);
            if (object4 == null) {
                return true;
            }
            this.bundle.getBundle().removeKey(string);
            if (this.tree.enumChild((TreeNode)object4) == null || this.tree.enumChild((TreeNode)object4).length == 0) {
                this.tree.remove(string);
                this.removeLeafs(string);
            }
            this.tree.selectNode(((TreeNode)object4).parent);
            this.adjustIndicator((TreeNode)object4);
            this.tree.repaint();
            this.wasSelectedKey = null;
            this.setTranslations();
            this.textPanel.invalidate();
            this.validate();
        }
        if (event.target == this.repDialog) {
            if (event.arg instanceof Button && ((Button)event.arg).getLabel().equals(this.REPLACE_BUTTONS[0])) {
                this.makeReplaceImpl();
            } else if (event.arg instanceof Button && ((Button)event.arg).getLabel().equals(this.REPLACE_BUTTONS[2])) {
                this.replaceTo = null;
            }
        }
        if (event.target == this.keepLastDirMenu) {
            this.keepLastDir = this.keepLastDirMenu.getState();
        }
        if (event.target == this.omitSpacesMenu) {
            this.omitSpaces = this.omitSpacesMenu.getState();
        }
        if (event.target == this.autoExpandTFMenu) {
            this.autoExpandTF = this.autoExpandTFMenu.getState();
        }
        if (event.target == this.allowDotMenu) {
            this.allowDot = this.allowDotMenu.getState();
        }
        if (event.target == this.allowUScoreMenu) {
            this.allowUScore = this.allowUScoreMenu.getState();
        }
        if (event.target instanceof MenuItem) {
            String string4 = ((MenuItem)event.target).getLabel();
            for (int i = 0; i < this.pickList.size(); ++i) {
                object3 = (String)this.pickList.elementAt(i);
                object2 = this.stretchPath((String)object3);
                if (!((String)object2).equals(string4)) continue;
                this.clear();
                this.readResources((String)object3, false);
                break;
            }
        }
        this.sbl1.setText(" " + this.getVisLangCount() + "/" + this.bundle.getBundle().getLangCount() + ", " + this.bundle.getBundle().getItemCount() + " ");
        return true;
    }

    private void setTranslations() {
        String string = this.tree.getSelectedText();
        this.setTranslations(string);
    }

    private void setTranslations(String string) {
        String string2;
        BundleItem bundleItem;
        Object object;
        Object object2;
        if (this.wasSelectedKey != null) {
            Object object3;
            for (int i = 0; i < this.langStates.size(); ++i) {
                object3 = this.getLangState(i);
                if (((LangState)object3).hidden) continue;
                object2 = ((LangState)object3).tf.getText();
                object = this.bundle.getBundle().getItem(this.wasSelectedKey);
                if (object == null) {
                    ((LangState)object3).tf.setVisible(false);
                    ((LangState)object3).label.setVisible(false);
                    this.commField.setEnabled(false);
                    continue;
                }
                if (((BundleItem)object).getTranslation(((LangState)object3).name) == null || !((BundleItem)object).getTranslation(((LangState)object3).name).equals(object2)) {
                    this.isDirty = true;
                }
                this.bundle.getBundle().updateValue(this.wasSelectedKey, ((LangState)object3).name, (String)object2);
            }
            BundleItem bundleItem2 = bundleItem = this.commField == null ? null : this.commField.getText();
            if (bundleItem != null && ((String)((Object)bundleItem)).trim().length() == 0) {
                bundleItem = null;
            }
            if ((object3 = this.bundle.getBundle().getItem(this.wasSelectedKey)) != null) {
                ((BundleItem)object3).setComment((String)((Object)bundleItem));
            }
            this.adjustIndicator(this.tree.getNode(this.wasSelectedKey));
            this.setIndicators(this.tree.getNode(this.wasSelectedKey));
            this.tree.repaint();
        }
        if (string == null) {
            return;
        }
        bundleItem = this.bundle.getBundle().getItem(string);
        for (int i = 0; i < this.langStates.size(); ++i) {
            object2 = this.getLangState(i);
            Object object4 = object = bundleItem == null ? null : bundleItem.getTranslation(((LangState)object2).name);
            if (object == null) {
                object = "";
            }
            if (bundleItem == null) {
                ((LangState)object2).tf.setVisible(false);
                ((LangState)object2).label.setVisible(false);
                this.commField.setEnabled(false);
            } else {
                ((LangState)object2).tf.setVisible(!((LangState)object2).hidden);
                ((LangState)object2).label.setVisible(!((LangState)object2).hidden);
                this.commField.setEnabled(true);
            }
            ((LangState)object2).tf.setText((String)object);
        }
        String string3 = string2 = bundleItem == null ? " ** " + this.RC("tools.translator.message.noentry") + " **" : bundleItem.getComment();
        if (this.commField != null) {
            this.commField.setText(string2 == null ? "" : string2);
        }
        this.keynLab.setText("Key: " + string);
        this.keynLab.repaint();
        this.sbl2.setText(string);
        this.adjustIndicator(this.tree.getNode(string));
        object2 = "";
        this.wasSelectedKey = string;
        if (this.wasSelectedKey != null) {
            object2 = this.wasSelectedKey + ".";
        }
        this.keyName.setText((String)object2);
        this.tree.repaint();
    }

    public String getValidKey() {
        String string = this.keyName.getText();
        if (string == null) {
            return null;
        }
        while (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() <= 0) {
            return null;
        }
        String string2 = "";
        if (string.indexOf(61) >= 0) {
            string2 = "=";
        }
        if (string.indexOf(35) >= 0) {
            string2 = "#";
        }
        if (string2.length() == 0) {
            return this.bundle.replace(string, "..", "");
        }
        MessageBox2 messageBox2 = new MessageBox2(this);
        messageBox2.setTitle(this.RC("dialog.title.warning"));
        messageBox2.setText(this.bundle.replace(this.RC("tools.translator.message.illchar"), "[%illchar%]", string2));
        messageBox2.setIcon(this.imgres.getImage(this.SYS_DIR + "stop.gif", messageBox2));
        messageBox2.setButtons(this.RC("dialog.button.ok"));
        messageBox2.show();
        return null;
    }

    public void onInsertKey() {
        if (this.bundle.getBundle().getLangCount() == 0) {
            return;
        }
        String string = this.getValidKey();
        if (string != null) {
            this.addToTree(string);
            this.bundle.getBundle().addKey(string);
            this.bundle.getBundle().resort();
            this.commField.setText("");
            this.isDirty = true;
            this.tree.selectNodeAndOpen(string);
            this.tree.repaint();
            this.setTranslations();
            this.saveBundleMenu.enable();
            this.saveAsBundleMenu.enable();
            this.genMenu.enable();
            this.setIndicators(this.tree.getRootNode());
            this.isDirty = true;
            this.textPanel.invalidate();
            this.validate();
        }
        this.syncToolbar();
    }

    public void onDeleteKey() {
        String string = this.tree.getSelectedText();
        if (string == null) {
            return;
        }
        this.delDialog.setText(this.bundle.replace(this.RC("tools.translator.message.delkey"), "[%key%]", string));
        TreeNode treeNode = this.tree.getNode(string);
        if (treeNode == null) {
            return;
        }
        boolean bl = this.tree.enumChild(treeNode) != null && this.tree.enumChild(treeNode).length != 0;
        BundleItem bundleItem = this.bundle.getBundle().getItem(string);
        if (bundleItem != null && bl) {
            this.delDialog.setButtons(this.DELETE_BUTTONS);
        } else if (bundleItem != null && !bl) {
            this.delDialog.setButtons(this.DELETE_BUTTONS3);
        } else if (bundleItem == null) {
            this.delDialog.setButtons(this.DELETE_BUTTONS2);
        }
        this.delDialog.show();
    }

    public void onClose() {
        this.setTranslations();
        if (this.isDirty) {
            this.closeDialog.show();
        } else if (this.exitInitiated) {
            this.finish();
        } else {
            this.clear();
            this.exitInitiated = true;
        }
    }

    public void finish() {
        this.hide();
        this.saveIni();
        System.exit(0);
    }

    public void onSave() {
        if (this.bundle.getBundle().getLangCount() == 0) {
            return;
        }
        String string = this.bundle.getBundle().getLanguage(0).getLangFile();
        if (string == null) {
            this.onSaveAs();
            return;
        }
        this.setTranslations();
        try {
            this.bundle.store(null);
        }
        catch (Exception exception) {
            this.infoException(exception);
        }
        this.isDirty = false;
    }

    public void clear() {
        this.setTitle(null);
        if (this.keyName != null) {
            this.keyName.setText("");
        }
        if (this.keynLab != null) {
            this.keynLab.setText("");
        }
        this.wasSelectedKey = null;
        this.textPanel.removeAll();
        this.langMenu.removeAll();
        if (this.tree.getRootNode() != null) {
            this.tree.remove(this.tree.getRootNode());
        }
        this.tree.repaint();
        this.textPanel.invalidate();
        this.validate();
        this.isDirty = false;
        this.bundle = new BundleManager();
        this.langStates = new Vector();
        this.closeMenu.disable();
        this.saveBundleMenu.disable();
        this.saveAsBundleMenu.disable();
        this.genMenu.disable();
        this.langMenu.disable();
    }

    private LangState getLangState(int n) {
        return (LangState)this.langStates.elementAt(n);
    }

    private int getVisLangCount() {
        int n = 0;
        for (int i = 0; i < this.langStates.size(); ++i) {
            LangState langState = this.getLangState(i);
            if (langState.hidden) continue;
            ++n;
        }
        return n;
    }

    private void setAllIndicators() {
        for (int i = 0; i < this.langStates.size(); ++i) {
            LangState langState = this.getLangState(i);
            langState.hidden = false;
            langState.box.setState(true);
        }
        this.hideTransMenu.disable();
        new Thread(new Runnable(){

            public void run() {
                Translator.this.setIndicatorsInit();
            }
        }).start();
    }

    private void setIndicatorsInit() {
        this.sbl2.setText(this.RC("tools.translator.progress.indicator"));
        this.sbl2.repaint();
        this.setIndicators(this.tree.getRootNode());
        this.hideTransMenu.enable();
        this.sbl2.setText("");
        this.sbl2.repaint();
    }

    private boolean setIndicators(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        boolean bl = this.setIndicators(treeNode.sibling);
        return this.setIndicator(treeNode, this.setIndicators(treeNode.child)) || bl;
    }

    private boolean setIndicator(TreeNode treeNode, boolean bl) {
        if (treeNode == null) {
            return false;
        }
        if (this.getVisLangCount() < 2) {
            treeNode.setIndicator(null);
            return false;
        }
        if (bl) {
            treeNode.setIndicator(this.SYS_DIR + "incomplete.gif");
            return true;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        BundleItem bundleItem = this.bundle.getBundle().getItem(treeNode.getText());
        if (bundleItem == null) {
            treeNode.setIndicator(null);
            return false;
        }
        for (int i = 0; i < this.langStates.size(); ++i) {
            LangState langState = this.getLangState(i);
            if (langState.hidden) continue;
            String string = bundleItem.getTranslation(langState.name);
            if (string != null && string.trim().length() == 0) {
                string = null;
            }
            bl2 |= string == null;
            bl3 |= string != null;
        }
        treeNode.setIndicator(null);
        if (bl2 && bl3) {
            this.tree.setIndicator(treeNode.getText(), this.SYS_DIR + "incomplete.gif");
            ++this.notCompletedCount;
        } else if (bl2) {
            ++this.nullsCount;
            if (this.showNullsMenu.getState()) {
                treeNode.setIndicator(this.SYS_DIR + "incomplete.gif");
                return true;
            }
        }
        return bl2 && bl3;
    }

    private void adjustIndicator(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        this.setIndicator(treeNode, this.isSetInSiblings(treeNode.child));
        this.adjustIndicator(treeNode.parent);
    }

    private boolean isSetInSiblings(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        if (treeNode.getIndicator() != null) {
            return true;
        }
        return this.isSetInSiblings(treeNode.sibling);
    }

    private void createNewFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.infoException(exception);
        }
    }

    private void onSearch() {
        SearchDialog searchDialog = new SearchDialog((Frame)this, this.RC("tools.translator.label.search.caption"), true, this);
        searchDialog.setLabelCaption(this.RC("tools.translator.label.search.label"));
        searchDialog.setButtonsCaption(this.RC("dialog.button.ok"), this.CLOSE_BUTTONS[2]);
        searchDialog.setKVGroupLabels(this.RC("tools.translator.label.search.inkeys"), this.RC("tools.translator.label.search.invalues"));
        searchDialog.setRMEGroupLabels(this.RC("tools.translator.label.search.regex"), this.RC("tools.translator.label.search.mask"), this.RC("tools.translator.label.search.exact"));
        searchDialog.setCaseLabel(this.RC("tools.translator.label.search.case"));
        searchDialog.doModal();
        String string = searchDialog.getText();
        if (string.length() <= 0 || !searchDialog.isApply()) {
            return;
        }
        this.searchCriteria = string;
        this.searchRegex = searchDialog.isRegexMatching();
        this.searchData = !searchDialog.isKeyMatching();
        this.searchMask = searchDialog.isMaskMatching();
        this.searchCase = searchDialog.isCaseSensitive();
        this.replaceTo = null;
        if (!(this.searchRegex || this.searchMask || this.searchCase)) {
            this.searchCriteria = this.searchCriteria.toLowerCase();
        }
        this.lastKeyFound = null;
        this.onSearchAgain();
        searchDialog.dispose();
    }

    private void onReplace() {
        ReplaceDialog replaceDialog = new ReplaceDialog((Frame)this, this.RC("tools.translator.label.replace.caption"), true, this);
        replaceDialog.setLabelCaption(this.RC("tools.translator.label.search.label"));
        replaceDialog.setButtonsCaption(this.RC("dialog.button.ok"), this.CLOSE_BUTTONS[2]);
        replaceDialog.setReplaceLabel(this.RC("tools.translator.label.replace.label"));
        replaceDialog.setRMGroupLabels(this.RC("tools.translator.label.search.regex"), this.RC("tools.translator.label.search.exact"));
        replaceDialog.setCPALabels(this.RC("tools.translator.label.search.case"), this.RC("tools.translator.label.replace.prompt"), this.RC("tools.translator.label.replace.all"));
        replaceDialog.doModal();
        String string = replaceDialog.getText();
        if (string.length() <= 0 || !replaceDialog.isApply()) {
            return;
        }
        this.searchCriteria = string;
        this.searchRegex = replaceDialog.isRegexMatching();
        this.searchData = true;
        this.searchMask = false;
        this.searchCase = replaceDialog.isCaseSensitive();
        this.replacePrompt = replaceDialog.isPromptRequired();
        this.replaceAll = replaceDialog.isReplaceAll();
        this.replaceTo = replaceDialog.getReplaceTo();
        if (!(this.searchRegex || this.searchMask || this.searchCase)) {
            this.searchCriteria = this.searchCriteria.toLowerCase();
        }
        this.lastKeyFound = null;
        this.onSearchAgain();
    }

    private boolean isMatchedWith(String string) {
        if (string == null) {
            return false;
        }
        if (this.searchRegex) {
            return this.match_regex(this.searchCriteria, string, !this.searchCase);
        }
        if (this.searchMask) {
            return this.match_mask(this.searchCriteria, string, !this.searchCase);
        }
        if (this.searchCase) {
            return string.indexOf(this.searchCriteria) != -1;
        }
        return string.toLowerCase().indexOf(this.searchCriteria) != -1;
    }

    private void makeReplaceImpl() {
        int n;
        LangState langState;
        String string = this.curLangForReplace.getLangId();
        String string2 = this.curItemForReplace.getTranslation(string);
        if (this.searchRegex) {
            try {
                RE rE = new RE(this.searchCriteria, this.searchCase ? 0 : 1);
                string2 = rE.subst(string2, this.replaceTo, this.replaceAll ? 0 : 1);
            }
            catch (RESyntaxException rESyntaxException) {
                this.infoException(rESyntaxException);
                this.replaceTo = null;
            }
        } else if (this.replaceAll) {
            string2 = this.bundle.replace(string2, this.searchCriteria, this.replaceTo);
        } else {
            int n2 = string2.indexOf(this.searchCriteria);
            if (n2 > 0) {
                string2 = string2.substring(0, n2) + this.replaceTo + string2.substring(n2 + this.searchCriteria.length());
            } else if (n2 == 0) {
                string2 = this.replaceTo + string2.substring(this.searchCriteria.length());
            }
        }
        this.curItemForReplace.setTranslation(string, string2);
        if (this.tree.getSelectedText().equals(this.curItemForReplace.getId()) && (langState = this.getLangState(n = this.bundle.getBundle().getLangIndex(string))) != null) {
            langState.tf.setText(string2);
            langState.tf.getControl().requestFocus();
        }
        this.isDirty = true;
    }

    private void makeReplace(BundleItem bundleItem, LangItem langItem) {
        this.curItemForReplace = bundleItem;
        this.curLangForReplace = langItem;
        if (this.replacePrompt) {
            if (this.replacePrompt && this.replaceAll) {
                this.setTranslations();
                this.tree.selectNode(this.curItemForReplace.getId());
                this.tree.openToNode(this.curItemForReplace.getId());
                this.setTranslations(this.curItemForReplace.getId());
                this.textPanel.invalidate();
                this.validate();
                this.tree.repaint();
            }
            this.repDialog.setModal(this.replaceAll);
            String string = this.RC("tools.translator.message.found");
            string = this.bundle.replace(string, "[%found%]", this.searchCriteria);
            string = this.bundle.replace(string, "[%subst%]", this.replaceTo);
            this.repDialog.setText(string);
            this.repDialog.show();
        } else {
            this.makeReplaceImpl();
        }
    }

    private void onSearchAgain() {
        boolean bl;
        int n = 0;
        if (this.searchCriteria == null) {
            this.onSearch();
            return;
        }
        boolean bl2 = bl = this.lastKeyFound == null;
        if (this.lastKeyFound != null) {
            n = this.bundle.getBundle().getItemIndex(this.lastKeyFound) + 1;
        }
        if (!this.searchData) {
            for (int i = n; i < this.bundle.getBundle().getItemCount(); ++i) {
                BundleItem bundleItem = this.bundle.getBundle().getItem(i);
                String string = bundleItem.getId();
                if (!this.isMatchedWith(string)) continue;
                this.lastKeyFound = string;
                this.tree.selectNode(bundleItem.getId());
                this.tree.openToNode(bundleItem.getId());
                this.setTranslations(bundleItem.getId());
                this.textPanel.invalidate();
                this.validate();
                this.tree.requestFocus();
                this.tree.repaint();
                return;
            }
            this.lastKeyFound = null;
            if (bl) {
                this.searchCriteria = null;
            }
            this.errDialog.setText(bl ? this.RC("tools.translator.label.search.nokeys") : this.RC("tools.translator.label.search.nomorekeys"));
            this.errDialog.show();
            return;
        }
        int n2 = 0;
        block1: for (int i = n; i < this.bundle.getBundle().getItemCount(); ++i) {
            BundleItem bundleItem = this.bundle.getBundle().getItem(i);
            for (int j = 0; j < this.bundle.getBundle().getLangCount(); ++j) {
                LangItem langItem = this.bundle.getBundle().getLanguage(j);
                String string = bundleItem.getTranslation(langItem.getLangId());
                if (!this.isMatchedWith(string)) continue;
                this.lastKeyFound = bundleItem.getId();
                if (this.replaceTo == null || this.replaceTo != null && !this.replaceAll) {
                    this.tree.selectNode(bundleItem.getId());
                    this.tree.openToNode(bundleItem.getId());
                    this.setTranslations(bundleItem.getId());
                    this.tree.repaint();
                    if (this.replaceTo != null) {
                        this.makeReplace(bundleItem, langItem);
                    }
                    this.textPanel.invalidate();
                    this.validate();
                    if (this.replaceTo == null) {
                        this.textPanel.requestFocus();
                        LangState langState = this.getLangState(j);
                        langState.tf.getControl().requestFocus();
                    }
                    return;
                }
                this.makeReplace(bundleItem, langItem);
                ++n2;
                if (this.replaceTo == null) continue block1;
            }
        }
        this.lastKeyFound = null;
        if (bl) {
            this.searchCriteria = null;
        }
        if (n2 > 0) {
            this.errDialog.setText(this.bundle.replace(this.RC("tools.translator.label.replaced.count"), "[%replaced%]", Integer.toString(n2)));
        } else {
            this.errDialog.setText(bl ? this.RC("tools.translator.label.search.nokeys") : this.RC("tools.translator.label.search.nomorekeys"));
        }
        this.errDialog.show();
    }

    private void onNewResource() {
        EditDialog editDialog = new EditDialog((Frame)this, this.RC("tools.translator.label.newrestitle"), true, this);
        editDialog.setLabelCaption(this.RC("tools.translator.label.filesuff"));
        editDialog.setButtonsCaption(this.RC("dialog.button.ok"), this.CLOSE_BUTTONS[2]);
        editDialog.doModal();
        String string = editDialog.getText();
        if (string.length() <= 0 || !editDialog.isApply()) {
            return;
        }
        this.bundle.getBundle().addLanguage(string);
        this.syncLanguage(string);
        for (int i = 0; i < this.langStates.size(); ++i) {
            LangState langState = this.getLangState(i);
            CheckboxMenuItem checkboxMenuItem = langState.box;
            boolean bl = checkboxMenuItem.getState();
            langState.tf.setVisible(bl);
            langState.hidden = !bl;
            langState.label.setVisible(bl);
        }
        this.setAllIndicators();
        this.textPanel.invalidate();
        this.validate();
    }

    public void onNewBundle() {
        this.clear();
        this.initControls();
        this.bundle.getBundle().addLanguage("en");
        this.bundle.getBundle().addKey("creationDate");
        this.bundle.getBundle().updateValue("creationDate", "en", new Date().toLocaleString());
        this.bundle.getBundle().resort();
        this.initData(false);
        this.setTitle(null);
        this.isDirty = false;
    }

    private String RC(String string) {
        return this.rcTable.getString(string);
    }

    public void setTitle(String string) {
        String string2 = "";
        if (string != null) {
            string2 = " [" + string + "]";
        }
        super.setTitle("Zaval JRC Editor" + string2);
        this.sbl2.setText(string == null ? "" : string);
    }

    private void join(BundleManager bundleManager, boolean bl) {
        if (bl) {
            BundleSet bundleSet = bundleManager.getBundle();
            int n = bundleSet.getItemCount();
            for (int i = 0; i < n; ++i) {
                BundleItem bundleItem = bundleSet.getItem(i);
                BundleItem bundleItem2 = this.bundle.getBundle().addKey(bundleItem.getId());
                Enumeration enumeration = bundleItem.getLanguages();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.bundle.getBundle().addLanguage(string);
                    bundleItem2.setTranslation(string, bundleItem.getTranslation(string));
                }
            }
            bundleSet.resort();
        } else {
            this.bundle = bundleManager;
        }
    }

    public void readResources(String string, boolean bl) {
        File file = new File(string);
        if (!file.canRead()) {
            this.errDialog.setText(string + ":" + this.RC("no.file.found"));
            this.errDialog.show();
            return;
        }
        new Thread(new Loader(string, bl)).start();
        this.setTitle(string);
        this.addToPickList(string);
    }

    private void initControls() {
        this.commLab = new IELabel(this.RC("tools.translator.label.comments"));
        this.constrain(this.textPanel, this.commLab, 0, 0, 1, 1, 11, 0, 0.0, 0.0, 10, 3, 0, 15);
        this.commField = new EmulatedTextField();
        this.commField.setBackground(Color.lightGray);
        this.constrain(this.textPanel, this.commField, 1, 0, 1, 1, 11, 1, 1.0, 1.0, 3, 3, 5, 15);
        this.dropComment = new Button(this.RC("tools.translator.label.dropcomment"));
        this.constrain(this.textPanel, this.dropComment, 2, 0, 1, 1, 11, 0, 0.0, 0.0, 3, 3, 5, 15);
        this.keynLab = new IELabel("");
        this.constrain(this.textPanel, this.keynLab, 0, 1, 3, 1, 11, 2, 1.0, 0.0, 10, 3, 0, 15);
        this.langMenu.enable();
    }

    private void syncLanguage(String string) {
        LangItem langItem = this.bundle.getBundle().getLanguage(string);
        int n = this.bundle.getBundle().getLangIndex(string);
        String string2 = langItem.getLangDescription();
        LangState langState = new LangState();
        langState.name = langItem.getLangId();
        langState.box = new CheckboxMenuItem(string2, false);
        langState.box.setState(true);
        langState.label = new IELabel(string2 + ":", 0);
        langState.tf = new TextAreaWrap();
        langState.tf.getControl().setBackground(Color.white);
        langState.tf.setLocale(new Locale(string, ""));
        langState.tf.getControl().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!keyEvent.isActionKey() && keyEvent.getKeyChar() == '\n') {
                    Translator.this.invokeAutoFit();
                }
                Translator.this.checkForScrolling(keyEvent.getComponent());
            }
        });
        this.langStates.addElement(langState);
        this.langMenu.add(langState.box);
        this.constrain(this.textPanel, langState.label, 0, n + 2, 1, 1, 18, 0, 0.0, 0.0, 10, 3, 0, 3);
        this.constrain(this.textPanel, langState.tf.getControl(), 1, n + 2, 2, 1, 18, 2, 1.0, 1.0, 3, 3, 5, 3);
    }

    private void addToTree(String string) {
        int n;
        TreeNode treeNode = this.tree.getNode(string);
        if (treeNode != null) {
            return;
        }
        int n2 = this.allowDot ? string.lastIndexOf(46) : -1;
        int n3 = n = this.allowUScore ? string.lastIndexOf(95) : -1;
        if (n > n2) {
            n2 = n;
        }
        treeNode = new TreeNode(string, this.SYS_DIR + "BITMAP1.gif", this.SYS_DIR + "BITMAP2.gif");
        if (n2 < 0) {
            treeNode.caption = string;
            this.tree.insertRoot(string);
            treeNode = this.tree.getNode(string);
            treeNode.setExpandedImage(this.SYS_DIR + "BITMAP1.gif");
            treeNode.setCollapsedImage(this.SYS_DIR + "BITMAP2.gif");
        } else {
            String string2 = string.substring(0, n2);
            this.addToTree(string2);
            TreeNode treeNode2 = this.tree.getNode(string2);
            treeNode.caption = string.substring(n2 + 1);
            this.tree.insert(treeNode, treeNode2, 0);
            treeNode = this.tree.getNode(string);
        }
        treeNode.setContextMenu(1);
    }

    private String lookupFileForLoad(String string) {
        FileDialog fileDialog = new FileDialog((Frame)this, this.RC("tools.translator.label.opentitle"), 0);
        fileDialog.setDirectory(this.lastDirectory);
        fileDialog.setFile(string);
        fileDialog.show();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            if (this.keepLastDir) {
                this.lastDirectory = fileDialog.getDirectory();
            }
            return fileDialog.getDirectory() + string2;
        }
        return null;
    }

    private String lookupFileForStore(String string, String string2) {
        FileDialog fileDialog = new FileDialog((Frame)this, this.RC("tools.translator.label.saveastitle"), 1);
        fileDialog.setDirectory(this.lastDirectory);
        fileDialog.setFile(string2);
        fileDialog.show();
        String string3 = fileDialog.getFile();
        if (string3 != null && this.keepLastDir) {
            this.lastDirectory = fileDialog.getDirectory();
            return fileDialog.getDirectory() + string3;
        }
        return string3;
    }

    public void onSaveAs() {
        String string;
        String string2 = "*.properties";
        String string3 = this.bundle.getBundle().getLanguage(0).getLangFile();
        if (string3 == null) {
            string3 = "autosaved";
        }
        if ((string = this.lookupFileForStore(string2, string3 = string3 + ".properties")) != null) {
            try {
                this.bundle.store(string);
                this.addToPickList(string);
                this.setTitle(string);
                this.isDirty = false;
            }
            catch (Exception exception) {
                this.infoException(exception);
            }
        }
    }

    private void infoException(Exception exception) {
        exception.printStackTrace();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            printStream.close();
            String string = new String(byteArrayOutputStream.toByteArray(), 0);
            String string2 = exception.getMessage() == null ? exception.toString() : exception.getMessage();
            string2 = string2 + "\n" + string;
            this.errDialog.setText(string2);
            this.errDialog.show();
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private void onAbout() {
        MessageBox2 messageBox2 = new MessageBox2(this);
        messageBox2.setText(this.RC("tools.translator.copyright"));
        messageBox2.setTitle(this.RC("dialog.title.info"));
        messageBox2.setIcon(this.imgres.getImage(this.SYS_DIR + "ZavalCE.gif", messageBox2));
        String[] stringArray = new String[]{this.RC("dialog.button.ok")};
        messageBox2.setButtons(stringArray);
        messageBox2.show();
    }

    private void onStatistics() {
        MessageBox2 messageBox2 = new MessageBox2(this);
        this.nullsCount = 0;
        this.notCompletedCount = 0;
        this.setIndicators(this.tree.getRootNode());
        String string = this.RC("tools.translator.label.statistics.lang") + this.bundle.getBundle().getLangCount() + "\n";
        string = string + this.RC("tools.translator.label.statistics.record") + this.bundle.getBundle().getItemCount() + "\n";
        string = string + this.RC("tools.translator.label.statistics.nulls") + this.nullsCount + "\n";
        string = string + this.RC("tools.translator.label.statistics.notcompleted") + this.notCompletedCount;
        messageBox2.setText(string);
        messageBox2.setTitle(this.RC("dialog.title.info"));
        String[] stringArray = new String[]{this.RC("dialog.button.ok")};
        messageBox2.setButtons(stringArray);
        ResultField resultField = messageBox2.getTextContainer();
        TextAlignArea textAlignArea = resultField.getAlignArea();
        textAlignArea.setAlign(20);
        messageBox2.show();
    }

    private void onGenCode() {
        try {
            String string = "*.java";
            String string2 = this.bundle.getBundle().getLangCount() == 0 || this.bundle.getBundle().getLanguage(0).getLangFile() == null ? "Sample" : this.bundle.baseName(this.bundle.getBundle().getLanguage(0).getLangFile());
            string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
            String string3 = this.lookupFileForStore(string, string2 + "ResourceMapped.java");
            if (string3 != null) {
                SrcGenerator srcGenerator = new SrcGenerator(this.bundle.replace(string3, "\\", "/"));
                srcGenerator.perform(this.bundle.getBundle());
            }
        }
        catch (Exception exception) {
            this.infoException(exception);
        }
    }

    private void onParseCode() {
        try {
            String string = "*.java";
            String string2 = this.lookupFileForLoad(string);
            if (string2 != null) {
                JavaParser javaParser = new JavaParser(new FileInputStream(string2 = this.bundle.replace(string2, "\\", "/")));
                Hashtable hashtable = javaParser.parse();
                if (hashtable.size() == 0) {
                    hashtable.put("empty", "");
                }
                this.clear();
                this.initControls();
                this.bundle.getBundle().addLanguage("en");
                String string3 = this.bundle.getBundle().getLanguage(0).getLangId();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    BundleItem bundleItem = this.bundle.getBundle().addKey(string4);
                    bundleItem.setTranslation(string3, (String)hashtable.get(string4));
                }
                this.bundle.getBundle().resort();
                this.initData(false);
                this.setTitle(string2);
            }
        }
        catch (Exception exception) {
            this.infoException(exception);
        }
    }

    private void initData(boolean bl) {
        for (int i = 0; i < this.bundle.getBundle().getLangCount(); ++i) {
            LangItem langItem = this.bundle.getBundle().getLanguage(i);
            this.syncLanguage(langItem.getLangId());
        }
        this.hideTransMenu.setState(false);
        BundleItem bundleItem = this.bundle.getBundle().getItem(0);
        this.addToTree(bundleItem.getId());
        for (int i = 1; i < this.bundle.getBundle().getItemCount(); ++i) {
            BundleItem bundleItem2 = this.bundle.getBundle().getItem(i);
            this.addToTree(bundleItem2.getId());
            if (i % 250 != 0) continue;
            this.sbl2.setText("    " + i + " " + this.RC("tools.translator.progress.addkeys"));
            this.sbl2.repaint();
        }
        this.setAllIndicators();
        this.sbl2.setText("");
        this.sbl2.repaint();
        this.setCursor(0);
        if (this.bundle.getBundle().getItemCount() > 0) {
            String string = this.bundle.getBundle().getItem(0).getId();
            this.tree.selectNodeAndOpen(string);
            this.wasSelectedKey = null;
            this.setTranslations();
        }
        this.tree.requestFocus();
        this.closeMenu.enable();
        this.saveBundleMenu.enable();
        this.saveAsBundleMenu.enable();
        this.genMenu.enable();
        this.textPanel.invalidate();
        this.validate();
        this.repaint();
        this.syncToolbar();
        if (!bl) {
            this.loadPickList();
        }
    }

    private void invokeAutoFit() {
        if (this.autoExpandTF) {
            this.textPanel.invalidate();
            this.validate();
        }
    }

    private void expand(TreeNode treeNode) {
        if (treeNode != null) {
            TreeNode[] treeNodeArray = this.tree.enumChild(treeNode);
            if (treeNodeArray != null) {
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    this.expand(treeNodeArray[i]);
                }
            }
            this.tree.openNode(treeNode.getText());
        }
    }

    private void collapse(TreeNode treeNode) {
        if (treeNode != null) {
            TreeNode[] treeNodeArray = this.tree.enumChild(treeNode);
            if (treeNodeArray != null) {
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    this.collapse(treeNodeArray[i]);
                }
            }
            this.tree.closeNode(treeNode.getText());
        }
    }

    private void syncToolbar() {
        for (int i = 0; i < this.tbar2menu.length; ++i) {
            this.tool.setEnabled(i, this.tbar2menu[i].isEnabled());
        }
    }

    private void linkPickList() {
        for (int i = 0; i < this.pickList.size(); ++i) {
            String string = this.stretchPath((String)this.pickList.elementAt(i));
            MenuItem menuItem = new MenuItem(string);
            this.fileMenu.add(menuItem);
        }
        if (this.pickList.size() > 0) {
            this.fileMenu.addSeparator();
        }
        this.fileMenu.add(this.exitMenu);
    }

    private void removePickList() {
        String string;
        int n;
        if (this.pickList.size() == 0) {
            return;
        }
        String string2 = this.stretchPath((String)this.pickList.elementAt(0));
        for (n = 0; n < this.fileMenu.countItems() && !(string = this.fileMenu.getItem(n).getLabel()).equals(string2); ++n) {
        }
        this.pickList = new Vector();
        if (n >= this.fileMenu.countItems()) {
            return;
        }
        while (n < this.fileMenu.countItems()) {
            this.fileMenu.remove(n);
        }
    }

    private String stretchPath(String string) {
        if (string.length() < 40) {
            return string;
        }
        return string.substring(0, 4) + "..." + string.substring(string.length() - Math.min(string.length() - 7, 33));
    }

    private void loadPickList() {
        Hashtable hashtable;
        this.removePickList();
        String string = System.getProperty("user.home") + "/.jrc-editor.conf";
        try {
            InputIniFile inputIniFile = new InputIniFile(new FileInputStream(string));
            hashtable = inputIniFile.getTable();
            inputIniFile.close();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)hashtable.get(string2);
                if (!string2.startsWith("picklist.")) continue;
                try {
                    string2 = string2.substring(string2.indexOf(46) + 1);
                    int n = Integer.parseInt(string2);
                    while (this.pickList.size() <= n) {
                        this.pickList.addElement(null);
                    }
                    this.pickList.setElementAt(string3, n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.keepLastDir = hashtable.get("keepLastDir") == null || hashtable.get("keepLastDir").equals("Y");
            this.omitSpaces = hashtable.get("omitSpaces") == null || hashtable.get("omitSpaces").equals("Y");
            this.autoExpandTF = hashtable.get("autoExpandTF") == null || hashtable.get("autoExpandTF").equals("Y");
            this.allowDot = hashtable.get("allowDot") == null || hashtable.get("allowDot").equals("Y");
            this.allowUScore = hashtable.get("allowUScore") == null || hashtable.get("allowUScore").equals("Y");
            this.keepLastDirMenu.setState(this.keepLastDir);
            this.omitSpacesMenu.setState(this.omitSpaces);
            this.autoExpandTFMenu.setState(this.autoExpandTF);
            this.allowDotMenu.setState(this.allowDot);
            this.allowUScoreMenu.setState(this.allowUScore);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.pickList.size(); ++i) {
            hashtable = this.pickList.elementAt(i);
            if (hashtable != null) continue;
            this.pickList.removeElementAt(i);
            --i;
        }
        this.linkPickList();
    }

    private void addToPickList(String string) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < this.pickList.size(); ++i) {
            String string2 = (String)this.pickList.elementAt(i);
            if (!string2.equals(string)) continue;
            this.pickList.removeElementAt(i);
            --i;
        }
        this.pickList.insertElementAt(string, 0);
        while (this.pickList.size() >= 8) {
            this.pickList.removeElementAt(7);
        }
        this.saveIni();
    }

    private void saveIni() {
        try {
            String string = System.getProperty("user.home") + "/.jrc-editor.conf";
            IniFile iniFile = new IniFile(string);
            for (int i = 0; i < this.pickList.size(); ++i) {
                iniFile.putString("picklist." + i, (String)this.pickList.elementAt(i));
            }
            iniFile.putString("keepLastDir", this.keepLastDir ? "Y" : "N");
            iniFile.putString("omitSpaces", this.omitSpaces ? "Y" : "N");
            iniFile.putString("autoExpandTF", this.autoExpandTF ? "Y" : "N");
            iniFile.putString("allowDot", this.allowDot ? "Y" : "N");
            iniFile.putString("allowUScore", this.keepLastDir ? "Y" : "N");
            iniFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] getLangSet() {
        LangDialog langDialog = new LangDialog((Frame)this, this.RC("tools.translator.label.choosetitle"), true, this);
        langDialog.setLabelCaption(this.RC("tools.translator.label.chooselabel"));
        langDialog.setButtonsCaption(this.RC("dialog.button.ok"), this.CLOSE_BUTTONS[2]);
        LangItem[] langItemArray = new LangItem[this.bundle.getBundle().getLangCount()];
        for (int i = 0; i < langItemArray.length; ++i) {
            langItemArray[i] = this.bundle.getBundle().getLanguage(i);
        }
        langDialog.setList(langItemArray);
        langDialog.doModal();
        String[] stringArray = langDialog.getList();
        if (stringArray == null || stringArray.length <= 0 || !langDialog.isApply()) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(58) <= 0) continue;
            stringArray[i] = stringArray[i].substring(0, stringArray[i].indexOf(58)).trim();
        }
        return stringArray;
    }

    public void onOpen(boolean bl) {
        String string = "*.properties;*.ini";
        String string2 = this.lookupFileForLoad(string);
        if (string2 != null) {
            if (!bl) {
                this.clear();
            }
            this.readResources(string2, bl);
        }
    }

    public void onSaveXml(boolean bl) {
        String string;
        String[] stringArray;
        String[] stringArray2 = stringArray = bl ? this.getLangSet() : null;
        if (bl && (stringArray == null || stringArray.length < 2)) {
            return;
        }
        String string2 = "*.xml";
        String string3 = this.bundle.getBundle().getLanguage(0).getLangFile();
        if (string3 == null) {
            string3 = "autosaved";
        }
        if ((string = this.lookupFileForStore(string2, this.bundle.baseName(string3) + ".xml")) != null) {
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
                BundleSet bundleSet = this.bundle.getBundle();
                int n = bundleSet.getItemCount();
                dataOutputStream.writeChar(65279);
                dataOutputStream.writeChars("<xml>\n");
                for (int i = 0; i < n; ++i) {
                    BundleItem bundleItem = bundleSet.getItem(i);
                    Enumeration enumeration = bundleItem.getLanguages();
                    dataOutputStream.writeChars("\t<key name=\"" + bundleItem.getId() + "\">\n");
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        if (bl && !this.inArray(stringArray, string4)) continue;
                        dataOutputStream.writeChars("\t\t<value lang=\"" + string4 + "\">" + bundleItem.getTranslation(string4) + "</value>\n");
                    }
                    dataOutputStream.writeChars("\t</key>\n");
                }
                dataOutputStream.writeChars("</xml>\n");
                dataOutputStream.close();
            }
            catch (Exception exception) {
                this.infoException(exception);
            }
        }
    }

    public void onSaveUtf(boolean bl) {
        String string;
        String[] stringArray;
        String[] stringArray2 = stringArray = bl ? this.getLangSet() : null;
        if (bl && (stringArray == null || stringArray.length < 2)) {
            return;
        }
        String string2 = "*.txt";
        String string3 = this.bundle.getBundle().getLanguage(0).getLangFile();
        if (string3 == null) {
            string3 = "autosaved";
        }
        if ((string = this.lookupFileForStore(string2, this.bundle.baseName(string3) + ".txt")) != null) {
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
                BundleSet bundleSet = this.bundle.getBundle();
                int n = bundleSet.getItemCount();
                dataOutputStream.writeChar(65279);
                dataOutputStream.writeChars("#JRC Editor: do not modify this line\r\n\r\n");
                for (int i = 0; i < n; ++i) {
                    BundleItem bundleItem = bundleSet.getItem(i);
                    Enumeration enumeration = bundleItem.getLanguages();
                    dataOutputStream.writeChars("KEY=\"" + bundleItem.getId() + "\":\r\n");
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        if (bl && !this.inArray(stringArray, string4)) continue;
                        dataOutputStream.writeChars("\t\"" + string4 + "\"=\"" + bundleItem.getTranslation(string4) + "\"\r\n");
                    }
                    dataOutputStream.writeChars("\r\n");
                }
                dataOutputStream.close();
            }
            catch (Exception exception) {
                this.infoException(exception);
            }
        }
    }

    private boolean inArray(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private String getBody(String string) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        StringBuffer stringBuffer = new StringBuffer(dataInputStream.available());
        try {
            dataInputStream.readChar();
            while (true) {
                char c = dataInputStream.readChar();
                stringBuffer.append(c);
            }
        }
        catch (EOFException eOFException) {
            return stringBuffer.toString();
        }
    }

    private void fillTable(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "!");
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            if (this.bundle.getBundle().getLanguage(string3) == null) {
                this.bundle.getBundle().addLanguage(string3);
            }
            this.bundle.getBundle().addKey(string2);
            this.bundle.getBundle().updateValue(string2, string3, (String)hashtable.get(string));
        }
        this.bundle.getBundle().resort();
    }

    public void onLoadXml(boolean bl) {
        String string = "*.xml";
        String string2 = this.lookupFileForLoad(string);
        if (string2 != null) {
            if (!bl) {
                this.clear();
            }
            if (!bl) {
                this.initControls();
            }
            this.bundle.getBundle().addLanguage("en");
            try {
                XmlReader xmlReader = new XmlReader(this.getBody(string2));
                Hashtable hashtable = xmlReader.getTable();
                this.fillTable(hashtable);
            }
            catch (Exception exception) {
                this.infoException(exception);
            }
            this.initData(bl);
            this.setTitle(string2);
        }
    }

    public void onLoadUtf(boolean bl) {
        String string = "*.txt";
        String string2 = this.lookupFileForLoad(string);
        if (string2 != null) {
            if (!bl) {
                this.clear();
            }
            if (!bl) {
                this.initControls();
            }
            this.bundle.getBundle().addLanguage("en");
            try {
                UtfParser utfParser = new UtfParser(new StringReader(this.getBody(string2)));
                Hashtable hashtable = utfParser.parse();
                this.fillTable(hashtable);
            }
            catch (Exception exception) {
                this.infoException(exception);
            }
            this.initData(bl);
            this.setTitle(string2);
        }
    }

    private void onNewKey() {
        EditDialog editDialog = new EditDialog((Frame)this, this.RC("tools.translator.label.newkeytitle"), true, this);
        editDialog.setLabelCaption(this.RC("tools.translator.label.insert"));
        editDialog.setButtonsCaption(this.RC("dialog.button.ok"), this.CLOSE_BUTTONS[2]);
        editDialog.doModal();
        String string = editDialog.getText();
        if (string.length() <= 0 || !editDialog.isApply()) {
            return;
        }
        this.keyName.setText(string);
        this.onInsertKey();
    }

    private void infoError(String string) {
        this.errDialog.setText(string);
        this.errDialog.show();
    }

    private void moveFocus() {
        LangState langState;
        int n;
        Container container;
        Window window = null;
        for (container = this; container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (container == null) {
            return;
        }
        window = container;
        Component component = window.getFocusOwner();
        int n2 = this.tabOrder.indexOf(component);
        if (n2 >= 0 && n2 + 1 < this.tabOrder.size()) {
            Component component2 = (Component)this.tabOrder.elementAt(n2 + 1);
            component2.requestFocus();
            return;
        }
        for (n = 0; n < this.langStates.size(); ++n) {
            langState = this.getLangState(n);
            if (!langState.hidden && langState.tf.getControl() == component) break;
        }
        if (n < this.langStates.size()) {
            ++n;
            while (n < this.langStates.size()) {
                langState = this.getLangState(n);
                if (!langState.hidden) {
                    langState.tf.requestFocus();
                    return;
                }
                ++n;
            }
            this.tree.requestFocus();
            return;
        }
        for (n = 0; n < this.langStates.size(); ++n) {
            langState = this.getLangState(n);
            if (langState.hidden) continue;
            langState.tf.requestFocus();
            return;
        }
        this.tree.requestFocus();
    }

    private void removeLeafs(String string) {
        if (this.bundle.getBundle().getItem(string) != null) {
            return;
        }
        TreeNode treeNode = this.tree.getNode(string);
        if (treeNode != null) {
            if (this.tree.enumChild(treeNode) != null && this.tree.enumChild(treeNode).length > 0) {
                return;
            }
            this.tree.remove(string);
        }
        int n = this.allowDot ? string.lastIndexOf(46) : -1;
        int n2 = this.allowUScore ? string.lastIndexOf(95) : -1;
        if ((n = Math.max(n, n2)) <= 0) {
            return;
        }
        this.removeLeafs(string.substring(0, n));
    }

    void onRenameKey() {
        String string = this.keyName.getText();
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        EditDialog editDialog = new EditDialog((Frame)this, this.RC("tools.translator.label.rename.caption"), true, this);
        editDialog.setLabelCaption(this.RC("tools.translator.label.rename.label"));
        editDialog.setButtonsCaption(this.RC("dialog.button.ok"), this.CLOSE_BUTTONS[2]);
        editDialog.setText(string);
        editDialog.doModal();
        String string2 = editDialog.getText();
        if (string2.trim().length() <= 0 || !editDialog.isApply()) {
            return;
        }
        if (string.equals(string2)) {
            return;
        }
        BundleItem bundleItem = this.bundle.getBundle().getItem(string);
        Enumeration enumeration = this.bundle.getBundle().getKeysBeginningWith(string);
        while (enumeration.hasMoreElements()) {
            String string3;
            String string4;
            int n;
            BundleItem bundleItem2 = (BundleItem)enumeration.nextElement();
            String string5 = string2;
            if (bundleItem == null) {
                string5 = string2 + bundleItem2.getId().substring(string.length());
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n2 = this.bundle.getBundle().getLangCount();
            BundleItem bundleItem3 = this.bundle.getBundle().getItem(string5);
            if (bundleItem3 != null) {
                this.errDialog.setText(this.RC("tools.translator.label.rename.dup"));
                this.errDialog.show();
                return;
            }
            for (n = 0; n < n2; ++n) {
                string4 = this.bundle.getBundle().getLanguage(n).getLangId();
                string3 = bundleItem2.getTranslation(string4);
                if (string3 == null) continue;
                hashtable.put(string4, string3);
            }
            this.bundle.getBundle().removeKey(bundleItem2.getId());
            this.keyName.setText(string5);
            this.addToTree(string5);
            bundleItem3 = this.bundle.getBundle().addKey(string5);
            for (n = 0; n < n2; ++n) {
                string4 = this.bundle.getBundle().getLanguage(n).getLangId();
                string3 = (String)hashtable.get(string4);
                if (string3 == null) continue;
                bundleItem3.setTranslation(string4, string3);
            }
        }
        this.isDirty = true;
        this.tree.remove(string);
        this.removeLeafs(string);
        this.bundle.getBundle().resort();
        this.tree.selectNodeAndOpen(string2);
        this.tree.repaint();
        this.setTranslations();
        this.setIndicators(this.tree.getSelectedNode());
    }

    private void onLoadJar() {
        String string = "*.jar";
        String string2 = this.lookupFileForLoad(string);
        if (string2 != null) {
            this.clear();
            this.initControls();
            this.bundle.getBundle().addLanguage("en");
            try {
                ZipFile zipFile = new ZipFile(string2);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (!zipEntry.getName().endsWith(".properties")) continue;
                    String string3 = this.bundle.determineLanguage(zipEntry.getName());
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    this.bundle.appendResource(inputStream, string3);
                }
                this.initData(false);
                this.bundle.getBundle().getLanguage(0).setLangFile(null);
                this.setTitle(string2);
            }
            catch (Exception exception) {
                this.infoException(exception);
            }
        }
    }

    private void hideTranslated(boolean bl) {
        this.hideTranslated(this.tree.getRootNode(), bl);
        this.tree.invalidate();
        this.validate();
        this.tree.repaint();
    }

    private void hideTranslated(TreeNode treeNode, boolean bl) {
        while (treeNode != null) {
            if (treeNode.getIndicator() == null) {
                treeNode.setHide(bl);
            }
            this.hideTranslated(treeNode.child, bl);
            treeNode = treeNode.sibling;
        }
    }

    private void onOptions() {
    }

    private void constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8, int n9, int n10) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n6;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        if (n8 + n10 + n7 + n9 > 0) {
            gridBagConstraints.insets = new Insets(n8, n7, n10, n9);
        }
        LayoutManager layoutManager = container.getLayout();
        GridBagLayout gridBagLayout = (GridBagLayout)layoutManager;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private boolean match_regex(String string, String string2, boolean bl) {
        try {
            RE rE = new RE(string, bl ? 0 : 1);
            return rE.match(string2);
        }
        catch (RESyntaxException rESyntaxException) {
            this.infoException(rESyntaxException);
            return false;
        }
    }

    private boolean match_mask(String string, String string2, boolean bl) {
        return this.match_mask(string.toCharArray(), 0, string2.toCharArray(), 0, bl);
    }

    private boolean match_mask(char[] cArray, int n, char[] cArray2, int n2, boolean bl) {
        if (n == cArray.length && n2 == cArray2.length) {
            return true;
        }
        if (n2 == cArray2.length && cArray[n] == '*') {
            return this.match_mask(cArray, n + 1, cArray2, n2, bl);
        }
        if (n2 == cArray2.length && n != cArray.length) {
            return false;
        }
        if (n == cArray.length && n2 != cArray2.length) {
            return false;
        }
        if (cArray[n] == '?') {
            return this.match_mask(cArray, n + 1, cArray2, n2 + 1, bl);
        }
        if (!bl && Character.toLowerCase(cArray[n]) == Character.toLowerCase(cArray2[n2])) {
            return this.match_mask(cArray, n + 1, cArray2, n2 + 1, bl);
        }
        if (bl && cArray[n] == cArray2[n2]) {
            return this.match_mask(cArray, n + 1, cArray2, n2 + 1, bl);
        }
        if (cArray[n] != '?' && cArray[n] != '*') {
            if (!bl && Character.toLowerCase(cArray[n]) != Character.toLowerCase(cArray2[n2])) {
                return false;
            }
            if (bl && cArray[n] != cArray2[n2]) {
                return false;
            }
        }
        if (cArray[n] == '*' && cArray.length == n + 1) {
            return true;
        }
        for (int i = n2; i < cArray2.length; ++i) {
            if (!this.match_mask(cArray, n + 1, cArray2, i, bl)) continue;
            return true;
        }
        return this.match_mask(cArray, n + 1, cArray2, n2, bl);
    }

    private void checkForScrolling(Component component) {
        if (component instanceof EmulatedTextField) {
            int n;
            Rectangle rectangle = component.getBounds();
            Rectangle rectangle2 = ((EmulatedTextField)component).getCursorShape();
            if (rectangle == null || rectangle2 == null) {
                return;
            }
            rectangle.x += rectangle2.x;
            rectangle.y += rectangle2.y;
            rectangle.width = rectangle2.width + 25;
            rectangle.height = rectangle2.height + 25;
            Dimension dimension = this.scrPanel.size();
            dimension.width = dimension.width - (this.scrPanel.getVScrollbar().isVisible() ? this.scrPanel.getVScrollbar().size().width : 0);
            dimension.height = dimension.height - (this.scrPanel.getHScrollbar().isVisible() ? this.scrPanel.getHScrollbar().size().height : 0);
            int n2 = this.scrPanel.getHScrollbar().isVisible() ? this.scrPanel.getHScrollbar().getValue() : 0;
            int n3 = n = this.scrPanel.getVScrollbar().isVisible() ? this.scrPanel.getVScrollbar().getValue() : 0;
            if (rectangle.x + rectangle.width >= dimension.width + n2 || rectangle.y + rectangle.height >= dimension.height + n || rectangle.x < n2 || rectangle.y < n) {
                int n4 = n2;
                int n5 = n;
                Dimension dimension2 = this.scrPanel.getScrollableObject().preferredSize();
                if (rectangle.x + rectangle.width >= dimension.width) {
                    n4 = Math.min(rectangle.x + rectangle.width - dimension.width, dimension2.width - dimension.width);
                }
                if (rectangle.y + rectangle.height >= dimension.height) {
                    n5 = Math.min(rectangle.y + rectangle.height - dimension.height, dimension2.height - dimension.height);
                }
                if (rectangle.x < n2) {
                    n4 = rectangle.x;
                }
                if (rectangle.y < n) {
                    n4 = rectangle.y;
                }
                this.scrPanel.scroll(n4, n5);
            }
        }
    }

    class Loader
    implements Runnable {
        private String fileName;
        private boolean part;

        Loader(String string, boolean bl) {
            this.fileName = string;
            this.part = bl;
        }

        public void run() {
            Translator.this.setCursor(3);
            Translator.this.sbl2.setText(Translator.this.RC("tools.translator.progress.loadfiles"));
            Translator.this.sbl2.repaint();
            try {
                BundleManager bundleManager = new BundleManager(this.fileName);
                Translator.this.join(bundleManager, this.part);
            }
            catch (Exception exception) {
                Translator.this.infoException(exception);
            }
            Translator.this.sbl2.setText(Translator.this.RC("tools.translator.progress.maketree"));
            Translator.this.sbl2.repaint();
            if (!this.part) {
                Translator.this.initControls();
            } else {
                Translator.this.wasSelectedKey = null;
            }
            Translator.this.initData(this.part);
        }
    }
}

