/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.tools.i18n.translator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import org.zaval.xml.XmlElement;
import org.zaval.xml.XmlParseException;

class XmlReader {
    private XmlElement xml = new XmlElement();

    public XmlReader(InputStream inputStream) throws IOException, XmlParseException {
        this.xml.parse(new InputStreamReader(inputStream));
    }

    public XmlReader(String string) throws IOException, XmlParseException {
        this.xml.parse(new StringReader(string));
    }

    public XmlElement getRootNode() {
        return this.xml;
    }

    public Hashtable getTable() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.xml.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XmlElement xmlElement = (XmlElement)enumeration.nextElement();
            this.getTable(hashtable, xmlElement, "");
        }
        return hashtable;
    }

    private void getTable(Hashtable hashtable, XmlElement xmlElement, String string) {
        String string2 = (String)xmlElement.getAttribute("lang");
        if (string2 != null) {
            // empty if block
        }
        if (string2 == null) {
            string2 = (String)xmlElement.getAttribute("name");
        }
        if (string2 == null) {
            string2 = xmlElement.getName();
        }
        String string3 = string + string2 + "!";
        if (xmlElement.getContent() != null) {
            hashtable.put(string + string2, xmlElement.getContent());
        }
        Enumeration enumeration = xmlElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XmlElement xmlElement2 = (XmlElement)enumeration.nextElement();
            this.getTable(hashtable, xmlElement2, string3);
        }
    }
}

