/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.util;

import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class SafeResourceBundle {
    protected ResourceBundle rb = null;
    public static final String FAILURE_STRING = "?????";
    public static final String START_VAR = "[%";
    public static final String FINISH_VAR = "%]";

    public SafeResourceBundle(String string, Locale locale) {
        try {
            if (locale == null) {
                Locale locale2 = Locale.getDefault();
                Locale.setDefault(new Locale("en", "US"));
                this.rb = ResourceBundle.getBundle(string);
                Locale.setDefault(locale2);
            } else {
                this.rb = ResourceBundle.getBundle(string, locale);
            }
        }
        catch (Exception exception) {
            System.err.println(string + ": resource not found");
        }
    }

    public String getString(String string) {
        if (this.rb == null) {
            return FAILURE_STRING;
        }
        String string2 = null;
        try {
            string2 = this.rb.getString(string);
        }
        catch (Exception exception) {
            System.err.println(string + ": resource not found");
        }
        if (string2 != null) {
            return string2;
        }
        return FAILURE_STRING;
    }

    public String getString(String string, Hashtable hashtable) {
        int n;
        String string2 = this.getString(string);
        String string3 = "";
        do {
            if ((n = string2.indexOf(START_VAR)) < 0) {
                string3 = string3 + string2;
                continue;
            }
            string3 = string3 + string2.substring(0, n);
            int n2 = string2.indexOf(FINISH_VAR, n);
            if (n2 >= 0) {
                String string4 = (String)hashtable.get(string2.substring(n + 2, n2));
                if (string4 == null) {
                    string4 = "";
                }
                string3 = string3 + string4;
                string2 = string2.substring(n2 + 2);
                continue;
            }
            string3 = string3 + START_VAR;
            string2 = string2.substring(n + 2);
        } while (n >= 0);
        return string3;
    }

    public static Locale parseSuffix(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(95);
        String string2 = string;
        String string3 = "";
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        return new Locale(string2, string3);
    }

    public SafeResourceBundle(String string, String string2) {
        this(string, SafeResourceBundle.parseSuffix(string2));
    }
}

