/*
 * Decompiled with CFR 0.152.
 */
package org.zaval.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.zaval.xml.XmlParseException;

public class XmlElement {
    static final long serialVersionUID = 6685035139346394777L;
    public static final int NANOXML_MAJOR_VERSION = 2;
    public static final int NANOXML_MINOR_VERSION = 2;
    private Hashtable attributes;
    private Vector children;
    private String name;
    private String contents;
    private Hashtable entities;
    private int lineNr;
    private boolean ignoreCase;
    private boolean ignoreWhitespace;
    private char charReadTooMuch;
    private Reader reader;
    private int parserLineNr;

    public XmlElement() {
        this(new Hashtable(), false, true, true);
    }

    public XmlElement(Hashtable hashtable) {
        this(hashtable, false, true, true);
    }

    public XmlElement(boolean bl) {
        this(new Hashtable(), bl, true, true);
    }

    public XmlElement(Hashtable hashtable, boolean bl) {
        this(hashtable, bl, true, true);
    }

    public XmlElement(Hashtable hashtable, boolean bl, boolean bl2) {
        this(hashtable, bl, true, bl2);
    }

    protected XmlElement(Hashtable hashtable, boolean bl, boolean bl2, boolean bl3) {
        this.ignoreWhitespace = bl;
        this.ignoreCase = bl3;
        this.name = null;
        this.contents = "";
        this.attributes = new Hashtable();
        this.children = new Vector();
        this.entities = hashtable;
        this.lineNr = 0;
        Enumeration enumeration = this.entities.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = this.entities.get(k);
            if (!(object instanceof String)) continue;
            object = ((String)object).toCharArray();
            this.entities.put(k, object);
        }
        if (bl2) {
            this.entities.put("amp", new char[]{'&'});
            this.entities.put("quot", new char[]{'\"'});
            this.entities.put("apos", new char[]{'\''});
            this.entities.put("lt", new char[]{'<'});
            this.entities.put("gt", new char[]{'>'});
        }
    }

    public void addChild(XmlElement xmlElement) {
        this.children.addElement(xmlElement);
    }

    public void setAttribute(String string, Object object) {
        if (this.ignoreCase) {
            string = string.toLowerCase();
        }
        this.attributes.put(string, object.toString());
    }

    public int countChildren() {
        return this.children.size();
    }

    public Enumeration enumerateAttributeNames() {
        return this.attributes.keys();
    }

    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    public Vector getChildren() {
        try {
            return (Vector)this.children.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getContents() {
        return this.getContent();
    }

    public String getContent() {
        return this.contents;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public Object getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    public Object getAttribute(String string, Object object) {
        Object object2;
        if (this.ignoreCase) {
            string = string.toLowerCase();
        }
        if ((object2 = this.attributes.get(string)) == null) {
            object2 = object;
        }
        return object2;
    }

    public Object getAttribute(String string, Hashtable hashtable, String string2, boolean bl) {
        Object v;
        Object object;
        if (this.ignoreCase) {
            string = string.toLowerCase();
        }
        if ((object = this.attributes.get(string)) == null) {
            object = string2;
        }
        if ((v = hashtable.get(object)) == null) {
            if (bl) {
                v = object;
            } else {
                throw this.invalidValue(string, (String)object);
            }
        }
        return v;
    }

    public String getName() {
        return this.name;
    }

    public String getTagName() {
        return this.getName();
    }

    public void parse(Reader reader) throws IOException, XmlParseException {
        this.parse(reader, 1);
    }

    public void parse(Reader reader, int n) throws IOException, XmlParseException {
        char c;
        this.charReadTooMuch = '\u0000';
        this.reader = reader;
        this.parserLineNr = n;
        while (true) {
            if ((c = this.scanWhitespace()) != '<') {
                throw this.expectedInput("<");
            }
            c = this.readChar();
            if (c != '!' && c != '?') break;
            this.skipSpecialTag(0);
        }
        this.unreadChar(c);
        this.scanElement(this);
    }

    public void parse(String string) throws XmlParseException {
        try {
            this.parse(new StringReader(string), 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void removeChild(XmlElement xmlElement) {
        this.children.removeElement(xmlElement);
    }

    public void removeAttribute(String string) {
        if (this.ignoreCase) {
            string = string.toLowerCase();
        }
        this.attributes.remove(string);
    }

    public void removeChild(String string) {
        this.removeAttribute(string);
    }

    protected XmlElement createAnotherElement() {
        return new XmlElement(this.entities, this.ignoreWhitespace, false, this.ignoreCase);
    }

    public void setContent(String string) {
        this.contents = string;
    }

    public void setTagName(String string) {
        this.setName(string);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.write(new PrintStream(byteArrayOutputStream));
            byteArrayOutputStream.flush();
            return new String(byteArrayOutputStream.toByteArray(), 0);
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    public void write(PrintStream printStream) throws IOException {
        Object object;
        Enumeration enumeration;
        if (this.name == null) {
            this.writeEncoded(printStream, this.contents);
            return;
        }
        printStream.print('<');
        printStream.print(this.name);
        if (!this.attributes.isEmpty()) {
            enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                printStream.print(' ');
                object = (String)enumeration.nextElement();
                String string = (String)this.attributes.get(object);
                printStream.print((String)object);
                printStream.print('=');
                printStream.write(34);
                this.writeEncoded(printStream, string);
                printStream.write(34);
            }
        }
        if (this.contents != null && this.contents.length() > 0) {
            printStream.print('>');
            this.writeEncoded(printStream, this.contents);
            printStream.print('<');
            printStream.print('/');
            printStream.print(this.name);
            printStream.write(62);
        } else if (this.children.isEmpty()) {
            printStream.print('/');
            printStream.print('>');
        } else {
            printStream.print('>');
            enumeration = this.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                object = (XmlElement)enumeration.nextElement();
                ((XmlElement)object).write(printStream);
            }
            printStream.print('<');
            printStream.print('/');
            printStream.print(this.name);
            printStream.print('>');
        }
    }

    protected void writeEncoded(PrintStream printStream, String string) throws IOException {
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    printStream.write(38);
                    printStream.write(108);
                    printStream.write(116);
                    printStream.write(59);
                    continue block7;
                }
                case '>': {
                    printStream.write(38);
                    printStream.write(103);
                    printStream.write(116);
                    printStream.write(59);
                    continue block7;
                }
                case '&': {
                    printStream.write(38);
                    printStream.write(97);
                    printStream.write(109);
                    printStream.write(112);
                    printStream.write(59);
                    continue block7;
                }
                case '\"': {
                    printStream.write(38);
                    printStream.write(113);
                    printStream.write(117);
                    printStream.write(111);
                    printStream.write(116);
                    printStream.write(59);
                    continue block7;
                }
                case '\'': {
                    printStream.write(38);
                    printStream.write(97);
                    printStream.write(112);
                    printStream.write(111);
                    printStream.write(115);
                    printStream.write(59);
                    continue block7;
                }
                default: {
                    char c2 = c;
                    if (c2 < ' ' || c2 > '~') {
                        printStream.write(38);
                        printStream.write(35);
                        printStream.write(120);
                        printStream.print(Integer.toString(c2, 16));
                        printStream.write(59);
                        continue block7;
                    }
                    printStream.write(c);
                }
            }
        }
    }

    protected void scanIdentifier(StringBuffer stringBuffer) throws IOException {
        while (true) {
            char c;
            if (!((c = this.readChar()) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == ':' || c == '-' || c > '~')) {
                this.unreadChar(c);
                return;
            }
            stringBuffer.append(c);
        }
    }

    protected char scanWhitespace() throws IOException {
        char c;
        block3: while (true) {
            c = this.readChar();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return c;
    }

    protected char scanWhitespace(StringBuffer stringBuffer) throws IOException {
        char c;
        block4: while (true) {
            c = this.readChar();
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    stringBuffer.append(c);
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return c;
    }

    protected void scanString(StringBuffer stringBuffer) throws IOException {
        char c = this.readChar();
        if (c != '\'' && c != '\"') {
            throw this.expectedInput("' or \"");
        }
        char c2;
        while ((c2 = this.readChar()) != c) {
            if (c2 == '&') {
                this.resolveEntity(stringBuffer);
                continue;
            }
            stringBuffer.append(c2);
        }
        return;
    }

    protected void scanPCData(StringBuffer stringBuffer) throws IOException {
        while (true) {
            char c;
            if ((c = this.readChar()) == '<') {
                c = this.readChar();
                if (c == '!') {
                    this.checkCDATA(stringBuffer);
                    continue;
                }
                this.unreadChar(c);
                return;
            }
            if (c == '&') {
                this.resolveEntity(stringBuffer);
                continue;
            }
            stringBuffer.append(c);
        }
    }

    protected boolean checkCDATA(StringBuffer stringBuffer) throws IOException {
        char c = this.readChar();
        if (c != '[') {
            this.unreadChar(c);
            this.skipSpecialTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipSpecialTag(1);
            return false;
        }
        int n = 0;
        block4: while (n < 3) {
            int n2;
            c = this.readChar();
            switch (c) {
                case ']': {
                    if (n < 2) {
                        ++n;
                        continue block4;
                    }
                    stringBuffer.append(']');
                    stringBuffer.append(']');
                    n = 0;
                    continue block4;
                }
                case '>': {
                    if (n < 2) {
                        for (n2 = 0; n2 < n; ++n2) {
                            stringBuffer.append(']');
                        }
                        n = 0;
                        stringBuffer.append('>');
                        continue block4;
                    }
                    n = 3;
                    continue block4;
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(']');
            }
            stringBuffer.append(c);
            n = 0;
        }
        return true;
    }

    protected void skipComment() throws IOException {
        int n = 2;
        while (n > 0) {
            char c = this.readChar();
            if (c == '-') {
                --n;
                continue;
            }
            n = 2;
        }
        if (this.readChar() != '>') {
            throw this.expectedInput(">");
        }
    }

    protected void skipSpecialTag(int n) throws IOException {
        char c;
        int n2 = 1;
        char c2 = '\u0000';
        if (n == 0) {
            c = this.readChar();
            if (c == '[') {
                ++n;
            } else if (c == '-') {
                c = this.readChar();
                if (c == '[') {
                    ++n;
                } else if (c == ']') {
                    --n;
                } else if (c == '-') {
                    this.skipComment();
                    return;
                }
            }
        }
        while (n2 > 0) {
            c = this.readChar();
            if (c2 == '\u0000') {
                if (c == '\"' || c == '\'') {
                    c2 = c;
                } else if (n <= 0) {
                    if (c == '<') {
                        ++n2;
                    } else if (c == '>') {
                        --n2;
                    }
                }
                if (c == '[') {
                    ++n;
                    continue;
                }
                if (c != ']') continue;
                --n;
                continue;
            }
            if (c != c2) continue;
            c2 = '\u0000';
        }
    }

    protected boolean checkLiteral(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (this.readChar() == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected char readChar() throws IOException {
        if (this.charReadTooMuch != '\u0000') {
            char c = this.charReadTooMuch;
            this.charReadTooMuch = '\u0000';
            return c;
        }
        int n = this.reader.read();
        if (n < 0) {
            throw this.unexpectedEndOfData();
        }
        if (n == 10) {
            ++this.parserLineNr;
            return '\n';
        }
        return (char)n;
    }

    protected void scanElement(XmlElement xmlElement) throws IOException {
        Object object;
        char c;
        String string;
        StringBuffer stringBuffer;
        block22: {
            stringBuffer = new StringBuffer();
            this.scanIdentifier(stringBuffer);
            string = stringBuffer.toString();
            xmlElement.setName(string);
            c = this.scanWhitespace();
            while (c != '>' && c != '/') {
                stringBuffer.setLength(0);
                this.unreadChar(c);
                this.scanIdentifier(stringBuffer);
                object = stringBuffer.toString();
                c = this.scanWhitespace();
                if (c != '=') {
                    throw this.expectedInput("=");
                }
                this.unreadChar(this.scanWhitespace());
                stringBuffer.setLength(0);
                this.scanString(stringBuffer);
                xmlElement.setAttribute((String)object, stringBuffer);
                c = this.scanWhitespace();
            }
            if (c == '/') {
                c = this.readChar();
                if (c != '>') {
                    throw this.expectedInput(">");
                }
                return;
            }
            stringBuffer.setLength(0);
            c = this.scanWhitespace(stringBuffer);
            if (c != '<') {
                this.unreadChar(c);
                this.scanPCData(stringBuffer);
            } else {
                while ((c = this.readChar()) == '!') {
                    if (this.checkCDATA(stringBuffer)) {
                        this.scanPCData(stringBuffer);
                    } else {
                        c = this.scanWhitespace(stringBuffer);
                        if (c == '<') continue;
                        this.unreadChar(c);
                        this.scanPCData(stringBuffer);
                    }
                    break block22;
                }
                stringBuffer.setLength(0);
            }
        }
        if (stringBuffer.length() == 0) {
            while (c != '/') {
                if (c == '!') {
                    c = this.readChar();
                    if (c != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    c = this.readChar();
                    if (c != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    this.skipComment();
                } else {
                    this.unreadChar(c);
                    object = this.createAnotherElement();
                    this.scanElement((XmlElement)object);
                    xmlElement.addChild((XmlElement)object);
                }
                c = this.scanWhitespace();
                if (c != '<') {
                    throw this.expectedInput("<");
                }
                c = this.readChar();
            }
            this.unreadChar(c);
        } else if (this.ignoreWhitespace) {
            xmlElement.setContent(stringBuffer.toString().trim());
        } else {
            xmlElement.setContent(stringBuffer.toString());
        }
        c = this.readChar();
        if (c != '/') {
            throw this.expectedInput("/");
        }
        this.unreadChar(this.scanWhitespace());
        if (!this.checkLiteral(string)) {
            throw this.expectedInput(string);
        }
        if (this.scanWhitespace() != '>') {
            throw this.expectedInput(">");
        }
    }

    protected void resolveEntity(StringBuffer stringBuffer) throws IOException {
        char c = '\u0000';
        StringBuffer stringBuffer2 = new StringBuffer();
        while ((c = this.readChar()) != ';') {
            stringBuffer2.append(c);
        }
        String string = stringBuffer2.toString();
        if (string.charAt(0) == '#') {
            try {
                c = string.charAt(1) == 'x' ? (char)Integer.parseInt(string.substring(2), 16) : (char)Integer.parseInt(string.substring(1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.unknownEntity(string);
            }
            stringBuffer.append(c);
        } else {
            char[] cArray = (char[])this.entities.get(string);
            if (cArray == null) {
                throw this.unknownEntity(string);
            }
            stringBuffer.append(cArray);
        }
    }

    protected void unreadChar(char c) {
        this.charReadTooMuch = c;
    }

    protected XmlParseException invalidValueSet(String string) {
        String string2 = "Invalid value set (entity name = \"" + string + "\")";
        return new XmlParseException(this.getName(), this.parserLineNr, string2);
    }

    protected XmlParseException invalidValue(String string, String string2) {
        String string3 = "Attribute \"" + string + "\" does not contain a valid " + "value (\"" + string2 + "\")";
        return new XmlParseException(this.getName(), this.parserLineNr, string3);
    }

    protected XmlParseException unexpectedEndOfData() {
        String string = "Unexpected end of data reached";
        return new XmlParseException(this.getName(), this.parserLineNr, string);
    }

    protected XmlParseException syntaxError(String string) {
        String string2 = "Syntax error while parsing " + string;
        return new XmlParseException(this.getName(), this.parserLineNr, string2);
    }

    protected XmlParseException expectedInput(String string) {
        String string2 = "Expected: " + string;
        return new XmlParseException(this.getName(), this.parserLineNr, string2);
    }

    protected XmlParseException unknownEntity(String string) {
        String string2 = "Unknown or invalid entity: &" + string + ";";
        return new XmlParseException(this.getName(), this.parserLineNr, string2);
    }
}

